/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.client;

import com.cobblemon.mod.common.OrientationControllable;
import com.cobblemon.mod.common.api.orientation.OrientationController;
import com.github.exopandora.shouldersurfing.api.callback.ITargetCameraOffsetCallback;
import com.github.exopandora.shouldersurfing.api.client.IShoulderSurfingCamera;
import com.github.exopandora.shouldersurfing.api.util.EntityHelper;
import com.github.exopandora.shouldersurfing.client.ShoulderSurfingImpl;
import com.github.exopandora.shouldersurfing.compat.CobblemonCompat;
import com.github.exopandora.shouldersurfing.compat.Mods;
import com.github.exopandora.shouldersurfing.config.Config;
import com.github.exopandora.shouldersurfing.math.Vec2f;
import com.github.exopandora.shouldersurfing.plugin.ShoulderSurfingRegistrar;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ShoulderSurfingCamera
implements IShoulderSurfingCamera {
    private static final Vector3f VECTOR_NEGATIVE_Y = new Vector3f(0.0f, -1.0f, 0.0f);
    private final ShoulderSurfingImpl instance;
    private Vec3 offset;
    private Vec3 offsetO;
    private Vec3 renderOffset;
    private Vec3 targetOffset;
    private Vec3 deltaMovementO;
    private double cameraDistance;
    private double maxCameraDistance;
    private double maxCameraDistanceO;
    private float xRot;
    private float yRot;
    private float xRotOffset;
    private float yRotOffset;
    private float xRotOffsetO;
    private float yRotOffsetO;
    private float freeLookYRot;
    private float lastMovedYRot;
    private boolean initialized;

    public ShoulderSurfingCamera(ShoulderSurfingImpl instance) {
        this.instance = instance;
        this.init();
    }

    public void tick() {
        Entity entity;
        if (!this.initialized) {
            this.init();
        }
        double cameraTransitionSpeedMultiplier = Config.CLIENT.getCameraTransitionSpeedMultiplier();
        this.xRotOffsetO = this.xRotOffset;
        this.yRotOffsetO = this.yRotOffset;
        this.offsetO = this.offset;
        this.offset = this.offsetO.lerp(this.targetOffset, cameraTransitionSpeedMultiplier);
        this.maxCameraDistanceO = this.maxCameraDistance;
        this.maxCameraDistance += (this.offset.length() - this.maxCameraDistance) * cameraTransitionSpeedMultiplier;
        Entity cameraEntity = Minecraft.getInstance().getCameraEntity();
        if (this.instance.isCameraDecoupled()) {
            if (EntityHelper.isPlayerSpectatingEntity() && cameraEntity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)cameraEntity;
                this.xRot += living.getXRot() - living.xRotO;
                this.yRot += living.getYHeadRot() - living.yHeadRotO;
            }
        } else if (cameraEntity != null && cameraEntity.isPassenger() && (entity = cameraEntity.getVehicle()) instanceof Boat) {
            Boat boat = (Boat)entity;
            this.yRot += boat.getYRot() - boat.yRotO;
        }
        if (cameraEntity != null) {
            this.deltaMovementO = ShoulderSurfingCamera.getDeltaMovementWithoutGravity(cameraEntity);
        }
        if (!this.instance.isFreeLooking()) {
            this.freeLookYRot = this.yRot;
            this.xRotOffset *= 0.5f;
            this.yRotOffset *= 0.5f;
        }
    }

    private void init() {
        this.offset = new Vec3(Config.CLIENT.getOffsetX(), Config.CLIENT.getOffsetY(), Config.CLIENT.getOffsetZ());
        Entity cameraEntity = Minecraft.getInstance().getCameraEntity();
        if (cameraEntity != null) {
            this.offset = this.offset.scale((double)EntityHelper.getScale(cameraEntity));
            this.xRot = cameraEntity.getXRot();
            this.yRot = cameraEntity.getYRot();
            this.deltaMovementO = ShoulderSurfingCamera.getDeltaMovementWithoutGravity(cameraEntity);
        } else {
            this.xRot = 0.0f;
            this.yRot = -180.0f;
            this.deltaMovementO = Vec3.ZERO;
        }
        this.offsetO = this.offset;
        this.renderOffset = this.offset;
        this.targetOffset = this.offset;
        this.maxCameraDistanceO = this.maxCameraDistance = this.offset.length();
        this.xRotOffset = 0.0f;
        this.yRotOffset = 0.0f;
        this.xRotOffsetO = 0.0f;
        this.yRotOffsetO = 0.0f;
        this.lastMovedYRot = this.yRot;
        this.initialized = true;
    }

    public Vec2f calcRotations(Entity cameraEntity, float partialTick) {
        Entity entity;
        if (!this.instance.isCameraDecoupled() && EntityHelper.isPlayerSpectatingEntity() && cameraEntity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)cameraEntity;
            return new Vec2f(living.getViewXRot(partialTick), living.getViewYRot(partialTick));
        }
        float cameraXRotWithOffset = Mth.clamp((float)(Mth.rotLerp((float)partialTick, (float)this.xRotOffsetO, (float)this.xRotOffset) + this.xRot), (float)-90.0f, (float)90.0f);
        float cameraYRotWithOffset = Mth.rotLerp((float)partialTick, (float)this.yRotOffsetO, (float)this.yRotOffset) + this.yRot;
        if (this.instance.isCameraDecoupled()) {
            if (EntityHelper.isPlayerSpectatingEntity() && cameraEntity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)cameraEntity;
                cameraXRotWithOffset += (living.getXRot() - living.xRotO) * partialTick;
                cameraYRotWithOffset += (living.getYHeadRot() - living.yHeadRotO) * partialTick;
            }
        } else if (cameraEntity != null && !this.instance.isCameraDecoupled() && cameraEntity.isPassenger() && (entity = cameraEntity.getVehicle()) instanceof Boat) {
            Boat boat = (Boat)entity;
            cameraYRotWithOffset += (boat.getYRot() - boat.yRotO) * partialTick;
        }
        return new Vec2f(cameraXRotWithOffset, cameraYRotWithOffset);
    }

    public Vec3 calcOffset(Camera camera, BlockGetter level, float partialTick, Entity cameraEntity) {
        LivingEntity living;
        Vec3 defaultOffset;
        Vec3 targetOffset = defaultOffset = new Vec3(Config.CLIENT.getOffsetX(), Config.CLIENT.getOffsetY(), Config.CLIENT.getOffsetZ());
        List<ITargetCameraOffsetCallback> targetCameraOffsetCallbacks = ShoulderSurfingRegistrar.getInstance().getTargetCameraOffsetCallbacks();
        for (ITargetCameraOffsetCallback targetCameraOffsetCallback : targetCameraOffsetCallbacks) {
            targetOffset = targetCameraOffsetCallback.pre(this.instance, targetOffset, defaultOffset);
        }
        if (cameraEntity.isPassenger()) {
            targetOffset = ShoulderSurfingCamera.applyModifiersAndMultipliers(targetOffset, defaultOffset, Config.CLIENT.getPassengerOffsetModifiers(), Config.CLIENT.getPassengerOffsetMultipliers());
        }
        if (cameraEntity.isSprinting()) {
            targetOffset = ShoulderSurfingCamera.applyModifiersAndMultipliers(targetOffset, defaultOffset, Config.CLIENT.getSprintOffsetModifiers(), Config.CLIENT.getSprintOffsetMultipliers());
        }
        if (this.instance.isAiming()) {
            targetOffset = ShoulderSurfingCamera.applyModifiersAndMultipliers(targetOffset, defaultOffset, Config.CLIENT.getAimingOffsetModifiers(), Config.CLIENT.getAimingOffsetMultipliers());
        }
        if (cameraEntity instanceof LivingEntity && (living = (LivingEntity)cameraEntity).isFallFlying()) {
            targetOffset = ShoulderSurfingCamera.applyModifiersAndMultipliers(targetOffset, defaultOffset, Config.CLIENT.getFallFlyingOffsetModifiers(), Config.CLIENT.getFallFlyingMultipliers());
        }
        if (!cameraEntity.isSpectator()) {
            if (cameraEntity instanceof LivingEntity && (living = (LivingEntity)cameraEntity).onClimbable()) {
                targetOffset = ShoulderSurfingCamera.applyModifiersAndMultipliers(targetOffset, defaultOffset, Config.CLIENT.getClimbingOffsetModifiers(), Config.CLIENT.getClimbingMultipliers());
            }
            if ((double)camera.getLookVector().angle((Vector3fc)VECTOR_NEGATIVE_Y) < Config.CLIENT.getCenterCameraWhenLookingDownAngle() * 0.01745329238474369) {
                targetOffset = new Vec3(0.0, 0.0, targetOffset.z());
            }
            if (Config.CLIENT.doDynamicallyAdjustOffsets()) {
                targetOffset = ShoulderSurfingCamera.calcDynamicOffsets(camera, cameraEntity, level, targetOffset);
            }
        }
        double targetOffsetX = Config.CLIENT.isUnlimitedOffsetX() ? targetOffset.x() : Math.clamp(targetOffset.x(), Config.CLIENT.getMinOffsetX(), Config.CLIENT.getMaxOffsetX());
        double targetOffsetY = Config.CLIENT.isUnlimitedOffsetY() ? targetOffset.y() : Math.clamp(targetOffset.y(), Config.CLIENT.getMinOffsetY(), Config.CLIENT.getMaxOffsetY());
        double targetOffsetZ = Config.CLIENT.isUnlimitedOffsetZ() ? targetOffset.z() : Math.clamp(targetOffset.z(), Config.CLIENT.getMinOffsetZ(), Config.CLIENT.getMaxOffsetZ());
        targetOffset = new Vec3(targetOffsetX, targetOffsetY, targetOffsetZ);
        targetOffset = targetOffset.scale((double)ShoulderSurfingCamera.getScale(cameraEntity));
        for (ITargetCameraOffsetCallback targetCameraOffsetCallback : targetCameraOffsetCallbacks) {
            targetOffset = targetCameraOffsetCallback.post(this.instance, targetOffset, defaultOffset);
        }
        this.targetOffset = targetOffset;
        Vec3 drag = this.calcCameraDrag(camera, cameraEntity, partialTick);
        Vec3 lerpedOffset = this.offsetO.lerp(this.offset, (double)partialTick).add(drag);
        if (cameraEntity.isSpectator()) {
            this.cameraDistance = lerpedOffset.length();
            this.renderOffset = lerpedOffset;
        } else {
            double targetCameraDistance = ShoulderSurfingCamera.maxZoom(camera, level, lerpedOffset, partialTick);
            if (targetCameraDistance < this.maxCameraDistance) {
                this.maxCameraDistance = targetCameraDistance;
            }
            double lerpedMaxDistance = Mth.lerp((double)partialTick, (double)this.maxCameraDistanceO, (double)this.maxCameraDistance);
            this.cameraDistance = Math.min(targetCameraDistance, lerpedMaxDistance);
            this.renderOffset = lerpedOffset.normalize().scale(this.cameraDistance);
        }
        return this.renderOffset;
    }

    private static Vec3 applyModifiersAndMultipliers(Vec3 targetVec, Vec3 originalVec, Vec3 modifiers, Vec3 multipliers) {
        return targetVec.add(originalVec.multiply(multipliers).subtract(originalVec)).add(modifiers);
    }

    private static Vec3 calcDynamicOffsets(Camera camera, Entity cameraEntity, BlockGetter level, Vec3 targetOffset) {
        Vec3 lookVector = new Vec3(camera.getLookVector());
        Vec3 worldXYOffset = new Vec3(camera.getUpVector()).scale(targetOffset.y()).add(new Vec3(camera.getLeftVector()).scale(targetOffset.x()));
        Vec3 worldOffset = worldXYOffset.add(lookVector.scale(-targetOffset.z()));
        double offsetXAbs = Math.abs(targetOffset.x());
        double offsetYAbs = Math.abs(targetOffset.y());
        double offsetZAbs = Math.abs(targetOffset.z());
        double targetX = offsetXAbs;
        double targetY = offsetYAbs;
        double clearance = (double)cameraEntity.getBbWidth() / 3.0;
        Vec3 cameraPosition = camera.getPosition();
        for (double dz = 0.0; dz <= offsetZAbs; dz += 0.03125) {
            double newTargetY;
            Vec3 endPos;
            double scale = dz / offsetZAbs;
            Vec3 startPos = cameraPosition.add(worldOffset.scale(scale));
            ClipContext context = new ClipContext(startPos, endPos = cameraPosition.add(worldXYOffset).add(lookVector.scale(-dz)), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, cameraEntity);
            BlockHitResult hitResult = level.clip(context);
            if (hitResult.getType() == HitResult.Type.MISS) continue;
            double distance = hitResult.getLocation().distanceTo(startPos);
            double newTargetX = Math.max(distance + offsetXAbs * scale - clearance, 0.0);
            if (newTargetX < targetX) {
                targetX = newTargetX;
            }
            if (!((newTargetY = Math.max(distance + offsetYAbs * scale - clearance, 0.0)) < targetY)) continue;
            targetY = newTargetY;
        }
        double targetXOffset = Math.signum(targetOffset.x()) * targetX;
        double targetYOffset = Math.signum(targetOffset.y()) * targetY;
        return new Vec3(targetXOffset, targetYOffset, targetOffset.z());
    }

    private static double maxZoom(Camera camera, BlockGetter level, Vec3 cameraOffset, float partialTick) {
        double distance = cameraOffset.length();
        Vec3 worldOffset = new Vec3(camera.getUpVector()).scale(cameraOffset.y()).add(new Vec3(camera.getLeftVector()).scale(cameraOffset.x())).add(new Vec3(camera.getLookVector()).scale(-cameraOffset.z()));
        Vec3 eyePosition = camera.getEntity().getEyePosition(partialTick);
        for (int i = 0; i < 8; ++i) {
            double newDistance;
            Vec3 toOffset;
            Vec3 to;
            Vec3 offset = new Vec3((double)(i & 1), (double)(i >> 1 & 1), (double)(i >> 2 & 1)).scale(2.0).subtract(1.0, 1.0, 1.0);
            Vec3 fromOffset = offset.scale((double)Math.clamp(camera.getEntity().getBbWidth() / 2.0f / Mth.sqrt((float)2.0f), 0.0f, 0.15f)).xRot(-camera.getXRot() * ((float)Math.PI / 180)).yRot(-camera.getYRot() * ((float)Math.PI / 180));
            Vec3 from = eyePosition.add(fromOffset);
            ClipContext context = new ClipContext(from, to = eyePosition.add(toOffset = offset.scale(0.15).xRot(-camera.getXRot() * ((float)Math.PI / 180)).yRot(-camera.getYRot() * ((float)Math.PI / 180))).add(worldOffset), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, camera.getEntity());
            BlockHitResult hitResult = level.clip(context);
            if (hitResult.getType() == HitResult.Type.MISS || !((newDistance = hitResult.getLocation().distanceTo(eyePosition)) < distance)) continue;
            distance = newDistance;
        }
        return distance;
    }

    private Vec3 calcCameraDrag(Camera cameraIn, Entity cameraEntity, float partialTick) {
        Vec3 deltaMovement = ShoulderSurfingCamera.getDeltaMovementWithoutGravity(cameraEntity);
        Vec3 deltaMovementLerped = this.deltaMovementO.lerp(deltaMovement, (double)partialTick).multiply(Config.CLIENT.getCameraDragMultipliers()).yRot(cameraIn.getYRot() * ((float)Math.PI / 180)).xRot(cameraIn.getXRot() * ((float)Math.PI / 180));
        return new Vec3(-deltaMovementLerped.x, -deltaMovementLerped.y, deltaMovementLerped.z);
    }

    public Vec2f calcSway(ShoulderSurfingCamera camera, Entity cameraEntity, float partialTick) {
        Vec3 deltaMovement = ShoulderSurfingCamera.getDeltaMovementWithoutGravity(cameraEntity);
        Vec3 deltaMovementLerped = this.deltaMovementO.lerp(deltaMovement, (double)partialTick).yRot(camera.getYRot() * ((float)Math.PI / 180)).xRot(camera.getXRot() * ((float)Math.PI / 180));
        double maxVelocityX = Config.CLIENT.getCameraSwayXMaxVelocity() / 20.0;
        double maxVelocityZ = Config.CLIENT.getCameraSwayZMaxVelocity() / 20.0;
        double maxAngleX = Config.CLIENT.getCameraSwayXMaxAngle();
        double maxAngleZ = Config.CLIENT.getCameraSwayZMaxAngle();
        double swayX = Math.min(Math.abs(deltaMovementLerped.y), maxVelocityX) / maxVelocityX * maxAngleX * Math.signum(deltaMovementLerped.y);
        double swayZ = Math.min(Math.abs(deltaMovementLerped.x), maxVelocityZ) / maxVelocityZ * maxAngleZ * Math.signum(deltaMovementLerped.x);
        return new Vec2f((float)swayX, (float)swayZ);
    }

    public boolean turn(LocalPlayer player, double yRot, double xRot) {
        if (this.instance.isShoulderSurfing()) {
            OrientationControllable controllableVehicle;
            OrientationController vehicleController;
            Entity entity;
            if (Mods.COBBLEMON.isLoaded() && CobblemonCompat.supportsRiding() && (entity = player.getVehicle()) instanceof OrientationControllable && (vehicleController = (controllableVehicle = (OrientationControllable)entity).getOrientationController()).isActive()) {
                this.xRot = vehicleController.getPitch();
                this.yRot = vehicleController.getYaw();
            }
            float scaledXRot = (float)(xRot * (double)0.15f);
            float scaledYRot = (float)(yRot * (double)0.15f);
            if (this.instance.isFreeLooking()) {
                this.xRotOffset = Mth.clamp((float)(this.xRotOffset + scaledXRot), (float)-90.0f, (float)90.0f);
                this.yRotOffset = Mth.wrapDegrees((float)(this.yRotOffset + scaledYRot));
                this.xRotOffsetO = this.xRotOffset;
                this.yRotOffsetO = this.yRotOffset;
                return true;
            }
            float cameraXRot = Mth.clamp((float)(this.xRot + scaledXRot), (float)-90.0f, (float)90.0f);
            float cameraYRot = this.yRot + scaledYRot;
            if (player.isPassenger()) {
                Vec2f constraintRotations = ShoulderSurfingCamera.applyPassengerRotationConstraints((Player)player, cameraXRot, cameraYRot, this.xRot, this.yRot);
                cameraXRot = constraintRotations.x();
                cameraYRot = constraintRotations.y();
            }
            if (this.instance.isCameraDecoupled()) {
                boolean isMoving;
                boolean bl = isMoving = player.input.getMoveVector().x != 0.0f || player.input.getMoveVector().y != 0.0f || player.isFallFlying();
                if (this.instance.shouldEntityFollowCamera((LivingEntity)player)) {
                    player.setXRot(cameraXRot);
                    player.setYRot(cameraYRot);
                    player.xRotO += Mth.degreesDifference((float)this.xRot, (float)cameraXRot);
                    player.yRotO += Mth.degreesDifference((float)this.yRot, (float)cameraYRot);
                } else if (!this.instance.shouldEntityAimAtTarget((LivingEntity)player, Minecraft.getInstance())) {
                    if (Config.CLIENT.shouldPlayerXRotFollowCamera()) {
                        player.setXRot(cameraXRot);
                        player.xRotO += Mth.degreesDifference((float)this.xRot, (float)cameraXRot);
                    }
                    if (Config.CLIENT.shouldPlayerYRotFollowCamera() && !isMoving) {
                        float maxFollowAngle = (float)Config.CLIENT.getPlayerYRotFollowAngleLimit();
                        float playerYRot = Mth.approachDegrees((float)this.lastMovedYRot, (float)(player.getYRot() + scaledYRot), (float)maxFollowAngle);
                        player.yRotO = player.getYRot();
                        player.setYRot(playerYRot);
                    }
                }
                if (isMoving) {
                    this.lastMovedYRot = player.getYRot();
                }
            }
            this.xRot = cameraXRot;
            this.yRot = cameraYRot;
            return this.instance.isCameraDecoupled();
        }
        return false;
    }

    private static float getScale(Entity cameraEntity) {
        Entity entity = cameraEntity;
        float scale = EntityHelper.getScale(entity);
        while (entity.getVehicle() != null) {
            entity = entity.getVehicle();
            scale = Math.max(scale, EntityHelper.getScale(entity));
        }
        return scale;
    }

    private static Vec2f applyPassengerRotationConstraints(Player player, float cameraXRot, float cameraYRot, float cameraXRotO, float cameraYRotO) {
        Entity vehicle = player.getVehicle();
        float partialTick = Minecraft.getInstance().getDeltaTracker().getGameTimeDeltaPartialTick(true);
        float playerXRot = player.getXRot();
        float playerYRot = player.getYRot();
        float playerXRotO = player.xRotO;
        float playerYRotO = player.yRotO;
        float playerYHeadRot = player.yHeadRot;
        float playerYHeadRotO = player.yHeadRotO;
        float playerYBodyRot = player.yBodyRot;
        float playerYBodyRotO = player.yBodyRotO;
        float vehicleXRot = vehicle.getXRot();
        float vehicleYRot = vehicle.getYRot();
        float vehicleXRotO = vehicle.xRotO;
        float vehicleYRotO = vehicle.yRotO;
        vehicle.setXRot(Mth.rotLerp((float)partialTick, (float)vehicleXRotO, (float)vehicleXRot));
        vehicle.setYRot(Mth.rotLerp((float)partialTick, (float)vehicleYRotO, (float)vehicleYRot));
        player.setXRot(cameraXRot);
        player.setYRot(cameraYRot);
        player.xRotO = cameraXRotO;
        player.yRotO = cameraYRotO;
        player.yHeadRot = cameraYRot;
        player.yHeadRotO = cameraYRotO;
        player.yBodyRot = cameraYRot;
        player.yBodyRotO = cameraYRotO;
        vehicle.onPassengerTurned((Entity)player);
        if (player.getXRot() != cameraXRot) {
            cameraXRot = player.getXRot();
        }
        if (player.getYRot() != cameraYRot) {
            cameraYRot = player.getYRot();
        }
        player.setXRot(playerXRot);
        player.setYRot(playerYRot);
        player.xRotO = playerXRotO;
        player.yRotO = playerYRotO;
        player.yHeadRot = playerYHeadRot;
        player.yHeadRotO = playerYHeadRotO;
        player.yBodyRot = playerYBodyRot;
        player.yBodyRotO = playerYBodyRotO;
        vehicle.setXRot(vehicleXRot);
        vehicle.setYRot(vehicleYRot);
        return new Vec2f(cameraXRot, cameraYRot);
    }

    public void resetState() {
        this.initialized = false;
    }

    @Override
    public double getCameraDistance() {
        return this.cameraDistance;
    }

    @Override
    public Vec3 getOffset() {
        return this.offset;
    }

    @Override
    public Vec3 getRenderOffset() {
        return this.renderOffset;
    }

    @Override
    public Vec3 getTargetOffset() {
        return this.targetOffset;
    }

    @Override
    public float getXRot() {
        return this.xRot + this.xRotOffset;
    }

    @Override
    public void setXRot(float xRot) {
        this.xRot = xRot;
        this.xRotOffset = 0.0f;
        this.xRotOffsetO = 0.0f;
    }

    @Override
    public float getYRot() {
        return this.yRot + this.yRotOffset;
    }

    @Override
    public void setYRot(float yRot) {
        this.yRot = yRot;
        this.yRotOffset = 0.0f;
        this.yRotOffsetO = 0.0f;
    }

    public float getFreeLookYRot() {
        return this.freeLookYRot;
    }

    public void setLastMovedYRot(float lastMovedYRot) {
        this.lastMovedYRot = lastMovedYRot;
    }

    private static Vec3 getDeltaMovementWithoutGravity(Entity entity) {
        return entity.getDeltaMovement().add(0.0, entity.getGravity(), 0.0);
    }
}

