/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.api.callback;

import java.util.stream.StreamSupport;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

public interface IAdaptiveItemCallback {
    public boolean isHoldingAdaptiveItem(Minecraft var1, LivingEntity var2);

    public static IAdaptiveItemCallback mainHandMatches(ItemLike ... items) {
        return (minecraft, entity) -> IAdaptiveItemCallback.containsItem(entity.getMainHandItem().getItem(), items);
    }

    public static IAdaptiveItemCallback offHandMatches(ItemLike ... items) {
        return (minecraft, entity) -> IAdaptiveItemCallback.containsItem(entity.getOffhandItem().getItem(), items);
    }

    public static IAdaptiveItemCallback anyHandMatches(ItemLike ... items) {
        return (minecraft, entity) -> StreamSupport.stream(entity.getHandSlots().spliterator(), false).anyMatch(stack -> IAdaptiveItemCallback.containsItem(stack.getItem(), items));
    }

    private static boolean containsItem(Item itemToFind, ItemLike ... items) {
        for (ItemLike item : items) {
            if (!itemToFind.equals(item.asItem())) continue;
            return true;
        }
        return false;
    }
}

