/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.client;

import com.github.exopandora.shouldersurfing.api.callback.IPlayerInputCallback;
import com.github.exopandora.shouldersurfing.api.model.Perspective;
import com.github.exopandora.shouldersurfing.client.ShoulderSurfingCamera;
import com.github.exopandora.shouldersurfing.client.ShoulderSurfingImpl;
import com.github.exopandora.shouldersurfing.config.Config;
import com.github.exopandora.shouldersurfing.math.Vec2f;
import com.github.exopandora.shouldersurfing.plugin.ShoulderSurfingRegistrar;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class InputHandler {
    public static final KeyMapping CAMERA_LEFT = InputHandler.createKeyMapping("adjust_camera_left", 263);
    public static final KeyMapping CAMERA_RIGHT = InputHandler.createKeyMapping("adjust_camera_right", 262);
    public static final KeyMapping CAMERA_IN = InputHandler.createKeyMapping("adjust_camera_in", 265);
    public static final KeyMapping CAMERA_OUT = InputHandler.createKeyMapping("adjust_camera_out", 264);
    public static final KeyMapping CAMERA_UP = InputHandler.createKeyMapping("adjust_camera_up", 266);
    public static final KeyMapping CAMERA_DOWN = InputHandler.createKeyMapping("adjust_camera_down", 267);
    public static final KeyMapping SWAP_SHOULDER = InputHandler.createKeyMapping("swap_shoulder", 79);
    public static final KeyMapping TOGGLE_FIRST_PERSON = InputHandler.createKeyMapping("toggle_first_person", InputConstants.UNKNOWN.getValue());
    public static final KeyMapping TOGGLE_THIRD_PERSON_FRONT = InputHandler.createKeyMapping("toggle_third_person_front", InputConstants.UNKNOWN.getValue());
    public static final KeyMapping TOGGLE_THIRD_PERSON_BACK = InputHandler.createKeyMapping("toggle_third_person_back", InputConstants.UNKNOWN.getValue());
    public static final KeyMapping FREE_LOOK = InputHandler.createKeyMapping("free_look", 342);
    public static final KeyMapping TOGGLE_CAMERA_COUPLING = InputHandler.createKeyMapping("toggle_camera_coupling", InputConstants.UNKNOWN.getValue());
    public static final KeyMapping TOGGLE_X_OFFSET_PRESETS = InputHandler.createKeyMapping("toggle_x_offset_presets", InputConstants.UNKNOWN.getValue());
    public static final KeyMapping TOGGLE_Y_OFFSET_PRESETS = InputHandler.createKeyMapping("toggle_y_offset_presets", InputConstants.UNKNOWN.getValue());
    public static final KeyMapping TOGGLE_Z_OFFSET_PRESETS = InputHandler.createKeyMapping("toggle_z_offset_presets", InputConstants.UNKNOWN.getValue());
    private final ShoulderSurfingImpl instance;

    public InputHandler(ShoulderSurfingImpl instance) {
        this.instance = instance;
    }

    public void tick() {
        Options options = Minecraft.getInstance().options;
        while (TOGGLE_FIRST_PERSON.consumeClick()) {
            if (this.instance.isShoulderSurfing()) {
                this.instance.changePerspective(Perspective.FIRST_PERSON);
                continue;
            }
            this.instance.changePerspective(Perspective.SHOULDER_SURFING);
        }
        while (TOGGLE_THIRD_PERSON_FRONT.consumeClick()) {
            if (this.instance.isShoulderSurfing()) {
                this.instance.changePerspective(Perspective.THIRD_PERSON_FRONT);
                continue;
            }
            this.instance.changePerspective(Perspective.SHOULDER_SURFING);
        }
        while (TOGGLE_THIRD_PERSON_BACK.consumeClick()) {
            if (this.instance.isShoulderSurfing()) {
                this.instance.changePerspective(Perspective.THIRD_PERSON_BACK);
                continue;
            }
            this.instance.changePerspective(Perspective.SHOULDER_SURFING);
        }
        while (CAMERA_LEFT.consumeClick()) {
            if (!this.instance.isShoulderSurfing()) continue;
            Config.CLIENT.adjustCameraLeft();
        }
        while (CAMERA_RIGHT.consumeClick()) {
            if (!this.instance.isShoulderSurfing()) continue;
            Config.CLIENT.adjustCameraRight();
        }
        while (CAMERA_OUT.consumeClick()) {
            if (!this.instance.isShoulderSurfing()) continue;
            Config.CLIENT.adjustCameraOut();
        }
        while (CAMERA_IN.consumeClick()) {
            if (!this.instance.isShoulderSurfing()) continue;
            Config.CLIENT.adjustCameraIn();
        }
        while (CAMERA_UP.consumeClick()) {
            if (!this.instance.isShoulderSurfing()) continue;
            Config.CLIENT.adjustCameraUp();
        }
        while (CAMERA_DOWN.consumeClick()) {
            if (!this.instance.isShoulderSurfing()) continue;
            Config.CLIENT.adjustCameraDown();
        }
        while (SWAP_SHOULDER.consumeClick()) {
            if (!this.instance.isShoulderSurfing()) continue;
            this.instance.swapShoulder();
        }
        while (options.keyTogglePerspective.consumeClick()) {
            this.instance.togglePerspective();
        }
        while (FREE_LOOK.consumeClick()) {
        }
        while (TOGGLE_CAMERA_COUPLING.consumeClick()) {
            this.instance.toggleCameraCoupling();
        }
        while (TOGGLE_X_OFFSET_PRESETS.consumeClick()) {
            this.instance.toggleOffsetXPreset();
        }
        while (TOGGLE_Y_OFFSET_PRESETS.consumeClick()) {
            this.instance.toggleOffsetYPreset();
        }
        while (TOGGLE_Z_OFFSET_PRESETS.consumeClick()) {
            this.instance.toggleOffsetZPreset();
        }
    }

    public void updateMovementInput(Input input) {
        Minecraft minecraft = Minecraft.getInstance();
        Entity cameraEntity = minecraft.getCameraEntity();
        for (IPlayerInputCallback callback : ShoulderSurfingRegistrar.getInstance().getPlayerInputCallbacks()) {
            if (!callback.isForcingVanillaMovementInput(new IPlayerInputCallback.IsForcingVanillaMovementInputContext(minecraft, cameraEntity))) continue;
            return;
        }
        Vec2f moveVector = new Vec2f(input.leftImpulse, input.forwardImpulse);
        if (this.instance.isShoulderSurfing() && this.instance.isFreeLooking()) {
            moveVector.rotateDegrees(Mth.degreesDifference((float)cameraEntity.getYRot(), (float)this.instance.getCamera().getFreeLookYRot()));
            input.leftImpulse = moveVector.x();
            input.forwardImpulse = moveVector.y();
        } else if (this.instance.isShoulderSurfing() && minecraft.player != null && cameraEntity == minecraft.player) {
            if (moveVector.lengthSquared() > 0.0) {
                ShoulderSurfingCamera camera = this.instance.getCamera();
                LocalPlayer player = minecraft.player;
                float yRot = player.getYRot();
                if (this.instance.isEntityRotationDecoupled((LivingEntity)player, minecraft)) {
                    float cameraXRot = camera.getXRot();
                    float cameraYRot = camera.getYRot();
                    Vec2f rotated = moveVector.rotateDegrees(cameraYRot);
                    float xRot = cameraXRot * 0.5f;
                    float xRotO = player.getXRot();
                    float yRotO = yRot;
                    yRot = (float)Mth.wrapDegrees((double)(Math.atan2(-rotated.x(), rotated.y()) * 57.2957763671875));
                    xRot = xRotO + Mth.degreesDifference((float)xRotO, (float)xRot) * 0.25f;
                    yRot = yRotO + Mth.degreesDifference((float)yRotO, (float)yRot) * 0.25f;
                    player.setXRot(xRot);
                    player.setYRot(yRot);
                }
                moveVector = moveVector.rotateDegrees(Mth.degreesDifference((float)yRot, (float)camera.getYRot()));
            }
            input.leftImpulse = moveVector.x();
            input.forwardImpulse = moveVector.y();
        }
    }

    @NotNull
    private static KeyMapping createKeyMapping(String key, int keyCode) {
        return new KeyMapping("key.shouldersurfing." + key, keyCode, "Shoulder Surfing");
    }
}

