/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.compat.plugin;

import com.cobblemon.mod.common.OrientationControllable;
import com.cobblemon.mod.common.api.orientation.OrientationController;
import com.github.exopandora.shouldersurfing.api.callback.ICameraRotationSetupCallback;
import com.github.exopandora.shouldersurfing.compat.CobblemonCompat;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class CobblemonCameraRotationSetupCallback
implements ICameraRotationSetupCallback {
    @Override
    public void pre(ICameraRotationSetupCallback.CameraRotationSetupContext context, ICameraRotationSetupCallback.CameraRotationSetupResult result) {
        OrientationControllable controllableVehicle;
        OrientationController vehicleController;
        Entity entity = context.player().getVehicle();
        if (entity instanceof OrientationControllable && (vehicleController = (controllableVehicle = (OrientationControllable)entity).getOrientationController()).isActive()) {
            result.setXRot(vehicleController.getPitch());
            result.setYRot(vehicleController.getYaw());
        }
    }

    @Override
    public void post(ICameraRotationSetupCallback.CameraRotationSetupContext context, ICameraRotationSetupCallback.CameraRotationSetupResult result) {
        if (CobblemonCompat.hasActiveBoatBehaviour(context.player().getVehicle())) {
            Entity vehicle = context.player().getVehicle();
            float partialTick = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
            float yRotLerped = Mth.rotLerp((float)partialTick, (float)vehicle.yRotO, (float)vehicle.getYRot());
            float delta = Mth.wrapDegrees((float)(result.getYRot() - yRotLerped));
            float clamped = Mth.clamp((float)delta, (float)-105.0f, (float)105.0f);
            result.setYRot(result.getYRot() + clamped - delta);
        }
    }
}

