/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.api.model;

import net.minecraft.client.Camera;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public enum PickVector {
    PLAYER((camera, entity, partialTick) -> PickVector.entityViewVector(entity, partialTick)),
    CAMERA((camera, entity, partialTick) -> new Vec3(camera.getLookVector()));

    private final IPickVectorFunction pickVectorFunction;

    private PickVector(IPickVectorFunction pickVectorFunction) {
        this.pickVectorFunction = pickVectorFunction;
    }

    public Vec3 calc(Camera camera, Entity entity, float partialTick) {
        return this.pickVectorFunction.apply(camera, entity, partialTick);
    }

    @NotNull
    private static Vec3 entityViewVector(Entity entity, float partialTick) {
        float xRot = partialTick == 1.0f ? entity.getXRot() : Mth.rotLerp((float)partialTick, (float)entity.xRotO, (float)entity.getXRot());
        float yRot = partialTick == 1.0f ? entity.getYRot() : Mth.rotLerp((float)partialTick, (float)entity.yRotO, (float)entity.getYRot());
        float xRotDeg = xRot * ((float)Math.PI / 180);
        float yRotDegNegated = -yRot * ((float)Math.PI / 180);
        float a = Mth.cos((float)yRotDegNegated);
        float b = Mth.sin((float)yRotDegNegated);
        float c = Mth.cos((float)xRotDeg);
        float d = Mth.sin((float)xRotDeg);
        return new Vec3((double)(b * c), (double)(-d), (double)(a * c));
    }

    private static interface IPickVectorFunction {
        public Vec3 apply(Camera var1, Entity var2, float var3);
    }
}

