/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.daycount.client;

import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.petemc.daycount.DayCount;
import net.petemc.daycount.config.MainConfig;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;

@OnlyIn(value=Dist.CLIENT)
public class DayCountHud
implements Gui.RenderFunction {
    public static DayCountHud DAY_COUNT_HUD_INSTANCE;
    private static String currentTextColor;

    public static void setCurrentTextColor(String value) {
        currentTextColor = value;
    }

    public String getCurrentTextColor() {
        return currentTextColor;
    }

    public static void init() {
        DAY_COUNT_HUD_INSTANCE = new DayCountHud();
    }

    public void render(@NotNull GuiGraphics guiGraphics, @NotNull DeltaTracker pDeltaTracker) {
        if (DayCount.dayCountEnabled) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.level != null) {
                int currentDay = (int)(mc.level.getDayTime() / 24000L);
                if (mc.gameMode != null && (mc.gameMode.getPlayerMode().isSurvival() || mc.gameMode.getPlayerMode().isCreative()) && !mc.getDebugOverlay().showDebugScreen()) {
                    Matrix3x2fStack matrixStack = guiGraphics.pose();
                    matrixStack.pushMatrix();
                    matrixStack.translate(MainConfig.getLocationX(), MainConfig.getLocationY(), (Matrix3x2f)matrixStack);
                    matrixStack.scale(MainConfig.getSizeX(), MainConfig.getSizeY(), (Matrix3x2f)matrixStack);
                    guiGraphics.drawString(mc.font, MainConfig.getDayCounterString() + (currentDay + MainConfig.getDayOffset()), 1, 1, (int)Long.parseLong(currentTextColor, 16));
                    matrixStack.popMatrix();
                }
            }
        }
    }

    static {
        currentTextColor = "FFFFFFFF";
    }
}

