/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.daycount;

import com.mojang.logging.LogUtils;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.petemc.daycount.client.DayCountHud;
import net.petemc.daycount.config.MainConfig;
import org.slf4j.Logger;

@Mod(value="daycount")
public class DayCount {
    public static final String MOD_ID = "daycount";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static boolean dayCountEnabled = false;

    public DayCount(FMLJavaModLoadingContext context) {
        BusGroup modBusGroup = context.getModBusGroup();
        FMLCommonSetupEvent.getBus((BusGroup)modBusGroup).addListener(this::commonSetup);
        FMLClientSetupEvent.getBus((BusGroup)modBusGroup).addListener(ClientModEvents::onClientSetup);
        ServerStartingEvent.BUS.addListener(this::onServerStarting);
        BuildCreativeModeTabContentsEvent.getBus((BusGroup)modBusGroup).addListener(this::addCreative);
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)MainConfig.SPEC_CLIENT);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {});
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("client side mod, ignoring server side");
    }

    @Mod.EventBusSubscriber(modid="daycount", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("Initializing DayCount mod for Forge");
            dayCountEnabled = MainConfig.getDayCountEnabled();
            DayCountHud.setCurrentTextColor(MainConfig.getTextColorWithTransparency());
            DayCountHud.init();
        }
    }
}

