/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.daycount.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.petemc.daycount.DayCount;

@Mod.EventBusSubscriber(modid="daycount", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MainConfig {
    private static final ForgeConfigSpec.Builder BUILDER_SERVER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC_SERVER = BUILDER_SERVER.build();
    private static final ForgeConfigSpec.Builder BUILDER_CLIENT = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.BooleanValue DAY_COUNT_ENABLED = BUILDER_CLIENT.comment("If true, the Day Count will be displayed | default: true").define("dayCountEnabled", true);
    private static final ForgeConfigSpec.IntValue DAY_OFFSET = BUILDER_CLIENT.comment("Offset to add to the Day Count | default: 1").defineInRange("dayOffset", 1, 0, Integer.MAX_VALUE);
    private static final ForgeConfigSpec.DoubleValue SIZE_X = BUILDER_CLIENT.comment("Horizontal size of the Day Counter | default: 2.0").defineInRange("sizeX", 2.0, 0.0, 20000.0);
    private static final ForgeConfigSpec.DoubleValue SIZE_Y = BUILDER_CLIENT.comment("Vertical size of the Day Counter | default: 2.0").defineInRange("sizeY", 2.0, 0.0, 20000.0);
    private static final ForgeConfigSpec.DoubleValue LOCATION_X = BUILDER_CLIENT.comment("Horizontal position of the Day Counter | default: 2.0").defineInRange("locationX", 2.0, 0.0, 20000.0);
    private static final ForgeConfigSpec.DoubleValue LOCATION_Y = BUILDER_CLIENT.comment("Vertical position of the Day Counter | default: 2.0").defineInRange("locationY", 2.0, 0.0, 20000.0);
    private static final ForgeConfigSpec.ConfigValue<String> TEXT_COLOR_WITH_TRANSPARENCY = BUILDER_CLIENT.comment("Color of the Day Counter (with transparency) | default: FFFFFFFF (the first FFs are the transparency value)").define("textColorWithTransparency", (Object)"FFFFFFFF");
    private static final ForgeConfigSpec.ConfigValue<String> DAY_COUNT_STRING = BUILDER_CLIENT.comment("DayCounter String | default: 'Day: '").define("dayCounterString", (Object)"Day: ");
    public static final ForgeConfigSpec SPEC_CLIENT = BUILDER_CLIENT.build();
    private static boolean dayCountEnabled = true;
    private static int dayOffset = 1;
    private static float sizeX = 2.0f;
    private static float sizeY = 2.0f;
    private static float locationX = 2.0f;
    private static float locationY = 2.0f;
    private static String textColorWithTransparency = "FFFFFFFF";
    private static String dayCounterString = "Day: ";

    public static boolean getDayCountEnabled() {
        return dayCountEnabled;
    }

    public static int getDayOffset() {
        return dayOffset;
    }

    public static float getSizeX() {
        return sizeX;
    }

    public static float getSizeY() {
        return sizeY;
    }

    public static float getLocationX() {
        return locationX;
    }

    public static float getLocationY() {
        return locationY;
    }

    public static String getTextColorWithTransparency() {
        return textColorWithTransparency;
    }

    public static String getDayCounterString() {
        return dayCounterString;
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        if (SPEC_SERVER.isLoaded()) {
            DayCount.LOGGER.info("Loading {} server config", (Object)"daycount");
        }
        if (SPEC_CLIENT.isLoaded()) {
            DayCount.LOGGER.info("Loading {} client config", (Object)"daycount");
            dayCountEnabled = (Boolean)DAY_COUNT_ENABLED.get();
            dayOffset = (Integer)DAY_OFFSET.get();
            sizeX = ((Double)SIZE_X.get()).floatValue();
            sizeY = ((Double)SIZE_Y.get()).floatValue();
            locationX = ((Double)LOCATION_X.get()).floatValue();
            locationY = ((Double)LOCATION_Y.get()).floatValue();
            textColorWithTransparency = (String)TEXT_COLOR_WITH_TRANSPARENCY.get();
        }
    }
}

