/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.daycount.config;

import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.petemc.daycount.DayCount;

@EventBusSubscriber(modid="daycount", bus=EventBusSubscriber.Bus.MOD)
public class MainConfig {
    private static final ModConfigSpec.Builder BUILDER_SERVER = new ModConfigSpec.Builder();
    public static final ModConfigSpec SPEC_SERVER = BUILDER_SERVER.build();
    private static final ModConfigSpec.Builder BUILDER_CLIENT = new ModConfigSpec.Builder();
    private static final ModConfigSpec.BooleanValue DAY_COUNT_ENABLED = BUILDER_CLIENT.comment("If true, the Day Count will be displayed | default: true").define("dayCountEnabled", true);
    private static final ModConfigSpec.IntValue DAY_OFFSET = BUILDER_CLIENT.comment("Offset to add to the Day Count | default: 1").defineInRange("dayOffset", 1, 0, Integer.MAX_VALUE);
    private static final ModConfigSpec.DoubleValue SIZE_X = BUILDER_CLIENT.comment("Horizontal size of the Day Counter | default: 2.0").defineInRange("sizeX", 2.0, 0.0, 20000.0);
    private static final ModConfigSpec.DoubleValue SIZE_Y = BUILDER_CLIENT.comment("Vertical size of the Day Counter | default: 2.0").defineInRange("sizeY", 2.0, 0.0, 20000.0);
    private static final ModConfigSpec.DoubleValue LOCATION_X = BUILDER_CLIENT.comment("Horizontal position of the Day Counter | default: 2.0").defineInRange("locationX", 2.0, 0.0, 20000.0);
    private static final ModConfigSpec.DoubleValue LOCATION_Y = BUILDER_CLIENT.comment("Vertical position of the Day Counter | default: 2.0").defineInRange("locationY", 2.0, 0.0, 20000.0);
    private static final ModConfigSpec.ConfigValue<String> TEXT_COLOR = BUILDER_CLIENT.comment("Color of the Day Counter | default: FFFFFF (for white)").define("textColor", (Object)"FFFFFF");
    private static final ModConfigSpec.ConfigValue<String> DAY_COUNT_STRING = BUILDER_CLIENT.comment("DayCounter String | default: 'Day: '").define("dayCounterString", (Object)"Day: ");
    public static final ModConfigSpec SPEC_CLIENT = BUILDER_CLIENT.build();
    private static boolean dayCountEnabled = true;
    private static int dayOffset = 1;
    private static float sizeX = 2.0f;
    private static float sizeY = 2.0f;
    private static float locationX = 2.0f;
    private static float locationY = 2.0f;
    private static String textColor = "FFFFFF";
    private static String dayCounterString = "Day: ";

    public static boolean getDayCountEnabled() {
        return dayCountEnabled;
    }

    public static int getDayOffset() {
        return dayOffset;
    }

    public static float getSizeX() {
        return sizeX;
    }

    public static float getSizeY() {
        return sizeY;
    }

    public static float getLocationX() {
        return locationX;
    }

    public static float getLocationY() {
        return locationY;
    }

    public static String getTextColor() {
        return textColor;
    }

    public static String getDayCounterString() {
        return dayCounterString;
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        if (SPEC_SERVER.isLoaded()) {
            DayCount.LOGGER.info("Loading {} server config", (Object)"daycount");
        }
        if (SPEC_CLIENT.isLoaded()) {
            DayCount.LOGGER.info("Loading {} client config", (Object)"daycount");
            dayCountEnabled = (Boolean)DAY_COUNT_ENABLED.get();
            dayOffset = (Integer)DAY_OFFSET.get();
            sizeX = ((Double)SIZE_X.get()).floatValue();
            sizeY = ((Double)SIZE_Y.get()).floatValue();
            locationX = ((Double)LOCATION_X.get()).floatValue();
            locationY = ((Double)LOCATION_Y.get()).floatValue();
            textColor = (String)TEXT_COLOR.get();
            dayCounterString = (String)DAY_COUNT_STRING.get();
        }
    }
}

