/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.daycount;

import com.mojang.logging.LogUtils;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.petemc.daycount.client.DayCountClient;
import net.petemc.daycount.config.MainConfig;
import org.slf4j.Logger;

@Mod(value="daycount")
public class DayCount {
    public static final String MOD_ID = "daycount";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static boolean dayCountEnabled = false;

    public DayCount() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)MainConfig.SPEC_CLIENT);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {});
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("client side mod, ignoring server side");
    }

    @Mod.EventBusSubscriber(modid="daycount", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("Initializing DayCount mod for Forge");
            dayCountEnabled = MainConfig.getDayCountEnabled();
            DayCountClient.setCurrentTextColor(MainConfig.getTextColor());
        }

        @SubscribeEvent
        public static void registerGuiOverlays(RegisterGuiOverlaysEvent event) {
            event.registerAboveAll("day_counter_hud", DayCountClient.HUD_DAY_COUNTER);
        }
    }
}

