/*
 * Decompiled with CFR 0.152.
 */
package theduckman64.skinkeybindmanager;

import java.awt.image.BufferedImage;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import theduckman64.skinkeybindmanager.SkinKeybindManagerClient;
import theduckman64.skinkeybindmanager.SkinKeybindUtils;

public class SkinKeybindManagerScreen
extends Screen {
    private final Screen parent;
    private static long lastUploadTime = 0L;
    private static final long UPLOAD_COOLDOWN_MS = 60000L;

    public SkinKeybindManagerScreen(Screen parent) {
        super((Component)Component.literal((String)"Skin Keybind Manager"));
        this.parent = parent;
    }

    protected void init() {
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Back"), b -> this.minecraft.setScreen(this.parent)).bounds(5, 5, 150, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Upload keybinds to skin"), b -> {
            long currentTime = System.currentTimeMillis();
            long timeSinceLastUpload = currentTime - lastUploadTime;
            if (timeSinceLastUpload < 60000L) {
                long remainingMs = 60000L - timeSinceLastUpload;
                long remainingSeconds = (remainingMs + 999L) / 1000L;
                this.showToast("Upload Cooldown", "Please wait " + remainingSeconds + " seconds");
                return;
            }
            try {
                BufferedImage skin = SkinKeybindManagerClient.downloadSkin();
                String variant = SkinKeybindManagerClient.getVariant();
                Map<String, SkinKeybindUtils.KeyData> skinKeybinds = SkinKeybindUtils.decodePlayerSkin(skin, variant);
                Map<String, SkinKeybindUtils.KeyData> mergedBindings = SkinKeybindManagerClient.getMergedKeybinds(skinKeybinds);
                BufferedImage encodedSkin = SkinKeybindUtils.encodePlayerSkin(mergedBindings, skin, variant);
                boolean isSlim = variant.equalsIgnoreCase("slim");
                boolean success = SkinKeybindManagerClient.uploadSkin(SkinKeybindManagerClient.saveSkinToDisk(encodedSkin), isSlim);
                if (success) {
                    lastUploadTime = currentTime;
                    this.showToast("Skin Keybinds", "Successfully uploaded keybinds to skin");
                } else {
                    this.showToast("Skin Keybinds", "Failed to upload skin");
                }
            }
            catch (Exception e) {
                this.showToast("Error", "Failed to upload: " + e.getMessage());
                e.printStackTrace();
            }
        }).bounds(5, 30, 150, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Download keybinds from skin"), b -> {
            try {
                long currentTime = System.currentTimeMillis();
                long timeSinceLastUpload = currentTime - lastUploadTime;
                if (timeSinceLastUpload < 60000L) {
                    long remainingMs = 60000L - timeSinceLastUpload;
                    long remainingSeconds = (remainingMs + 999L) / 1000L;
                    this.showToast("Upload Cooldown", "Please wait " + remainingSeconds + " seconds");
                    return;
                }
                BufferedImage skin = SkinKeybindManagerClient.downloadSkin();
                String variant = SkinKeybindManagerClient.getVariant();
                Map<String, SkinKeybindUtils.KeyData> keybinds = SkinKeybindUtils.decodePlayerSkin(skin, variant);
                int applied = SkinKeybindManagerClient.applyKeybinds(keybinds);
                lastUploadTime = currentTime;
                this.showToast("Skin Keybinds", "Applied " + applied + " keybinds from skin");
            }
            catch (Exception e) {
                this.showToast("Error", "Failed to download: " + e.getMessage());
                e.printStackTrace();
            }
        }).bounds(160, 30, 150, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Save skin with keybinds to disk"), b -> {
            try {
                BufferedImage skin = SkinKeybindManagerClient.downloadSkin();
                String variant = SkinKeybindManagerClient.getVariant();
                Map<String, SkinKeybindUtils.KeyData> skinKeybinds = SkinKeybindUtils.decodePlayerSkin(skin, variant);
                Map<String, SkinKeybindUtils.KeyData> mergedBindings = SkinKeybindManagerClient.getMergedKeybinds(skinKeybinds);
                BufferedImage encodedSkin = SkinKeybindUtils.encodePlayerSkin(mergedBindings, skin, variant);
                SkinKeybindManagerClient.saveSkinToDisk(encodedSkin);
                this.showToast("Skin Keybinds", "Skin saved to disk successfully");
            }
            catch (Exception e) {
                this.showToast("Error", "Failed to save: " + e.getMessage());
                e.printStackTrace();
            }
        }).bounds(5, 55, 150, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Load skin with keybinds from disk"), b -> {
            try {
                BufferedImage skin = SkinKeybindManagerClient.loadSkinFromDisk();
                String variant = SkinKeybindManagerClient.getVariant();
                Map<String, SkinKeybindUtils.KeyData> decoded = SkinKeybindUtils.decodePlayerSkin(skin, variant);
                int applied = SkinKeybindManagerClient.applyKeybinds(decoded);
                this.showToast("Skin Keybinds", "Applied " + applied + " keybinds from disk");
            }
            catch (Exception e) {
                this.showToast("Error", "Failed to load: " + e.getMessage());
                e.printStackTrace();
            }
        }).bounds(160, 55, 150, 20).build());
    }

    private void showToast(String title, String message) {
        Minecraft.getInstance().getToasts().addToast((Toast)new SystemToast(SystemToast.SystemToastId.NARRATOR_TOGGLE, (Component)Component.literal((String)title), (Component)Component.literal((String)message)));
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

