/*
 * Decompiled with CFR 0.152.
 */
package theduckman64.skinkeybindmanager;

import com.mojang.blaze3d.platform.InputConstants;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.User;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.controls.ControlsScreen;
import net.minecraft.network.chat.Component;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.client.event.ScreenEvent;
import theduckman64.skinkeybindmanager.SkinKeybindManagerScreen;
import theduckman64.skinkeybindmanager.SkinKeybindUtils;

@Mod(value="skinkeybindmanager")
@EventBusSubscriber(modid="skinkeybindmanager")
public class SkinKeybindManagerClient {
    public static User user;

    public SkinKeybindManagerClient(IEventBus modBus) {
        modBus.addListener(this::onClientSetup);
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            Minecraft minecraft = Minecraft.getInstance();
            user = minecraft.getUser();
        });
    }

    @SubscribeEvent
    public static void onScreenInit(ScreenEvent.Init.Post event) {
        Minecraft mc = Minecraft.getInstance();
        if (event.getScreen() instanceof ControlsScreen) {
            event.addListener((GuiEventListener)Button.builder((Component)Component.literal((String)"Skin Keybind Manager"), b -> mc.setScreen((Screen)new SkinKeybindManagerScreen(event.getScreen()))).bounds(5, 5, 150, 20).build());
        }
    }

    public static Map<String, SkinKeybindUtils.KeyData> getMergedKeybinds(Map<String, SkinKeybindUtils.KeyData> skinKeybindMap) {
        Minecraft mc = Minecraft.getInstance();
        HashMap<String, SkinKeybindUtils.KeyData> mergedMap = new HashMap<String, SkinKeybindUtils.KeyData>();
        HashMap<String, SkinKeybindUtils.KeyData> remainingSkinKeybinds = skinKeybindMap != null ? new HashMap<String, SkinKeybindUtils.KeyData>(skinKeybindMap) : new HashMap();
        for (KeyMapping kb : mc.options.keyMappings) {
            String id = kb.getName();
            InputConstants.Key boundKey = kb.getKey();
            if (boundKey != InputConstants.UNKNOWN && boundKey.getValue() != -1) {
                String translationKey = boundKey.getName();
                mergedMap.put(id, new SkinKeybindUtils.KeyData(translationKey, id));
                remainingSkinKeybinds.remove(id);
                continue;
            }
            remainingSkinKeybinds.remove(id);
        }
        mergedMap.putAll(remainingSkinKeybinds);
        return mergedMap;
    }

    public static int applyKeybinds(Map<String, SkinKeybindUtils.KeyData> skinKeybindMap) {
        if (skinKeybindMap == null || skinKeybindMap.isEmpty()) {
            return 0;
        }
        Minecraft mc = Minecraft.getInstance();
        KeyMapping[] allKeys = mc.options.keyMappings;
        int applied = 0;
        for (KeyMapping km : allKeys) {
            String name = km.getName();
            if (!skinKeybindMap.containsKey(name)) continue;
            SkinKeybindUtils.KeyData keyData = skinKeybindMap.get(name);
            InputConstants.Key newKey = InputConstants.getKey((String)keyData.translationKey());
            km.setKey(newKey);
            ++applied;
        }
        KeyMapping.resetMapping();
        return applied;
    }

    private static File getSkinFile() {
        return new File(FMLPaths.GAMEDIR.get().toFile(), "skin_encoded.png");
    }

    public static File saveSkinToDisk(BufferedImage skin) throws IOException {
        return SkinKeybindUtils.saveSkinToDisk(skin, SkinKeybindManagerClient.getSkinFile());
    }

    public static BufferedImage loadSkinFromDisk() throws IOException {
        return SkinKeybindUtils.loadSkinFromDisk(SkinKeybindManagerClient.getSkinFile());
    }

    public static BufferedImage downloadSkin() throws IOException {
        if (user == null) {
            throw new IOException("User session not initialized.");
        }
        return SkinKeybindUtils.downloadSkin(user.getProfileId().toString(), user.getAccessToken());
    }

    public static String getVariant() throws IOException {
        if (user == null) {
            throw new IOException("User session not initialized.");
        }
        return SkinKeybindUtils.getVariant(user.getProfileId().toString(), user.getAccessToken());
    }

    public static boolean uploadSkin(File skinFile, boolean slim) throws IOException {
        if (user == null) {
            throw new IOException("User session not initialized.");
        }
        String variant = slim ? "slim" : "classic";
        return SkinKeybindUtils.uploadSkin(skinFile, variant, user.getAccessToken());
    }
}

