/*
 * Decompiled with CFR 0.152.
 */
package com.cwelth.trovogration;

import com.cwelth.trovogration.connection.StaticData;
import com.cwelth.trovogration.datastorage.SafePoint;
import com.cwelth.trovogration.datastorage.TrovoActions;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class Config {
    public static final String CATEGORY_MAIN = "main";
    public static ForgeConfigSpec.BooleanValue ENABLE_MOD;
    public static ForgeConfigSpec.ConfigValue<String> ACTIONS_LIST_POSITION;
    public static ForgeConfigSpec.DoubleValue MANA_MULTIPLIER;
    public static ForgeConfigSpec.DoubleValue ELIXIR_MULTIPLIER;
    public static ForgeConfigSpec.IntValue SUB_TIER1_REWARD;
    public static ForgeConfigSpec.IntValue SUB_TIER2_REWARD;
    public static ForgeConfigSpec.IntValue SUB_TIER3_REWARD;
    public static ForgeConfigSpec.IntValue GIFTSUB_TIER1_REWARD;
    public static ForgeConfigSpec.IntValue GIFTSUB_TIER2_REWARD;
    public static ForgeConfigSpec.IntValue GIFTSUB_TIER3_REWARD;
    public static ForgeConfigSpec.IntValue RAID_REWARD;
    public static ForgeConfigSpec.IntValue RAID_MIN_VIEWERS;
    public static ForgeConfigSpec.IntValue COOLDOWN_ON_DEATH;
    public static ForgeConfigSpec.IntValue COOLDOWN_ON_LIMIT;
    public static ForgeConfigSpec.IntValue COOLDOWN_ON_CONNECT;
    public static ForgeConfigSpec.IntValue SPENDING_LIMIT_PER_DAY;
    public static ForgeConfigSpec.IntValue LIMIT_MAX_DAY;
    public static ForgeConfigSpec.BooleanValue POSITIVE_COMMANDS_ALWAYS_ACTIVE;
    public static ForgeConfigSpec.IntValue COOLDOWN_ON_SETSAFE;
    public static ForgeConfigSpec.IntValue SAFE_RADIUS;
    public static ForgeConfigSpec.BooleanValue SUPERMOD_ALLOWED_TO_ADD_POINTS;
    public static ForgeConfigSpec.BooleanValue MODERATOR_ALLOWED_TO_ADD_POINTS;
    public static final String CATEGORY_ACTIONS = "actions";
    private static final ForgeConfigSpec.Builder CLIENT_BUILDER;
    public static ForgeConfigSpec CLIENT_CONFIG;
    public static ForgeConfigSpec.ConfigValue<List<? extends List<String>>> ACTIONS_LIST;
    public static TrovoActions ACTIONS_COLLECTION;
    public static SafePoint SAFE_POINT;
    public static ForgeConfigSpec.DoubleValue HOMICIDE_REWARD;
    public static ForgeConfigSpec.BooleanValue SAVE_BANK_BETWEEN_SESSIONS;
    public static ForgeConfigSpec.BooleanValue SAVE_SAFE_POINT_BETWEEN_SESSIONS;
    public static ForgeConfigSpec.BooleanValue ENABLE_INTEGRATION_DURING_CREATIVE;
    public static ForgeConfigSpec.IntValue HISTORY_ENTRIES_TO_KEEP;

    public static void fillActionsCollection() {
        ACTIONS_COLLECTION.initFromConfig(ACTIONS_LIST);
    }

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).preserveInsertionOrder().build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
        Config.fillActionsCollection();
        StaticData.loadPersistentData();
    }

    static {
        CLIENT_BUILDER = new ForgeConfigSpec.Builder();
        ACTIONS_COLLECTION = new TrovoActions();
        SAFE_POINT = new SafePoint();
        CLIENT_BUILDER.comment("Main config").push(CATEGORY_MAIN);
        ENABLE_MOD = CLIENT_BUILDER.comment("Is the mod available at all?").define("enable_mod", true);
        ACTIONS_LIST_POSITION = CLIENT_BUILDER.comment("Location of actions panel. MIDDLE_LEFT or MIDDLE_RIGHT are valid options.").defineInList("action_list_position", (Object)"MIDDLE_LEFT", Arrays.asList("MIDDLE_LEFT", "MIDDLE_RIGHT"));
        MANA_MULTIPLIER = CLIENT_BUILDER.comment("Mana adds to RP (regular points), specify multiplier here to set the desired amount of points to add for 1 mana (integer value will be rounded down).").defineInRange("mana_multiplier", 0.01, 0.0, Double.MAX_VALUE);
        ELIXIR_MULTIPLIER = CLIENT_BUILDER.comment("Elixir adds to SP (special points), specify multiplier here to set the desired amount of points to add for 1 elixir (integer value will be rounded down).").defineInRange("elixir_multiplier", 0.5, 0.0, Double.MAX_VALUE);
        HOMICIDE_REWARD = CLIENT_BUILDER.comment("Heat points to add after successful assassination, specify multiplier here to set the desired amount of points to add for 1 heat point (integer value will be rounded down).").defineInRange("homicide_reward_multiplier", 0.2, 0.0, Double.MAX_VALUE);
        SUB_TIER1_REWARD = CLIENT_BUILDER.comment("Tier-1 subscription usually equals to 200 elixir, which adds to SP (special points), specify your desired amount instead.").defineInRange("sub_tier1_reward", 100, 0, Integer.MAX_VALUE);
        SUB_TIER2_REWARD = CLIENT_BUILDER.comment("Tier-2 subscription usually equals to 500 elixir, which adds to SP (special points), specify your desired amount instead.").defineInRange("sub_tier2_reward", 250, 0, Integer.MAX_VALUE);
        SUB_TIER3_REWARD = CLIENT_BUILDER.comment("Tier-3 subscription usually equals to 1000 elixir, which adds to SP (special points), specify your desired amount instead.").defineInRange("sub_tier3_reward", 500, 0, Integer.MAX_VALUE);
        GIFTSUB_TIER1_REWARD = CLIENT_BUILDER.comment("Tier-1 gift-sub usually equals to 200 elixir, which adds to SP (special points), specify your desired amount instead.").defineInRange("giftsub_tier1_reward", 100, 0, Integer.MAX_VALUE);
        GIFTSUB_TIER2_REWARD = CLIENT_BUILDER.comment("Tier-2 gift-sub usually equals to 500 elixir, which adds to SP (special points), specify your desired amount instead.").defineInRange("giftsub_tier2_reward", 250, 0, Integer.MAX_VALUE);
        GIFTSUB_TIER3_REWARD = CLIENT_BUILDER.comment("Tier-3 gift-sub usually equals to 1000 elixir, which adds to SP (special points), specify your desired amount instead.").defineInRange("giftsub_tier3_reward", 500, 0, Integer.MAX_VALUE);
        RAID_REWARD = CLIENT_BUILDER.comment("If you want to reward your stream-raiders, specify the desired amount to add to his/her SP (special points), don't forget about minimum raiders quantity.").defineInRange("raid_reward", 1000, 0, Integer.MAX_VALUE);
        RAID_MIN_VIEWERS = CLIENT_BUILDER.comment("If you decide to reward your stream-raiders, you can specify the minimum number of viewers in raid to pay the reward. Set to 0 to reward any raid (not recommended).").defineInRange("raid_min_viewers", 10, 0, Integer.MAX_VALUE);
        COOLDOWN_ON_DEATH = CLIENT_BUILDER.comment("Set the cooldown time (in seconds) to temporary disable integration when player dies.").defineInRange("cooldown_on_death", 300, 0, Integer.MAX_VALUE);
        COOLDOWN_ON_LIMIT = CLIENT_BUILDER.comment("Set the cooldown time (in seconds) to temporary disable integration when certain amount of points are spent.").defineInRange("cooldown_on_limit", 300, 0, Integer.MAX_VALUE);
        COOLDOWN_ON_CONNECT = CLIENT_BUILDER.comment("Set the cooldown time (in seconds) to temporary disable integration when player just connects to Trovo.").defineInRange("cooldown_on_connect", 60, 0, Integer.MAX_VALUE);
        SPENDING_LIMIT_PER_DAY = CLIENT_BUILDER.comment("How much points is allowed to spend multiplied by minecraft day. When this limit is hit, cooldown_on_limit will begin. ").defineInRange("spending_limit_per_day", 50, 0, Integer.MAX_VALUE);
        LIMIT_MAX_DAY = CLIENT_BUILDER.comment("Maximum multiplier for spending limit. There will be no further limit increase after this day passed. ").defineInRange("limit_max_day", 400, 0, Integer.MAX_VALUE);
        POSITIVE_COMMANDS_ALWAYS_ACTIVE = CLIENT_BUILDER.comment("Should commands marked as \"positive\" be allowed during general cooldowns?").define("positive_commands_always_active", true);
        COOLDOWN_ON_SETSAFE = CLIENT_BUILDER.comment("How many seconds should pass before safe-zone will be set").defineInRange("cooldown_on_setsafe", 300, 0, Integer.MAX_VALUE);
        SAFE_RADIUS = CLIENT_BUILDER.comment("What radius will be set as a \"SAFE ZONE\" on successful activation").defineInRange("safe_radius", 32, 0, Integer.MAX_VALUE);
        MODERATOR_ALLOWED_TO_ADD_POINTS = CLIENT_BUILDER.comment("Should moderators be allowed to use #addsp and #addrp commands?").define("moderator_allowed_to_add_points", false);
        SUPERMOD_ALLOWED_TO_ADD_POINTS = CLIENT_BUILDER.comment("Should super-moderators be allowed to use #addsp and #addrp commands?").define("supermod_allowed_to_add_points", true);
        SAVE_BANK_BETWEEN_SESSIONS = CLIENT_BUILDER.comment("Should Bank Reward be saved between game-sessions?").define("persistent_bank", true);
        SAVE_SAFE_POINT_BETWEEN_SESSIONS = CLIENT_BUILDER.comment("Should Safe Point be saved between game-sessions?").define("persistent_safe_point", false);
        ENABLE_INTEGRATION_DURING_CREATIVE = CLIENT_BUILDER.comment("Should actions be allowed if player is in Creative Mode?").define("allow_creative", false);
        HISTORY_ENTRIES_TO_KEEP = CLIENT_BUILDER.comment("Maximum number of actions to keep for the rollback").defineInRange("history_size", 20, 1, 4096);
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.comment("The list of actions in format of \"command\", \"is action negative?\", \"minimum day\", \"allowed dimension list divided by semicolon (leave blank, if any, add a minus sign at the beginning to specify blacklist instead)\", \"cost\", \"only accept SP?\", \"cooldown (in seconds)\", \"command list divided by semicolon\"").push(CATEGORY_ACTIONS);
        ACTIONS_LIST = CLIENT_BUILDER.defineList(CATEGORY_ACTIONS, new ArrayList<ArrayList>(Arrays.asList(new ArrayList<String>(Arrays.asList("zombie", "true", "1", "", "20", "false", "30", "/summon minecraft:zombie")), new ArrayList<String>(Arrays.asList("skeleton", "true", "1", "-minecraft:the_nether", "30", "false", "30", "/summon minecraft:skeleton")), new ArrayList<String>(Arrays.asList("spider", "true", "1", "", "20", "false", "30", "/summon minecraft:spider")), new ArrayList<String>(Arrays.asList("cow", "false", "1", "minecraft:overworld", "40", "false", "600", "/summon minecraft:cow")), new ArrayList<String>(Arrays.asList("blaze", "true", "10", "minecraft:the_nether", "20", "true", "600", "/summon minecraft:blaze")))), obj -> obj instanceof List);
        CLIENT_BUILDER.pop();
        CLIENT_CONFIG = CLIENT_BUILDER.build();
    }
}

