/*
 * Decompiled with CFR 0.152.
 */
package com.cwelth.trovogration.connection;

import com.cwelth.trovogration.TrovoGration;
import com.cwelth.trovogration.connection.RESTHelper;
import com.cwelth.trovogration.connection.StaticData;
import com.cwelth.trovogration.connection.goodgame.GetGGAuthKey;
import com.cwelth.trovogration.connection.goodgame.GoodgameClient;
import com.cwelth.trovogration.connection.goodgame.wssGGUserInfo;
import com.cwelth.trovogration.connection.trovo.GetTrovoAuthKey;
import com.cwelth.trovogration.connection.trovo.TrovoClient;
import com.cwelth.trovogration.connection.trovo.UserInfo;
import com.cwelth.trovogration.connection.trovo.wssChatToken;
import com.cwelth.trovogration.connection.twitch.GetTwitchAuthKey;
import com.cwelth.trovogration.connection.twitch.TwitchClient;
import com.cwelth.trovogration.connection.twitch.UserInfoJson;
import com.google.gson.Gson;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import net.minecraft.client.player.LocalPlayer;

public class InternalServer {
    public HttpServer httpServer;
    public boolean isListening = false;
    public boolean disconnectedDisplayed = false;
    public boolean waitingForConnectionData = false;
    public TrovoClient trovo = null;
    public TwitchClient twitch = null;
    public GoodgameClient goodgame = null;

    public boolean listen(LocalPlayer localPlayer) {
        StaticData.player = localPlayer;
        if (this.isListening) {
            return false;
        }
        if (StaticData.TrovoOAuthKey != "") {
            TrovoGration.LOGGER.error("[TG] StaticData.TrovoOAuthKey is set! That's not normal!");
            this.done();
        }
        try {
            this.httpServer = HttpServer.create(new InetSocketAddress(56207), 0);
            this.httpServer.createContext("/trovo", new GetTrovoAuthKey());
            this.httpServer.createContext("/twitch", new GetTwitchAuthKey());
            this.httpServer.createContext("/goodgame", new GetGGAuthKey());
            this.httpServer.setExecutor(null);
            this.httpServer.start();
            this.isListening = true;
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void connectToTrovoWss() {
        if (this.trovo != null) {
            this.trovo = null;
        }
        Object message = "";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Client-ID", "8dc67f44eee88811c019371f2478db53");
        headers.put("Authorization", "OAuth " + StaticData.TrovoOAuthKey);
        TrovoGration.LOGGER.info("Asking for channelInfo...");
        String result = RESTHelper.performSyncJSONRequest("https://open-api.trovo.live/openplatform/getuserinfo", "GET", headers, "");
        Gson gs = new Gson();
        UserInfo userInfo = (UserInfo)gs.fromJson(result, UserInfo.class);
        TrovoGration.LOGGER.info("Got channelId: " + userInfo.channelId);
        StaticData.TrovoChannelID = userInfo.channelId;
        headers.clear();
        headers.put("Accept", "application/json");
        headers.put("Client-ID", "8dc67f44eee88811c019371f2478db53");
        TrovoGration.LOGGER.info("Asking for chatToken...");
        result = RESTHelper.performSyncJSONRequest("https://open-api.trovo.live/openplatform/chat/channel-token/" + userInfo.channelId, "GET", headers, "");
        wssChatToken chatToken = (wssChatToken)gs.fromJson(result, wssChatToken.class);
        TrovoGration.LOGGER.info("Got chatToken: " + chatToken.token);
        message = "{ \"type\": \"AUTH\", \"nonce\": \"k7d7hkhfh\", \"data\": { \"token\": \"" + chatToken.token + "\" } }";
        try {
            this.trovo = new TrovoClient();
            TrovoGration.LOGGER.info("Connecting to WSS...");
            this.trovo.connect((String)message);
        }
        catch (Exception e) {
            TrovoGration.LOGGER.error(e.getMessage());
        }
    }

    public void connectToTwitchWss() {
        if (this.twitch != null) {
            this.twitch = null;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Client-ID", "h54dy9gxk43a0xw1zvqfxqgppfnd7g");
        headers.put("Authorization", "Bearer " + StaticData.TwitchOAuthKey);
        TrovoGration.LOGGER.info("Asking for channelInfo...");
        String result = RESTHelper.performSyncJSONRequest("https://api.twitch.tv/helix/users", "GET", headers, "");
        Gson gs = new Gson();
        UserInfoJson userInfo = (UserInfoJson)gs.fromJson(result, UserInfoJson.class);
        TrovoGration.LOGGER.info("Got channelId: " + userInfo.data.get((int)0).id);
        StaticData.TwitchChannelID = userInfo.data.get((int)0).id;
        try {
            this.twitch = new TwitchClient();
            TrovoGration.LOGGER.info("Connecting to WSS...");
            this.twitch.connect(StaticData.TwitchOAuthKey, userInfo.data.get((int)0).login);
        }
        catch (Exception e) {
            TrovoGration.LOGGER.error(e.getMessage());
        }
    }

    public void connectToGoodgameWss() {
        if (this.goodgame != null) {
            this.goodgame = null;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Client-ID", "Trovogration");
        headers.put("Authorization", "Bearer " + StaticData.GoodgameOAuthKey);
        String authResponse = RESTHelper.performSyncJSONRequest("https://goodgame.ru/api/4/users/@me2", "GET", headers, "");
        Gson gson = new Gson();
        wssGGUserInfo userId = (wssGGUserInfo)gson.fromJson(authResponse, wssGGUserInfo.class);
        TrovoGration.LOGGER.info("Got channelId: " + userId.id);
        try {
            this.goodgame = new GoodgameClient();
            TrovoGration.LOGGER.info("Connecting to WSS...");
            this.goodgame.connect(StaticData.GoodgameOAuthKey);
        }
        catch (Exception e) {
            TrovoGration.LOGGER.error(e.getMessage());
        }
    }

    public void done() {
        this.waitingForConnectionData = false;
        if (this.isListening) {
            this.httpServer.stop(3);
            this.isListening = false;
        }
    }
}

