/*
 * Decompiled with CFR 0.152.
 */
package com.cwelth.trovogration.connection;

import com.cwelth.trovogration.Config;
import com.cwelth.trovogration.TrovoGration;
import com.cwelth.trovogration.connection.trovo.PersistentDataJson;
import com.cwelth.trovogration.datastorage.ViewersDB;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import net.minecraft.client.player.LocalPlayer;

public class StaticData {
    public static final String CLIENT_ID_TROVO = "8dc67f44eee88811c019371f2478db53";
    public static final String CLIENT_ID_TWITCH = "h54dy9gxk43a0xw1zvqfxqgppfnd7g";
    public static final String CLIENT_ID_GOODGAME = "Trovogration";
    public static String TrovoOAuthKey = "";
    private static String TrovoPersistentKey = "";
    public static String TwitchOAuthKey = "";
    private static String TwitchPersistentKey = "";
    public static String GoodgameOAuthKey = "";
    private static String GoodgamePersistentKey = "";
    public static LocalPlayer player;
    public static String TrovoChatKey;
    public static String TrovoChannelID;
    public static String TwitchChatKey;
    public static String TwitchChannelID;
    public static long DaysSurvived;
    public static long LoginDay;

    public static void setTrovoKey(String oAuth) {
        TrovoPersistentKey = oAuth;
        StaticData.savePersistentData();
    }

    public static String getTrovoKey() {
        return TrovoPersistentKey == null ? "" : TrovoPersistentKey;
    }

    public static void setTwitchKey(String oAuth) {
        TwitchPersistentKey = oAuth;
        StaticData.savePersistentData();
    }

    public static String getTwitchKey() {
        return TwitchPersistentKey == null ? "" : TwitchPersistentKey;
    }

    public static void setGGKey(String oAuth) {
        GoodgamePersistentKey = oAuth;
        StaticData.savePersistentData();
    }

    public static String getGGKey() {
        return GoodgamePersistentKey == null ? "" : GoodgamePersistentKey;
    }

    public static void savePersistentData() {
        new Thread(() -> {
            Gson builder = new GsonBuilder().setPrettyPrinting().create();
            try {
                FileWriter writer = new FileWriter(ViewersDB.getPath() + "/trovogrationpersistentdata.json", StandardCharsets.UTF_8);
                builder.toJson((Object)new PersistentDataJson(TrovoPersistentKey, TwitchPersistentKey, GoodgamePersistentKey, Config.ACTIONS_COLLECTION.bank, Config.SAFE_POINT, DaysSurvived), (Appendable)writer);
                ((Writer)writer).flush();
                ((Writer)writer).close();
            }
            catch (JsonIOException | IOException e) {
                TrovoGration.LOGGER.error("Cannot save persistent data. " + e.getLocalizedMessage());
            }
        }).start();
    }

    public static void loadPersistentData() {
        try {
            BufferedReader br = new BufferedReader(new FileReader(ViewersDB.getPath() + "/trovogrationpersistentdata.json", StandardCharsets.UTF_8));
            PersistentDataJson json = (PersistentDataJson)new Gson().fromJson((Reader)br, PersistentDataJson.class);
            TrovoPersistentKey = json.oAuthKeyTrovo;
            TwitchPersistentKey = json.oAuthKeyTwitch;
            GoodgamePersistentKey = json.oAuthKeyGoodgame;
            if (((Boolean)Config.SAVE_BANK_BETWEEN_SESSIONS.get()).booleanValue()) {
                Config.ACTIONS_COLLECTION.bank = json.bank;
            }
            if (((Boolean)Config.SAVE_SAFE_POINT_BETWEEN_SESSIONS.get()).booleanValue()) {
                Config.SAFE_POINT = json.safePoint;
            }
            DaysSurvived = json.daysSurvived;
        }
        catch (IOException e) {
            TrovoPersistentKey = "";
            TwitchPersistentKey = "";
            GoodgamePersistentKey = "";
        }
    }

    static {
        TrovoChatKey = "";
        TrovoChannelID = "";
        TwitchChatKey = "";
        TwitchChannelID = "";
        DaysSurvived = 0L;
        LoginDay = -1L;
    }
}

