/*
 * Decompiled with CFR 0.152.
 */
package com.cwelth.trovogration.connection.goodgame;

import com.cwelth.trovogration.Config;
import com.cwelth.trovogration.Sounds;
import com.cwelth.trovogration.TrovoGration;
import com.cwelth.trovogration.connection.RESTHelper;
import com.cwelth.trovogration.connection.StaticData;
import com.cwelth.trovogration.connection.goodgame.GGMessage;
import com.cwelth.trovogration.connection.goodgame.wssGGAuth;
import com.cwelth.trovogration.connection.goodgame.wssGGChannelInfo;
import com.cwelth.trovogration.connection.goodgame.wssGGGiftPremium;
import com.cwelth.trovogration.connection.goodgame.wssGGIncomingData;
import com.cwelth.trovogration.connection.goodgame.wssGGIncomingMsg;
import com.cwelth.trovogration.connection.goodgame.wssGGJoin;
import com.cwelth.trovogration.connection.goodgame.wssGGNewSub;
import com.cwelth.trovogration.connection.goodgame.wssGGOutgoingMsg;
import com.cwelth.trovogration.connection.goodgame.wssGGRaid;
import com.cwelth.trovogration.connection.goodgame.wssGGUserInfo;
import com.cwelth.trovogration.datastorage.StreamPlatform;
import com.cwelth.trovogration.datastorage.TrovoAction;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.ClientCommandHandler;
import trovogration.com.neovisionaries.ws.client.WebSocket;
import trovogration.com.neovisionaries.ws.client.WebSocketAdapter;
import trovogration.com.neovisionaries.ws.client.WebSocketFactory;
import trovogration.com.neovisionaries.ws.client.WebSocketFrame;

public class GoodgameClient {
    public boolean isConnected = false;
    public boolean shouldReconnect = false;
    public String access_token = "";
    public String channel_id = "";
    public int reconnectMultiplier = 1;
    public long wakeUpTime = 0L;
    public WebSocket ws;
    public ExecutorService executorThread = Executors.newFixedThreadPool(1);
    public int pingCoolDown = 0;
    public boolean breakThread = false;

    public void connect(String access_token) throws Exception {
        this.access_token = access_token;
        this.ws = new WebSocketFactory().setConnectionTimeout(1500).createSocket("wss://chat-1.goodgame.ru/chat2/");
        this.ws.addListener(new WebSocketAdapter(){

            @Override
            public void onConnected(WebSocket websocket, Map<String, List<String>> headers) throws Exception {
                TrovoGration.LOGGER.info("Connected. Sending handshake...");
                GoodgameClient.this.wakeUpTime = System.currentTimeMillis() / 1000L;
            }

            @Override
            public void onTextMessage(WebSocket websocket, String message) {
                GoodgameClient.this.onMessage(message);
            }

            @Override
            public void onDisconnected(WebSocket websocket, WebSocketFrame serverCloseFrame, WebSocketFrame clientCloseFrame, boolean closedByServer) throws Exception {
                super.onDisconnected(websocket, serverCloseFrame, clientCloseFrame, closedByServer);
                TrovoGration.LOGGER.info("Disconnected from Goodgame.");
                StaticData.player.m_213846_((Component)Component.m_237115_((String)"status.disconnected"));
                GoodgameClient.this.isConnected = false;
                if (GoodgameClient.this.shouldReconnect) {
                    TrovoGration.LOGGER.info("Reconnecting...");
                    StaticData.player.m_213846_((Component)Component.m_237115_((String)"status.reconnect"));
                    TrovoGration.HTTPSERVER.connectToGoodgameWss();
                }
            }
        }).connect();
    }

    public void disconnect() {
        if (this.isConnected) {
            this.breakThread = true;
            this.shouldReconnect = false;
            this.ws.disconnect(0, "Client request", 3L);
        }
        TrovoGration.viewersDB.saveToDisk();
        TrovoGration.history.saveToDisk();
    }

    public void onMessage(String message) {
        Gson gson = new Gson();
        wssGGIncomingData incomingData = (wssGGIncomingData)gson.fromJson(message, wssGGIncomingData.class);
        switch (incomingData.type) {
            case "welcome": {
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Accept", "application/json");
                headers.put("Client-ID", "Trovogration");
                headers.put("Authorization", "Bearer " + this.access_token);
                String authResponse = RESTHelper.performSyncJSONRequest("https://goodgame.ru/api/4/users/@me2", "GET", headers, "");
                wssGGUserInfo userId = (wssGGUserInfo)gson.fromJson(authResponse, wssGGUserInfo.class);
                if (userId == null) {
                    TrovoGration.LOGGER.info("Disconnected from Goodgame. authResponse: " + authResponse);
                    StaticData.player.m_213846_((Component)Component.m_237115_((String)"status.disconnected"));
                    break;
                }
                String channelResponse = RESTHelper.performSyncJSONRequest("https://goodgame.ru/api/4/streams/2/username/" + userId.username, "GET", headers, "");
                wssGGChannelInfo channelInfo = (wssGGChannelInfo)gson.fromJson(channelResponse, wssGGChannelInfo.class);
                wssGGAuth ggAuth = new wssGGAuth();
                this.channel_id = channelInfo.id;
                ggAuth.data.user_id = userId.id;
                ggAuth.data.token = userId.chatToken;
                String ggAuthStr = gson.toJson((Object)ggAuth);
                this.send(ggAuthStr);
                break;
            }
            case "success_auth": {
                wssGGJoin gGWSSJoin = new wssGGJoin();
                gGWSSJoin.data.channel_id = this.channel_id;
                String ggJoinStr = gson.toJson((Object)gGWSSJoin);
                this.send(ggJoinStr);
                break;
            }
            case "success_join": {
                this.isConnected = true;
                StaticData.player.m_213846_((Component)Component.m_237115_((String)"status.connected"));
                if (!this.shouldReconnect) {
                    Config.ACTIONS_COLLECTION.commonCooldown = (Integer)Config.COOLDOWN_ON_CONNECT.get();
                }
                this.shouldReconnect = true;
                TrovoGration.LOGGER.info("Loading viewers data...");
                TrovoGration.viewersDB.loadFromDisk();
                TrovoGration.LOGGER.info("Loading history...");
                TrovoGration.history.loadFromDisk();
                TrovoGration.LOGGER.info("Done.");
                TrovoGration.HTTPSERVER.waitingForConnectionData = false;
                break;
            }
            case "message": {
                wssGGIncomingMsg msg = (wssGGIncomingMsg)gson.fromJson(message, wssGGIncomingMsg.class);
                if (msg.data._private.equals("1")) break;
                GGMessage ggMessage = GGMessage.Parse(msg);
                this.processChat(ggMessage);
                break;
            }
            case "premium": {
                wssGGNewSub msg = (wssGGNewSub)gson.fromJson(message, wssGGNewSub.class);
                int spAdded = (Integer)Config.SUB_TIER1_REWARD.get();
                TrovoGration.viewersDB.addSPPoints(msg.data.userName, spAdded, StreamPlatform.GOODGAME);
                TrovoGration.history.addPoints(true, msg.data.userName, spAdded, "tier 1 subscription", StreamPlatform.GOODGAME);
                long sp = TrovoGration.viewersDB.getSPPoints(msg.data.userName, StreamPlatform.GOODGAME);
                long rp = TrovoGration.viewersDB.getRPPoints(msg.data.userName, StreamPlatform.GOODGAME);
                this.sendMessageToChat(I18n.m_118938_((String)"commands.addsp", (Object[])new Object[]{msg.data.userName, spAdded, sp, rp}));
                break;
            }
            case "gifted_premiums": {
                wssGGGiftPremium msg = (wssGGGiftPremium)gson.fromJson(message, wssGGGiftPremium.class);
                int resubDuration = 1;
                Pattern giftDuration = Pattern.compile("(\\d+)");
                Matcher giftMatcher = giftDuration.matcher(msg.data.title);
                if (giftMatcher.matches()) {
                    resubDuration = Integer.parseInt(giftMatcher.group(1)) / 30;
                }
                int spAdded = (Integer)Config.GIFTSUB_TIER1_REWARD.get() * msg.data.users.size() * resubDuration;
                TrovoGration.viewersDB.addSPPoints(msg.data.payer, spAdded, StreamPlatform.GOODGAME);
                TrovoGration.history.addPoints(true, msg.data.payer, spAdded, "tier 1 gift sub(s)", StreamPlatform.GOODGAME);
                long sp = TrovoGration.viewersDB.getSPPoints(msg.data.payer, StreamPlatform.GOODGAME);
                long rp = TrovoGration.viewersDB.getRPPoints(msg.data.payer, StreamPlatform.GOODGAME);
                this.sendMessageToChat(I18n.m_118938_((String)"commands.addsp", (Object[])new Object[]{msg.data.payer, spAdded, sp, rp}));
                break;
            }
            case "teleport_aim": {
                wssGGRaid msg = (wssGGRaid)gson.fromJson(message, wssGGRaid.class);
                if (msg.data.usersCnt < (Integer)Config.RAID_MIN_VIEWERS.get()) break;
                int spAdded = (Integer)Config.RAID_REWARD.get();
                TrovoGration.viewersDB.addSPPoints(msg.data.streamerNicknameSrc, spAdded, StreamPlatform.GOODGAME);
                TrovoGration.history.addPoints(true, msg.data.streamerNicknameSrc, spAdded, "raid of " + msg.data.usersCnt, StreamPlatform.GOODGAME);
                long sp = TrovoGration.viewersDB.getSPPoints(msg.data.streamerNicknameSrc, StreamPlatform.GOODGAME);
                long rp = TrovoGration.viewersDB.getRPPoints(msg.data.streamerNicknameSrc, StreamPlatform.GOODGAME);
                this.sendMessageToChat(I18n.m_118938_((String)"commands.addsp", (Object[])new Object[]{msg.data.streamerNicknameSrc, spAdded, sp, rp}));
                break;
            }
        }
    }

    public void send(String toSend) {
        this.ws.sendText(toSend + "\r\n");
    }

    public void sendMessageToChat(String message) {
        Gson gson = new Gson();
        wssGGOutgoingMsg msgData = new wssGGOutgoingMsg();
        msgData.data.text = message;
        msgData.data.channel_id = this.channel_id;
        String jsonData = gson.toJson((Object)msgData);
        this.send(jsonData);
    }

    /*
     * WARNING - void declaration
     */
    public void processChat(GGMessage chat) {
        Gson gson = new Gson();
        boolean isVip = chat.isSubscriber || chat.isMod;
        boolean isMod = chat.isMod;
        if (chat.message.charAt(0) == '#') {
            String[] cmd_parts = chat.message.split(" ");
            cmd_parts[0] = cmd_parts[0].substring(1);
            switch (cmd_parts[0]) {
                case "days": 
                case "gs": {
                    this.sendMessageToChat(I18n.m_118938_((String)"commands.days", (Object[])new Object[]{StaticData.DaysSurvived}));
                    break;
                }
                case "cp": {
                    if (cmd_parts.length == 1) {
                        long sp = TrovoGration.viewersDB.getSPPoints(chat.nickname, StreamPlatform.GOODGAME);
                        long rp = TrovoGration.viewersDB.getRPPoints(chat.nickname, StreamPlatform.GOODGAME);
                        long l = sp + rp;
                        this.sendMessageToChat(I18n.m_118938_((String)"commands.cp", (Object[])new Object[]{chat.nickname, l, sp, rp}));
                        break;
                    }
                    if (cmd_parts.length != 2 || !isVip) break;
                    String viewerName = cmd_parts[1];
                    if (viewerName.charAt(0) == '@') {
                        viewerName = viewerName.substring(1);
                    }
                    long sp = TrovoGration.viewersDB.getSPPoints(viewerName, StreamPlatform.GOODGAME);
                    long rp = TrovoGration.viewersDB.getRPPoints(viewerName, StreamPlatform.GOODGAME);
                    long cpTotal = sp + rp;
                    this.sendMessageToChat(I18n.m_118938_((String)"commands.cp", (Object[])new Object[]{viewerName, cpTotal, sp, rp}));
                    break;
                }
                case "addsp": {
                    if (cmd_parts.length != 3 || ((Boolean)Config.MODERATOR_ALLOWED_TO_ADD_POINTS.get()).booleanValue() && !isVip || ((Boolean)Config.SUPERMOD_ALLOWED_TO_ADD_POINTS.get()).booleanValue() && !isMod) break;
                    int spAdded = Integer.parseInt(cmd_parts[2]);
                    String viewerName = cmd_parts[1];
                    if (viewerName.charAt(0) == '@') {
                        viewerName = viewerName.substring(1);
                    }
                    TrovoGration.viewersDB.addSPPoints(viewerName, spAdded, StreamPlatform.GOODGAME);
                    if (spAdded > 0) {
                        TrovoGration.history.addPoints(true, viewerName, spAdded, chat.nickname + " issued #addsp " + viewerName + " " + spAdded, StreamPlatform.GOODGAME);
                    } else {
                        TrovoGration.history.subtractPoints(true, viewerName, Math.abs(spAdded), chat.nickname + " issued #addsp " + viewerName + " " + spAdded, StreamPlatform.GOODGAME);
                    }
                    long sp = TrovoGration.viewersDB.getSPPoints(viewerName, StreamPlatform.GOODGAME);
                    long l = TrovoGration.viewersDB.getRPPoints(viewerName, StreamPlatform.GOODGAME);
                    this.sendMessageToChat(I18n.m_118938_((String)"commands.addsp", (Object[])new Object[]{viewerName, spAdded, sp, l}));
                    break;
                }
                case "addspx": {
                    if (cmd_parts.length != 4 || ((Boolean)Config.MODERATOR_ALLOWED_TO_ADD_POINTS.get()).booleanValue() && !isVip || ((Boolean)Config.SUPERMOD_ALLOWED_TO_ADD_POINTS.get()).booleanValue() && !isMod) break;
                    float multiplier = Float.parseFloat(cmd_parts[1]);
                    int spAdded = (int)((float)Integer.parseInt(cmd_parts[3]) * multiplier);
                    String viewerName = cmd_parts[2];
                    if (viewerName.charAt(0) == '@') {
                        viewerName = viewerName.substring(1);
                    }
                    TrovoGration.viewersDB.addSPPoints(viewerName, spAdded, StreamPlatform.GOODGAME);
                    if (spAdded > 0) {
                        TrovoGration.history.addPoints(true, viewerName, spAdded, chat.nickname + " issued #addspx " + cmd_parts[1] + " " + viewerName + " " + spAdded, StreamPlatform.GOODGAME);
                    } else {
                        TrovoGration.history.subtractPoints(true, viewerName, Math.abs(spAdded), chat.nickname + " issued #addspx " + cmd_parts[1] + " " + viewerName + " " + spAdded, StreamPlatform.GOODGAME);
                    }
                    long sp = TrovoGration.viewersDB.getSPPoints(viewerName, StreamPlatform.GOODGAME);
                    long rp = TrovoGration.viewersDB.getRPPoints(viewerName, StreamPlatform.GOODGAME);
                    this.sendMessageToChat(I18n.m_118938_((String)"commands.addsp", (Object[])new Object[]{viewerName, spAdded, sp, rp}));
                    break;
                }
                case "addpp": 
                case "addrp": {
                    if (cmd_parts.length != 3 || ((Boolean)Config.MODERATOR_ALLOWED_TO_ADD_POINTS.get()).booleanValue() && !isVip || ((Boolean)Config.SUPERMOD_ALLOWED_TO_ADD_POINTS.get()).booleanValue() && !isMod) break;
                    int rpAdded = Integer.parseInt(cmd_parts[2]);
                    String viewerName = cmd_parts[1];
                    if (viewerName.charAt(0) == '@') {
                        viewerName = viewerName.substring(1);
                    }
                    TrovoGration.viewersDB.addRPPoints(viewerName, rpAdded, StreamPlatform.GOODGAME);
                    if (rpAdded > 0) {
                        TrovoGration.history.addPoints(false, viewerName, rpAdded, chat.nickname + " issued #addrp " + viewerName + " " + rpAdded, StreamPlatform.GOODGAME);
                    } else {
                        TrovoGration.history.subtractPoints(false, viewerName, Math.abs(rpAdded), chat.nickname + " issued #addrp " + viewerName + " " + rpAdded, StreamPlatform.GOODGAME);
                    }
                    long rp = TrovoGration.viewersDB.getRPPoints(viewerName, StreamPlatform.GOODGAME);
                    long l = TrovoGration.viewersDB.getSPPoints(viewerName, StreamPlatform.GOODGAME);
                    this.sendMessageToChat(I18n.m_118938_((String)"commands.addrp", (Object[])new Object[]{viewerName, rpAdded, l, rp}));
                    break;
                }
                case "addppx": 
                case "addrpx": {
                    if (cmd_parts.length != 4 || ((Boolean)Config.MODERATOR_ALLOWED_TO_ADD_POINTS.get()).booleanValue() && !isVip || ((Boolean)Config.SUPERMOD_ALLOWED_TO_ADD_POINTS.get()).booleanValue() && !isMod) break;
                    float multiplier = Float.parseFloat(cmd_parts[1]);
                    int rpAdded = (int)((float)Integer.parseInt(cmd_parts[3]) * multiplier);
                    String viewerName = cmd_parts[2];
                    if (viewerName.charAt(0) == '@') {
                        viewerName = viewerName.substring(1);
                    }
                    TrovoGration.viewersDB.addRPPoints(viewerName, rpAdded, StreamPlatform.GOODGAME);
                    if (rpAdded > 0) {
                        TrovoGration.history.addPoints(false, viewerName, rpAdded, chat.nickname + " issued #addrpx " + cmd_parts[1] + " " + viewerName + " " + rpAdded, StreamPlatform.GOODGAME);
                    } else {
                        TrovoGration.history.subtractPoints(false, viewerName, Math.abs(rpAdded), chat.nickname + " issued #addrpx " + cmd_parts[1] + " " + viewerName + " " + rpAdded, StreamPlatform.GOODGAME);
                    }
                    long rp = TrovoGration.viewersDB.getRPPoints(viewerName, StreamPlatform.GOODGAME);
                    long sp = TrovoGration.viewersDB.getSPPoints(viewerName, StreamPlatform.GOODGAME);
                    this.sendMessageToChat(I18n.m_118938_((String)"commands.addrp", (Object[])new Object[]{viewerName, rpAdded, sp, rp}));
                    break;
                }
                case "link": {
                    this.sendMessageToChat(I18n.m_118938_((String)"commands.link_new_command", (Object[])new Object[0]));
                    break;
                }
                case "twitch": {
                    if (cmd_parts.length != 2) break;
                    String foreignAccount = cmd_parts[1];
                    TrovoGration.linkRequests.addLinkRequest(StreamPlatform.GOODGAME, chat.nickname, StreamPlatform.TWITCH, foreignAccount);
                    break;
                }
                case "trovo": {
                    if (cmd_parts.length != 2) break;
                    String foreignAccount = cmd_parts[1];
                    TrovoGration.linkRequests.addLinkRequest(StreamPlatform.GOODGAME, chat.nickname, StreamPlatform.TROVO, foreignAccount);
                    break;
                }
                case "check": {
                    if (cmd_parts.length != 1) break;
                    int regViewerIdx = TrovoGration.viewersDB.findViewer(chat.nickname, StreamPlatform.GOODGAME);
                    if (regViewerIdx == -1) {
                        this.sendMessageToChat(I18n.m_118938_((String)"commands.link_check_failed", (Object[])new Object[]{chat.nickname}));
                        break;
                    }
                    String regIdTwitch = TrovoGration.viewersDB.viewers.get((int)regViewerIdx).userNameTwitch;
                    String regIdTrovo = TrovoGration.viewersDB.viewers.get((int)regViewerIdx).userNameTrovo;
                    String regIdGoodGame = TrovoGration.viewersDB.viewers.get((int)regViewerIdx).userNameGoodgame;
                    if (!regIdTrovo.isEmpty() && !regIdTwitch.isEmpty()) {
                        this.sendMessageToChat(I18n.m_118938_((String)"commands.link_check_two", (Object[])new Object[]{chat.nickname, "Trovo", regIdTrovo, "Twitch", regIdTwitch}));
                        break;
                    }
                    if (!regIdTrovo.isEmpty()) {
                        this.sendMessageToChat(I18n.m_118938_((String)"commands.link_check_one", (Object[])new Object[]{chat.nickname, "Trovo", regIdTrovo}));
                        break;
                    }
                    if (!regIdTwitch.isEmpty()) {
                        this.sendMessageToChat(I18n.m_118938_((String)"commands.link_check_one", (Object[])new Object[]{chat.nickname, "Twitch", regIdTwitch}));
                        break;
                    }
                    this.sendMessageToChat(I18n.m_118938_((String)"commands.link_check_failed", (Object[])new Object[]{chat.nickname}));
                    break;
                }
                case "unlink": {
                    StreamPlatform sp_foreignPlatform;
                    if (cmd_parts.length != 2) {
                        this.sendMessageToChat(I18n.m_118938_((String)"commands.unlink_failed_args", (Object[])new Object[0]));
                        break;
                    }
                    String foreignPlatform = cmd_parts[1];
                    StreamPlatform streamPlatform = foreignPlatform.equalsIgnoreCase("trovo") ? StreamPlatform.TROVO : (foreignPlatform.equalsIgnoreCase("twitch") ? StreamPlatform.TWITCH : (sp_foreignPlatform = foreignPlatform.equalsIgnoreCase("goodgame") ? StreamPlatform.GOODGAME : StreamPlatform.UNKNOWN));
                    if (sp_foreignPlatform == StreamPlatform.UNKNOWN) {
                        this.sendMessageToChat(I18n.m_118938_((String)"commands.unlink_failed_args", (Object[])new Object[0]));
                        break;
                    }
                    int regViewerIdx = TrovoGration.viewersDB.findViewer(chat.nickname, StreamPlatform.GOODGAME);
                    if (regViewerIdx == -1) {
                        this.sendMessageToChat(I18n.m_118938_((String)"commands.unlink_failed", (Object[])new Object[]{foreignPlatform}));
                        break;
                    }
                    int existingLink = TrovoGration.linkRequests.getPendingLinkIndex(chat.nickname, StreamPlatform.GOODGAME, sp_foreignPlatform);
                    if (existingLink != -1) {
                        void var12_35;
                        String string = "";
                        if (sp_foreignPlatform == StreamPlatform.TWITCH) {
                            String string2 = TrovoGration.linkRequests.requests.get((int)existingLink).twitchNickname;
                        }
                        if (sp_foreignPlatform == StreamPlatform.TROVO) {
                            String string3 = TrovoGration.linkRequests.requests.get((int)existingLink).trovoNickname;
                        }
                        TrovoGration.linkRequests.requests.remove(existingLink);
                        this.sendMessageToChat(I18n.m_118938_((String)"commands.unlink_request_cancelled", (Object[])new Object[]{var12_35, foreignPlatform}));
                        break;
                    }
                    String string = TrovoGration.viewersDB.viewers.get((int)regViewerIdx).userNameTwitch;
                    String regIdTrovo = TrovoGration.viewersDB.viewers.get((int)regViewerIdx).userNameTrovo;
                    String regIdGoodGame = TrovoGration.viewersDB.viewers.get((int)regViewerIdx).userNameGoodgame;
                    if (sp_foreignPlatform == StreamPlatform.TWITCH) {
                        if (string.isEmpty()) {
                            this.sendMessageToChat(I18n.m_118938_((String)"commands.unlink_failed", (Object[])new Object[]{chat.nickname, foreignPlatform}));
                            break;
                        }
                        TrovoGration.viewersDB.viewers.get((int)regViewerIdx).userNameTwitch = "";
                        TrovoGration.viewersDB.saveToDisk();
                        this.sendMessageToChat(I18n.m_118938_((String)"commands.unlink_success", (Object[])new Object[]{chat.nickname, string, foreignPlatform}));
                        break;
                    }
                    if (sp_foreignPlatform != StreamPlatform.TROVO) break;
                    if (regIdTrovo.isEmpty()) {
                        this.sendMessageToChat(I18n.m_118938_((String)"commands.unlink_failed", (Object[])new Object[]{chat.nickname, foreignPlatform}));
                        break;
                    }
                    TrovoGration.viewersDB.viewers.get((int)regViewerIdx).userNameTrovo = "";
                    TrovoGration.viewersDB.saveToDisk();
                    this.sendMessageToChat(I18n.m_118938_((String)"commands.unlink_success", (Object[])new Object[]{chat.nickname, regIdGoodGame, foreignPlatform}));
                    break;
                }
                default: {
                    TrovoAction matchedAction = Config.ACTIONS_COLLECTION.getSuitableCommand(cmd_parts[0]);
                    if (matchedAction == null || !TrovoGration.viewersDB.discardPoints(chat.nickname, matchedAction.cost, matchedAction.spOnly, StreamPlatform.GOODGAME)) break;
                    TrovoGration.history.subtractPoints(matchedAction.spOnly, chat.nickname, matchedAction.cost, "#" + cmd_parts[0], StreamPlatform.GOODGAME);
                    if (matchedAction.isNegative) {
                        Sounds.PlaySoundOnClient("negative_action");
                    } else {
                        Sounds.PlaySoundOnClient("positive_action");
                    }
                    if (matchedAction.commands_list.startsWith("r/")) {
                        clear_command = matchedAction.commands_list.substring(2);
                        int lastIndex = ((String)clear_command).lastIndexOf(47);
                        int count = Integer.parseInt(((String)clear_command).substring(lastIndex + 1));
                        clear_command = ((String)clear_command).substring(0, lastIndex);
                        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(((String)clear_command).split(";")));
                        int rndLimit = arrayList.size();
                        for (int i = 0; i < count; ++i) {
                            Object summonCommand = arrayList.get((int)(Math.random() * (double)rndLimit));
                            if (((String)summonCommand).startsWith("/summon")) {
                                summonCommand = !((String)summonCommand).substring(((String)summonCommand).length() - 1).equals("}") ? (String)summonCommand + " ~ ~ ~ {CustomName:'{\"text\":\"" + chat.nickname + "G\"}',CustomNameVisible:1}" : ((String)summonCommand).substring(0, ((String)summonCommand).length() - 1) + ",CustomName:'{\"text\":\"" + chat.nickname + "G\"}',CustomNameVisible:1}";
                            }
                            if (((String)summonCommand).startsWith("/xc summonnamed")) {
                                summonCommand = ((String)summonCommand).replace("%name%", chat.nickname + "G");
                            }
                            if (((String)summonCommand).startsWith("/")) {
                                summonCommand = ((String)summonCommand).substring(1);
                            }
                            StaticData.player.f_108617_.m_246623_((String)summonCommand);
                        }
                    } else if (matchedAction.commands_list.startsWith("c/")) {
                        clear_command = matchedAction.commands_list.substring(2);
                        if (((String)clear_command).startsWith("/")) {
                            clear_command = ((String)clear_command).substring(1);
                        }
                        ClientCommandHandler.runCommand((String)clear_command);
                    } else {
                        for (String string : matchedAction.commands_list.split(";")) {
                            void var12_38;
                            void var12_44;
                            void var12_42;
                            if (string.startsWith("/summon")) {
                                if (!string.substring(string.length() - 1).equals("}")) {
                                    String string4 = string + " ~ ~ ~ {CustomName:'{\"text\":\"" + chat.nickname + "G\"}',CustomNameVisible:1}";
                                } else {
                                    String string5 = string.substring(0, string.length() - 1) + ",CustomName:'{\"text\":\"" + chat.nickname + "G\"}',CustomNameVisible:1}";
                                }
                            }
                            if (var12_42.startsWith("/xc summonnamed")) {
                                String string6 = var12_42.replace("%name%", chat.nickname + "G");
                            }
                            if (var12_44.startsWith("/")) {
                                String string7 = var12_44.substring(1);
                            }
                            StaticData.player.f_108617_.m_246623_((String)var12_38);
                        }
                    }
                    Config.ACTIONS_COLLECTION.setActionCooldown(matchedAction.command);
                    Config.ACTIONS_COLLECTION.updateAvailableList();
                    long sp = TrovoGration.viewersDB.getSPPoints(chat.nickname, StreamPlatform.GOODGAME);
                    long rp = TrovoGration.viewersDB.getRPPoints(chat.nickname, StreamPlatform.GOODGAME);
                    this.sendMessageToChat(I18n.m_118938_((String)"commands.fired", (Object[])new Object[]{chat.nickname, matchedAction.command, sp, rp}));
                }
            }
        }
    }
}

