/*
 * Decompiled with CFR 0.152.
 */
package com.cwelth.trovogration.connection.trovo;

import com.cwelth.trovogration.Config;
import com.cwelth.trovogration.Sounds;
import com.cwelth.trovogration.TrovoGration;
import com.cwelth.trovogration.connection.RESTHelper;
import com.cwelth.trovogration.connection.StaticData;
import com.cwelth.trovogration.connection.trovo.ChatContent;
import com.cwelth.trovogration.connection.trovo.TrovoSpell;
import com.cwelth.trovogration.connection.trovo.wssChatChat;
import com.cwelth.trovogration.connection.trovo.wssChatChatsDataChat;
import com.cwelth.trovogration.connection.trovo.wssChatPong;
import com.cwelth.trovogration.connection.trovo.wssChatType;
import com.cwelth.trovogration.datastorage.StreamPlatform;
import com.cwelth.trovogration.datastorage.TrovoAction;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.ClientCommandHandler;
import trovogration.com.neovisionaries.ws.client.WebSocket;
import trovogration.com.neovisionaries.ws.client.WebSocketAdapter;
import trovogration.com.neovisionaries.ws.client.WebSocketFactory;
import trovogration.com.neovisionaries.ws.client.WebSocketFrame;

public class TrovoClient {
    public boolean isConnected = false;
    public boolean shouldReconnect = false;
    public String handShakeMessage = "";
    public int reconnectMultiplier = 1;
    public long wakeUpTime = 0L;
    public WebSocket ws;
    public ExecutorService executorThread = Executors.newFixedThreadPool(1);
    public int pingCoolDown = 0;
    public boolean breakThread = false;

    public void connect(final String handShakeMessage) throws Exception {
        this.handShakeMessage = handShakeMessage;
        this.ws = new WebSocketFactory().setConnectionTimeout(1500).createSocket("wss://open-chat.trovo.live/chat");
        this.ws.addListener(new WebSocketAdapter(){

            @Override
            public void onConnected(WebSocket websocket, Map<String, List<String>> headers) throws Exception {
                TrovoGration.LOGGER.info("Connected. Sending handshake...");
                TrovoClient.this.send(handShakeMessage);
                TrovoClient.this.wakeUpTime = System.currentTimeMillis() / 1000L;
            }

            @Override
            public void onTextMessage(WebSocket websocket, String message) {
                TrovoClient.this.onMessage(message);
            }

            @Override
            public void onDisconnected(WebSocket websocket, WebSocketFrame serverCloseFrame, WebSocketFrame clientCloseFrame, boolean closedByServer) throws Exception {
                super.onDisconnected(websocket, serverCloseFrame, clientCloseFrame, closedByServer);
                TrovoGration.LOGGER.info("Disconnected from Trovo.");
                StaticData.player.m_213846_((Component)Component.m_237115_((String)"status.disconnected"));
                TrovoClient.this.isConnected = false;
                if (TrovoClient.this.shouldReconnect) {
                    TrovoGration.LOGGER.info("Reconnecting...");
                    StaticData.player.m_213846_((Component)Component.m_237115_((String)"status.reconnect"));
                    TrovoGration.HTTPSERVER.connectToTrovoWss();
                }
            }
        }).connect();
    }

    public void disconnect() {
        if (this.isConnected) {
            this.breakThread = true;
            this.shouldReconnect = false;
            this.ws.disconnect(0, "Client request", 3L);
        }
        TrovoGration.viewersDB.saveToDisk();
        TrovoGration.history.saveToDisk();
    }

    public void pingPong() {
        this.breakThread = false;
        this.executorThread.submit(() -> {
            while (!this.breakThread) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (this.pingCoolDown <= 0) continue;
                --this.pingCoolDown;
                if (this.pingCoolDown != 0) continue;
                this.send("{ \"type\": \"PING\", \"nonce\": \"sjdygjsdf\" }");
            }
        });
        this.executorThread.shutdown();
    }

    public void onMessage(String message) {
        Gson gson = new Gson();
        wssChatType chatType = (wssChatType)gson.fromJson(message, wssChatType.class);
        switch (chatType.type) {
            case "RESPONSE": {
                this.isConnected = true;
                TrovoGration.LOGGER.info("Got RESPONSE from WSS! message:" + message);
                StaticData.player.m_213846_((Component)Component.m_237115_((String)"status.connected"));
                if (!this.shouldReconnect) {
                    Config.ACTIONS_COLLECTION.commonCooldown = (Integer)Config.COOLDOWN_ON_CONNECT.get();
                }
                this.shouldReconnect = true;
                this.pingCoolDown = 59;
                this.pingPong();
                TrovoGration.LOGGER.info("Loading viewers data...");
                TrovoGration.viewersDB.loadFromDisk();
                TrovoGration.LOGGER.info("Loading history...");
                TrovoGration.history.loadFromDisk();
                TrovoGration.LOGGER.info("Done.");
                TrovoGration.HTTPSERVER.waitingForConnectionData = false;
                break;
            }
            case "PONG": {
                wssChatPong chatPong = (wssChatPong)gson.fromJson(message, wssChatPong.class);
                this.pingCoolDown = chatPong.data.gap;
                break;
            }
            case "CHAT": {
                try {
                    wssChatChat chatChat = (wssChatChat)gson.fromJson(message, wssChatChat.class);
                    this.processChat(chatChat);
                    break;
                }
                catch (Exception e) {
                    TrovoGration.LOGGER.error(e.getMessage());
                }
            }
        }
    }

    public void send(String toSend) {
        this.ws.sendText(toSend);
    }

    public void sendMessageToChat(String message) {
        new Thread(() -> {
            Gson gs = new Gson();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "application/json");
            headers.put("Client-ID", "8dc67f44eee88811c019371f2478db53");
            headers.put("Authorization", "OAuth " + StaticData.TrovoOAuthKey);
            ChatContent chatContent = new ChatContent();
            chatContent.content = message;
            chatContent.channel_id = StaticData.TrovoChannelID;
            String body = gs.toJson((Object)chatContent);
            String result = RESTHelper.performSyncJSONRequest("https://open-api.trovo.live/openplatform/chat/send", "POST", headers, body);
            TrovoGration.LOGGER.info("Sent message response: " + result);
        }).start();
    }

    /*
     * WARNING - void declaration
     */
    public void processChat(wssChatChat chats) {
        block29: for (wssChatChatsDataChat chat : chats.data.chats) {
            long rp;
            if (Double.parseDouble(chat.send_time) < (double)this.wakeUpTime) continue;
            Gson gson = new Gson();
            boolean isStreamer = false;
            boolean isModerator = false;
            boolean isSupermod = false;
            List<String> rolesList = Arrays.stream(chat.roles).toList();
            if (rolesList.contains("streamer")) {
                isSupermod = true;
                isModerator = true;
                isStreamer = true;
            } else if (rolesList.contains("supermod") || rolesList.contains("editor")) {
                isSupermod = true;
                isModerator = true;
            } else if (rolesList.contains("mod")) {
                isModerator = true;
            }
            if (chat.type == 5 || chat.type == 5009) {
                TrovoSpell spell = (TrovoSpell)gson.fromJson(chat.content, TrovoSpell.class);
                int amountToAdd = spell.gift_value * spell.num;
                if (spell.value_type.equalsIgnoreCase("mana")) {
                    amountToAdd = (int)((double)amountToAdd * (Double)Config.MANA_MULTIPLIER.get());
                    TrovoGration.viewersDB.addRPPoints(chat.nick_name, amountToAdd, StreamPlatform.TROVO);
                    TrovoGration.history.addPoints(false, chat.nick_name, amountToAdd, spell.gift + "x" + spell.num, StreamPlatform.TROVO);
                    long sp = TrovoGration.viewersDB.getSPPoints(chat.nick_name, StreamPlatform.TROVO);
                    long rp2 = TrovoGration.viewersDB.getRPPoints(chat.nick_name, StreamPlatform.TROVO);
                    this.sendMessageToChat(I18n.m_118938_((String)"commands.addrp", (Object[])new Object[]{chat.nick_name, amountToAdd, sp, rp2}));
                } else {
                    amountToAdd = (int)((double)amountToAdd * (Double)Config.ELIXIR_MULTIPLIER.get());
                    TrovoGration.viewersDB.addSPPoints(chat.nick_name, amountToAdd, StreamPlatform.TROVO);
                    TrovoGration.history.addPoints(true, chat.nick_name, amountToAdd, spell.gift + "x" + spell.num, StreamPlatform.TROVO);
                    long sp = TrovoGration.viewersDB.getSPPoints(chat.nick_name, StreamPlatform.TROVO);
                    long rp3 = TrovoGration.viewersDB.getRPPoints(chat.nick_name, StreamPlatform.TROVO);
                    this.sendMessageToChat(I18n.m_118938_((String)"commands.addsp", (Object[])new Object[]{chat.nick_name, amountToAdd, sp, rp3}));
                }
            }
            if (chat.type == 5008 && chat.content_data.raiderNum >= (Integer)Config.RAID_MIN_VIEWERS.get()) {
                int spAdded = (Integer)Config.RAID_REWARD.get();
                TrovoGration.viewersDB.addSPPoints(chat.content_data.nickname, spAdded, StreamPlatform.TROVO);
                TrovoGration.history.addPoints(true, chat.content_data.nickname, spAdded, "raid of " + chat.content_data.raiderNum, StreamPlatform.TROVO);
                long sp = TrovoGration.viewersDB.getSPPoints(chat.content_data.nickname, StreamPlatform.TROVO);
                rp = TrovoGration.viewersDB.getRPPoints(chat.content_data.nickname, StreamPlatform.TROVO);
                this.sendMessageToChat(I18n.m_118938_((String)"commands.addsp", (Object[])new Object[]{chat.nick_name, spAdded, sp, rp}));
            }
            if (chat.type == 5001 && chat.content_data != null && chat.content_data.isReSub != -1) {
                int spAdded = 0;
                if (chat.sub_tier == 1) {
                    spAdded = (Integer)Config.SUB_TIER1_REWARD.get();
                }
                if (chat.sub_tier == 2) {
                    spAdded = (Integer)Config.SUB_TIER2_REWARD.get();
                }
                if (chat.sub_tier == 3) {
                    spAdded = (Integer)Config.SUB_TIER3_REWARD.get();
                }
                TrovoGration.viewersDB.addSPPoints(chat.nick_name, spAdded, StreamPlatform.TROVO);
                TrovoGration.history.addPoints(true, chat.nick_name, spAdded, "tier " + chat.sub_tier + " subscription", StreamPlatform.TROVO);
                long sp = TrovoGration.viewersDB.getSPPoints(chat.nick_name, StreamPlatform.TROVO);
                rp = TrovoGration.viewersDB.getRPPoints(chat.nick_name, StreamPlatform.TROVO);
                this.sendMessageToChat(I18n.m_118938_((String)"commands.addsp", (Object[])new Object[]{chat.nick_name, spAdded, sp, rp}));
            }
            if (chat.type == 5005) {
                // empty if block
            }
            if (chat.type == 5006) {
                int spAdded = 0;
                if (chat.content_data.tier == 1) {
                    spAdded = (Integer)Config.GIFTSUB_TIER1_REWARD.get();
                }
                if (chat.content_data.tier == 2) {
                    spAdded = (Integer)Config.GIFTSUB_TIER2_REWARD.get();
                }
                if (chat.content_data.tier == 3) {
                    spAdded = (Integer)Config.GIFTSUB_TIER3_REWARD.get();
                }
                TrovoGration.viewersDB.addSPPoints(chat.nick_name, spAdded, StreamPlatform.TROVO);
                TrovoGration.history.addPoints(true, chat.nick_name, spAdded, "tier " + chat.content_data.tier + " gift sub", StreamPlatform.TROVO);
                long sp = TrovoGration.viewersDB.getSPPoints(chat.nick_name, StreamPlatform.TROVO);
                rp = TrovoGration.viewersDB.getRPPoints(chat.nick_name, StreamPlatform.TROVO);
                this.sendMessageToChat(I18n.m_118938_((String)"commands.addsp", (Object[])new Object[]{chat.nick_name, spAdded, sp, rp}));
            }
            if (chat.type != 0 || !chat.content.substring(0, 1).equals("#")) continue;
            String[] cmd_parts = chat.content.split(" ");
            cmd_parts[0] = cmd_parts[0].substring(1);
            switch (cmd_parts[0]) {
                case "days": 
                case "gs": {
                    this.sendMessageToChat(I18n.m_118938_((String)"commands.days", (Object[])new Object[]{StaticData.DaysSurvived}));
                    continue block29;
                }
                case "cp": {
                    if (cmd_parts.length == 1) {
                        long sp = TrovoGration.viewersDB.getSPPoints(chat.nick_name, StreamPlatform.TROVO);
                        long rp4 = TrovoGration.viewersDB.getRPPoints(chat.nick_name, StreamPlatform.TROVO);
                        long l = sp + rp4;
                        this.sendMessageToChat(I18n.m_118938_((String)"commands.cp", (Object[])new Object[]{chat.nick_name, l, sp, rp4}));
                        continue block29;
                    }
                    if (cmd_parts.length != 2 || !isModerator) continue block29;
                    String viewerName = cmd_parts[1];
                    if (viewerName.charAt(0) == '@') {
                        viewerName = viewerName.substring(1);
                    }
                    long sp = TrovoGration.viewersDB.getSPPoints(viewerName, StreamPlatform.TROVO);
                    long rp5 = TrovoGration.viewersDB.getRPPoints(viewerName, StreamPlatform.TROVO);
                    long cpTotal = sp + rp5;
                    this.sendMessageToChat(I18n.m_118938_((String)"commands.cp", (Object[])new Object[]{viewerName, cpTotal, sp, rp5}));
                    continue block29;
                }
                case "addsp": {
                    if (cmd_parts.length != 3 || ((Boolean)Config.MODERATOR_ALLOWED_TO_ADD_POINTS.get()).booleanValue() && !isModerator || ((Boolean)Config.SUPERMOD_ALLOWED_TO_ADD_POINTS.get()).booleanValue() && !isSupermod) continue block29;
                    int spAdded = Integer.parseInt(cmd_parts[2]);
                    String viewerName = cmd_parts[1];
                    if (viewerName.charAt(0) == '@') {
                        viewerName = viewerName.substring(1);
                    }
                    TrovoGration.viewersDB.addSPPoints(viewerName, spAdded, StreamPlatform.TROVO);
                    if (spAdded > 0) {
                        TrovoGration.history.addPoints(true, viewerName, spAdded, chat.nick_name + " issued #addsp " + viewerName + " " + spAdded, StreamPlatform.TROVO);
                    } else {
                        TrovoGration.history.subtractPoints(true, viewerName, Math.abs(spAdded), chat.nick_name + " issued #addsp " + viewerName + " " + spAdded, StreamPlatform.TROVO);
                    }
                    long sp = TrovoGration.viewersDB.getSPPoints(viewerName, StreamPlatform.TROVO);
                    long l = TrovoGration.viewersDB.getRPPoints(viewerName, StreamPlatform.TROVO);
                    this.sendMessageToChat(I18n.m_118938_((String)"commands.addsp", (Object[])new Object[]{viewerName, spAdded, sp, l}));
                    continue block29;
                }
                case "addspx": {
                    if (cmd_parts.length != 4 || ((Boolean)Config.MODERATOR_ALLOWED_TO_ADD_POINTS.get()).booleanValue() && !isModerator || ((Boolean)Config.SUPERMOD_ALLOWED_TO_ADD_POINTS.get()).booleanValue() && !isSupermod) continue block29;
                    float multiplier = Float.parseFloat(cmd_parts[1]);
                    int spAdded = (int)((float)Integer.parseInt(cmd_parts[3]) * multiplier);
                    String viewerName = cmd_parts[2];
                    if (viewerName.charAt(0) == '@') {
                        viewerName = viewerName.substring(1);
                    }
                    TrovoGration.viewersDB.addSPPoints(viewerName, spAdded, StreamPlatform.TROVO);
                    if (spAdded > 0) {
                        TrovoGration.history.addPoints(true, viewerName, spAdded, chat.nick_name + " issued #addspx " + cmd_parts[1] + " " + viewerName + " " + spAdded, StreamPlatform.TROVO);
                    } else {
                        TrovoGration.history.subtractPoints(true, viewerName, Math.abs(spAdded), chat.nick_name + " issued #addspx " + cmd_parts[1] + " " + viewerName + " " + spAdded, StreamPlatform.TROVO);
                    }
                    long sp = TrovoGration.viewersDB.getSPPoints(viewerName, StreamPlatform.TROVO);
                    long rp7 = TrovoGration.viewersDB.getRPPoints(viewerName, StreamPlatform.TROVO);
                    this.sendMessageToChat(I18n.m_118938_((String)"commands.addsp", (Object[])new Object[]{viewerName, spAdded, sp, rp7}));
                    continue block29;
                }
                case "addpp": 
                case "addrp": {
                    if (cmd_parts.length != 3 || ((Boolean)Config.MODERATOR_ALLOWED_TO_ADD_POINTS.get()).booleanValue() && !isModerator || ((Boolean)Config.SUPERMOD_ALLOWED_TO_ADD_POINTS.get()).booleanValue() && !isSupermod) continue block29;
                    int rpAdded = Integer.parseInt(cmd_parts[2]);
                    String viewerName = cmd_parts[1];
                    if (viewerName.charAt(0) == '@') {
                        viewerName = viewerName.substring(1);
                    }
                    TrovoGration.viewersDB.addRPPoints(viewerName, rpAdded, StreamPlatform.TROVO);
                    if (rpAdded > 0) {
                        TrovoGration.history.addPoints(false, viewerName, rpAdded, chat.nick_name + " issued #addrp " + viewerName + " " + rpAdded, StreamPlatform.TROVO);
                    } else {
                        TrovoGration.history.subtractPoints(false, viewerName, Math.abs(rpAdded), chat.nick_name + " issued #addrp " + viewerName + " " + rpAdded, StreamPlatform.TROVO);
                    }
                    long rp8 = TrovoGration.viewersDB.getRPPoints(viewerName, StreamPlatform.TROVO);
                    long l = TrovoGration.viewersDB.getSPPoints(viewerName, StreamPlatform.TROVO);
                    this.sendMessageToChat(I18n.m_118938_((String)"commands.addrp", (Object[])new Object[]{viewerName, rpAdded, l, rp8}));
                    continue block29;
                }
                case "addppx": 
                case "addrpx": {
                    if (cmd_parts.length != 4 || ((Boolean)Config.MODERATOR_ALLOWED_TO_ADD_POINTS.get()).booleanValue() && !isModerator || ((Boolean)Config.SUPERMOD_ALLOWED_TO_ADD_POINTS.get()).booleanValue() && !isSupermod) continue block29;
                    float multiplier = Float.parseFloat(cmd_parts[1]);
                    int rpAdded = (int)((float)Integer.parseInt(cmd_parts[3]) * multiplier);
                    String viewerName = cmd_parts[2];
                    if (viewerName.charAt(0) == '@') {
                        viewerName = viewerName.substring(1);
                    }
                    TrovoGration.viewersDB.addRPPoints(viewerName, rpAdded, StreamPlatform.TROVO);
                    if (rpAdded > 0) {
                        TrovoGration.history.addPoints(false, viewerName, rpAdded, chat.nick_name + " issued #addrpx " + cmd_parts[1] + " " + viewerName + " " + rpAdded, StreamPlatform.TROVO);
                    } else {
                        TrovoGration.history.subtractPoints(false, viewerName, Math.abs(rpAdded), chat.nick_name + " issued #addrpx " + cmd_parts[1] + " " + viewerName + " " + rpAdded, StreamPlatform.TROVO);
                    }
                    long rp9 = TrovoGration.viewersDB.getRPPoints(viewerName, StreamPlatform.TROVO);
                    long sp = TrovoGration.viewersDB.getSPPoints(viewerName, StreamPlatform.TROVO);
                    this.sendMessageToChat(I18n.m_118938_((String)"commands.addrp", (Object[])new Object[]{viewerName, rpAdded, sp, rp9}));
                    continue block29;
                }
                case "link": {
                    this.sendMessageToChat(I18n.m_118938_((String)"commands.link_new_command", (Object[])new Object[0]));
                    continue block29;
                }
                case "twitch": {
                    if (cmd_parts.length != 2) continue block29;
                    String foreignAccount = cmd_parts[1];
                    TrovoGration.linkRequests.addLinkRequest(StreamPlatform.TROVO, chat.nick_name, StreamPlatform.TWITCH, foreignAccount);
                    continue block29;
                }
                case "goodgame": {
                    if (cmd_parts.length != 2) continue block29;
                    String foreignAccount = cmd_parts[1];
                    TrovoGration.linkRequests.addLinkRequest(StreamPlatform.TROVO, chat.nick_name, StreamPlatform.GOODGAME, foreignAccount);
                    continue block29;
                }
                case "check": {
                    if (cmd_parts.length != 1) continue block29;
                    int regViewerIdx = TrovoGration.viewersDB.findViewer(chat.nick_name, StreamPlatform.TROVO);
                    if (regViewerIdx == -1) {
                        this.sendMessageToChat(I18n.m_118938_((String)"commands.link_check_failed", (Object[])new Object[]{chat.nick_name}));
                        continue block29;
                    }
                    String regIdTwitch = TrovoGration.viewersDB.viewers.get((int)regViewerIdx).userNameTwitch;
                    String regIdTrovo = TrovoGration.viewersDB.viewers.get((int)regViewerIdx).userNameTrovo;
                    String regIdGoodGame = TrovoGration.viewersDB.viewers.get((int)regViewerIdx).userNameGoodgame;
                    if (!regIdTwitch.isEmpty() && !regIdGoodGame.isEmpty()) {
                        this.sendMessageToChat(I18n.m_118938_((String)"commands.link_check_two", (Object[])new Object[]{chat.nick_name, "Twitch", regIdTwitch, "GoodGame", regIdGoodGame}));
                        continue block29;
                    }
                    if (!regIdTwitch.isEmpty()) {
                        this.sendMessageToChat(I18n.m_118938_((String)"commands.link_check_one", (Object[])new Object[]{chat.nick_name, "Twitch", regIdTwitch}));
                        continue block29;
                    }
                    if (!regIdGoodGame.isEmpty()) {
                        this.sendMessageToChat(I18n.m_118938_((String)"commands.link_check_one", (Object[])new Object[]{chat.nick_name, "GoodGame", regIdGoodGame}));
                        continue block29;
                    }
                    this.sendMessageToChat(I18n.m_118938_((String)"commands.link_check_failed", (Object[])new Object[]{chat.nick_name}));
                    continue block29;
                }
                case "unlink": {
                    StreamPlatform sp_foreignPlatform;
                    if (cmd_parts.length != 2) {
                        this.sendMessageToChat(I18n.m_118938_((String)"commands.unlink_failed_args", (Object[])new Object[0]));
                        continue block29;
                    }
                    String foreignPlatform = cmd_parts[1];
                    StreamPlatform streamPlatform = foreignPlatform.equalsIgnoreCase("trovo") ? StreamPlatform.TROVO : (foreignPlatform.equalsIgnoreCase("twitch") ? StreamPlatform.TWITCH : (sp_foreignPlatform = foreignPlatform.equalsIgnoreCase("goodgame") ? StreamPlatform.GOODGAME : StreamPlatform.UNKNOWN));
                    if (sp_foreignPlatform == StreamPlatform.UNKNOWN) {
                        this.sendMessageToChat(I18n.m_118938_((String)"commands.unlink_failed_args", (Object[])new Object[0]));
                        continue block29;
                    }
                    int regViewerIdx = TrovoGration.viewersDB.findViewer(chat.nick_name, StreamPlatform.TROVO);
                    if (regViewerIdx == -1) {
                        this.sendMessageToChat(I18n.m_118938_((String)"commands.unlink_failed", (Object[])new Object[]{foreignPlatform}));
                        continue block29;
                    }
                    int existingLink = TrovoGration.linkRequests.getPendingLinkIndex(chat.nick_name, StreamPlatform.TROVO, sp_foreignPlatform);
                    if (existingLink != -1) {
                        void var18_68;
                        String string = "";
                        if (sp_foreignPlatform == StreamPlatform.TWITCH) {
                            String string2 = TrovoGration.linkRequests.requests.get((int)existingLink).twitchNickname;
                        }
                        if (sp_foreignPlatform == StreamPlatform.GOODGAME) {
                            String string3 = TrovoGration.linkRequests.requests.get((int)existingLink).goodgameNickname;
                        }
                        TrovoGration.linkRequests.requests.remove(existingLink);
                        this.sendMessageToChat(I18n.m_118938_((String)"commands.unlink_request_cancelled", (Object[])new Object[]{var18_68, foreignPlatform}));
                        continue block29;
                    }
                    String string = TrovoGration.viewersDB.viewers.get((int)regViewerIdx).userNameTwitch;
                    String regIdTrovo = TrovoGration.viewersDB.viewers.get((int)regViewerIdx).userNameTrovo;
                    String regIdGoodGame = TrovoGration.viewersDB.viewers.get((int)regViewerIdx).userNameGoodgame;
                    if (sp_foreignPlatform == StreamPlatform.TWITCH) {
                        if (string.isEmpty()) {
                            this.sendMessageToChat(I18n.m_118938_((String)"commands.unlink_failed", (Object[])new Object[]{chat.nick_name, foreignPlatform}));
                            continue block29;
                        }
                        TrovoGration.viewersDB.viewers.get((int)regViewerIdx).userNameTwitch = "";
                        TrovoGration.viewersDB.saveToDisk();
                        this.sendMessageToChat(I18n.m_118938_((String)"commands.unlink_success", (Object[])new Object[]{chat.nick_name, string, foreignPlatform}));
                        continue block29;
                    }
                    if (sp_foreignPlatform != StreamPlatform.GOODGAME) continue block29;
                    if (regIdGoodGame.isEmpty()) {
                        this.sendMessageToChat(I18n.m_118938_((String)"commands.unlink_failed", (Object[])new Object[]{chat.nick_name, foreignPlatform}));
                        continue block29;
                    }
                    TrovoGration.viewersDB.viewers.get((int)regViewerIdx).userNameGoodgame = "";
                    TrovoGration.viewersDB.saveToDisk();
                    this.sendMessageToChat(I18n.m_118938_((String)"commands.unlink_success", (Object[])new Object[]{chat.nick_name, regIdGoodGame, foreignPlatform}));
                    continue block29;
                }
                default: {
                    TrovoAction matchedAction = Config.ACTIONS_COLLECTION.getSuitableCommand(cmd_parts[0]);
                    if (matchedAction == null || !TrovoGration.viewersDB.discardPoints(chat.nick_name, matchedAction.cost, matchedAction.spOnly, StreamPlatform.TROVO)) continue block29;
                    TrovoGration.history.subtractPoints(matchedAction.spOnly, chat.nick_name, matchedAction.cost, "#" + cmd_parts[0], StreamPlatform.TROVO);
                    if (matchedAction.isNegative) {
                        Sounds.PlaySoundOnClient("negative_action");
                    } else {
                        Sounds.PlaySoundOnClient("positive_action");
                    }
                    if (matchedAction.commands_list.startsWith("r/")) {
                        clear_command = matchedAction.commands_list.substring(2);
                        int lastIndex = ((String)clear_command).lastIndexOf(47);
                        int count = Integer.parseInt(((String)clear_command).substring(lastIndex + 1));
                        clear_command = ((String)clear_command).substring(0, lastIndex);
                        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(((String)clear_command).split(";")));
                        int rndLimit = arrayList.size();
                        for (int i = 0; i < count; ++i) {
                            Object summonCommand = arrayList.get((int)(Math.random() * (double)rndLimit));
                            if (((String)summonCommand).startsWith("/summon")) {
                                summonCommand = !((String)summonCommand).substring(((String)summonCommand).length() - 1).equals("}") ? (String)summonCommand + " ~ ~ ~ {CustomName:'{\"text\":\"" + chat.nick_name + "T\"}',CustomNameVisible:1}" : ((String)summonCommand).substring(0, ((String)summonCommand).length() - 1) + ",CustomName:'{\"text\":\"" + chat.nick_name + "T\"}',CustomNameVisible:1}";
                            }
                            if (((String)summonCommand).startsWith("/xc summonnamed")) {
                                summonCommand = ((String)summonCommand).replace("%name%", chat.nick_name + "T");
                            }
                            if (((String)summonCommand).startsWith("/")) {
                                summonCommand = ((String)summonCommand).substring(1);
                            }
                            StaticData.player.f_108617_.m_246623_((String)summonCommand);
                        }
                    } else if (matchedAction.commands_list.startsWith("c/")) {
                        clear_command = matchedAction.commands_list.substring(2);
                        if (((String)clear_command).startsWith("/")) {
                            clear_command = ((String)clear_command).substring(1);
                        }
                        ClientCommandHandler.runCommand((String)clear_command);
                    } else {
                        for (String string : matchedAction.commands_list.split(";")) {
                            void var18_78;
                            void var18_76;
                            void var18_74;
                            if (string.startsWith("/summon")) {
                                if (!string.substring(string.length() - 1).equals("}")) {
                                    String string4 = string + " ~ ~ ~ {CustomName:'{\"text\":\"" + chat.nick_name + "T\"}',CustomNameVisible:1}";
                                } else {
                                    String string5 = string.substring(0, string.length() - 1) + ",CustomName:'{\"text\":\"" + chat.nick_name + "T\"}',CustomNameVisible:1}";
                                }
                            }
                            if (var18_74.startsWith("/xc summonnamed")) {
                                String string6 = var18_74.replace("%name%", chat.nick_name + "T");
                            }
                            if (var18_76.startsWith("/")) {
                                String string7 = var18_76.substring(1);
                            }
                            StaticData.player.f_108617_.m_246623_((String)var18_78);
                        }
                    }
                    Config.ACTIONS_COLLECTION.setActionCooldown(matchedAction.command);
                    Config.ACTIONS_COLLECTION.updateAvailableList();
                    long sp = TrovoGration.viewersDB.getSPPoints(chat.nick_name, StreamPlatform.TROVO);
                    long rp10 = TrovoGration.viewersDB.getRPPoints(chat.nick_name, StreamPlatform.TROVO);
                    this.sendMessageToChat(I18n.m_118938_((String)"commands.fired", (Object[])new Object[]{chat.nick_name, matchedAction.command, sp, rp10}));
                }
            }
        }
    }
}

