/*
 * Decompiled with CFR 0.152.
 */
package com.cwelth.trovogration.connection.twitch;

import com.cwelth.trovogration.Config;
import com.cwelth.trovogration.Sounds;
import com.cwelth.trovogration.TrovoGration;
import com.cwelth.trovogration.connection.StaticData;
import com.cwelth.trovogration.connection.twitch.MessageType;
import com.cwelth.trovogration.connection.twitch.TwitchMessage;
import com.cwelth.trovogration.datastorage.StreamPlatform;
import com.cwelth.trovogration.datastorage.TrovoAction;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.ClientCommandHandler;
import trovogration.com.neovisionaries.ws.client.WebSocket;
import trovogration.com.neovisionaries.ws.client.WebSocketAdapter;
import trovogration.com.neovisionaries.ws.client.WebSocketFactory;
import trovogration.com.neovisionaries.ws.client.WebSocketFrame;

public class TwitchClient {
    public boolean isConnected = false;
    public boolean shouldReconnect = false;
    public String access_token = "";
    public String channel_name = "";
    public int reconnectMultiplier = 1;
    public long wakeUpTime = 0L;
    public WebSocket ws;
    public ExecutorService executorThread = Executors.newFixedThreadPool(1);
    public int pingCoolDown = 0;
    public boolean breakThread = false;

    public void connect(final String access_token, final String channel_name) throws Exception {
        this.access_token = access_token;
        this.channel_name = channel_name;
        this.ws = new WebSocketFactory().setConnectionTimeout(1500).createSocket("wss://irc-ws.chat.twitch.tv:443");
        this.ws.addListener(new WebSocketAdapter(){

            @Override
            public void onConnected(WebSocket websocket, Map<String, List<String>> headers) throws Exception {
                TrovoGration.LOGGER.info("Connected. Sending handshake...");
                TwitchClient.this.send("CAP REQ :twitch.tv/tags twitch.tv/commands");
                TwitchClient.this.send("PASS oauth:" + access_token);
                TwitchClient.this.send("NICK " + channel_name);
                TwitchClient.this.send("JOIN #" + channel_name);
                TwitchClient.this.wakeUpTime = System.currentTimeMillis() / 1000L;
            }

            @Override
            public void onTextMessage(WebSocket websocket, String message) {
                TwitchClient.this.onMessage(message);
            }

            @Override
            public void onDisconnected(WebSocket websocket, WebSocketFrame serverCloseFrame, WebSocketFrame clientCloseFrame, boolean closedByServer) throws Exception {
                super.onDisconnected(websocket, serverCloseFrame, clientCloseFrame, closedByServer);
                TrovoGration.LOGGER.info("Disconnected from Twitch.");
                StaticData.player.m_213846_((Component)Component.m_237115_((String)"status.disconnected"));
                TwitchClient.this.isConnected = false;
                if (TwitchClient.this.shouldReconnect) {
                    TrovoGration.LOGGER.info("Reconnecting...");
                    StaticData.player.m_213846_((Component)Component.m_237115_((String)"status.reconnect"));
                    TrovoGration.HTTPSERVER.connectToTwitchWss();
                }
            }
        }).connect();
    }

    public void disconnect() {
        if (this.isConnected) {
            this.breakThread = true;
            this.shouldReconnect = false;
            this.ws.disconnect(0, "Client request", 3L);
        }
        TrovoGration.viewersDB.saveToDisk();
        TrovoGration.history.saveToDisk();
    }

    public void onMessage(String message) {
        List<String> data = Arrays.stream(message.split("\r\n")).toList();
        for (String msg : data) {
            if (msg.trim().isEmpty()) continue;
            if (msg.startsWith("PING")) {
                String buildBack = "PONG " + msg.substring(5);
                this.send(buildBack);
                continue;
            }
            if (msg.startsWith(":")) {
                if (msg.equals(":tmi.twitch.tv RECONNECT")) {
                    this.shouldReconnect = true;
                    this.ws.disconnect(0, "Server reconnect request", 3L);
                    return;
                }
                if (!msg.startsWith(":tmi.twitch.tv 001")) continue;
                this.isConnected = true;
                StaticData.player.m_213846_((Component)Component.m_237115_((String)"status.connected"));
                if (!this.shouldReconnect) {
                    Config.ACTIONS_COLLECTION.commonCooldown = (Integer)Config.COOLDOWN_ON_CONNECT.get();
                }
                this.shouldReconnect = true;
                TrovoGration.LOGGER.info("Loading viewers data...");
                TrovoGration.viewersDB.loadFromDisk();
                TrovoGration.LOGGER.info("Loading history...");
                TrovoGration.history.loadFromDisk();
                TrovoGration.LOGGER.info("Done.");
                TrovoGration.HTTPSERVER.waitingForConnectionData = false;
                continue;
            }
            TwitchMessage twitchMessage = TwitchMessage.fromString(msg);
            this.processChat(twitchMessage);
        }
    }

    public void send(String toSend) {
        this.ws.sendText(toSend + "\r\n");
    }

    public void sendMessageToChat(String message, String reply_id) {
        Object msg = "";
        msg = reply_id == "" ? "PRIVMSG #" + this.channel_name + " :" + message : "@reply-parent-msg-id=" + reply_id + " PRIVMSG #" + this.channel_name + " :" + message;
        this.send((String)msg);
    }

    /*
     * WARNING - void declaration
     */
    public void processChat(TwitchMessage chat) {
        int spAdded;
        long rp;
        long sp;
        Gson gson = new Gson();
        boolean isVip = chat.isVip;
        boolean isMod = chat.isMod;
        if (chat.isBroadcaster) {
            isVip = true;
            isMod = true;
        }
        if (chat.messageType == MessageType.BITS_USED) {
            int amountToAdd = (int)((double)chat.bitsUsed * (Double)Config.ELIXIR_MULTIPLIER.get());
            TrovoGration.viewersDB.addSPPoints(chat.nickname, amountToAdd, StreamPlatform.TWITCH);
            TrovoGration.history.addPoints(true, chat.nickname, amountToAdd, chat.bitsUsed + " bit(s) used", StreamPlatform.TWITCH);
            sp = TrovoGration.viewersDB.getSPPoints(chat.nickname, StreamPlatform.TWITCH);
            rp = TrovoGration.viewersDB.getRPPoints(chat.nickname, StreamPlatform.TWITCH);
            this.sendMessageToChat(I18n.m_118938_((String)"commands.addsp", (Object[])new Object[]{chat.nickname, amountToAdd, sp, rp}), "");
        }
        if (chat.messageType == MessageType.RAID && chat.raiders_count >= (Integer)Config.RAID_MIN_VIEWERS.get()) {
            spAdded = (Integer)Config.RAID_REWARD.get();
            TrovoGration.viewersDB.addSPPoints(chat.nickname, spAdded, StreamPlatform.TWITCH);
            TrovoGration.history.addPoints(true, chat.nickname, spAdded, "raid of " + chat.raiders_count, StreamPlatform.TWITCH);
            sp = TrovoGration.viewersDB.getSPPoints(chat.nickname, StreamPlatform.TWITCH);
            rp = TrovoGration.viewersDB.getRPPoints(chat.nickname, StreamPlatform.TWITCH);
            this.sendMessageToChat(I18n.m_118938_((String)"commands.addsp", (Object[])new Object[]{chat.nickname, spAdded, sp, rp}), "");
        }
        if (chat.messageType == MessageType.SUBSCRIBE) {
            spAdded = 0;
            if (chat.sub_tier == 1) {
                spAdded = (Integer)Config.SUB_TIER1_REWARD.get();
            }
            if (chat.sub_tier == 2) {
                spAdded = (Integer)Config.SUB_TIER2_REWARD.get();
            }
            if (chat.sub_tier == 3) {
                spAdded = (Integer)Config.SUB_TIER3_REWARD.get();
            }
            TrovoGration.viewersDB.addSPPoints(chat.nickname, spAdded, StreamPlatform.TWITCH);
            TrovoGration.history.addPoints(true, chat.nickname, spAdded, "tier " + chat.sub_tier + " subscription", StreamPlatform.TWITCH);
            sp = TrovoGration.viewersDB.getSPPoints(chat.nickname, StreamPlatform.TWITCH);
            rp = TrovoGration.viewersDB.getRPPoints(chat.nickname, StreamPlatform.TWITCH);
            this.sendMessageToChat(I18n.m_118938_((String)"commands.addsp", (Object[])new Object[]{chat.nickname, spAdded, sp, rp}), "");
        }
        if (chat.messageType == MessageType.GIFTSUB) {
            spAdded = 0;
            if (chat.sub_tier == 1) {
                spAdded = (Integer)Config.GIFTSUB_TIER1_REWARD.get();
            }
            if (chat.sub_tier == 2) {
                spAdded = (Integer)Config.GIFTSUB_TIER2_REWARD.get();
            }
            if (chat.sub_tier == 3) {
                spAdded = (Integer)Config.GIFTSUB_TIER3_REWARD.get();
            }
            TrovoGration.viewersDB.addSPPoints(chat.nickname, spAdded, StreamPlatform.TWITCH);
            TrovoGration.history.addPoints(true, chat.nickname, spAdded, "tier " + chat.sub_tier + " gift sub", StreamPlatform.TWITCH);
            sp = TrovoGration.viewersDB.getSPPoints(chat.nickname, StreamPlatform.TWITCH);
            rp = TrovoGration.viewersDB.getRPPoints(chat.nickname, StreamPlatform.TWITCH);
            this.sendMessageToChat(I18n.m_118938_((String)"commands.addsp", (Object[])new Object[]{chat.nickname, spAdded, sp, rp}), "");
        }
        if (chat.messageType == MessageType.MESSAGE && chat.message.charAt(0) == '#') {
            String[] cmd_parts = chat.message.split(" ");
            cmd_parts[0] = cmd_parts[0].substring(1);
            switch (cmd_parts[0]) {
                case "days": 
                case "gs": {
                    this.sendMessageToChat(I18n.m_118938_((String)"commands.days", (Object[])new Object[]{StaticData.DaysSurvived}), chat.message_id);
                    break;
                }
                case "cp": {
                    if (cmd_parts.length == 1) {
                        long sp2 = TrovoGration.viewersDB.getSPPoints(chat.nickname, StreamPlatform.TWITCH);
                        long rp2 = TrovoGration.viewersDB.getRPPoints(chat.nickname, StreamPlatform.TWITCH);
                        long l = sp2 + rp2;
                        this.sendMessageToChat(I18n.m_118938_((String)"commands.cp", (Object[])new Object[]{chat.nickname, l, sp2, rp2}), chat.message_id);
                        break;
                    }
                    if (cmd_parts.length != 2 || !isVip) break;
                    String viewerName = cmd_parts[1];
                    if (viewerName.charAt(0) == '@') {
                        viewerName = viewerName.substring(1);
                    }
                    long sp3 = TrovoGration.viewersDB.getSPPoints(viewerName, StreamPlatform.TWITCH);
                    long rp3 = TrovoGration.viewersDB.getRPPoints(viewerName, StreamPlatform.TWITCH);
                    long cpTotal = sp3 + rp3;
                    this.sendMessageToChat(I18n.m_118938_((String)"commands.cp", (Object[])new Object[]{viewerName, cpTotal, sp3, rp3}), chat.message_id);
                    break;
                }
                case "addsp": {
                    if (cmd_parts.length != 3 || ((Boolean)Config.MODERATOR_ALLOWED_TO_ADD_POINTS.get()).booleanValue() && !isVip || ((Boolean)Config.SUPERMOD_ALLOWED_TO_ADD_POINTS.get()).booleanValue() && !isMod) break;
                    int spAdded2 = Integer.parseInt(cmd_parts[2]);
                    String viewerName = cmd_parts[1];
                    if (viewerName.charAt(0) == '@') {
                        viewerName = viewerName.substring(1);
                    }
                    TrovoGration.viewersDB.addSPPoints(viewerName, spAdded2, StreamPlatform.TWITCH);
                    if (spAdded2 > 0) {
                        TrovoGration.history.addPoints(true, viewerName, spAdded2, chat.nickname + " issued #addsp " + viewerName + " " + spAdded2, StreamPlatform.TWITCH);
                    } else {
                        TrovoGration.history.subtractPoints(true, viewerName, Math.abs(spAdded2), chat.nickname + " issued #addsp " + viewerName + " " + spAdded2, StreamPlatform.TWITCH);
                    }
                    long sp4 = TrovoGration.viewersDB.getSPPoints(viewerName, StreamPlatform.TWITCH);
                    long l = TrovoGration.viewersDB.getRPPoints(viewerName, StreamPlatform.TWITCH);
                    this.sendMessageToChat(I18n.m_118938_((String)"commands.addsp", (Object[])new Object[]{viewerName, spAdded2, sp4, l}), "");
                    break;
                }
                case "addspx": {
                    if (cmd_parts.length != 4 || ((Boolean)Config.MODERATOR_ALLOWED_TO_ADD_POINTS.get()).booleanValue() && !isVip || ((Boolean)Config.SUPERMOD_ALLOWED_TO_ADD_POINTS.get()).booleanValue() && !isMod) break;
                    float multiplier = Float.parseFloat(cmd_parts[1]);
                    int spAdded3 = (int)((float)Integer.parseInt(cmd_parts[3]) * multiplier);
                    String viewerName = cmd_parts[2];
                    if (viewerName.charAt(0) == '@') {
                        viewerName = viewerName.substring(1);
                    }
                    TrovoGration.viewersDB.addSPPoints(viewerName, spAdded3, StreamPlatform.TWITCH);
                    if (spAdded3 > 0) {
                        TrovoGration.history.addPoints(true, viewerName, spAdded3, chat.nickname + " issued #addspx " + cmd_parts[1] + " " + viewerName + " " + spAdded3, StreamPlatform.TWITCH);
                    } else {
                        TrovoGration.history.subtractPoints(true, viewerName, Math.abs(spAdded3), chat.nickname + " issued #addspx " + cmd_parts[1] + " " + viewerName + " " + spAdded3, StreamPlatform.TWITCH);
                    }
                    long sp5 = TrovoGration.viewersDB.getSPPoints(viewerName, StreamPlatform.TWITCH);
                    long rp5 = TrovoGration.viewersDB.getRPPoints(viewerName, StreamPlatform.TWITCH);
                    this.sendMessageToChat(I18n.m_118938_((String)"commands.addsp", (Object[])new Object[]{viewerName, spAdded3, sp5, rp5}), "");
                    break;
                }
                case "addpp": 
                case "addrp": {
                    if (cmd_parts.length != 3 || ((Boolean)Config.MODERATOR_ALLOWED_TO_ADD_POINTS.get()).booleanValue() && !isVip || ((Boolean)Config.SUPERMOD_ALLOWED_TO_ADD_POINTS.get()).booleanValue() && !isMod) break;
                    int rpAdded = Integer.parseInt(cmd_parts[2]);
                    String viewerName = cmd_parts[1];
                    if (viewerName.charAt(0) == '@') {
                        viewerName = viewerName.substring(1);
                    }
                    TrovoGration.viewersDB.addRPPoints(viewerName, rpAdded, StreamPlatform.TWITCH);
                    if (rpAdded > 0) {
                        TrovoGration.history.addPoints(false, viewerName, rpAdded, chat.nickname + " issued #addrp " + viewerName + " " + rpAdded, StreamPlatform.TWITCH);
                    } else {
                        TrovoGration.history.subtractPoints(false, viewerName, Math.abs(rpAdded), chat.nickname + " issued #addrp " + viewerName + " " + rpAdded, StreamPlatform.TWITCH);
                    }
                    long rp6 = TrovoGration.viewersDB.getRPPoints(viewerName, StreamPlatform.TWITCH);
                    long l = TrovoGration.viewersDB.getSPPoints(viewerName, StreamPlatform.TWITCH);
                    this.sendMessageToChat(I18n.m_118938_((String)"commands.addrp", (Object[])new Object[]{viewerName, rpAdded, l, rp6}), "");
                    break;
                }
                case "addppx": 
                case "addrpx": {
                    if (cmd_parts.length != 4 || ((Boolean)Config.MODERATOR_ALLOWED_TO_ADD_POINTS.get()).booleanValue() && !isVip || ((Boolean)Config.SUPERMOD_ALLOWED_TO_ADD_POINTS.get()).booleanValue() && !isMod) break;
                    float multiplier = Float.parseFloat(cmd_parts[1]);
                    int rpAdded = (int)((float)Integer.parseInt(cmd_parts[3]) * multiplier);
                    String viewerName = cmd_parts[2];
                    if (viewerName.charAt(0) == '@') {
                        viewerName = viewerName.substring(1);
                    }
                    TrovoGration.viewersDB.addRPPoints(viewerName, rpAdded, StreamPlatform.TWITCH);
                    if (rpAdded > 0) {
                        TrovoGration.history.addPoints(false, viewerName, rpAdded, chat.nickname + " issued #addrpx " + cmd_parts[1] + " " + viewerName + " " + rpAdded, StreamPlatform.TWITCH);
                    } else {
                        TrovoGration.history.subtractPoints(false, viewerName, Math.abs(rpAdded), chat.nickname + " issued #addrpx " + cmd_parts[1] + " " + viewerName + " " + rpAdded, StreamPlatform.TWITCH);
                    }
                    long rp7 = TrovoGration.viewersDB.getRPPoints(viewerName, StreamPlatform.TWITCH);
                    long sp7 = TrovoGration.viewersDB.getSPPoints(viewerName, StreamPlatform.TWITCH);
                    this.sendMessageToChat(I18n.m_118938_((String)"commands.addrp", (Object[])new Object[]{viewerName, rpAdded, sp7, rp7}), "");
                    break;
                }
                case "link": {
                    this.sendMessageToChat(I18n.m_118938_((String)"commands.link_new_command", (Object[])new Object[0]), "");
                    break;
                }
                case "trovo": {
                    if (cmd_parts.length != 2) break;
                    String foreignAccount = cmd_parts[1];
                    TrovoGration.linkRequests.addLinkRequest(StreamPlatform.TWITCH, chat.nickname, StreamPlatform.TROVO, foreignAccount);
                    break;
                }
                case "goodgame": {
                    if (cmd_parts.length != 2) break;
                    String foreignAccount = cmd_parts[1];
                    TrovoGration.linkRequests.addLinkRequest(StreamPlatform.TWITCH, chat.nickname, StreamPlatform.GOODGAME, foreignAccount);
                    break;
                }
                case "check": {
                    if (cmd_parts.length != 1) break;
                    int regViewerIdx = TrovoGration.viewersDB.findViewer(chat.nickname, StreamPlatform.TWITCH);
                    if (regViewerIdx == -1) {
                        this.sendMessageToChat(I18n.m_118938_((String)"commands.link_check_failed", (Object[])new Object[]{chat.nickname}), "");
                        break;
                    }
                    String regIdTwitch = TrovoGration.viewersDB.viewers.get((int)regViewerIdx).userNameTwitch;
                    String regIdTrovo = TrovoGration.viewersDB.viewers.get((int)regViewerIdx).userNameTrovo;
                    String regIdGoodGame = TrovoGration.viewersDB.viewers.get((int)regViewerIdx).userNameGoodgame;
                    if (!regIdTrovo.isEmpty() && !regIdGoodGame.isEmpty()) {
                        this.sendMessageToChat(I18n.m_118938_((String)"commands.link_check_two", (Object[])new Object[]{chat.nickname, "Trovo", regIdTrovo, "GoodGame", regIdGoodGame}), "");
                        break;
                    }
                    if (!regIdTrovo.isEmpty()) {
                        this.sendMessageToChat(I18n.m_118938_((String)"commands.link_check_one", (Object[])new Object[]{chat.nickname, "Trovo", regIdTrovo}), "");
                        break;
                    }
                    if (!regIdGoodGame.isEmpty()) {
                        this.sendMessageToChat(I18n.m_118938_((String)"commands.link_check_one", (Object[])new Object[]{chat.nickname, "GoodGame", regIdGoodGame}), "");
                        break;
                    }
                    this.sendMessageToChat(I18n.m_118938_((String)"commands.link_check_failed", (Object[])new Object[]{chat.nickname}), "");
                    break;
                }
                case "unlink": {
                    StreamPlatform sp_foreignPlatform;
                    if (cmd_parts.length != 2) {
                        this.sendMessageToChat(I18n.m_118938_((String)"commands.unlink_failed_args", (Object[])new Object[0]), "");
                        break;
                    }
                    String foreignPlatform = cmd_parts[1];
                    StreamPlatform streamPlatform = foreignPlatform.equalsIgnoreCase("trovo") ? StreamPlatform.TROVO : (foreignPlatform.equalsIgnoreCase("twitch") ? StreamPlatform.TWITCH : (sp_foreignPlatform = foreignPlatform.equalsIgnoreCase("goodgame") ? StreamPlatform.GOODGAME : StreamPlatform.UNKNOWN));
                    if (sp_foreignPlatform == StreamPlatform.UNKNOWN) {
                        this.sendMessageToChat(I18n.m_118938_((String)"commands.unlink_failed_args", (Object[])new Object[0]), "");
                        break;
                    }
                    int regViewerIdx = TrovoGration.viewersDB.findViewer(chat.nickname, StreamPlatform.TWITCH);
                    if (regViewerIdx == -1) {
                        this.sendMessageToChat(I18n.m_118938_((String)"commands.unlink_failed", (Object[])new Object[]{foreignPlatform}), "");
                        break;
                    }
                    int existingLink = TrovoGration.linkRequests.getPendingLinkIndex(chat.nickname, StreamPlatform.TWITCH, sp_foreignPlatform);
                    if (existingLink != -1) {
                        void var12_37;
                        String string = "";
                        if (sp_foreignPlatform == StreamPlatform.TROVO) {
                            String string2 = TrovoGration.linkRequests.requests.get((int)existingLink).trovoNickname;
                        }
                        if (sp_foreignPlatform == StreamPlatform.GOODGAME) {
                            String string3 = TrovoGration.linkRequests.requests.get((int)existingLink).goodgameNickname;
                        }
                        TrovoGration.linkRequests.requests.remove(existingLink);
                        this.sendMessageToChat(I18n.m_118938_((String)"commands.unlink_request_cancelled", (Object[])new Object[]{var12_37, foreignPlatform}), "");
                        break;
                    }
                    String string = TrovoGration.viewersDB.viewers.get((int)regViewerIdx).userNameTwitch;
                    String regIdTrovo = TrovoGration.viewersDB.viewers.get((int)regViewerIdx).userNameTrovo;
                    String regIdGoodGame = TrovoGration.viewersDB.viewers.get((int)regViewerIdx).userNameGoodgame;
                    if (sp_foreignPlatform == StreamPlatform.TROVO) {
                        if (regIdTrovo.isEmpty()) {
                            this.sendMessageToChat(I18n.m_118938_((String)"commands.unlink_failed", (Object[])new Object[]{chat.nickname, foreignPlatform}), "");
                            break;
                        }
                        TrovoGration.viewersDB.viewers.get((int)regViewerIdx).userNameTrovo = "";
                        TrovoGration.viewersDB.saveToDisk();
                        this.sendMessageToChat(I18n.m_118938_((String)"commands.unlink_success", (Object[])new Object[]{chat.nickname, regIdTrovo, foreignPlatform}), "");
                        break;
                    }
                    if (sp_foreignPlatform != StreamPlatform.GOODGAME) break;
                    if (regIdGoodGame.isEmpty()) {
                        this.sendMessageToChat(I18n.m_118938_((String)"commands.unlink_failed", (Object[])new Object[]{chat.nickname, foreignPlatform}), "");
                        break;
                    }
                    TrovoGration.viewersDB.viewers.get((int)regViewerIdx).userNameGoodgame = "";
                    TrovoGration.viewersDB.saveToDisk();
                    this.sendMessageToChat(I18n.m_118938_((String)"commands.unlink_success", (Object[])new Object[]{chat.nickname, regIdGoodGame, foreignPlatform}), "");
                    break;
                }
                default: {
                    TrovoAction matchedAction = Config.ACTIONS_COLLECTION.getSuitableCommand(cmd_parts[0]);
                    if (matchedAction == null || !TrovoGration.viewersDB.discardPoints(chat.nickname, matchedAction.cost, matchedAction.spOnly, StreamPlatform.TWITCH)) break;
                    TrovoGration.history.subtractPoints(matchedAction.spOnly, chat.nickname, matchedAction.cost, "#" + cmd_parts[0], StreamPlatform.TWITCH);
                    if (matchedAction.isNegative) {
                        Sounds.PlaySoundOnClient("negative_action");
                    } else {
                        Sounds.PlaySoundOnClient("positive_action");
                    }
                    if (matchedAction.commands_list.startsWith("r/")) {
                        clear_command = matchedAction.commands_list.substring(2);
                        int lastIndex = ((String)clear_command).lastIndexOf(47);
                        int count = Integer.parseInt(((String)clear_command).substring(lastIndex + 1));
                        clear_command = ((String)clear_command).substring(0, lastIndex);
                        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(((String)clear_command).split(";")));
                        int rndLimit = arrayList.size();
                        for (int i = 0; i < count; ++i) {
                            Object summonCommand = arrayList.get((int)(Math.random() * (double)rndLimit));
                            if (((String)summonCommand).startsWith("/summon")) {
                                summonCommand = !((String)summonCommand).substring(((String)summonCommand).length() - 1).equals("}") ? (String)summonCommand + " ~ ~ ~ {CustomName:'{\"text\":\"" + chat.nickname + "W\"}',CustomNameVisible:1}" : ((String)summonCommand).substring(0, ((String)summonCommand).length() - 1) + ",CustomName:'{\"text\":\"" + chat.nickname + "W\"}',CustomNameVisible:1}";
                            }
                            if (((String)summonCommand).startsWith("/xc summonnamed")) {
                                summonCommand = ((String)summonCommand).replace("%name%", chat.nickname + "W");
                            }
                            if (((String)summonCommand).startsWith("/")) {
                                summonCommand = ((String)summonCommand).substring(1);
                            }
                            StaticData.player.f_108617_.m_246623_((String)summonCommand);
                        }
                    } else if (matchedAction.commands_list.startsWith("c/")) {
                        clear_command = matchedAction.commands_list.substring(2);
                        if (((String)clear_command).startsWith("/")) {
                            clear_command = ((String)clear_command).substring(1);
                        }
                        ClientCommandHandler.runCommand((String)clear_command);
                    } else {
                        for (String string : matchedAction.commands_list.split(";")) {
                            void var12_40;
                            void var12_46;
                            void var12_44;
                            if (string.startsWith("/summon")) {
                                if (!string.substring(string.length() - 1).equals("}")) {
                                    String string4 = string + " ~ ~ ~ {CustomName:'{\"text\":\"" + chat.nickname + "W\"}',CustomNameVisible:1}";
                                } else {
                                    String string5 = string.substring(0, string.length() - 1) + ",CustomName:'{\"text\":\"" + chat.nickname + "W\"}',CustomNameVisible:1}";
                                }
                            }
                            if (var12_44.startsWith("/xc summonnamed")) {
                                String string6 = var12_44.replace("%name%", chat.nickname + "W");
                            }
                            if (var12_46.startsWith("/")) {
                                String string7 = var12_46.substring(1);
                            }
                            StaticData.player.f_108617_.m_246623_((String)var12_40);
                        }
                    }
                    Config.ACTIONS_COLLECTION.setActionCooldown(matchedAction.command);
                    Config.ACTIONS_COLLECTION.updateAvailableList();
                    long sp8 = TrovoGration.viewersDB.getSPPoints(chat.nickname, StreamPlatform.TWITCH);
                    long rp8 = TrovoGration.viewersDB.getRPPoints(chat.nickname, StreamPlatform.TWITCH);
                    this.sendMessageToChat(I18n.m_118938_((String)"commands.fired", (Object[])new Object[]{chat.nickname, matchedAction.command, sp8, rp8}), chat.message_id);
                }
            }
        }
    }
}

