/*
 * Decompiled with CFR 0.152.
 */
package com.cwelth.trovogration.connection.twitch;

import com.cwelth.trovogration.connection.twitch.MessageType;
import java.util.Arrays;
import java.util.List;

public class TwitchMessage {
    public boolean isMod = false;
    public boolean isVip = false;
    public boolean isTurbo = false;
    public boolean isSubscriber = false;
    public boolean isBroadcaster = false;
    public int subscribeDuration = 0;
    public int bitsUsed = 0;
    public long send_time;
    public String user_id;
    public String message_id = "";
    public String nickname = "";
    public String message = "";
    public MessageType messageType = MessageType.MESSAGE;
    public int raiders_count = 0;
    public int sub_tier = 0;

    public static TwitchMessage fromString(String src) {
        TwitchMessage msg = new TwitchMessage();
        List<String> firstSplit = Arrays.stream(src.split(" ", 2)).toList();
        if (firstSplit.get(0).startsWith("@badge-info=")) {
            List<String> thirdSplit = Arrays.stream(firstSplit.get(1).split(" ", 4)).toList();
            boolean shouldProcess = false;
            switch (thirdSplit.get(1)) {
                case "USERNOTICE": 
                case "PRIVMSG": {
                    shouldProcess = true;
                    msg.message = thirdSplit.size() == 4 ? thirdSplit.get(3).substring(1) : "";
                }
            }
            if (shouldProcess) {
                List<String> secondSplit = Arrays.stream(firstSplit.get(0).substring(1).split(";")).toList();
                block63: for (String tag : secondSplit) {
                    String[] tagData = tag.split("=", 2);
                    block23 : switch (tagData[0]) {
                        case "id": {
                            msg.message_id = tagData[1];
                            break;
                        }
                        case "badges": {
                            List<String> badges = Arrays.stream(tagData[1].split(",")).toList();
                            for (String badge : badges) {
                                if (!badge.startsWith("broadcaster")) continue;
                                msg.isBroadcaster = true;
                            }
                            continue block63;
                        }
                        case "badge-info": {
                            String[] subSplit = tagData[1].split("/");
                            if (subSplit.length != 2 || !subSplit[0].equals("subscriber")) break;
                            msg.subscribeDuration = Integer.parseInt(subSplit[1]);
                            break;
                        }
                        case "display-name": {
                            msg.nickname = tagData[1];
                            break;
                        }
                        case "mod": {
                            if (!tagData[1].equals("1")) break;
                            msg.isMod = true;
                            break;
                        }
                        case "subscriber": {
                            if (!tagData[1].equals("1")) break;
                            msg.isSubscriber = true;
                            break;
                        }
                        case "turbo": {
                            if (!tagData[1].equals("1")) break;
                            msg.isTurbo = true;
                            break;
                        }
                        case "vip": {
                            msg.isVip = true;
                            break;
                        }
                        case "tmi-sent-ts": {
                            msg.send_time = Long.parseLong(tagData[1]);
                            break;
                        }
                        case "user-id": {
                            msg.user_id = tagData[1];
                            break;
                        }
                        case "bits": {
                            msg.messageType = MessageType.BITS_USED;
                            msg.bitsUsed = Integer.parseInt(tagData[1]);
                            break;
                        }
                        case "msg-id": {
                            switch (tagData[1]) {
                                case "giftpaidupgrade": 
                                case "resub": 
                                case "sub": {
                                    msg.messageType = MessageType.SUBSCRIBE;
                                    break block23;
                                }
                                case "subgift": 
                                case "submysterygift": {
                                    msg.messageType = MessageType.GIFTSUB;
                                    break block23;
                                }
                                case "raid": {
                                    msg.messageType = MessageType.RAID;
                                }
                            }
                            break;
                        }
                        case "msg-param-sub-plan": {
                            switch (tagData[1]) {
                                case "1000": {
                                    msg.sub_tier = 1;
                                    break block23;
                                }
                                case "Prime": 
                                case "2000": {
                                    msg.sub_tier = 2;
                                    break block23;
                                }
                                case "3000": {
                                    msg.sub_tier = 3;
                                }
                            }
                            break;
                        }
                        case "msg-param-viewerCount": {
                            msg.raiders_count = Integer.parseInt(tagData[1]);
                            break;
                        }
                    }
                }
            }
        }
        return msg;
    }
}

