/*
 * Decompiled with CFR 0.152.
 */
package com.cwelth.trovogration.datastorage;

import com.cwelth.trovogration.Config;
import com.cwelth.trovogration.TrovoGration;
import com.cwelth.trovogration.datastorage.StreamPlatform;
import com.cwelth.trovogration.datastorage.ViewersDB;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class History {
    public List<HistoryEntry> history = new ArrayList<HistoryEntry>();

    public void shrinkHistory(int numEntries) {
        int count = this.history.size();
        if (count <= numEntries) {
            return;
        }
        for (int i = 0; i < count - numEntries; ++i) {
            this.history.remove(0);
        }
    }

    public void addPoints(boolean isSP, String nickname, int amount, String reason, StreamPlatform platform) {
        this.history.add(new HistoryEntry(nickname, true, isSP, amount, reason, platform));
        this.shrinkHistory((Integer)Config.HISTORY_ENTRIES_TO_KEEP.get());
    }

    public void subtractPoints(boolean isSP, String nickname, int amount, String reason, StreamPlatform platform) {
        this.history.add(new HistoryEntry(nickname, false, isSP, amount, reason, platform));
        this.shrinkHistory((Integer)Config.HISTORY_ENTRIES_TO_KEEP.get());
    }

    public void loadFromDisk() {
        try {
            BufferedReader br = new BufferedReader(new FileReader(ViewersDB.getPath() + "/trovogrationhistory.json", StandardCharsets.UTF_8));
            this.history = (List)new Gson().fromJson((Reader)br, new TypeToken<List<HistoryEntry>>(){}.getType());
            if (this.history == null) {
                this.history = new ArrayList<HistoryEntry>();
            }
            br.close();
        }
        catch (IOException e) {
            this.history = new ArrayList<HistoryEntry>();
        }
    }

    public void saveToDisk() {
        new Thread(() -> {
            Gson builder = new GsonBuilder().setPrettyPrinting().create();
            try {
                FileWriter writer = new FileWriter(ViewersDB.getPath() + "/trovogrationhistory.json", StandardCharsets.UTF_8);
                builder.toJson(this.history, (Appendable)writer);
                ((Writer)writer).flush();
                ((Writer)writer).close();
            }
            catch (JsonIOException e) {
                TrovoGration.LOGGER.error("Cannot save history data. " + e.getLocalizedMessage());
            }
            catch (IOException e) {
                TrovoGration.LOGGER.error("Cannot save history data. " + e.getLocalizedMessage());
            }
        }).start();
    }

    public void refundEntry(int idx) {
        HistoryEntry entry = this.history.get(idx);
        if (entry.isGaining) {
            TrovoGration.viewersDB.discardPoints(entry.nickname, entry.amount, entry.isSP, entry.platform);
            this.subtractPoints(entry.isSP, entry.nickname, entry.amount, "Discarded gaining", entry.platform);
        } else {
            if (entry.isSP) {
                TrovoGration.viewersDB.addSPPoints(entry.nickname, entry.amount, entry.platform);
            } else {
                TrovoGration.viewersDB.addRPPoints(entry.nickname, entry.amount, entry.platform);
            }
            this.addPoints(entry.isSP, entry.nickname, entry.amount, "Discarded withdrawal", entry.platform);
        }
    }

    public int findEntry(String entry) {
        for (int i = 0; i < this.history.size(); ++i) {
            if (!entry.equals(this.history.get(i).toString())) continue;
            return i;
        }
        return -1;
    }

    public static class HistoryEntry {
        public Date datetime;
        public String nickname;
        public boolean isGaining;
        public boolean isSP;
        public int amount;
        public String reason;
        public StreamPlatform platform = StreamPlatform.TROVO;

        public HistoryEntry(String nickname, boolean isGaining, boolean isSP, int amount, String reason, StreamPlatform platform) {
            this.nickname = nickname;
            this.isGaining = isGaining;
            this.isSP = isSP;
            this.amount = amount;
            this.reason = reason;
            this.datetime = new Date();
            this.platform = platform;
        }

        public String toString() {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yy-MM-dd HH:mm:ss");
            String op = this.isGaining ? "gained" : "spent";
            String pointsType = this.isSP ? "SP" : "RP";
            String toRet = dateFormat.format(this.datetime) + " " + this.nickname + " " + op + " " + this.amount + pointsType + " reason: " + this.reason;
            return toRet;
        }
    }
}

