/*
 * Decompiled with CFR 0.152.
 */
package com.cwelth.trovogration.datastorage;

import com.cwelth.trovogration.TrovoGration;
import com.cwelth.trovogration.datastorage.StreamPlatform;
import com.cwelth.trovogration.datastorage.Viewer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.language.I18n;

public class LinkRequests {
    public List<LinkRequest> requests = new ArrayList<LinkRequest>();

    public int getLinkIndex(String nickname, StreamPlatform platform) {
        for (int i = 0; i < this.requests.size(); ++i) {
            LinkRequest request = this.requests.get(i);
            if (platform == StreamPlatform.TROVO && request.trovoNickname.equalsIgnoreCase(nickname) && request.trovoConfirmed) {
                return i;
            }
            if (platform == StreamPlatform.TWITCH && request.twitchNickname.equalsIgnoreCase(nickname) && request.twitchConfirmed) {
                return i;
            }
            if (platform != StreamPlatform.GOODGAME || !request.goodgameNickname.equalsIgnoreCase(nickname) || !request.goodgameConfirmed) continue;
            return i;
        }
        return -1;
    }

    public int getPendingLinkIndex(String nickname, StreamPlatform src_platform, StreamPlatform platform) {
        for (int i = 0; i < this.requests.size(); ++i) {
            LinkRequest request = this.requests.get(i);
            String srcNickName = "";
            if (src_platform == StreamPlatform.TROVO) {
                srcNickName = request.trovoNickname;
            }
            if (src_platform == StreamPlatform.TWITCH) {
                srcNickName = request.twitchNickname;
            }
            if (src_platform == StreamPlatform.GOODGAME) {
                srcNickName = request.goodgameNickname;
            }
            if (platform == StreamPlatform.TROVO && srcNickName.equalsIgnoreCase(nickname) && !request.trovoConfirmed) {
                return i;
            }
            if (platform == StreamPlatform.TWITCH && srcNickName.equalsIgnoreCase(nickname) && !request.twitchConfirmed) {
                return i;
            }
            if (platform != StreamPlatform.GOODGAME || !srcNickName.equalsIgnoreCase(nickname) || request.goodgameConfirmed) continue;
            return i;
        }
        return -1;
    }

    public void addLinkRequest(StreamPlatform srcPlatform, String srcNickname, StreamPlatform dstPlatform, String dstNickname) {
        String thirdPlatformNickname;
        Viewer newViewer;
        Viewer dstViewer;
        Viewer srcViewer;
        Viewer newViewer2;
        int dataIdxDst;
        int dataIdxSrc;
        LinkRequest request;
        LinkRequest newRequest;
        int regViewerIdx;
        int existingLink = -1;
        if (srcNickname == null) {
            srcNickname = "";
        }
        if (dstNickname == null) {
            dstNickname = "";
        }
        if (srcPlatform == StreamPlatform.TROVO) {
            Viewer regViewer;
            regViewerIdx = TrovoGration.viewersDB.findViewer(srcNickname, StreamPlatform.TROVO);
            if (regViewerIdx != -1) {
                regViewer = TrovoGration.viewersDB.viewers.get(regViewerIdx);
                if (dstPlatform == StreamPlatform.TWITCH && !regViewer.userNameTwitch.isEmpty()) {
                    TrovoGration.HTTPSERVER.trovo.sendMessageToChat(I18n.m_118938_((String)"commands.link_already_linked", (Object[])new Object[]{srcNickname, dstNickname}));
                    return;
                }
                if (dstPlatform == StreamPlatform.GOODGAME && !regViewer.userNameGoodgame.isEmpty()) {
                    TrovoGration.HTTPSERVER.trovo.sendMessageToChat(I18n.m_118938_((String)"commands.link_already_linked", (Object[])new Object[]{srcNickname, dstNickname}));
                    return;
                }
            }
            if (dstPlatform == StreamPlatform.TWITCH) {
                regViewerIdx = TrovoGration.viewersDB.findViewer(dstNickname, StreamPlatform.TWITCH);
            }
            if (dstPlatform == StreamPlatform.GOODGAME) {
                regViewerIdx = TrovoGration.viewersDB.findViewer(dstNickname, StreamPlatform.GOODGAME);
            }
            if (regViewerIdx != -1) {
                regViewer = TrovoGration.viewersDB.viewers.get(regViewerIdx);
                if (!regViewer.userNameTrovo.isEmpty()) {
                    TrovoGration.HTTPSERVER.trovo.sendMessageToChat(I18n.m_118938_((String)"commands.link_already_linked", (Object[])new Object[]{dstNickname, regViewer.userNameTrovo}));
                    return;
                }
            }
            if ((existingLink = this.getLinkIndex(srcNickname, srcPlatform)) == -1) {
                int sideLink = this.getLinkIndex(dstNickname, dstPlatform);
                if (sideLink == -1) {
                    newRequest = new LinkRequest();
                    if (dstPlatform == StreamPlatform.TWITCH) {
                        newRequest.setToTwitch(srcPlatform, srcNickname, dstNickname);
                        TrovoGration.HTTPSERVER.trovo.sendMessageToChat(I18n.m_118938_((String)"commands.link_init_to_twitch", (Object[])new Object[]{srcNickname, dstNickname}));
                    }
                    if (dstPlatform == StreamPlatform.GOODGAME) {
                        newRequest.setToGoodgame(srcPlatform, srcNickname, dstNickname);
                        TrovoGration.HTTPSERVER.trovo.sendMessageToChat(I18n.m_118938_((String)"commands.link_init_to_goodgame", (Object[])new Object[]{srcNickname, dstNickname}));
                    }
                    this.requests.add(newRequest);
                } else {
                    request = this.requests.get(sideLink);
                    if (request.confirmTrovo(srcNickname)) {
                        dataIdxSrc = TrovoGration.viewersDB.findViewer(srcNickname, StreamPlatform.TROVO);
                        dataIdxDst = -1;
                        if (dstPlatform == StreamPlatform.TWITCH) {
                            dataIdxDst = TrovoGration.viewersDB.findViewer(dstNickname, StreamPlatform.TWITCH);
                        }
                        if (dstPlatform == StreamPlatform.GOODGAME) {
                            dataIdxDst = TrovoGration.viewersDB.findViewer(dstNickname, StreamPlatform.GOODGAME);
                        }
                        if (dataIdxSrc == -1 && dataIdxDst == -1) {
                            if (dstPlatform == StreamPlatform.TWITCH) {
                                TrovoGration.viewersDB.viewers.add(new Viewer(srcNickname, dstNickname, "", 0L, 0L));
                            }
                            if (dstPlatform == StreamPlatform.GOODGAME) {
                                TrovoGration.viewersDB.viewers.add(new Viewer(srcNickname, "", dstNickname, 0L, 0L));
                            }
                        } else if (dataIdxSrc == -1) {
                            newViewer2 = TrovoGration.viewersDB.viewers.get(dataIdxDst);
                            newViewer2.userNameTrovo = srcNickname;
                            TrovoGration.viewersDB.viewers.set(dataIdxDst, newViewer2);
                        } else if (dataIdxDst == -1) {
                            newViewer2 = TrovoGration.viewersDB.viewers.get(dataIdxSrc);
                            if (dstPlatform == StreamPlatform.TWITCH) {
                                newViewer2.userNameTwitch = dstNickname;
                            }
                            if (dstPlatform == StreamPlatform.GOODGAME) {
                                newViewer2.userNameGoodgame = dstNickname;
                            }
                            TrovoGration.viewersDB.viewers.set(dataIdxSrc, newViewer2);
                        } else {
                            srcViewer = TrovoGration.viewersDB.viewers.get(dataIdxSrc);
                            dstViewer = TrovoGration.viewersDB.viewers.get(dataIdxDst);
                            newViewer = null;
                            thirdPlatformNickname = "";
                            if (dstPlatform == StreamPlatform.TWITCH) {
                                if (!srcViewer.userNameGoodgame.isEmpty()) {
                                    thirdPlatformNickname = srcViewer.userNameGoodgame;
                                }
                                if (!dstViewer.userNameGoodgame.isEmpty()) {
                                    thirdPlatformNickname = dstViewer.userNameGoodgame;
                                }
                                TrovoGration.viewersDB.viewers.remove(dataIdxSrc);
                                newViewer = new Viewer(srcNickname, dstNickname, thirdPlatformNickname, srcViewer.sp + dstViewer.sp, srcViewer.rp + dstViewer.rp);
                                TrovoGration.viewersDB.viewers.remove(TrovoGration.viewersDB.findViewer(dstNickname, StreamPlatform.TWITCH));
                            }
                            if (dstPlatform == StreamPlatform.GOODGAME) {
                                if (!srcViewer.userNameTwitch.isEmpty()) {
                                    thirdPlatformNickname = srcViewer.userNameTwitch;
                                }
                                if (!dstViewer.userNameTwitch.isEmpty()) {
                                    thirdPlatformNickname = dstViewer.userNameTwitch;
                                }
                                TrovoGration.viewersDB.viewers.remove(dataIdxSrc);
                                newViewer = new Viewer(srcNickname, thirdPlatformNickname, dstNickname, srcViewer.sp + dstViewer.sp, srcViewer.rp + dstViewer.rp);
                                TrovoGration.viewersDB.viewers.remove(TrovoGration.viewersDB.findViewer(dstNickname, StreamPlatform.GOODGAME));
                            }
                            TrovoGration.viewersDB.viewers.add(newViewer);
                        }
                        this.requests.remove(sideLink);
                        TrovoGration.HTTPSERVER.trovo.sendMessageToChat(I18n.m_118938_((String)"commands.link_success", (Object[])new Object[]{srcNickname, dstNickname}));
                        if (dstPlatform == StreamPlatform.TWITCH) {
                            TrovoGration.HTTPSERVER.twitch.sendMessageToChat(I18n.m_118938_((String)"commands.link_success", (Object[])new Object[]{dstNickname, srcNickname}), "");
                        }
                        if (dstPlatform == StreamPlatform.GOODGAME) {
                            TrovoGration.HTTPSERVER.goodgame.sendMessageToChat(I18n.m_118938_((String)"commands.link_success", (Object[])new Object[]{dstNickname, srcNickname}));
                        }
                    }
                }
            } else {
                this.requests.remove(existingLink);
                LinkRequest newRequest2 = new LinkRequest();
                if (dstPlatform == StreamPlatform.TWITCH) {
                    newRequest2.setToTwitch(srcPlatform, srcNickname, dstNickname);
                }
                if (dstPlatform == StreamPlatform.GOODGAME) {
                    newRequest2.setToGoodgame(srcPlatform, srcNickname, dstNickname);
                }
                this.requests.add(newRequest2);
            }
        }
        if (srcPlatform == StreamPlatform.TWITCH) {
            regViewerIdx = TrovoGration.viewersDB.findViewer(srcNickname, StreamPlatform.TWITCH);
            if (regViewerIdx != -1) {
                Viewer regViewer = TrovoGration.viewersDB.viewers.get(regViewerIdx);
                if (dstPlatform == StreamPlatform.TROVO && !regViewer.userNameTrovo.isEmpty()) {
                    TrovoGration.HTTPSERVER.twitch.sendMessageToChat(I18n.m_118938_((String)"commands.link_already_linked", (Object[])new Object[]{srcNickname, dstNickname}), "");
                    return;
                }
                if (dstPlatform == StreamPlatform.GOODGAME && !regViewer.userNameGoodgame.isEmpty()) {
                    TrovoGration.HTTPSERVER.twitch.sendMessageToChat(I18n.m_118938_((String)"commands.link_already_linked", (Object[])new Object[]{srcNickname, dstNickname}), "");
                    return;
                }
            }
            if (dstPlatform == StreamPlatform.TROVO) {
                regViewerIdx = TrovoGration.viewersDB.findViewer(dstNickname, StreamPlatform.TROVO);
            }
            if (dstPlatform == StreamPlatform.GOODGAME) {
                regViewerIdx = TrovoGration.viewersDB.findViewer(dstNickname, StreamPlatform.GOODGAME);
            }
            if (regViewerIdx != -1) {
                Viewer regViewer = TrovoGration.viewersDB.viewers.get(regViewerIdx);
                if (!regViewer.userNameTwitch.isEmpty()) {
                    TrovoGration.HTTPSERVER.twitch.sendMessageToChat(I18n.m_118938_((String)"commands.link_already_linked", (Object[])new Object[]{dstNickname, regViewer.userNameTrovo}), "");
                    return;
                }
            }
            if ((existingLink = this.getLinkIndex(srcNickname, srcPlatform)) == -1) {
                int sideLink = this.getLinkIndex(dstNickname, dstPlatform);
                if (sideLink == -1) {
                    newRequest = new LinkRequest();
                    if (dstPlatform == StreamPlatform.TROVO) {
                        newRequest.setToTrovo(srcPlatform, srcNickname, dstNickname);
                        TrovoGration.HTTPSERVER.twitch.sendMessageToChat(I18n.m_118938_((String)"commands.link_init_to_trovo", (Object[])new Object[]{srcNickname, dstNickname}), "");
                    }
                    if (dstPlatform == StreamPlatform.GOODGAME) {
                        newRequest.setToGoodgame(srcPlatform, srcNickname, dstNickname);
                        TrovoGration.HTTPSERVER.twitch.sendMessageToChat(I18n.m_118938_((String)"commands.link_init_to_goodgame", (Object[])new Object[]{srcNickname, dstNickname}), "");
                    }
                    this.requests.add(newRequest);
                } else {
                    request = this.requests.get(sideLink);
                    if (request.confirmTwitch(srcNickname)) {
                        dataIdxSrc = TrovoGration.viewersDB.findViewer(srcNickname, StreamPlatform.TWITCH);
                        dataIdxDst = -1;
                        if (dstPlatform == StreamPlatform.TROVO) {
                            dataIdxDst = TrovoGration.viewersDB.findViewer(dstNickname, StreamPlatform.TROVO);
                        }
                        if (dstPlatform == StreamPlatform.GOODGAME) {
                            dataIdxDst = TrovoGration.viewersDB.findViewer(dstNickname, StreamPlatform.GOODGAME);
                        }
                        if (dataIdxSrc == -1 && dataIdxDst == -1) {
                            if (dstPlatform == StreamPlatform.TROVO) {
                                TrovoGration.viewersDB.viewers.add(new Viewer(dstNickname, srcNickname, "", 0L, 0L));
                            }
                            if (dstPlatform == StreamPlatform.GOODGAME) {
                                TrovoGration.viewersDB.viewers.add(new Viewer("", srcNickname, dstNickname, 0L, 0L));
                            }
                        } else if (dataIdxSrc == -1) {
                            newViewer2 = TrovoGration.viewersDB.viewers.get(dataIdxDst);
                            newViewer2.userNameTwitch = srcNickname;
                            TrovoGration.viewersDB.viewers.set(dataIdxDst, newViewer2);
                        } else if (dataIdxDst == -1) {
                            newViewer2 = TrovoGration.viewersDB.viewers.get(dataIdxSrc);
                            if (dstPlatform == StreamPlatform.TROVO) {
                                newViewer2.userNameTrovo = dstNickname;
                            }
                            if (dstPlatform == StreamPlatform.GOODGAME) {
                                newViewer2.userNameGoodgame = dstNickname;
                            }
                            TrovoGration.viewersDB.viewers.set(dataIdxSrc, newViewer2);
                        } else {
                            srcViewer = TrovoGration.viewersDB.viewers.get(dataIdxSrc);
                            dstViewer = TrovoGration.viewersDB.viewers.get(dataIdxDst);
                            newViewer = null;
                            thirdPlatformNickname = "";
                            if (dstPlatform == StreamPlatform.TROVO) {
                                if (!srcViewer.userNameGoodgame.isEmpty()) {
                                    thirdPlatformNickname = srcViewer.userNameGoodgame;
                                }
                                if (!dstViewer.userNameGoodgame.isEmpty()) {
                                    thirdPlatformNickname = dstViewer.userNameGoodgame;
                                }
                                TrovoGration.viewersDB.viewers.remove(dataIdxSrc);
                                newViewer = new Viewer(dstNickname, srcNickname, thirdPlatformNickname, srcViewer.sp + dstViewer.sp, srcViewer.rp + dstViewer.rp);
                                TrovoGration.viewersDB.viewers.remove(TrovoGration.viewersDB.findViewer(dstNickname, StreamPlatform.TROVO));
                            }
                            if (dstPlatform == StreamPlatform.GOODGAME) {
                                if (!srcViewer.userNameTrovo.isEmpty()) {
                                    thirdPlatformNickname = srcViewer.userNameTrovo;
                                }
                                if (!dstViewer.userNameTrovo.isEmpty()) {
                                    thirdPlatformNickname = dstViewer.userNameTrovo;
                                }
                                TrovoGration.viewersDB.viewers.remove(dataIdxSrc);
                                newViewer = new Viewer(thirdPlatformNickname, srcNickname, dstNickname, srcViewer.sp + dstViewer.sp, srcViewer.rp + dstViewer.rp);
                                TrovoGration.viewersDB.viewers.remove(TrovoGration.viewersDB.findViewer(dstNickname, StreamPlatform.GOODGAME));
                            }
                            TrovoGration.viewersDB.viewers.add(newViewer);
                        }
                        this.requests.remove(sideLink);
                        TrovoGration.HTTPSERVER.twitch.sendMessageToChat(I18n.m_118938_((String)"commands.link_success", (Object[])new Object[]{srcNickname, dstNickname}), "");
                        if (dstPlatform == StreamPlatform.TROVO) {
                            TrovoGration.HTTPSERVER.trovo.sendMessageToChat(I18n.m_118938_((String)"commands.link_success", (Object[])new Object[]{dstNickname, srcNickname}));
                        }
                        if (dstPlatform == StreamPlatform.GOODGAME) {
                            TrovoGration.HTTPSERVER.goodgame.sendMessageToChat(I18n.m_118938_((String)"commands.link_success", (Object[])new Object[]{dstNickname, srcNickname}));
                        }
                    }
                }
            } else {
                this.requests.remove(existingLink);
                LinkRequest newRequest3 = new LinkRequest();
                if (dstPlatform == StreamPlatform.TROVO) {
                    newRequest3.setToTrovo(srcPlatform, srcNickname, dstNickname);
                }
                if (dstPlatform == StreamPlatform.GOODGAME) {
                    newRequest3.setToGoodgame(srcPlatform, srcNickname, dstNickname);
                }
                this.requests.add(newRequest3);
            }
        }
        if (srcPlatform == StreamPlatform.GOODGAME) {
            regViewerIdx = TrovoGration.viewersDB.findViewer(srcNickname, StreamPlatform.GOODGAME);
            if (regViewerIdx != -1) {
                Viewer regViewer = TrovoGration.viewersDB.viewers.get(regViewerIdx);
                if (dstPlatform == StreamPlatform.TROVO && !regViewer.userNameTrovo.isEmpty()) {
                    TrovoGration.HTTPSERVER.goodgame.sendMessageToChat(I18n.m_118938_((String)"commands.link_already_linked", (Object[])new Object[]{srcNickname, dstNickname}));
                    return;
                }
                if (dstPlatform == StreamPlatform.TWITCH && !regViewer.userNameTwitch.isEmpty()) {
                    TrovoGration.HTTPSERVER.goodgame.sendMessageToChat(I18n.m_118938_((String)"commands.link_already_linked", (Object[])new Object[]{srcNickname, dstNickname}));
                    return;
                }
            }
            if (dstPlatform == StreamPlatform.TROVO) {
                regViewerIdx = TrovoGration.viewersDB.findViewer(dstNickname, StreamPlatform.TROVO);
            }
            if (dstPlatform == StreamPlatform.TWITCH) {
                regViewerIdx = TrovoGration.viewersDB.findViewer(dstNickname, StreamPlatform.TWITCH);
            }
            if (regViewerIdx != -1) {
                Viewer regViewer = TrovoGration.viewersDB.viewers.get(regViewerIdx);
                if (!regViewer.userNameGoodgame.isEmpty()) {
                    TrovoGration.HTTPSERVER.goodgame.sendMessageToChat(I18n.m_118938_((String)"commands.link_already_linked", (Object[])new Object[]{dstNickname, regViewer.userNameTrovo}));
                    return;
                }
            }
            if ((existingLink = this.getLinkIndex(srcNickname, srcPlatform)) == -1) {
                int sideLink = this.getLinkIndex(dstNickname, dstPlatform);
                if (sideLink == -1) {
                    newRequest = new LinkRequest();
                    if (dstPlatform == StreamPlatform.TROVO) {
                        newRequest.setToTrovo(srcPlatform, srcNickname, dstNickname);
                        TrovoGration.HTTPSERVER.goodgame.sendMessageToChat(I18n.m_118938_((String)"commands.link_init_to_trovo", (Object[])new Object[]{srcNickname, dstNickname}));
                    }
                    if (dstPlatform == StreamPlatform.TWITCH) {
                        newRequest.setToTwitch(srcPlatform, srcNickname, dstNickname);
                        TrovoGration.HTTPSERVER.goodgame.sendMessageToChat(I18n.m_118938_((String)"commands.link_init_to_twitch", (Object[])new Object[]{srcNickname, dstNickname}));
                    }
                    this.requests.add(newRequest);
                } else {
                    request = this.requests.get(sideLink);
                    if (request.confirmGoodgame(srcNickname)) {
                        dataIdxSrc = TrovoGration.viewersDB.findViewer(srcNickname, StreamPlatform.GOODGAME);
                        dataIdxDst = -1;
                        if (dstPlatform == StreamPlatform.TROVO) {
                            dataIdxDst = TrovoGration.viewersDB.findViewer(dstNickname, StreamPlatform.TROVO);
                        }
                        if (dstPlatform == StreamPlatform.TWITCH) {
                            dataIdxDst = TrovoGration.viewersDB.findViewer(dstNickname, StreamPlatform.TWITCH);
                        }
                        if (dataIdxSrc == -1 && dataIdxDst == -1) {
                            if (dstPlatform == StreamPlatform.TROVO) {
                                TrovoGration.viewersDB.viewers.add(new Viewer(dstNickname, "", srcNickname, 0L, 0L));
                            }
                            if (dstPlatform == StreamPlatform.TWITCH) {
                                TrovoGration.viewersDB.viewers.add(new Viewer("", dstNickname, srcNickname, 0L, 0L));
                            }
                        } else if (dataIdxSrc == -1) {
                            newViewer2 = TrovoGration.viewersDB.viewers.get(dataIdxDst);
                            newViewer2.userNameGoodgame = srcNickname;
                            TrovoGration.viewersDB.viewers.set(dataIdxDst, newViewer2);
                        } else if (dataIdxDst == -1) {
                            newViewer2 = TrovoGration.viewersDB.viewers.get(dataIdxSrc);
                            if (dstPlatform == StreamPlatform.TROVO) {
                                newViewer2.userNameTrovo = dstNickname;
                            }
                            if (dstPlatform == StreamPlatform.TWITCH) {
                                newViewer2.userNameTwitch = dstNickname;
                            }
                            TrovoGration.viewersDB.viewers.set(dataIdxSrc, newViewer2);
                        } else {
                            srcViewer = TrovoGration.viewersDB.viewers.get(dataIdxSrc);
                            dstViewer = TrovoGration.viewersDB.viewers.get(dataIdxDst);
                            newViewer = null;
                            thirdPlatformNickname = "";
                            if (dstPlatform == StreamPlatform.TROVO) {
                                if (!srcViewer.userNameTwitch.isEmpty()) {
                                    thirdPlatformNickname = srcViewer.userNameTwitch;
                                }
                                if (!dstViewer.userNameTwitch.isEmpty()) {
                                    thirdPlatformNickname = dstViewer.userNameTwitch;
                                }
                                TrovoGration.viewersDB.viewers.remove(dataIdxSrc);
                                newViewer = new Viewer(dstNickname, thirdPlatformNickname, srcNickname, srcViewer.sp + dstViewer.sp, srcViewer.rp + dstViewer.rp);
                                TrovoGration.viewersDB.viewers.remove(TrovoGration.viewersDB.findViewer(dstNickname, StreamPlatform.TROVO));
                            }
                            if (dstPlatform == StreamPlatform.TWITCH) {
                                if (!srcViewer.userNameTrovo.isEmpty()) {
                                    thirdPlatformNickname = srcViewer.userNameTrovo;
                                }
                                if (!dstViewer.userNameTrovo.isEmpty()) {
                                    thirdPlatformNickname = dstViewer.userNameTrovo;
                                }
                                TrovoGration.viewersDB.viewers.remove(dataIdxSrc);
                                newViewer = new Viewer(thirdPlatformNickname, dstNickname, srcNickname, srcViewer.sp + dstViewer.sp, srcViewer.rp + dstViewer.rp);
                                TrovoGration.viewersDB.viewers.remove(TrovoGration.viewersDB.findViewer(dstNickname, StreamPlatform.TWITCH));
                            }
                            TrovoGration.viewersDB.viewers.add(newViewer);
                        }
                        this.requests.remove(sideLink);
                        TrovoGration.HTTPSERVER.goodgame.sendMessageToChat(I18n.m_118938_((String)"commands.link_success", (Object[])new Object[]{srcNickname, dstNickname}));
                        if (dstPlatform == StreamPlatform.TROVO) {
                            TrovoGration.HTTPSERVER.trovo.sendMessageToChat(I18n.m_118938_((String)"commands.link_success", (Object[])new Object[]{dstNickname, srcNickname}));
                        }
                        if (dstPlatform == StreamPlatform.TWITCH) {
                            TrovoGration.HTTPSERVER.twitch.sendMessageToChat(I18n.m_118938_((String)"commands.link_success", (Object[])new Object[]{dstNickname, srcNickname}), "");
                        }
                    }
                }
            } else {
                this.requests.remove(existingLink);
                LinkRequest newRequest4 = new LinkRequest();
                if (dstPlatform == StreamPlatform.TROVO) {
                    newRequest4.setToTrovo(srcPlatform, srcNickname, dstNickname);
                }
                if (dstPlatform == StreamPlatform.TWITCH) {
                    newRequest4.setToTwitch(srcPlatform, srcNickname, dstNickname);
                }
                this.requests.add(newRequest4);
            }
        }
    }

    public class LinkRequest {
        public int idx = -1;
        public String trovoNickname = "";
        public String twitchNickname = "";
        public String goodgameNickname = "";
        public boolean trovoConfirmed = false;
        public boolean twitchConfirmed = false;
        public boolean goodgameConfirmed = false;

        public void setToTwitch(StreamPlatform srcPlatform, String srcNickname, String twitchNickname) {
            this.twitchNickname = twitchNickname;
            if (srcPlatform == StreamPlatform.TROVO) {
                this.trovoNickname = srcNickname;
                this.trovoConfirmed = true;
            } else if (srcPlatform == StreamPlatform.GOODGAME) {
                this.goodgameNickname = srcNickname;
                this.goodgameConfirmed = true;
            }
        }

        public void setToTrovo(StreamPlatform srcPlatform, String srcNickname, String trovoNickname) {
            this.trovoNickname = trovoNickname;
            if (srcPlatform == StreamPlatform.TWITCH) {
                this.twitchNickname = srcNickname;
                this.twitchConfirmed = true;
            } else if (srcPlatform == StreamPlatform.GOODGAME) {
                this.goodgameNickname = srcNickname;
                this.goodgameConfirmed = true;
            }
        }

        public void setToGoodgame(StreamPlatform srcPlatform, String srcNickname, String goodgameNickname) {
            this.goodgameNickname = goodgameNickname;
            if (srcPlatform == StreamPlatform.TWITCH) {
                this.twitchNickname = srcNickname;
                this.twitchConfirmed = true;
            } else if (srcPlatform == StreamPlatform.TROVO) {
                this.trovoNickname = srcNickname;
                this.trovoConfirmed = true;
            }
        }

        public boolean confirmTrovo(String nickname) {
            if (this.trovoNickname.equalsIgnoreCase(nickname)) {
                this.trovoConfirmed = true;
                return true;
            }
            return false;
        }

        public boolean confirmTwitch(String nickname) {
            if (this.twitchNickname.equalsIgnoreCase(nickname)) {
                this.twitchConfirmed = true;
                return true;
            }
            return false;
        }

        public boolean confirmGoodgame(String nickname) {
            if (this.goodgameNickname.equalsIgnoreCase(nickname)) {
                this.goodgameConfirmed = true;
                return true;
            }
            return false;
        }
    }
}

