/*
 * Decompiled with CFR 0.152.
 */
package com.cwelth.trovogration.datastorage;

import com.cwelth.trovogration.Config;
import com.cwelth.trovogration.Sounds;
import com.cwelth.trovogration.TrovoGration;
import com.cwelth.trovogration.connection.StaticData;
import com.cwelth.trovogration.datastorage.TrovoAction;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;

public class TrovoActions {
    public List<TrovoAction> list = new ArrayList<TrovoAction>();
    public List<TrovoAction> availableList = new ArrayList<TrovoAction>();
    public int commonCooldown = 0;
    public int accumulatedHeat = 0;
    public int bank = 0;

    public TrovoAction getSuitableCommand(String command) {
        for (TrovoAction action : this.availableList) {
            if (!action.command.equalsIgnoreCase(command)) continue;
            return action;
        }
        return null;
    }

    public int getCommandIndexByName(String command) {
        for (int idx = 0; idx < this.list.size(); ++idx) {
            if (!this.list.get((int)idx).command.equalsIgnoreCase(command)) continue;
            return idx;
        }
        return -1;
    }

    public TrovoAction getCommandByName(String command) {
        for (TrovoAction action : this.list) {
            if (!action.command.equalsIgnoreCase(command)) continue;
            return action;
        }
        return null;
    }

    public void setActionCooldown(String command) {
        for (int i = 0; i < this.list.size(); ++i) {
            TrovoAction action = this.list.get(i);
            if (!action.command.equalsIgnoreCase(command)) continue;
            action.cooldown_passed = action.cooldown;
            this.accumulatedHeat += action.cost;
            this.bank += (int)((double)action.cost * (Double)Config.HOMICIDE_REWARD.get());
            LocalPlayer player = StaticData.player;
            if (player == null) {
                return;
            }
            Level dimension = player.m_9236_();
            long day = dimension.m_46468_() / 24000L;
            if (this.accumulatedHeat >= this.getHeatLimit(day)) {
                this.commonCooldown = (Integer)Config.COOLDOWN_ON_LIMIT.get();
                Sounds.PlaySoundOnClient("cooldown_start");
                TrovoGration.HTTPSERVER.trovo.sendMessageToChat(I18n.m_118938_((String)"commands.cooldownstart", (Object[])new Object[0]));
            }
            this.list.set(i, action);
            break;
        }
    }

    public void sortByAmounts() {
        this.list.sort(Comparator.comparingInt(o -> o.cost));
    }

    public void initFromConfig(ForgeConfigSpec.ConfigValue<List<? extends List<String>>> configList) {
        this.list.clear();
        for (List action : (List)configList.get()) {
            boolean isOk = true;
            String command = (String)action.get(0);
            boolean isNegative = Boolean.parseBoolean((String)action.get(1));
            if (!((String)action.get(1)).equalsIgnoreCase("true") && !((String)action.get(1)).equalsIgnoreCase("false")) {
                TrovoGration.LOGGER.error("Configuration error. " + (String)action.get(1) + " is not a boolean! Should be \"true\" or \"false\" (Case-Sensitive!).");
                isOk = false;
            }
            String dimensions = (String)action.get(3);
            int minimumDay = 0;
            int cost = 0;
            int cooldown = 0;
            try {
                minimumDay = Integer.parseInt((String)action.get(2)) - 1;
                if (minimumDay < 0) {
                    minimumDay = 0;
                }
            }
            catch (NumberFormatException nfe) {
                TrovoGration.LOGGER.error("Configuration error. " + (String)action.get(2) + " is not a number! Should be integer.");
                isOk = false;
            }
            try {
                cost = Integer.parseInt((String)action.get(4));
            }
            catch (NumberFormatException nfe) {
                TrovoGration.LOGGER.error("Configuration error. " + (String)action.get(4) + " is not a number! Should be integer.");
                isOk = false;
            }
            boolean spOnly = Boolean.parseBoolean((String)action.get(5));
            if (!((String)action.get(5)).equalsIgnoreCase("true") && !((String)action.get(5)).equalsIgnoreCase("false")) {
                TrovoGration.LOGGER.error("Configuration error. " + (String)action.get(5) + " is not a boolean! Should be \"true\" or \"false\" (Case-Sensitive!).");
                isOk = false;
            }
            try {
                cooldown = Integer.parseInt((String)action.get(6));
            }
            catch (NumberFormatException nfe) {
                TrovoGration.LOGGER.error("Configuration error. " + (String)action.get(6) + " is not a number! Should be integer.");
                isOk = false;
            }
            String command_list = (String)action.get(7);
            if (isOk) {
                this.list.add(new TrovoAction(command, isNegative, minimumDay, dimensions, cost, spOnly, cooldown, command_list));
                continue;
            }
            TrovoGration.LOGGER.error("Skipping action setting for: \"" + (String)action.get(0) + "\", \"" + (String)action.get(1) + "\", \"" + (String)action.get(2) + "\", \"" + (String)action.get(3) + "\", \"" + (String)action.get(4) + "\", \"" + (String)action.get(5) + "\", \"" + (String)action.get(6) + "\", \"" + (String)action.get(7) + "\"");
        }
        this.sortByAmounts();
    }

    public void passToConfig(ForgeConfigSpec.ConfigValue<List<? extends List<String>>> configList) {
        ArrayList allActions = new ArrayList();
        for (TrovoAction action : this.list) {
            ArrayList<String> singleAction = new ArrayList<String>();
            singleAction.add(action.command);
            singleAction.add(Boolean.toString(action.isNegative).toLowerCase());
            singleAction.add(Integer.toString(action.min_day + 1));
            singleAction.add(action.allowed_dimensions);
            singleAction.add(Integer.toString(action.cost));
            singleAction.add(Boolean.toString(action.spOnly));
            singleAction.add(Integer.toString(action.cooldown));
            singleAction.add(action.commands_list);
            allActions.add(singleAction);
        }
        configList.set(allActions);
    }

    public boolean addNewActionCommand(String command, boolean negative, int min_day, String dimList, int price, boolean spOnly, int cooldown, String commands) {
        if (this.getCommandByName(command) != null) {
            return false;
        }
        this.list.add(new TrovoAction(command, negative, min_day, dimList, price, spOnly, cooldown, commands));
        this.sortByAmounts();
        this.updateAvailableList();
        this.passToConfig(Config.ACTIONS_LIST);
        return true;
    }

    public boolean editActionCommand(String command, String new_command, boolean negative, int min_day, String dimList, int price, boolean spOnly, int cooldown, String commands) {
        int originalIdx = this.getCommandIndexByName(command);
        if (originalIdx == -1) {
            return false;
        }
        TrovoAction original = this.getAction(originalIdx);
        if (original == null) {
            return false;
        }
        original.command = new_command;
        original.isNegative = negative;
        original.min_day = min_day;
        original.allowed_dimensions = dimList;
        original.cost = price;
        original.spOnly = spOnly;
        original.cooldown = cooldown;
        original.commands_list = commands;
        this.list.set(originalIdx, original);
        this.sortByAmounts();
        this.updateAvailableList();
        this.passToConfig(Config.ACTIONS_LIST);
        return true;
    }

    public boolean removeActionCommand(int originalIdx) {
        if (originalIdx == -1 || originalIdx >= this.list.size()) {
            return false;
        }
        this.list.remove(originalIdx);
        this.sortByAmounts();
        this.updateAvailableList();
        this.passToConfig(Config.ACTIONS_LIST);
        return true;
    }

    public boolean removeActionCommand(String command) {
        int originalIdx = this.getCommandIndexByName(command);
        if (originalIdx == -1) {
            return false;
        }
        this.list.remove(originalIdx);
        this.sortByAmounts();
        this.updateAvailableList();
        this.passToConfig(Config.ACTIONS_LIST);
        return true;
    }

    public List<String> getAllActionCommands() {
        ArrayList<String> toRet = new ArrayList<String>();
        for (TrovoAction action : this.list) {
            toRet.add(action.command);
        }
        return toRet;
    }

    public int getAvailableCount() {
        return this.availableList.size();
    }

    public void updateAvailableList() {
        this.availableList.clear();
        LocalPlayer player = StaticData.player;
        if (player == null) {
            return;
        }
        Level dimension = player.m_9236_();
        long day = StaticData.DaysSurvived;
        for (TrovoAction action : this.list) {
            if (player.m_7500_() && !((Boolean)Config.ENABLE_INTEGRATION_DURING_CREATIVE.get()).booleanValue()) continue;
            boolean dimensionAllowed = true;
            if (!action.allowed_dimensions.isEmpty()) {
                boolean whitelist = true;
                String allowedList = action.allowed_dimensions.toLowerCase();
                if (allowedList.charAt(0) == '-') {
                    whitelist = false;
                    allowedList = allowedList.substring(1);
                }
                if (whitelist) {
                    if (!allowedList.contains(dimension.m_46472_().m_135782_().toString().toLowerCase())) {
                        dimensionAllowed = false;
                    }
                } else if (allowedList.contains(dimension.m_46472_().m_135782_().toString().toLowerCase())) {
                    dimensionAllowed = false;
                }
            }
            if (!dimensionAllowed || (long)action.min_day > day || action.cooldown_passed > 0 || this.commonCooldown > 0 && (action.isNegative || !((Boolean)Config.POSITIVE_COMMANDS_ALWAYS_ACTIVE.get()).booleanValue()) || Config.SAFE_POINT.isSafeSet && Config.SAFE_POINT.isWithinSafeZone && (action.isNegative || !((Boolean)Config.POSITIVE_COMMANDS_ALWAYS_ACTIVE.get()).booleanValue())) continue;
            this.availableList.add(action);
        }
    }

    public void tickCooldowns() {
        for (int idx = 0; idx < this.list.size(); ++idx) {
            TrovoAction action = this.list.get(idx);
            if (action.cooldown_passed <= 0) continue;
            --action.cooldown_passed;
            this.list.set(idx, action);
        }
        if (this.commonCooldown > 0) {
            --this.commonCooldown;
            if (this.commonCooldown == 0) {
                this.accumulatedHeat = 0;
                this.updateAvailableList();
                Sounds.PlaySoundOnClient("cooldown_end");
                if (TrovoGration.HTTPSERVER.trovo != null && TrovoGration.HTTPSERVER.trovo.isConnected) {
                    TrovoGration.HTTPSERVER.trovo.sendMessageToChat(I18n.m_118938_((String)"commands.cooldownpassed", (Object[])new Object[0]));
                }
                if (TrovoGration.HTTPSERVER.twitch != null && TrovoGration.HTTPSERVER.twitch.isConnected) {
                    TrovoGration.HTTPSERVER.twitch.sendMessageToChat(I18n.m_118938_((String)"commands.cooldownpassed", (Object[])new Object[0]), "");
                }
                if (TrovoGration.HTTPSERVER.goodgame != null && TrovoGration.HTTPSERVER.goodgame.isConnected) {
                    TrovoGration.HTTPSERVER.goodgame.sendMessageToChat(I18n.m_118938_((String)"commands.cooldownpassed", (Object[])new Object[0]));
                }
            }
        }
    }

    public TrovoAction getAction(int index) {
        if (index >= this.list.size() || index < 0) {
            return null;
        }
        return this.list.get(index);
    }

    public int getHeatLimit(long day) {
        if (++day <= (long)((Integer)Config.LIMIT_MAX_DAY.get()).intValue()) {
            return (Integer)Config.SPENDING_LIMIT_PER_DAY.get() * (int)day;
        }
        return (Integer)Config.SPENDING_LIMIT_PER_DAY.get() * (Integer)Config.LIMIT_MAX_DAY.get();
    }

    public MutableComponent getTimeAndCooldown() {
        LocalPlayer player = StaticData.player;
        if (player == null) {
            return Component.m_237113_((String)"Trovogration");
        }
        Level dimension = player.m_9236_();
        long day = dimension.m_46468_() / 24000L;
        if (this.commonCooldown == 0) {
            return Component.m_237110_((String)"status.ready", (Object[])new Object[]{this.accumulatedHeat, this.getHeatLimit(day)});
        }
        return Component.m_237110_((String)"status.cooldown", (Object[])new Object[]{this.commonCooldown});
    }

    public MutableComponent getAvailableIndexCommand(int idx) {
        if (idx > this.getAvailableCount()) {
            return Component.m_237113_((String)"Out of Range");
        }
        TrovoAction action = this.availableList.get(idx);
        Object replacer = action.command.trim().toLowerCase();
        if (!action.isNegative) {
            replacer = "\u00a7a" + (String)replacer;
        }
        return Component.m_237110_((String)"actions.command", (Object[])new Object[]{replacer});
    }

    public MutableComponent getAvailableIndexPrice(int idx) {
        if (idx > this.getAvailableCount()) {
            return Component.m_237113_((String)"Out of Range");
        }
        TrovoAction action = this.availableList.get(idx);
        Object replacer = Integer.toString(action.cost);
        replacer = action.spOnly ? "\u00a7d" + (String)replacer + "\u00a7fSP" : (String)replacer + "RP";
        return Component.m_237110_((String)"actions.price", (Object[])new Object[]{replacer});
    }
}

