/*
 * Decompiled with CFR 0.152.
 */
package com.cwelth.trovogration.datastorage;

import com.cwelth.trovogration.TrovoGration;
import com.cwelth.trovogration.datastorage.StreamPlatform;
import com.cwelth.trovogration.datastorage.Viewer;
import com.cwelth.trovogration.datastorage.ViewerOld;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;

public class ViewersDB {
    public List<Viewer> viewers = new ArrayList<Viewer>();

    public static String getPath() {
        File file = Minecraft.m_91087_().f_91069_;
        try {
            return file.getCanonicalFile().getPath();
        }
        catch (IOException e) {
            TrovoGration.LOGGER.warn("Could not canonize path!");
            return file.getPath();
        }
    }

    public void loadFromDisk() {
        try {
            File fOld;
            File f = new File(ViewersDB.getPath() + "/trovogrationdata_v2.json");
            if (!f.exists() && (fOld = new File(ViewersDB.getPath() + "/trovogrationdata.json")).exists()) {
                BufferedReader br = new BufferedReader(new FileReader(ViewersDB.getPath() + "/trovogrationdata.json", StandardCharsets.UTF_8));
                ArrayList viewersOld = (ArrayList)new Gson().fromJson((Reader)br, new TypeToken<List<ViewerOld>>(){}.getType());
                if (viewersOld == null) {
                    viewersOld = new ArrayList();
                }
                br.close();
                for (ViewerOld viewerOld : viewersOld) {
                    this.viewers.add(new Viewer(viewerOld.userName, "", "", viewerOld.sp, viewerOld.rp));
                }
                Gson builder = new GsonBuilder().setPrettyPrinting().create();
                FileWriter writer = new FileWriter(ViewersDB.getPath() + "/trovogrationdata_v2.json", StandardCharsets.UTF_8);
                builder.toJson(this.viewers, (Appendable)writer);
                ((Writer)writer).flush();
                ((Writer)writer).close();
                File fBackup = new File(ViewersDB.getPath() + "/trovogrationdata_old.json");
                fOld.renameTo(fBackup);
            }
            BufferedReader br = new BufferedReader(new FileReader(ViewersDB.getPath() + "/trovogrationdata_v2.json", StandardCharsets.UTF_8));
            this.viewers = (List)new Gson().fromJson((Reader)br, new TypeToken<List<Viewer>>(){}.getType());
            if (this.viewers == null) {
                this.viewers = new ArrayList<Viewer>();
            }
            br.close();
            for (int ix = 0; ix < this.viewers.size(); ++ix) {
                if (this.viewers.get((int)ix).userNameGoodgame != null) continue;
                this.viewers.get((int)ix).userNameGoodgame = "";
            }
        }
        catch (IOException e) {
            this.viewers = new ArrayList<Viewer>();
        }
    }

    public void saveToDisk() {
        new Thread(() -> {
            Gson builder = new GsonBuilder().setPrettyPrinting().create();
            try {
                FileWriter writer = new FileWriter(ViewersDB.getPath() + "/trovogrationdata_v2.json", StandardCharsets.UTF_8);
                builder.toJson(this.viewers, (Appendable)writer);
                ((Writer)writer).flush();
                ((Writer)writer).close();
            }
            catch (JsonIOException e) {
                TrovoGration.LOGGER.error("Cannot save viewers data. " + e.getLocalizedMessage());
            }
            catch (IOException e) {
                TrovoGration.LOGGER.error("Cannot save viewers data. " + e.getLocalizedMessage());
            }
        }).start();
    }

    public int findViewer(String viewer, StreamPlatform platform) {
        for (int i = 0; i < this.viewers.size(); ++i) {
            Viewer vwr = this.viewers.get(i);
            if (this.viewers.get((int)i).userNameGoodgame.equalsIgnoreCase(viewer) && (platform == StreamPlatform.GOODGAME || platform == StreamPlatform.UNKNOWN)) {
                return i;
            }
            if (this.viewers.get((int)i).userNameTrovo.equalsIgnoreCase(viewer) && (platform == StreamPlatform.TROVO || platform == StreamPlatform.UNKNOWN)) {
                return i;
            }
            if (!this.viewers.get((int)i).userNameTwitch.equalsIgnoreCase(viewer) || platform != StreamPlatform.TWITCH && platform != StreamPlatform.UNKNOWN) continue;
            return i;
        }
        return -1;
    }

    public void addSPPoints(String viewer, int points, StreamPlatform platform) {
        int foundIdx = this.findViewer(viewer, StreamPlatform.UNKNOWN);
        if (foundIdx > -1) {
            Viewer original = this.viewers.get(foundIdx);
            original.sp += (long)points;
            this.viewers.set(foundIdx, original);
        } else {
            Viewer newViewer = null;
            if (platform == StreamPlatform.TROVO) {
                newViewer = new Viewer(viewer, "", "", points, 0L);
            }
            if (platform == StreamPlatform.TWITCH) {
                newViewer = new Viewer("", viewer, "", points, 0L);
            }
            if (platform == StreamPlatform.GOODGAME) {
                newViewer = new Viewer("", "", viewer, points, 0L);
            }
            if (newViewer != null) {
                this.viewers.add(newViewer);
            }
        }
    }

    public void addRPPoints(String viewer, int points, StreamPlatform platform) {
        int foundIdx = this.findViewer(viewer, StreamPlatform.UNKNOWN);
        if (foundIdx > -1) {
            Viewer original = this.viewers.get(foundIdx);
            original.rp += (long)points;
            this.viewers.set(foundIdx, original);
        } else {
            Viewer newViewer = null;
            if (platform == StreamPlatform.TROVO) {
                newViewer = new Viewer(viewer, "", "", 0L, points);
            }
            if (platform == StreamPlatform.TWITCH) {
                newViewer = new Viewer("", viewer, "", 0L, points);
            }
            if (platform == StreamPlatform.GOODGAME) {
                newViewer = new Viewer("", "", viewer, 0L, points);
            }
            if (newViewer != null) {
                this.viewers.add(newViewer);
            }
        }
    }

    public long getSPPoints(String viewer, StreamPlatform platform) {
        int foundIdx = this.findViewer(viewer, platform);
        if (foundIdx == -1) {
            return 0L;
        }
        Viewer vwr = this.viewers.get(foundIdx);
        return vwr.sp;
    }

    public long getRPPoints(String viewer, StreamPlatform platform) {
        int foundIdx = this.findViewer(viewer, platform);
        if (foundIdx == -1) {
            return 0L;
        }
        Viewer vwr = this.viewers.get(foundIdx);
        return vwr.rp;
    }

    public boolean discardPoints(String viewer, int amount, boolean spOnly, StreamPlatform platform) {
        int foundIdx = this.findViewer(viewer, platform);
        if (foundIdx == -1) {
            return false;
        }
        Viewer vwr = this.viewers.get(foundIdx);
        if (spOnly) {
            if (vwr.sp < (long)amount) {
                return false;
            }
            vwr.sp -= (long)amount;
        } else if (vwr.rp < (long)amount) {
            long sum = vwr.rp + vwr.sp;
            if (sum < (long)amount) {
                return false;
            }
            amount = (int)((long)amount - vwr.rp);
            vwr.rp = 0L;
            vwr.sp -= (long)amount;
        } else {
            vwr.rp -= (long)amount;
        }
        this.viewers.set(foundIdx, vwr);
        return true;
    }
}

