/*
 * Decompiled with CFR 0.152.
 */
package org.yusaki.villagertradeedit;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.util.BlockIterator;
import org.jetbrains.annotations.NotNull;
import org.yusaki.villagertradeedit.VillagerEditListener;
import org.yusaki.villagertradeedit.VillagerTradeEdit;
import org.yusaki.villagertradeedit.YskLibWrapper;
import org.yusaki.villagertradeedit.folialib.FoliaLib;

public class VTECommandExecutor
implements CommandExecutor,
TabCompleter {
    private final VillagerTradeEdit plugin;
    private final YskLibWrapper wrapper;
    private final VillagerEditListener villagerEditListener;
    private final FoliaLib foliaLib;
    private final Component prefixComponent;
    private final boolean prefixEnabled;

    public VTECommandExecutor(VillagerTradeEdit plugin, VillagerEditListener villagerEditListener) {
        boolean hasPrefix;
        this.plugin = plugin;
        this.wrapper = VillagerTradeEdit.getInstance().wrapper;
        this.villagerEditListener = villagerEditListener;
        this.foliaLib = plugin.getFoliaLib();
        String prefixRaw = this.wrapper.getMessage("prefix");
        if (prefixRaw == null || prefixRaw.isBlank()) {
            prefixRaw = plugin.getConfig().getString("messages.prefix", "");
        }
        this.prefixEnabled = hasPrefix = prefixRaw != null && !prefixRaw.isBlank();
        this.prefixComponent = hasPrefix ? LegacyComponentSerializer.legacyAmpersand().deserialize(prefixRaw) : Component.empty();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be run by a player.");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("villagertradeedit.command")) {
            this.wrapper.sendMessage((CommandSender)player, "noPermission");
            return true;
        }
        if (args.length == 0 || "help".equalsIgnoreCase(args[0])) {
            this.sendPluginInfo(player);
            return true;
        }
        if ("summon".equalsIgnoreCase(args[0])) {
            if (!player.hasPermission("villagertradeedit.command.summon")) {
                this.wrapper.sendMessage((CommandSender)player, "noPermission");
                return true;
            }
            if (!this.wrapper.canExecuteInWorld(player.getWorld())) {
                this.wrapper.sendMessage((CommandSender)player, "disabledWorld");
                return true;
            }
            BlockIterator iterator = new BlockIterator((LivingEntity)player, 5);
            while (iterator.hasNext()) {
                Block block = iterator.next();
                if (block.getType() == Material.AIR) continue;
                Location spawnLocation = block.getLocation().add(0.0, 1.0, 0.0);
                spawnLocation.setX(Math.floor(spawnLocation.getX()) + 0.5);
                spawnLocation.setZ(Math.floor(spawnLocation.getZ()) + 0.5);
                Villager villager = (Villager)player.getWorld().spawnEntity(spawnLocation, EntityType.VILLAGER);
                this.foliaLib.getScheduler().runAtEntity((Entity)villager, task -> {
                    this.villagerEditListener.activateStaticMode(villager, player);
                    villager.teleportAsync(spawnLocation);
                });
                return true;
            }
            this.wrapper.sendMessage((CommandSender)player, "noBlockInRange");
            return true;
        }
        if ("reload".equalsIgnoreCase(args[0])) {
            if (!player.hasPermission("villagertradeedit.command.reload")) {
                this.wrapper.sendMessage((CommandSender)player, "noPermission");
                return true;
            }
            this.plugin.reloadPluginConfig();
            this.wrapper.sendMessage((CommandSender)player, "configReloaded");
            return true;
        }
        return false;
    }

    private void sendPluginInfo(Player player) {
        String name = this.plugin.getDescription().getName();
        String version = this.plugin.getDescription().getVersion();
        String author = String.join((CharSequence)", ", this.plugin.getDescription().getAuthors());
        player.sendMessage((Component)Component.text((String)""));
        this.sendPrefixed(player, ((TextComponent)Component.text((String)(name + " v" + version)).color((TextColor)NamedTextColor.GOLD)).decorate(TextDecoration.BOLD));
        this.sendPrefixed(player, Component.text((String)"Custom villager trade editor (Paper/Folia).").color((TextColor)NamedTextColor.GRAY));
        this.sendPrefixed(player, ((TextComponent)Component.text((String)"Author: ").color((TextColor)NamedTextColor.DARK_GRAY)).append(Component.text((String)author).color((TextColor)NamedTextColor.WHITE)));
        player.sendMessage((Component)Component.text((String)""));
        this.sendPrefixed(player, Component.text((String)"Commands:").color((TextColor)NamedTextColor.GOLD));
        this.sendPrefixed(player, ((TextComponent)Component.text((String)" \u2022 /vte summon").color((TextColor)NamedTextColor.YELLOW)).append(Component.text((String)" \u2013 Spawn managed static villager").color((TextColor)NamedTextColor.GRAY)));
        this.sendPrefixed(player, ((TextComponent)Component.text((String)" \u2022 /vte reload").color((TextColor)NamedTextColor.YELLOW)).append(Component.text((String)" \u2013 Reload configuration").color((TextColor)NamedTextColor.GRAY)));
        player.sendMessage((Component)Component.text((String)""));
        this.sendPrefixed(player, Component.text((String)"Interactions:").color((TextColor)NamedTextColor.GOLD));
        this.sendPrefixed(player, Component.text((String)" \u2022 Right-click: trade (permission if set)").color((TextColor)NamedTextColor.GRAY));
        this.sendPrefixed(player, Component.text((String)" \u2022 Shift-right-click: open editor").color((TextColor)NamedTextColor.GRAY));
        player.sendMessage((Component)Component.text((String)""));
    }

    private void sendPrefixed(Player player, Component message) {
        if (this.prefixEnabled) {
            player.sendMessage(this.prefixComponent.append(message));
        } else {
            player.sendMessage(message);
        }
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (sender instanceof Player && args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>();
            completions.add("summon");
            completions.add("reload");
            return completions;
        }
        return null;
    }
}

