/*
 * Decompiled with CFR 0.152.
 */
package org.yusaki.villagertradeedit;

import com.destroystokyo.paper.event.entity.EntityPathfindEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.VillagerCareerChangeEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.EntitiesLoadEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.MerchantInventory;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;
import org.yusaki.villagertradeedit.SerializableMerchantRecipe;
import org.yusaki.villagertradeedit.VillagerTradeEdit;
import org.yusaki.villagertradeedit.YskLibWrapper;
import org.yusaki.villagertradeedit.folialib.FoliaLib;

public class VillagerEditListener
implements Listener {
    private VillagerTradeEdit plugin;
    YskLibWrapper wrapper;
    private final Map<Inventory, Villager> inventoryMap = new HashMap<Inventory, Villager>();
    private final Map<Inventory, Boolean> tradeAlteredMap = new HashMap<Inventory, Boolean>();
    private final Map<Inventory, Integer> pageMap = new HashMap<Inventory, Integer>();
    private final Map<Villager, List<RecipeRow>> editBuffer = new HashMap<Villager, List<RecipeRow>>();
    private final Map<UUID, Boolean> staticMap = new HashMap<UUID, Boolean>();
    private final Map<UUID, String> permissionMap = new HashMap<UUID, String>();
    private final Map<Villager, Villager.Profession> pendingProfessionMap = new HashMap<Villager, Villager.Profession>();
    private final Set<UUID> allowCareerChange = new HashSet<UUID>();
    private final Map<UUID, PotionEffect> removedHotv = new HashMap<UUID, PotionEffect>();
    private final NamespacedKey STATIC_KEY;
    private final NamespacedKey PROFESSION_KEY;
    private final NamespacedKey TRADES_KEY;
    private final NamespacedKey PERMISSION_KEY;
    FoliaLib foliaLib;
    private static final double TURN_RADIUS = 5.0;

    public VillagerEditListener() {
        this.plugin = VillagerTradeEdit.getInstance();
        this.foliaLib = this.plugin.getFoliaLib();
        this.wrapper = VillagerTradeEdit.getInstance().wrapper;
        this.STATIC_KEY = new NamespacedKey((Plugin)this.plugin, "static");
        this.PROFESSION_KEY = new NamespacedKey((Plugin)this.plugin, "profession");
        this.TRADES_KEY = new NamespacedKey((Plugin)this.plugin, "trades");
        this.PERMISSION_KEY = new NamespacedKey((Plugin)this.plugin, "permission");
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        if (!this.wrapper.canExecuteInWorld(event.getWorld())) {
            return;
        }
        for (Entity entity : event.getChunk().getEntities()) {
            NamespacedKey staticKey;
            Villager villager;
            PersistentDataContainer dataContainer;
            if (!(entity instanceof Villager) || !(dataContainer = (villager = (Villager)entity).getPersistentDataContainer()).has(staticKey = new NamespacedKey((Plugin)this.plugin, "static"), PersistentDataType.STRING)) continue;
            this.wrapper.logDebug("Found villager with data in loaded chunk, attempting to retrieve data");
            this.retrieveVillagerData(villager);
        }
    }

    @EventHandler
    public void onEntitiesLoad(EntitiesLoadEvent event) {
        if (!this.wrapper.canExecuteInWorld(event.getWorld())) {
            return;
        }
        for (Entity entity : event.getEntities()) {
            Villager villager;
            PersistentDataContainer dataContainer;
            if (!(entity instanceof Villager) || !(dataContainer = (villager = (Villager)entity).getPersistentDataContainer()).has(this.STATIC_KEY, PersistentDataType.STRING)) continue;
            this.wrapper.logDebug("Found villager entity loading with data, attempting to retrieve data (UUID: " + String.valueOf(villager.getUniqueId()) + ")");
            this.retrieveVillagerData(villager);
        }
    }

    public void storeVillagerData(Villager villager) {
        this.foliaLib.getScheduler().runAtEntity((Entity)villager, task -> this.storeVillagerDataSync(villager));
    }

    public void storeVillagerDataSync(Villager villager) {
        UUID villagerId = villager.getUniqueId();
        int tradeCount = villager.getRecipes().size();
        this.wrapper.logDebug("Storing data for villager " + String.valueOf(villagerId) + " (trades: " + tradeCount + ")");
        PersistentDataContainer dataContainer = villager.getPersistentDataContainer();
        boolean managed = this.isVillagerManaged(villager);
        this.staticMap.put(villagerId, managed);
        dataContainer.set(this.STATIC_KEY, PersistentDataType.STRING, (Object)Boolean.toString(managed));
        dataContainer.set(this.PROFESSION_KEY, PersistentDataType.STRING, (Object)villager.getProfession().name());
        String tradesData = this.serializeMerchantRecipes(villager.getRecipes());
        dataContainer.set(this.TRADES_KEY, PersistentDataType.STRING, (Object)tradesData);
        String perm = this.permissionMap.get(villagerId);
        if (perm == null) {
            perm = (String)dataContainer.get(this.PERMISSION_KEY, PersistentDataType.STRING);
        }
        if (perm != null && !perm.isBlank() && !perm.equalsIgnoreCase("none")) {
            dataContainer.set(this.PERMISSION_KEY, PersistentDataType.STRING, (Object)perm);
            this.permissionMap.put(villagerId, perm);
        } else {
            dataContainer.remove(this.PERMISSION_KEY);
            this.permissionMap.remove(villagerId);
        }
        this.wrapper.logDebug("Successfully stored data for villager " + String.valueOf(villagerId) + " (profession: " + villager.getProfession().name() + ", trades: " + tradeCount + ")");
    }

    public void retrieveVillagerData(Villager villager) {
        this.foliaLib.getScheduler().runAtEntity((Entity)villager, task -> {
            PersistentDataContainer dataContainer = villager.getPersistentDataContainer();
            String tradesData = (String)dataContainer.get(this.TRADES_KEY, PersistentDataType.STRING);
            int tradeCount = tradesData != null ? this.deserializeMerchantRecipes(tradesData).size() : 0;
            this.wrapper.logDebug("Retrieving data for villager " + String.valueOf(villager.getUniqueId()) + " (trades: " + tradeCount + ")");
            String staticValue = (String)dataContainer.get(this.STATIC_KEY, PersistentDataType.STRING);
            UUID villagerId = villager.getUniqueId();
            boolean managed = staticValue != null && Boolean.parseBoolean(staticValue);
            this.staticMap.put(villagerId, managed);
            villager.setCollidable(!managed);
            String professionName = (String)dataContainer.get(this.PROFESSION_KEY, PersistentDataType.STRING);
            if (professionName != null) {
                this.allowCareerChange.add(villager.getUniqueId());
                try {
                    villager.setProfession(Villager.Profession.valueOf((String)professionName));
                }
                finally {
                    this.allowCareerChange.remove(villager.getUniqueId());
                }
            }
            this.allowCareerChange.add(villager.getUniqueId());
            try {
                villager.setProfession(Villager.Profession.NONE);
            }
            finally {
                this.allowCareerChange.remove(villager.getUniqueId());
            }
            String permission = (String)dataContainer.get(this.PERMISSION_KEY, PersistentDataType.STRING);
            if (permission == null || permission.isBlank()) {
                this.permissionMap.remove(villagerId);
            } else {
                this.permissionMap.put(villagerId, permission);
            }
            villager.setRecipes(this.deserializeMerchantRecipes(tradesData));
            this.wrapper.logDebug("Successfully retrieved data for villager " + String.valueOf(villager.getUniqueId()) + " (profession: " + professionName + ", trades: " + tradeCount + ")");
        });
    }

    private String serializeMerchantRecipes(List<MerchantRecipe> recipes) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);
            dataOutput.writeInt(recipes.size());
            for (MerchantRecipe recipe : recipes) {
                SerializableMerchantRecipe serializableRecipe = new SerializableMerchantRecipe(recipe);
                dataOutput.writeObject((Object)serializableRecipe);
            }
            dataOutput.close();
            return Base64.getEncoder().encodeToString(outputStream.toByteArray());
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to save trades.", e);
        }
    }

    private List<MerchantRecipe> deserializeMerchantRecipes(String data) {
        if (data == null) {
            return new ArrayList<MerchantRecipe>();
        }
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64.getDecoder().decode(data));
            BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)inputStream);
            int size = dataInput.readInt();
            ArrayList<MerchantRecipe> recipes = new ArrayList<MerchantRecipe>(size);
            for (int i = 0; i < size; ++i) {
                SerializableMerchantRecipe serializableRecipe = (SerializableMerchantRecipe)dataInput.readObject();
                MerchantRecipe recipe = serializableRecipe.toMerchantRecipe();
                this.neutralizeRecipeDiscounts(recipe);
                recipes.add(recipe);
            }
            dataInput.close();
            return recipes;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalStateException("Unable to load trades.", e);
        }
    }

    public Inventory getInventoryFromVillager(Villager villager) {
        for (Map.Entry<Inventory, Villager> entry : this.inventoryMap.entrySet()) {
            if (!entry.getValue().equals((Object)villager)) continue;
            return entry.getKey();
        }
        return null;
    }

    private void renderPage(Villager villager, Inventory inv, int page) {
        int idx;
        List<RecipeRow> rows = this.ensureBuffer(villager);
        for (int s = 0; s < 27; ++s) {
            inv.setItem(s, new ItemStack(Material.AIR));
        }
        int start = page * 9;
        for (int col = 0; col < 9 && (idx = start + col) < rows.size(); ++col) {
            RecipeRow row = rows.get(idx);
            inv.setItem(col, this.cloneOrAir(row.ingredient1));
            inv.setItem(col + 9, this.cloneOrAir(row.ingredient2));
            inv.setItem(col + 18, this.cloneOrAir(row.result));
        }
        this.setupControls(inv, villager);
        this.updatePageIndicator(inv, page, this.computeTotalPages(villager));
    }

    private void syncVisiblePageToBuffer(Villager villager, Inventory inv) {
        List<RecipeRow> rows = this.ensureBuffer(villager);
        int page = this.pageMap.getOrDefault(inv, 0);
        int start = page * 9;
        for (int col = 0; col < 9; ++col) {
            int idx = start + col;
            ItemStack i1 = inv.getItem(col);
            ItemStack i2 = inv.getItem(col + 9);
            ItemStack res = inv.getItem(col + 18);
            RecipeRow row = new RecipeRow(i1, i2, res);
            if (idx >= rows.size()) {
                if (row.isEmpty()) continue;
                while (rows.size() <= idx) {
                    rows.add(new RecipeRow(new ItemStack(Material.AIR), new ItemStack(Material.AIR), new ItemStack(Material.AIR)));
                }
                rows.set(idx, row);
                continue;
            }
            rows.set(idx, row);
        }
    }

    private List<RecipeRow> ensureBuffer(Villager villager) {
        return this.editBuffer.computeIfAbsent(villager, v -> new ArrayList());
    }

    private void initBufferFromVillager(Villager villager) {
        this.foliaLib.getScheduler().runAtEntity((Entity)villager, task -> {
            ArrayList<RecipeRow> list = new ArrayList<RecipeRow>();
            for (MerchantRecipe mr : villager.getRecipes()) {
                ItemStack i1 = mr.getIngredients().size() > 0 ? (ItemStack)mr.getIngredients().get(0) : null;
                ItemStack i2 = mr.getIngredients().size() > 1 ? (ItemStack)mr.getIngredients().get(1) : null;
                ItemStack res = mr.getResult();
                list.add(new RecipeRow(i1, i2, res));
            }
            this.editBuffer.put(villager, list);
        });
    }

    private ItemStack cloneOrAir(ItemStack stack) {
        if (stack == null || stack.getType() == Material.AIR) {
            return new ItemStack(Material.AIR);
        }
        return stack.clone();
    }

    private void setupControls(Inventory inv, Villager villager) {
        for (int i = 27; i < inv.getSize(); ++i) {
            inv.setItem(i, new ItemStack(Material.BLACK_STAINED_GLASS_PANE));
        }
        inv.setItem(27, new ItemStack(Material.LEATHER_CHESTPLATE));
        this.foliaLib.getScheduler().runAtEntity((Entity)villager, task -> {
            Villager.Profession displayProfession = this.pendingProfessionMap.getOrDefault(villager, villager.getProfession());
            this.updateProfessionDisplayItem(inv, displayProfession);
            this.updateNameDisplayItem(inv, villager.customName());
            String currentPerm = (String)villager.getPersistentDataContainer().get(this.PERMISSION_KEY, PersistentDataType.STRING);
            this.updatePermissionDisplayItem(inv, currentPerm);
        });
        ItemStack prev = new ItemStack(Material.ARROW);
        ItemMeta pm = prev.getItemMeta();
        pm.displayName((Component)Component.text((String)"Prev"));
        prev.setItemMeta(pm);
        inv.setItem(32, prev);
        ItemStack next = new ItemStack(Material.ARROW);
        ItemMeta nm = next.getItemMeta();
        nm.displayName((Component)Component.text((String)"Next"));
        next.setItemMeta(nm);
        inv.setItem(33, next);
        ItemStack delete = new ItemStack(Material.BARRIER);
        ItemMeta dm = delete.getItemMeta();
        dm.displayName((Component)Component.text((String)"Delete Villager"));
        delete.setItemMeta(dm);
        inv.setItem(35, delete);
    }

    private void updatePageIndicator(Inventory inv, int page, int totalPages) {
        ItemStack indicator = new ItemStack(Material.PAPER);
        ItemMeta meta = indicator.getItemMeta();
        meta.displayName((Component)Component.text((String)("Page " + (page + 1) + "/" + totalPages)));
        indicator.setItemMeta(meta);
        inv.setItem(31, indicator);
    }

    private int countNonEmptyRows(List<RecipeRow> rows) {
        int count = 0;
        for (RecipeRow r : rows) {
            if (r.isEmpty()) continue;
            ++count;
        }
        return count;
    }

    private int computeTotalPages(Villager villager) {
        List<RecipeRow> rows = this.ensureBuffer(villager);
        int nonEmpty = this.countNonEmptyRows(rows);
        int base = (int)Math.ceil((double)nonEmpty / 9.0);
        return Math.max(1, base + 1);
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        Entity entity = event.getRightClicked();
        if (!(entity instanceof Villager)) {
            return;
        }
        Villager villager = (Villager)entity;
        if (!this.wrapper.canExecuteInWorld(villager.getWorld())) {
            return;
        }
        PersistentDataContainer pdc = villager.getPersistentDataContainer();
        if (player.isSneaking()) {
            if (pdc.has(this.STATIC_KEY, PersistentDataType.STRING)) {
                event.setCancelled(true);
                this.openEditor(villager, player);
            }
            return;
        }
        if (pdc.has(this.STATIC_KEY, PersistentDataType.STRING)) {
            String perm = (String)pdc.get(this.PERMISSION_KEY, PersistentDataType.STRING);
            if (!(perm == null || perm.isBlank() || perm.equalsIgnoreCase("none") || player.hasPermission(perm))) {
                event.setCancelled(true);
                this.wrapper.sendMessage((CommandSender)player, "noTradePermission");
                return;
            }
            event.setCancelled(true);
            this.openPerPlayerMerchant(villager, player);
            return;
        }
    }

    private void openPerPlayerMerchant(Villager villager, Player player) {
        this.foliaLib.getScheduler().runAtEntity((Entity)villager, task -> {
            ArrayList<MerchantRecipe> recipes = new ArrayList<MerchantRecipe>();
            for (MerchantRecipe r : villager.getRecipes()) {
                MerchantRecipe copy = new MerchantRecipe(this.cloneOrAir(r.getResult()), r.getMaxUses());
                for (ItemStack ing : r.getIngredients()) {
                    if (ing == null || ing.getType() == Material.AIR) continue;
                    copy.addIngredient(this.cloneOrAir(ing));
                }
                copy.setExperienceReward(false);
                this.neutralizeRecipeDiscounts(copy);
                recipes.add(copy);
            }
            Merchant merchant = Bukkit.createMerchant((String)(villager.customName() != null ? PlainTextComponentSerializer.plainText().serialize(villager.customName()) : "Villager"));
            merchant.setRecipes(recipes);
            this.foliaLib.getScheduler().runAtEntity((Entity)player, ptask -> player.openMerchant(merchant, true));
        });
    }

    public void openEditor(Villager villager, Player player) {
        if (!this.wrapper.canExecuteInWorld(villager.getWorld())) {
            this.wrapper.sendMessage((CommandSender)player, "disabledWorld");
            return;
        }
        if (!villager.getPersistentDataContainer().has(this.STATIC_KEY, PersistentDataType.STRING)) {
            this.wrapper.sendMessage((CommandSender)player, "notManagedVillager");
            return;
        }
        if (!player.hasPermission("villagertradeedit.open")) {
            this.wrapper.sendMessage((CommandSender)player, "noPermission");
            return;
        }
        Inventory inv = this.getInventoryFromVillager(villager);
        if (inv == null) {
            inv = Bukkit.createInventory(null, (int)36, (Component)Component.text((String)"Villager Trade Edit"));
            this.pageMap.put(inv, 0);
            if (!this.editBuffer.containsKey(villager)) {
                Inventory finalInv = inv;
                this.foliaLib.getScheduler().runAtEntity((Entity)villager, task -> {
                    ArrayList<RecipeRow> list = new ArrayList<RecipeRow>();
                    for (MerchantRecipe mr : villager.getRecipes()) {
                        ItemStack i1 = mr.getIngredients().size() > 0 ? (ItemStack)mr.getIngredients().get(0) : null;
                        ItemStack i2 = mr.getIngredients().size() > 1 ? (ItemStack)mr.getIngredients().get(1) : null;
                        ItemStack res = mr.getResult();
                        list.add(new RecipeRow(i1, i2, res));
                    }
                    this.editBuffer.put(villager, list);
                    this.foliaLib.getScheduler().runNextTick(task2 -> {
                        this.renderPage(villager, finalInv, this.pageMap.getOrDefault(finalInv, 0));
                        this.inventoryMap.put(finalInv, villager);
                        player.openInventory(finalInv);
                    });
                });
                return;
            }
        }
        this.renderPage(villager, inv, this.pageMap.getOrDefault(inv, 0));
        this.inventoryMap.put(inv, villager);
        player.openInventory(inv);
    }

    private void neutralizeRecipeDiscounts(MerchantRecipe recipe) {
        try {
            recipe.setSpecialPrice(0);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            recipe.setDemand(0);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            recipe.setPriceMultiplier(0.0f);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Method m = MerchantRecipe.class.getMethod("setIgnoreDiscounts", Boolean.TYPE);
            m.invoke((Object)recipe, true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        Inventory inventory = event.getInventory();
        if (!(inventory instanceof MerchantInventory)) {
            return;
        }
        MerchantInventory inv = (MerchantInventory)inventory;
        Merchant merchant = inv.getMerchant();
        if (merchant == null) {
            return;
        }
        if (merchant instanceof Villager) {
            Player player;
            PotionEffect effect;
            MerchantRecipe r2;
            Villager villager = (Villager)merchant;
            PersistentDataContainer pdc = villager.getPersistentDataContainer();
            if (!pdc.has(this.STATIC_KEY, PersistentDataType.STRING)) {
                return;
            }
            ArrayList recipes = new ArrayList(merchant.getRecipes());
            for (MerchantRecipe r2 : recipes) {
                this.neutralizeRecipeDiscounts(r2);
            }
            merchant.setRecipes(recipes);
            r2 = event.getPlayer();
            if (r2 instanceof Player && (effect = (player = (Player)r2).getPotionEffect(PotionEffectType.HERO_OF_THE_VILLAGE)) != null) {
                this.removedHotv.put(player.getUniqueId(), effect);
                player.removePotionEffect(PotionEffectType.HERO_OF_THE_VILLAGE);
            }
        }
    }

    private void updatePermissionDisplayItem(Inventory inv, String permission) {
        if (inv == null || inv.getSize() <= 29) {
            this.wrapper.logWarn("Inventory size is invalid or does not contain slot 29.");
            return;
        }
        ItemStack setPermissionItem = inv.getItem(29);
        if (setPermissionItem == null || setPermissionItem.getType() == Material.BLACK_STAINED_GLASS_PANE) {
            setPermissionItem = new ItemStack(Material.WRITABLE_BOOK);
        }
        ItemMeta setPermissionMeta = setPermissionItem.getItemMeta();
        String label = permission == null || permission.isBlank() || permission.equalsIgnoreCase("none") ? "(none)" : permission;
        setPermissionMeta.displayName((Component)Component.text((String)("Permission: " + label)));
        setPermissionItem.setItemMeta(setPermissionMeta);
        inv.setItem(29, setPermissionItem);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        int topSize;
        Inventory inv = event.getView().getTopInventory();
        if (!this.inventoryMap.containsKey(inv)) {
            return;
        }
        Villager villager = this.inventoryMap.get(inv);
        Player player = (Player)event.getWhoClicked();
        ItemStack clickedItem = event.getCurrentItem();
        int raw = event.getRawSlot();
        if (raw < (topSize = inv.getSize()) && raw < 27) {
            this.tradeAlteredMap.put(inv, true);
            int currentPage = this.pageMap.getOrDefault(inv, 0);
            this.foliaLib.getScheduler().runNextTick(task -> {
                this.syncVisiblePageToBuffer(villager, inv);
                this.updatePageIndicator(inv, currentPage, this.computeTotalPages(villager));
            });
            return;
        }
        if (raw < topSize && raw >= 27) {
            event.setCancelled(true);
        }
        if (raw == 27 && clickedItem != null) {
            this.handleProfessionChange(villager, player, inv);
            event.setCancelled(true);
        }
        if (raw == 28 && clickedItem != null) {
            this.handleSetName(villager, player, inv);
            event.setCancelled(true);
        }
        if (raw == 29 && clickedItem != null) {
            this.handleSetPermission(villager, player, inv);
            event.setCancelled(true);
        }
        if (raw == 32 && clickedItem != null) {
            this.syncVisiblePageToBuffer(villager, inv);
            int page = Math.max(0, this.pageMap.getOrDefault(inv, 0) - 1);
            this.pageMap.put(inv, page);
            this.renderPage(villager, inv, page);
            event.setCancelled(true);
        }
        if (raw == 33 && clickedItem != null) {
            this.syncVisiblePageToBuffer(villager, inv);
            int total = this.computeTotalPages(villager);
            int page = Math.min(total - 1, this.pageMap.getOrDefault(inv, 0) + 1);
            this.pageMap.put(inv, page);
            this.renderPage(villager, inv, page);
            event.setCancelled(true);
        }
        if (raw == 35 && clickedItem != null) {
            this.handleDeleteVillager(villager, player, inv);
            event.setCancelled(true);
        }
        if (raw >= topSize) {
            int currentPage = this.pageMap.getOrDefault(inv, 0);
            this.foliaLib.getScheduler().runNextTick(task -> {
                this.syncVisiblePageToBuffer(villager, inv);
                this.updatePageIndicator(inv, currentPage, this.computeTotalPages(villager));
            });
        }
    }

    private void handleSetPermission(final Villager villager, final Player player, final Inventory inv) {
        player.closeInventory();
        this.wrapper.sendMessage((CommandSender)player, "enterPermissionPrompt");
        Bukkit.getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onPlayerChat(AsyncPlayerChatEvent event) {
                if (event.getPlayer().equals((Object)player)) {
                    String permission = event.getMessage().trim();
                    event.setCancelled(true);
                    VillagerEditListener.this.foliaLib.getScheduler().runAtEntity((Entity)villager, task -> {
                        UUID villagerId = villager.getUniqueId();
                        if (permission.equalsIgnoreCase("none") || permission.isBlank()) {
                            VillagerEditListener.this.permissionMap.remove(villagerId);
                            villager.getPersistentDataContainer().remove(VillagerEditListener.this.PERMISSION_KEY);
                            VillagerEditListener.this.wrapper.sendMessage((CommandSender)player, "permissionCleared");
                        } else {
                            VillagerEditListener.this.permissionMap.put(villagerId, permission);
                            villager.getPersistentDataContainer().set(VillagerEditListener.this.PERMISSION_KEY, PersistentDataType.STRING, (Object)permission);
                            VillagerEditListener.this.wrapper.sendMessage((CommandSender)player, "permissionSet", permission);
                        }
                        VillagerEditListener.this.foliaLib.getScheduler().runNextTick(task2 -> {
                            VillagerEditListener.this.inventoryMap.put(inv, villager);
                            int currentPage = VillagerEditListener.this.pageMap.getOrDefault(inv, 0);
                            VillagerEditListener.this.renderPage(villager, inv, currentPage);
                            VillagerEditListener.this.updatePermissionDisplayItem(inv, (String)villager.getPersistentDataContainer().get(VillagerEditListener.this.PERMISSION_KEY, PersistentDataType.STRING));
                            player.openInventory(inv);
                        });
                    });
                    HandlerList.unregisterAll((Listener)this);
                }
            }
        }, (Plugin)this.plugin);
    }

    private void handleSetName(final Villager villager, final Player player, final Inventory inv) {
        player.closeInventory();
        this.wrapper.sendMessage((CommandSender)player, "enterNamePrompt");
        Bukkit.getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onPlayerChat(AsyncPlayerChatEvent event) {
                if (event.getPlayer().equals((Object)player)) {
                    event.setCancelled(true);
                    String input = event.getMessage();
                    if (input.equalsIgnoreCase("cancel")) {
                        VillagerEditListener.this.wrapper.sendMessage((CommandSender)player, "nameCancelled");
                    } else if (input.equalsIgnoreCase("none")) {
                        VillagerEditListener.this.foliaLib.getScheduler().runAtEntity((Entity)villager, task -> {
                            villager.customName(null);
                            villager.setCustomNameVisible(false);
                            VillagerEditListener.this.wrapper.sendMessage((CommandSender)player, "nameCleared");
                            VillagerEditListener.this.updateNameDisplayItem(inv, null);
                        });
                    } else {
                        Component comp = VillagerEditListener.this.parseNameComponent(input);
                        VillagerEditListener.this.foliaLib.getScheduler().runAtEntity((Entity)villager, task -> {
                            villager.customName(comp);
                            villager.setCustomNameVisible(true);
                            VillagerEditListener.this.wrapper.sendMessage((CommandSender)player, "nameUpdated");
                            VillagerEditListener.this.updateNameDisplayItem(inv, villager.customName());
                        });
                    }
                    HandlerList.unregisterAll((Listener)this);
                    VillagerEditListener.this.foliaLib.getScheduler().runNextTick(task -> {
                        VillagerEditListener.this.inventoryMap.put(inv, villager);
                        int currentPage = VillagerEditListener.this.pageMap.getOrDefault(inv, 0);
                        VillagerEditListener.this.renderPage(villager, inv, currentPage);
                        player.openInventory(inv);
                    });
                }
            }
        }, (Plugin)this.plugin);
    }

    private void handleDeleteVillager(Villager villager, Player player, Inventory inv) {
        this.inventoryMap.remove(inv);
        this.tradeAlteredMap.remove(inv);
        this.pageMap.remove(inv);
        this.editBuffer.remove(villager);
        this.pendingProfessionMap.remove(villager);
        this.permissionMap.remove(villager.getUniqueId());
        this.staticMap.remove(villager.getUniqueId());
        player.closeInventory();
        this.foliaLib.getScheduler().runAtEntity((Entity)villager, task -> {
            try {
                villager.remove();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.wrapper.sendMessage((CommandSender)player, "villagerDeleted");
        });
    }

    private void handleProfessionChange(Villager villager, Player player, Inventory inv) {
        Villager.Profession currentProfession = this.pendingProfessionMap.getOrDefault(villager, villager.getProfession());
        Villager.Profession nextProfession = this.getNextProfession(currentProfession);
        this.pendingProfessionMap.put(villager, nextProfession);
        this.foliaLib.getScheduler().runAtEntity((Entity)villager, task -> {
            this.allowCareerChange.add(villager.getUniqueId());
            try {
                villager.setProfession(nextProfession);
                villager.getPersistentDataContainer().set(this.PROFESSION_KEY, PersistentDataType.STRING, (Object)nextProfession.name());
            }
            finally {
                this.allowCareerChange.remove(villager.getUniqueId());
            }
        });
        this.updateProfessionDisplayItem(inv, nextProfession);
        this.tradeAlteredMap.put(inv, true);
    }

    void activateStaticMode(Villager villager, Player player) {
        this.wrapper.logDebugPlayer(player, "Static Mode Activated");
        this.staticMap.put(villager.getUniqueId(), true);
        villager.setInvulnerable(true);
        villager.setAware(false);
        villager.setVelocity(new Vector(0.0, 0.0, 0.0));
        Location currentLocation = villager.getLocation();
        Location centeredLocation = new Location(currentLocation.getWorld(), Math.floor(currentLocation.getX()) + 0.5, currentLocation.getY(), Math.floor(currentLocation.getZ()) + 0.5);
        villager.teleportAsync(centeredLocation);
        if (villager.getProfession() == Villager.Profession.NONE || villager.getProfession() == Villager.Profession.NITWIT) {
            villager.setProfession(Villager.Profession.ARMORER);
        }
        PersistentDataContainer dataContainer = villager.getPersistentDataContainer();
        dataContainer.set(this.STATIC_KEY, PersistentDataType.STRING, (Object)"true");
        villager.setCollidable(false);
        villager.setRecipes(new ArrayList());
    }

    void deactivateStaticMode(Villager villager, Player player) {
    }

    private Villager.Profession getNextProfession(Villager.Profession currentProfession) {
        Villager.Profession[] allowed = new Villager.Profession[]{Villager.Profession.ARMORER, Villager.Profession.BUTCHER, Villager.Profession.CARTOGRAPHER, Villager.Profession.CLERIC, Villager.Profession.FARMER, Villager.Profession.FISHERMAN, Villager.Profession.FLETCHER, Villager.Profession.LEATHERWORKER, Villager.Profession.LIBRARIAN, Villager.Profession.MASON, Villager.Profession.SHEPHERD, Villager.Profession.TOOLSMITH, Villager.Profession.WEAPONSMITH};
        int idx = 0;
        for (int i = 0; i < allowed.length; ++i) {
            if (allowed[i] != currentProfession) continue;
            idx = i;
            break;
        }
        return allowed[(idx + 1) % allowed.length];
    }

    private void updateProfessionDisplayItem(Inventory inv, Villager.Profession nextProfession) {
        ItemStack changeProfessionItem = inv.getItem(27);
        ItemMeta meta = changeProfessionItem.getItemMeta();
        String professionName = nextProfession.name();
        meta.displayName((Component)Component.text((String)("(" + professionName + ")")));
        changeProfessionItem.setItemMeta(meta);
    }

    private void updateNameDisplayItem(Inventory inv, Component nameComp) {
        ItemStack setNameItem = new ItemStack(Material.NAME_TAG);
        ItemMeta setNameMeta = setNameItem.getItemMeta();
        TextComponent label = nameComp == null ? Component.text((String)"Name: (none)") : Component.text((String)"Name: ").append(nameComp);
        setNameMeta.displayName((Component)label);
        setNameItem.setItemMeta(setNameMeta);
        inv.setItem(28, setNameItem);
    }

    private String getPlainName(Villager villager) {
        Component comp = villager.customName();
        if (comp == null) {
            return null;
        }
        return PlainTextComponentSerializer.plainText().serialize(comp);
    }

    private Component parseNameComponent(String input) {
        String msg = input.trim();
        if (msg.toLowerCase().startsWith("mini:")) {
            return MiniMessage.miniMessage().deserialize((Object)msg.substring(5));
        }
        if (msg.toLowerCase().startsWith("mm:")) {
            return MiniMessage.miniMessage().deserialize((Object)msg.substring(3));
        }
        if (msg.contains("<") && msg.contains(">")) {
            try {
                return MiniMessage.miniMessage().deserialize((Object)msg);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (msg.indexOf(38) >= 0 || msg.indexOf(167) >= 0) {
            String normalized = msg.replace('\u00a7', '&');
            return LegacyComponentSerializer.legacyAmpersand().deserialize(normalized);
        }
        return Component.text((String)msg);
    }

    private boolean isVillagerManaged(Villager villager) {
        UUID id = villager.getUniqueId();
        Boolean cached = this.staticMap.get(id);
        if (cached != null) {
            return cached;
        }
        PersistentDataContainer container = villager.getPersistentDataContainer();
        String stored = (String)container.get(this.STATIC_KEY, PersistentDataType.STRING);
        if (stored != null) {
            boolean managed = Boolean.parseBoolean(stored);
            this.staticMap.put(id, managed);
            return managed;
        }
        return false;
    }

    @EventHandler
    public void onEntityPathFind(EntityPathfindEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Villager)) {
            return;
        }
        Villager villager = (Villager)entity;
        if (this.isVillagerManaged(villager)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Villager)) {
            return;
        }
        Villager villager = (Villager)entity;
        if (this.isVillagerManaged(villager)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onVillagerCareerChange(VillagerCareerChangeEvent event) {
        Villager villager = event.getEntity();
        if (this.allowCareerChange.contains(villager.getUniqueId())) {
            return;
        }
        if (this.isVillagerManaged(villager)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (!(event.getEntity() instanceof Villager) || !(event.getDamager() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getDamager();
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (itemInHand.getType() == Material.NAME_TAG) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity player;
        Inventory inv = event.getInventory();
        if (this.inventoryMap.containsKey(inv)) {
            Villager villager = this.inventoryMap.get(inv);
            player = (Player)event.getPlayer();
            this.syncVisiblePageToBuffer(villager, inv);
            ArrayList<MerchantRecipe> newRecipes = new ArrayList<MerchantRecipe>();
            for (RecipeRow row : this.ensureBuffer(villager)) {
                if (row.isEmpty()) continue;
                MerchantRecipe newRecipe = new MerchantRecipe(this.cloneOrAir(row.result), 9999);
                if (row.ingredient1 != null && row.ingredient1.getType() != Material.AIR) {
                    newRecipe.addIngredient(this.cloneOrAir(row.ingredient1));
                }
                if (row.ingredient2 != null && row.ingredient2.getType() != Material.AIR) {
                    newRecipe.addIngredient(this.cloneOrAir(row.ingredient2));
                }
                this.neutralizeRecipeDiscounts(newRecipe);
                newRecipes.add(newRecipe);
            }
            if (this.isVillagerManaged(villager)) {
                this.foliaLib.getScheduler().runAtEntity((Entity)villager, task -> {
                    if (this.pendingProfessionMap.containsKey(villager)) {
                        this.allowCareerChange.add(villager.getUniqueId());
                        try {
                            villager.setProfession(this.pendingProfessionMap.get(villager));
                        }
                        finally {
                            this.allowCareerChange.remove(villager.getUniqueId());
                        }
                        this.pendingProfessionMap.remove(villager);
                    }
                    villager.setRecipes(newRecipes);
                    this.storeVillagerData(villager);
                });
            }
            this.tradeAlteredMap.remove(inv);
            this.pageMap.remove(inv);
            this.inventoryMap.remove(inv);
            this.editBuffer.remove(villager);
            this.pendingProfessionMap.remove(villager);
        }
        if ((player = event.getPlayer()) instanceof Player) {
            UUID id;
            PotionEffect prev;
            Player player2 = (Player)player;
            if (event.getInventory() instanceof MerchantInventory && (prev = this.removedHotv.remove(id = player2.getUniqueId())) != null) {
                player2.addPotionEffect(prev);
            }
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        Location playerLocation = player.getLocation();
        for (Entity entity : player.getNearbyEntities(5.0, 5.0, 5.0)) {
            Villager villager;
            if (!(entity instanceof Villager) || !this.isVillagerManaged(villager = (Villager)entity)) continue;
            this.turnVillagerTowardsPlayer(villager, playerLocation);
        }
    }

    private void turnVillagerTowardsPlayer(Villager villager, Location playerLocation) {
        Location villagerLocation = villager.getLocation();
        Vector direction = playerLocation.toVector().subtract(villagerLocation.toVector());
        villagerLocation.setDirection(direction);
        villager.teleportAsync(villagerLocation);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        UUID id = event.getPlayer().getUniqueId();
        PotionEffect prev = this.removedHotv.remove(id);
        if (prev != null) {
            // empty if block
        }
    }

    private static class RecipeRow {
        final ItemStack ingredient1;
        final ItemStack ingredient2;
        final ItemStack result;

        RecipeRow(ItemStack i1, ItemStack i2, ItemStack res) {
            this.ingredient1 = i1 == null ? new ItemStack(Material.AIR) : i1.clone();
            this.ingredient2 = i2 == null ? new ItemStack(Material.AIR) : i2.clone();
            this.result = res == null ? new ItemStack(Material.AIR) : res.clone();
        }

        boolean isEmpty() {
            boolean ing1 = this.ingredient1 == null || this.ingredient1.getType() == Material.AIR;
            boolean ing2 = this.ingredient2 == null || this.ingredient2.getType() == Material.AIR;
            boolean res = this.result == null || this.result.getType() == Material.AIR;
            return res || ing1 && ing2;
        }
    }
}

