/*
 * Decompiled with CFR 0.152.
 */
package org.yusaki.villagertradeedit;

import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Villager;
import org.bukkit.event.Listener;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.yusaki.lib.YskLib;
import org.yusaki.lib.config.ConfigMigration;
import org.yusaki.lib.config.ConfigUpdateOptions;
import org.yusaki.lib.modules.CommandAliasManager;
import org.yusaki.villagertradeedit.VTECommandExecutor;
import org.yusaki.villagertradeedit.VillagerEditListener;
import org.yusaki.villagertradeedit.YskLibWrapper;
import org.yusaki.villagertradeedit.folialib.FoliaLib;

public final class VillagerTradeEdit
extends JavaPlugin {
    private YskLib yskLib;
    public YskLibWrapper wrapper;
    private FoliaLib foliaLib;
    private VillagerEditListener villagerEditListener;

    public void onEnable() {
        this.saveDefaultConfig();
        this.yskLib = (YskLib)Bukkit.getPluginManager().getPlugin("YskLib");
        this.updateConfigSchema();
        this.yskLib.loadMessages((JavaPlugin)this);
        this.wrapper = new YskLibWrapper(this.yskLib);
        this.foliaLib = new FoliaLib((Plugin)this);
        this.getLogger().info("VillagerTradeEdit enabled!");
        this.villagerEditListener = new VillagerEditListener();
        this.getServer().getPluginManager().registerEvents((Listener)this.villagerEditListener, (Plugin)this);
        VTECommandExecutor vteCommandExecutor = new VTECommandExecutor(this, this.villagerEditListener);
        this.getCommand("vte").setExecutor((CommandExecutor)vteCommandExecutor);
        this.getCommand("vte").setTabCompleter((TabCompleter)vteCommandExecutor);
        this.applyCommandAliases();
        this.restoreAllLoadedVillagers(this.villagerEditListener);
    }

    private void restoreAllLoadedVillagers(VillagerEditListener listener) {
        this.foliaLib.getScheduler().runNextTick(task -> {
            int restoredCount = 0;
            for (World world : Bukkit.getWorlds()) {
                if (!this.wrapper.canExecuteInWorld(world)) continue;
                for (Entity entity : world.getEntities()) {
                    NamespacedKey staticKey;
                    Villager villager;
                    PersistentDataContainer pdc;
                    if (!(entity instanceof Villager) || !(pdc = (villager = (Villager)entity).getPersistentDataContainer()).has(staticKey = new NamespacedKey((Plugin)this, "static"), PersistentDataType.STRING)) continue;
                    listener.retrieveVillagerData(villager);
                    ++restoredCount;
                }
            }
            if (restoredCount > 0) {
                this.getLogger().info("Restored data for " + restoredCount + " already-loaded managed villagers");
            }
        });
    }

    public void onDisable() {
        this.getLogger().info("VillagerTradeEdit disabling, saving all managed villagers...");
        this.saveAllManagedVillagers();
        this.getLogger().info("VillagerTradeEdit disabled!");
    }

    private void saveAllManagedVillagers() {
        int savedCount = 0;
        for (World world : Bukkit.getWorlds()) {
            if (!this.wrapper.canExecuteInWorld(world)) continue;
            for (Entity entity : world.getEntities()) {
                NamespacedKey staticKey;
                Villager villager;
                PersistentDataContainer pdc;
                if (!(entity instanceof Villager) || !(pdc = (villager = (Villager)entity).getPersistentDataContainer()).has(staticKey = new NamespacedKey((Plugin)this, "static"), PersistentDataType.STRING) || this.villagerEditListener == null) continue;
                this.villagerEditListener.storeVillagerDataSync(villager);
                ++savedCount;
            }
        }
        this.getLogger().info("Saved data for " + savedCount + " managed villagers");
    }

    public static VillagerTradeEdit getInstance() {
        return (VillagerTradeEdit)VillagerTradeEdit.getPlugin(VillagerTradeEdit.class);
    }

    public FoliaLib getFoliaLib() {
        return this.foliaLib;
    }

    public void reloadPluginConfig() {
        this.updateConfigSchema();
        this.yskLib.loadMessages((JavaPlugin)this);
        this.applyCommandAliases();
    }

    private void updateConfigSchema() {
        ConfigUpdateOptions configOptions = ConfigUpdateOptions.builder().fileName("config.yml").resourcePath("config.yml").versionPath("version").reloadAction(file -> this.reloadConfig()).resetAction(file -> this.saveDefaultConfig()).skipMergeIfVersionMatches(true).addMigration(ConfigMigration.of((double)3.0, configuration -> {
            Object value = configuration.get("debug");
            if (value instanceof Boolean) {
                Boolean booleanValue = (Boolean)value;
                configuration.set("debug", (Object)(booleanValue != false ? 3 : 0));
            }
        }, (String)"Convert legacy boolean debug flag to numeric level")).build();
        this.yskLib.updateConfig((JavaPlugin)this, configOptions);
    }

    private void applyCommandAliases() {
        CommandAliasManager.applyAliases((JavaPlugin)this, (String)"vte", (FileConfiguration)this.getConfig(), (String)"settings.command-aliases.vte");
    }
}

