/*
 * Decompiled with CFR 0.152.
 */
package org.yusaki.villagertradeedit;

import java.util.Map;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.yusaki.lib.YskLib;
import org.yusaki.lib.modules.MessageManager;
import org.yusaki.villagertradeedit.VillagerTradeEdit;

public class YskLibWrapper {
    private final JavaPlugin plugin = VillagerTradeEdit.getInstance();
    private final YskLib yskLib;
    private final MessageManager messageManager;

    public YskLibWrapper(YskLib lib) {
        this.yskLib = lib;
        this.messageManager = lib.getMessageManager();
    }

    void sendActionBar(Player player, String message) {
        this.messageManager.sendActionBar(this.plugin, player, message);
    }

    void sendActionBar(Player player, String message, Map<String, String> placeholders) {
        this.messageManager.sendActionBar(this.plugin, player, message, placeholders);
    }

    void sendTitle(Player player, String title, String subtitle) {
        this.messageManager.sendTitle(this.plugin, player, title, subtitle, 20, 70, 20, MessageManager.createPlaceholders());
    }

    void sendTitle(Player player, String title, String subtitle, Map<String, String> placeholders) {
        this.messageManager.sendTitle(this.plugin, player, title, subtitle, 20, 70, 20, placeholders);
    }

    void sendMessage(CommandSender sender, String key) {
        this.messageManager.sendMessage(this.plugin, sender, key);
    }

    void sendMessage(CommandSender sender, String key, Map<String, String> placeholders) {
        this.messageManager.sendMessage(this.plugin, sender, key, placeholders);
    }

    void sendMessage(CommandSender sender, String key, Object ... args) {
        Map placeholders = MessageManager.createPlaceholders();
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; i += 2) {
                if (i + 1 < args.length) {
                    placeholders.put(String.valueOf(args[i]), String.valueOf(args[i + 1]));
                    continue;
                }
                placeholders.put("value", String.valueOf(args[i]));
            }
        }
        this.messageManager.sendMessage(this.plugin, sender, key, placeholders);
    }

    void sendMessageList(CommandSender sender, String key) {
        this.messageManager.sendMessageList(this.plugin, sender, key);
    }

    void sendMessageList(CommandSender sender, String key, Map<String, String> placeholders) {
        this.messageManager.sendMessageList(this.plugin, sender, key, placeholders);
    }

    String getMessage(String key) {
        return this.messageManager.getMessage(this.plugin, key);
    }

    String getMessage(String key, Map<String, String> placeholders) {
        return this.messageManager.getMessage(this.plugin, key, placeholders);
    }

    void updateConfig() {
        this.yskLib.updateConfig(this.plugin);
    }

    public boolean canExecuteInWorld(World world) {
        return this.yskLib.canExecuteInWorld(this.plugin, world);
    }

    public void logSevere(String s) {
        this.yskLib.logSevere(this.plugin, s);
    }

    public void logWarn(String s) {
        this.yskLib.logWarn(this.plugin, s);
    }

    public void logInfo(String s) {
        this.yskLib.logInfo(this.plugin, s);
    }

    public void logDebug(String s) {
        this.yskLib.logDebug(this.plugin, s);
    }

    public void logDebugPlayer(Player player, String s) {
        this.yskLib.logDebugPlayer(this.plugin, player, s);
    }
}

