/*
 *    This file is part of the Remote player waypoints for Xaero's Map mod
 *    licensed under the GNU GPL v3 License.
 *
 *    Copyright (C) 2024  Leander Knüttel
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package de.the_build_craft.remote_player_waypoints_for_xaero.mixins.forge.mods.xaerominimap;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.CommonModConfig;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
#if MC_VER == MC_1_17_1
import xaero.common.IXaeroMinimap;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.common.minimap.element.render.MinimapElementRenderer;
import xaero.common.minimap.element.render.MinimapElementRendererHandler;
import xaero.common.minimap.render.MinimapRendererHelper;
#else
import xaero.hud.minimap.element.render.MinimapElementRenderer;
import xaero.hud.minimap.element.render.MinimapElementRendererHandler;
#endif

import java.util.Collections;
import java.util.List;

/**
 * @author Leander Knüttel
 * @version 21.04.2025
 */
@Pseudo
@Mixin(xaero.common.minimap.element.render.MinimapElementRendererHandler.class)
public class MinimapElementRendererHandlerMixin {
    @Shadow
    @Final
    private List<xaero.common.minimap.element.render.MinimapElementRenderer<?, ?>> renderers;

    @Unique
    int lastOrder;

    @Inject(method = "render", at = @At("HEAD"))
    #if MC_VER > MC_1_19_4
    void injected(GuiGraphics guiGraphics, Vector3d renderPos, float partialTicks, Framebuffer framebuffer, double backgroundCoordinateScale, RegistryKey<World> mapDimension, CallbackInfo ci) {
    #elif MC_VER == MC_1_17_1
    void injected(MatrixStack matrixStack, Entity renderEntity, PlayerEntity player, double renderX, double renderY, double renderZ, double playerDimDiv, double ps, double pc, double zoom, boolean cave, float partialTicks, Framebuffer framebuffer, IXaeroMinimap modMain, MinimapRendererHelper helper, IRenderTypeBuffer.Impl renderTypeBuffers, FontRenderer font, MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers, CallbackInfo ci) {
    #else
    void injected(MatrixStack matrixStack, Vector3d renderPos, float partialTicks, Framebuffer framebuffer, double backgroundCoordinateScale, RegistryKey<World> mapDimension, CallbackInfo ci) {
    #endif
        int order = CommonModConfig.Instance.getWaypointLayerOrder();
        if (lastOrder == order) return;
        lastOrder = order;
        Collections.sort(renderers);
    }
}
