/*
 * Decompiled with CFR 0.152.
 */
package de.the_build_craft.maplink.common;

import de.the_build_craft.maplink.common.AbstractModInitializer;
import de.the_build_craft.maplink.common.CommonModConfig;
import de.the_build_craft.maplink.common.clientMapHandlers.ClientMapHandler;
import de.the_build_craft.maplink.common.waypoints.Double3;
import de.the_build_craft.maplink.common.waypoints.PlayerPosition;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.class_11200;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_742;
import net.minecraft.class_745;

public class FastUpdateTask {
    private final class_310 mc;
    public static final Map<String, PlayerPosition> playerPositions = new ConcurrentHashMap<String, PlayerPosition>();
    private final Map<String, PlayerPosition> onlinePlayerPositions = new ConcurrentHashMap<String, PlayerPosition>();
    private Set<String> currentLocalPlayerNames = new HashSet<String>();
    private final Map<String, Integer> skipOnlineUpdates = new ConcurrentHashMap<String, Integer>();
    private final Map<String, Double3> lastLocalVector = new ConcurrentHashMap<String, Double3>();
    private final Map<String, PlayerPosition> lastLocalPosition = new HashMap<String, PlayerPosition>();
    private static FastUpdateTask instance;

    public FastUpdateTask() {
        this.mc = class_310.method_1551();
        instance = this;
    }

    public void run() {
        try {
            this.runUpdate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runUpdate() {
        if (this.mc.field_1687 == null || this.mc.field_1724 == null || this.mc.field_1719 == null || this.mc.method_1576() != null && !this.mc.method_1576().method_3860() || this.mc.method_1558() == null || this.mc.method_1562() == null || !this.mc.method_1562().method_48296().method_10758() || !CommonModConfig.config.general.enabled || ClientMapHandler.getInstance() == null) {
            return;
        }
        playerPositions.clear();
        if (!AbstractModInitializer.connected) {
            ClientMapHandler.getInstance().handlePlayerWaypoints();
            return;
        }
        Set<String> prevLocalPlayerNames = this.currentLocalPlayerNames;
        this.currentLocalPlayerNames = new HashSet<String>(prevLocalPlayerNames.size());
        Map<String, PlayerPosition> map = this.onlinePlayerPositions;
        synchronized (map) {
            playerPositions.putAll(this.onlinePlayerPositions);
            Map<UUID, String> uuidPlayerMap = this.mc.method_1562().method_2880().stream().collect(Collectors.toMap(playerInfo -> playerInfo.method_2966().getId(), playerInfo -> playerInfo.method_2966().getName()));
            class_243 cameraPos = this.mc.field_1719.method_33571();
            this.mc.field_1724.field_3944.method_70936().method_70954(this.mc.field_1719, trackedWaypoint -> {
                if (trackedWaypoint.field_59775 == class_11200.class_11205.field_59779) {
                    class_11200.class_11206 vec3iWaypoint = (class_11200.class_11206)trackedWaypoint;
                    vec3iWaypoint.method_70763().left().ifPresent(uuid -> {
                        String name;
                        if (uuidPlayerMap.containsKey(uuid) && this.onlinePlayerPositions.containsKey(name = (String)uuidPlayerMap.get(uuid)) && cameraPos.method_1028((double)vec3iWaypoint.field_59784.method_10263(), (double)vec3iWaypoint.field_59784.method_10264(), (double)vec3iWaypoint.field_59784.method_10260()) < 40000.0) {
                            PlayerPosition playerPosition = new PlayerPosition(name, vec3iWaypoint.field_59784.method_10263(), vec3iWaypoint.field_59784.method_10264(), vec3iWaypoint.field_59784.method_10260(), "");
                            this.updateFromLocalPosition(playerPosition);
                        }
                    });
                }
            });
            for (class_742 player : this.mc.field_1687.method_18456()) {
                String name = player.method_7334().getName();
                if (!(player instanceof class_745) || !this.onlinePlayerPositions.containsKey(name)) continue;
                this.updateFromLocalPosition(new PlayerPosition(player));
            }
            for (String playerName : prevLocalPlayerNames) {
                if (this.currentLocalPlayerNames.contains(playerName)) continue;
                this.skipOnlineUpdates.put(playerName, 2);
            }
        }
        ClientMapHandler.getInstance().handlePlayerWaypoints();
    }

    private void updateFromLocalPosition(PlayerPosition playerPosition) {
        ClientMapHandler.registerTempPlayerPosition(playerPosition);
        Double3 lastPos = this.lastLocalPosition.getOrDefault((Object)playerPosition.name, (PlayerPosition)playerPosition).pos;
        if (!lastPos.roughlyEqual(playerPosition.pos)) {
            this.lastLocalVector.put(playerPosition.name, playerPosition.pos.sub(lastPos));
        }
        this.lastLocalPosition.put(playerPosition.name, playerPosition);
        playerPositions.put(playerPosition.name, playerPosition);
        this.currentLocalPlayerNames.add(playerPosition.name);
        this.skipOnlineUpdates.remove(playerPosition.name);
        this.onlinePlayerPositions.put(playerPosition.name, playerPosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFromOnlineMap(HashMap<String, PlayerPosition> onlinePlayerPositions) {
        Map<String, PlayerPosition> map = this.onlinePlayerPositions;
        synchronized (map) {
            for (PlayerPosition playerPosition : onlinePlayerPositions.values()) {
                if (this.skipOnlineUpdates.containsKey(playerPosition.name)) {
                    double dot = playerPosition.pos.sub(this.lastLocalPosition.get((Object)playerPosition.name).pos).dot(this.lastLocalVector.getOrDefault(playerPosition.name, Double3.ZERO));
                    if (dot >= 0.0) {
                        this.skipOnlineUpdates.remove(playerPosition.name);
                        this.onlinePlayerPositions.put(playerPosition.name, playerPosition);
                        continue;
                    }
                    int skipCount = this.skipOnlineUpdates.get(playerPosition.name);
                    if (skipCount <= 0) {
                        this.skipOnlineUpdates.remove(playerPosition.name);
                        this.onlinePlayerPositions.put(playerPosition.name, playerPosition);
                        continue;
                    }
                    this.skipOnlineUpdates.put(playerPosition.name, skipCount - 1);
                    continue;
                }
                this.onlinePlayerPositions.put(playerPosition.name, playerPosition);
            }
            this.onlinePlayerPositions.entrySet().removeIf(e -> !onlinePlayerPositions.containsKey(e.getKey()));
            this.skipOnlineUpdates.entrySet().removeIf(e -> !onlinePlayerPositions.containsKey(e.getKey()));
        }
    }

    public void clearAllPlayerPositions() {
        playerPositions.clear();
        this.onlinePlayerPositions.clear();
    }

    public static FastUpdateTask getInstance() {
        return instance;
    }
}

