/*
 * Decompiled with CFR 0.152.
 */
package de.the_build_craft.maplink.common.waypoints;

import de.the_build_craft.maplink.common.CommonModConfig;
import de.the_build_craft.maplink.common.clientMapHandlers.ClientMapHandler;
import de.the_build_craft.maplink.common.waypoints.Double3;
import de.the_build_craft.maplink.common.waypoints.MutableDouble3;
import de.the_build_craft.maplink.common.waypoints.PlayerPosition;
import de.the_build_craft.maplink.common.waypoints.WaypointState;
import java.util.UUID;
import net.minecraft.class_3532;

public class MutablePlayerPosition {
    private final String id;
    public final UUID uuid;
    private final MutableDouble3 prevPos;
    private final MutableDouble3 pos;
    private WaypointState waypointState;
    private long prevUpdate;
    private double interpolationTime = 100.0;

    public MutablePlayerPosition(PlayerPosition playerPosition, WaypointState waypointState) {
        this.id = playerPosition.id;
        this.uuid = playerPosition.gameProfile.getId();
        this.prevPos = new MutableDouble3(playerPosition.pos);
        this.pos = new MutableDouble3(playerPosition.pos);
        this.waypointState = waypointState;
        this.prevUpdate = System.currentTimeMillis();
    }

    public WaypointState getWaypointState() {
        if (this.waypointState.isOld) {
            this.waypointState = ClientMapHandler.getWaypointState(this.id);
        }
        return this.waypointState;
    }

    public void updateFrom(Double3 newPos) {
        this.prevPos.updateFrom(this.pos);
        this.pos.updateFrom(newPos);
        this.prevUpdate = System.currentTimeMillis();
        this.interpolationTime = class_3532.method_15350((double)CommonModConfig.config.general.interpolationTime, (double)1.0, (double)100.0);
    }

    double easeInOutCubic(double x) {
        return x < 0.5 ? 4.0 * x * x * x : 1.0 - Math.pow(-2.0 * x + 2.0, 3.0) / 2.0;
    }

    public double getLerpedX() {
        if (CommonModConfig.config.general.interpolationTime < 1) {
            return this.pos.x;
        }
        return class_3532.method_16436((double)this.easeInOutCubic(class_3532.method_15350((double)((double)(System.currentTimeMillis() - this.prevUpdate) / this.interpolationTime), (double)0.0, (double)1.0)), (double)this.prevPos.x, (double)this.pos.x);
    }

    public double getLerpedY() {
        if (CommonModConfig.config.general.interpolationTime < 1) {
            return this.pos.y;
        }
        return class_3532.method_16436((double)this.easeInOutCubic(class_3532.method_15350((double)((double)(System.currentTimeMillis() - this.prevUpdate) / this.interpolationTime), (double)0.0, (double)1.0)), (double)this.prevPos.y, (double)this.pos.y);
    }

    public double getLerpedZ() {
        if (CommonModConfig.config.general.interpolationTime < 1) {
            return this.pos.z;
        }
        return class_3532.method_16436((double)this.easeInOutCubic(class_3532.method_15350((double)((double)(System.currentTimeMillis() - this.prevUpdate) / this.interpolationTime), (double)0.0, (double)1.0)), (double)this.prevPos.z, (double)this.pos.z);
    }
}

