/*
 * Decompiled with CFR 0.152.
 */
package de.the_build_craft.remote_player_waypoints_for_xaero.common;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.CommonModConfig;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.LoaderType;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.ModChecker;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.PlayerPosition;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.UpdateTask;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.connections.MapConnection;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.wrappers.Utils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.commands.CommandSourceStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractModInitializer {
    public static final String MOD_ID = "remote_player_waypoints_for_xaero";
    public static final String MOD_NAME = "Remote Player Waypoints For Xaero's Map";
    public static final String VERSION = "3.4.0";
    public static final Logger LOGGER = LogManager.getLogger((String)"RemotePlayerWaypointsForXaero");
    public static AbstractModInitializer INSTANCE;
    private static UpdateTask updateTask;
    private static Timer RemoteUpdateThread;
    public static int TimerDelay;
    private static MapConnection connection;
    public static boolean connected;
    public static HashMap<String, Boolean> AfkDic;
    public static HashMap<String, Long> AfkTimeDic;
    public static HashMap<String, PlayerPosition> lastPlayerDataDic;
    public static int unknownAfkStateColor;
    public static int AfkColor;
    public static boolean showAfkInTabList;
    public static boolean showAfkTimeInTabList;
    public static boolean hideAfkMinutes;
    public static boolean enabled;
    public static boolean mapModInstalled;
    public static boolean overwriteCurrentDimension;
    public static HashMap<ClientLevel, HashMap<String, RemotePlayer>> fakePlayerEntities;
    public LoaderType loaderType;

    protected abstract void createInitialBindings();

    protected abstract IEventProxy createClientProxy();

    protected abstract IEventProxy createServerProxy(boolean var1);

    protected abstract void initializeModCompat();

    public void onInitializeClient() {
        LOGGER.info("Initializing Remote Player Waypoints For Xaero's Map");
        this.startup();
        mapModInstalled = ModChecker.INSTANCE.classExists("xaero.minimap.XaeroMinimap") || ModChecker.INSTANCE.classExists("xaero.pvp.BetterPVP");
        LOGGER.info("mapModInstalled: " + mapModInstalled);
        unknownAfkStateColor = CommonModConfig.Instance.unknownAfkStateColor();
        AfkColor = CommonModConfig.Instance.AfkColor();
        RemoteUpdateThread = new Timer(true);
        updateTask = new UpdateTask();
        RemoteUpdateThread.scheduleAtFixedRate((TimerTask)updateTask, 0L, (long)CommonModConfig.Instance.updateDelay());
        TimerDelay = CommonModConfig.Instance.updateDelay();
        this.printModInfo();
        this.createClientProxy().registerEvents();
        this.createServerProxy(false).registerEvents();
        this.initializeModCompat();
        this.initConfig();
        LOGGER.info("Remote Player Waypoints For Xaero's Map Initialized");
    }

    public void onInitializeServer() {
        LOGGER.info("Initializing Remote Player Waypoints For Xaero's Map");
        this.startup();
        this.printModInfo();
        this.createServerProxy(true).registerEvents();
        this.initConfig();
        LOGGER.info("Remote Player Waypoints For Xaero's Map Initialized");
    }

    private void startup() {
        INSTANCE = this;
        this.createInitialBindings();
    }

    private void printModInfo() {
        LOGGER.info("Remote Player Waypoints For Xaero's Map, Version: 3.4.0");
    }

    private void initConfig() {
    }

    public static void registerClientCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder<CommandSourceStack> baseCommand = AbstractModInitializer.literal(MOD_ID);
        LiteralArgumentBuilder ignoreCommand = (LiteralArgumentBuilder)baseCommand.then(AbstractModInitializer.literal("ignore_server").executes(context -> {
            AbstractModInitializer.IgnoreServer();
            return 1;
        }));
        dispatcher.register(ignoreCommand);
        LiteralArgumentBuilder setAfkTimeCommand = (LiteralArgumentBuilder)baseCommand.then(AbstractModInitializer.literal("set_afk_time").then(AbstractModInitializer.argument("player", StringArgumentType.word()).then(AbstractModInitializer.argument("time", IntegerArgumentType.integer((int)0)).executes(context -> {
            String playerName = StringArgumentType.getString((CommandContext)context, (String)"player");
            int time = IntegerArgumentType.getInteger((CommandContext)context, (String)"time");
            AfkTimeDic.put(playerName, (long)time * 1000L);
            AfkDic.put(playerName, time > 0);
            Utils.sendToClientChat("Set AFK time for " + playerName + " to " + time);
            return 1;
        }))));
        dispatcher.register(setAfkTimeCommand);
        LiteralArgumentBuilder setCurrentDimensionCommand = (LiteralArgumentBuilder)baseCommand.then(AbstractModInitializer.literal("set_current_dimension").then(AbstractModInitializer.argument("dimension", StringArgumentType.word()).executes(context -> {
            if (connection == null) {
                Utils.sendErrorToClientChat("Not connected to a server!");
            } else {
                String dimension;
                AbstractModInitializer.connection.currentDimension = dimension = StringArgumentType.getString((CommandContext)context, (String)"dimension");
                Utils.sendToClientChat("Set current-dimension to: " + dimension);
            }
            return 1;
        })));
        dispatcher.register(setCurrentDimensionCommand);
        LiteralArgumentBuilder setCurrentDimensionOverwriteCommand = (LiteralArgumentBuilder)baseCommand.then(AbstractModInitializer.literal("set_current_dimension_overwrite").then(AbstractModInitializer.argument("on", StringArgumentType.word()).executes(context -> {
            overwriteCurrentDimension = Boolean.parseBoolean(StringArgumentType.getString((CommandContext)context, (String)"on"));
            Utils.sendToClientChat("Set dimension-overwrite to: " + overwriteCurrentDimension);
            return 1;
        })));
        dispatcher.register(setCurrentDimensionOverwriteCommand);
        LiteralArgumentBuilder openOnlineMapConfig = (LiteralArgumentBuilder)baseCommand.then(AbstractModInitializer.literal("open_online_map_config").executes(context -> {
            if (connection == null) {
                Utils.sendErrorToClientChat("Not connected to a server!");
            } else {
                connection.OpenOnlineMapConfig();
            }
            return 1;
        }));
        dispatcher.register(openOnlineMapConfig);
        LiteralArgumentBuilder ignoreMarkerMessageCommand = (LiteralArgumentBuilder)baseCommand.then(AbstractModInitializer.literal("ignore_marker_message").executes(context -> {
            CommonModConfig.Instance.setIgnoreMarkerMessage(true);
            Utils.sendToClientChat("You will not receive this warning again!");
            return 1;
        }));
        dispatcher.register(ignoreMarkerMessageCommand);
    }

    public static void registerServerCommands(CommandDispatcher<CommandSourceStack> dispatcher, boolean allOrDedicated) {
    }

    private static LiteralArgumentBuilder<CommandSourceStack> literal(String string) {
        return LiteralArgumentBuilder.literal((String)string);
    }

    private static <T> RequiredArgumentBuilder<CommandSourceStack, T> argument(String name, ArgumentType<T> type) {
        return RequiredArgumentBuilder.argument((String)name, type);
    }

    public static void setUpdateDelay(int ms) {
        if (RemoteUpdateThread == null) {
            return;
        }
        updateTask.cancel();
        updateTask = new UpdateTask();
        RemoteUpdateThread.scheduleAtFixedRate((TimerTask)updateTask, 0L, (long)ms);
        TimerDelay = ms;
        LOGGER.info("Remote update delay has been set to " + ms + " ms");
    }

    public static void setConnection(MapConnection connection) {
        connected = connection != null;
        AbstractModInitializer.connection = connection;
    }

    @Nullable
    public static MapConnection getConnection() {
        return connection;
    }

    public static void IgnoreServer() {
        ServerData server = Minecraft.getInstance().getCurrentServer();
        if (server != null) {
            String address = server.ip.toLowerCase(Locale.ROOT);
            if (!CommonModConfig.Instance.ignoredServers().contains(address)) {
                CommonModConfig.Instance.ignoredServers().add(address);
            }
            CommonModConfig.Instance.saveConfig();
            Utils.sendToClientChat("You will not receive this warning again!");
        } else {
            Utils.sendToClientChat("This can only be executed on a server!");
        }
    }

    public static String[] getModIdAliases(String id) {
        HashMap<String, String[]> modIdAliases = new HashMap<String, String[]>();
        modIdAliases.put("xaerominimap", new String[]{"xaerominimapfair", "xaerobetterpvp", "xaerobetterpvpfair"});
        if (modIdAliases.containsKey(id)) {
            return (String[])modIdAliases.get(id);
        }
        return new String[]{id};
    }

    static {
        RemoteUpdateThread = null;
        connection = null;
        connected = false;
        AfkDic = new HashMap();
        AfkTimeDic = new HashMap();
        lastPlayerDataDic = new HashMap();
        unknownAfkStateColor = 0x606060;
        AfkColor = 0xFF5500;
        showAfkInTabList = true;
        showAfkTimeInTabList = true;
        hideAfkMinutes = false;
        enabled = true;
        mapModInstalled = false;
        overwriteCurrentDimension = false;
        fakePlayerEntities = new HashMap();
    }

    public static interface IEventProxy {
        public void registerEvents();
    }
}

