/*
 * Decompiled with CFR 0.152.
 */
package de.the_build_craft.remote_player_waypoints_for_xaero.common;

import de.the_build_craft.remote_player_waypoints_for_xaero.common.wrappers.Text;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.client.Minecraft;

public abstract class CommonModConfig {
    public static CommonModConfig Instance;

    public CommonModConfig() {
        Instance = this;
    }

    public abstract void saveConfig();

    public abstract boolean enabled();

    public abstract boolean enablePlayerWaypoints();

    public abstract boolean enableMarkerWaypoints();

    public abstract boolean enableEntityRadar();

    public abstract WaypointRenderBelowMode minimapWaypointsRenderBelow();

    public abstract int updateDelay();

    public abstract int minDistance();

    public abstract int maxDistance();

    public abstract int maxIconDistance();

    public abstract int minDistanceMarker();

    public abstract int maxDistanceMarker();

    public abstract int defaultY();

    public abstract int timeUntilAfk();

    public abstract int unknownAfkStateColor();

    public abstract int AfkColor();

    public abstract int playerWaypointColor();

    public abstract int markerWaypointColor();

    public abstract boolean showAfkTimeInTabList();

    public abstract boolean showAfkInTabList();

    public abstract boolean hideAfkMinutes();

    public abstract boolean debugMode();

    public abstract boolean chatLogInDebugMode();

    public abstract List<String> ignoredServers();

    public abstract List<ServerEntry> serverEntries();

    public abstract void setMarkerLayers(String var1, List<String> var2);

    public abstract void setIgnoreMarkerMessage(boolean var1);

    public abstract boolean ignoreMarkerMessage();

    public abstract List<String> friendList();

    public abstract boolean onlyShowFriendsWaypoints();

    public abstract boolean onlyShowFriendsIcons();

    public abstract boolean overwriteFriendDistances();

    public abstract int minFriendDistance();

    public abstract int maxFriendDistance();

    public abstract int maxFriendIconDistance();

    public abstract boolean overwriteFriendWaypointColor();

    public abstract int friendWaypointColor();

    public int getPlayerWaypointColor(String playerName) {
        if (this.overwriteFriendWaypointColor() && this.friendList().contains(playerName)) {
            return this.friendWaypointColor();
        }
        return this.playerWaypointColor();
    }

    public ServerEntry getCurrentServerEntry() {
        String serverIP = Objects.requireNonNull(Minecraft.getInstance().getCurrentServer()).ip.toLowerCase(Locale.ROOT);
        ServerEntry serverEntry = null;
        for (ServerEntry server : this.serverEntries()) {
            if (!Objects.equals(serverIP, server.ip.toLowerCase(Locale.ROOT))) continue;
            serverEntry = server;
        }
        return serverEntry;
    }

    public int getWaypointLayerOrder() {
        WaypointRenderBelowMode waypointRenderBelowMode = this.minimapWaypointsRenderBelow();
        boolean playerListDown = Minecraft.getInstance().options.keyPlayerList.isDown();
        if (waypointRenderBelowMode == WaypointRenderBelowMode.ALWAYS) {
            return -1;
        }
        if (waypointRenderBelowMode == WaypointRenderBelowMode.WHEN_PLAYER_LIST_SHOWN ? playerListDown : waypointRenderBelowMode == WaypointRenderBelowMode.WHEN_PLAYER_LIST_HIDDEN && !playerListDown) {
            return -1;
        }
        return 100;
    }

    public static class ServerEntry {
        public Maptype maptype;
        public String ip;
        public String link;
        public MarkerVisibilityMode markerVisibilityMode;
        public List<String> markerLayers;

        public ServerEntry() {
            this("", "", Maptype.Dynmap, MarkerVisibilityMode.Auto, new ArrayList<String>());
        }

        public ServerEntry(String ip, String link, Maptype maptype, MarkerVisibilityMode markerVisibilityMode, List<String> markerLayers) {
            this.ip = ip;
            this.link = link;
            this.maptype = maptype;
            this.markerVisibilityMode = markerVisibilityMode;
            this.markerLayers = markerLayers;
        }

        public boolean includeMarkerLayer(String layer) {
            switch (this.markerVisibilityMode.ordinal()) {
                case 0: 
                case 1: {
                    return true;
                }
                case 2: {
                    return false;
                }
                case 3: {
                    return !this.markerLayers.contains(layer);
                }
                case 4: {
                    return this.markerLayers.contains(layer);
                }
            }
            throw new IllegalArgumentException();
        }

        public static enum Maptype {
            Dynmap,
            Squaremap,
            Bluemap,
            Pl3xMap,
            LiveAtlas;

        }

        public static enum MarkerVisibilityMode {
            Auto,
            All,
            None,
            BlackList,
            WhiteList;

        }
    }

    public static enum WaypointRenderBelowMode {
        NEVER,
        ALWAYS,
        WHEN_PLAYER_LIST_SHOWN,
        WHEN_PLAYER_LIST_HIDDEN;


        public String toString() {
            return Text.translatable("text.autoconfig.remote_player_waypoints_for_xaero.option.general.minimapWaypointsRenderBelow." + this.name()).getString();
        }
    }

    public static enum WaypointColor {
        Black,
        DarkBlue,
        DarkGreen,
        DarkAqua,
        DarkRed,
        DarkPurple,
        Gold,
        Gray,
        DarkGray,
        Blue,
        Green,
        Aqua,
        Red,
        LightPurple,
        Yellow,
        White;


        public String toString() {
            return Text.translatable("WaypointColor." + this.name()).getString();
        }
    }
}

