/*
 * Decompiled with CFR 0.152.
 */
package de.the_build_craft.remote_player_waypoints_for_xaero.common.connections;

import com.google.common.reflect.TypeToken;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.AbstractModInitializer;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.CommonModConfig;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.HTTP;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.PlayerPosition;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.UpdateTask;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.WaypointPosition;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.connections.BlueMapConfiguration;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.connections.MapConnection;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.mapUpdates.BlueMapMarkerSet;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.mapUpdates.BlueMapPlayerUpdate;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.wrappers.Utils;
import java.io.IOException;
import java.lang.invoke.StringConcatFactory;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BlueMapConnection
extends MapConnection {
    public int lastWorldIndex;
    public List<URL> playerUrls;
    public List<URL> markerUrls;
    public List<String> worlds = new ArrayList<String>();
    URL lastURL = null;
    HashMap<String, WaypointPosition> lastResult = new HashMap();

    public BlueMapConnection(CommonModConfig.ServerEntry serverEntry, UpdateTask updateTask) throws IOException {
        this.playerUrls = new ArrayList<URL>();
        this.markerUrls = new ArrayList<URL>();
        try {
            this.generateLinks(serverEntry, true);
        }
        catch (Exception ignored) {
            try {
                this.generateLinks(serverEntry, false);
            }
            catch (Exception e) {
                if (!updateTask.linkBrokenErrorWasShown) {
                    updateTask.linkBrokenErrorWasShown = true;
                    Utils.sendErrorToClientChat("[Remote Player Waypoints For Xaero's Map]: Error: Your Bluemap link is broken!");
                }
                throw e;
            }
        }
    }

    private void generateLinks(CommonModConfig.ServerEntry serverEntry, boolean useHttps) throws IOException {
        String baseURL = this.getBaseURL(serverEntry, useHttps);
        AbstractModInitializer.LOGGER.info("baseURL " + baseURL);
        for (String w : HTTP.makeJSONHTTPRequest((URL)URI.create((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001/settings.json?"}, (String)baseURL))).toURL(), BlueMapConfiguration.class).maps) {
            this.playerUrls.add(URI.create((baseURL + "/maps/" + w + "/live/players.json?").replace(" ", "%20")).toURL());
            this.markerUrls.add(URI.create((baseURL + "/maps/" + w + "/live/markers.json?").replace(" ", "%20")).toURL());
            this.worlds.add(w);
        }
        this.onlineMapConfigLink = baseURL + "/settings.json?";
        this.getPlayerPositions();
        for (URL url : this.playerUrls) {
            AbstractModInitializer.LOGGER.info("new link: " + String.valueOf(url));
            if (!CommonModConfig.Instance.debugMode()) continue;
            Utils.sendToClientChat("new link: " + String.valueOf(url));
        }
        for (URL url : this.markerUrls) {
            AbstractModInitializer.LOGGER.info("new link: " + String.valueOf(url));
            if (!CommonModConfig.Instance.debugMode()) continue;
            Utils.sendToClientChat("new link: " + String.valueOf(url));
        }
    }

    @Override
    public HashSet<String> getMarkerLayers() {
        Type apiResponseType = new TypeToken<Map<String, BlueMapMarkerSet>>(){}.getType();
        HashSet<String> layers = new HashSet<String>();
        for (URL url : this.markerUrls) {
            Map sets;
            try {
                sets = (Map)HTTP.makeJSONHTTPRequest(url, apiResponseType);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            for (Map.Entry m : sets.entrySet()) {
                layers.add((String)m.getKey());
            }
        }
        return layers;
    }

    @Override
    public HashMap<String, WaypointPosition> getWaypointPositions() throws IOException {
        URL reqUrl;
        Type apiResponseType = new TypeToken<Map<String, BlueMapMarkerSet>>(){}.getType();
        CommonModConfig.ServerEntry serverEntry = CommonModConfig.Instance.getCurrentServerEntry();
        if (serverEntry.markerVisibilityMode == CommonModConfig.ServerEntry.MarkerVisibilityMode.Auto) {
            CommonModConfig.Instance.setMarkerLayers(serverEntry.ip, new ArrayList<String>(this.getMarkerLayers()));
        }
        if ((reqUrl = AbstractModInitializer.overwriteCurrentDimension && !Objects.equals(this.currentDimension, "") ? this.markerUrls.get(this.worlds.indexOf(this.currentDimension)) : this.markerUrls.get(this.lastWorldIndex)) == this.lastURL) {
            return this.lastResult;
        }
        this.lastURL = reqUrl;
        Map markerSets = (Map)HTTP.makeJSONHTTPRequest(reqUrl, apiResponseType);
        HashMap<String, WaypointPosition> positions = new HashMap<String, WaypointPosition>();
        for (Map.Entry m : markerSets.entrySet()) {
            if (CommonModConfig.Instance.debugMode() && CommonModConfig.Instance.chatLogInDebugMode()) {
                Utils.sendToClientChat("====================================");
                Utils.sendToClientChat("markerSet: " + (String)m.getKey());
            }
            if (!serverEntry.includeMarkerLayer((String)m.getKey())) continue;
            for (BlueMapMarkerSet.Marker marker : ((BlueMapMarkerSet)m.getValue()).markers.values()) {
                if (!Objects.equals(marker.type, "poi") && !Objects.equals(marker.type, "html")) continue;
                BlueMapMarkerSet.Position pos = marker.position;
                WaypointPosition newWaypointPosition = new WaypointPosition(marker.label, Math.round(pos.x), Math.round(pos.y), Math.round(pos.z));
                positions.put(newWaypointPosition.name, newWaypointPosition);
            }
        }
        this.lastResult = positions;
        return positions;
    }

    @Override
    public HashMap<String, PlayerPosition> getPlayerPositions() throws IOException {
        String clientName = this.mc.player.getName().getString();
        boolean correctWorld = false;
        BlueMapPlayerUpdate update = null;
        if (AbstractModInitializer.overwriteCurrentDimension && !Objects.equals(this.currentDimension, "")) {
            update = HTTP.makeJSONHTTPRequest(this.playerUrls.get(this.worlds.indexOf(this.currentDimension)), BlueMapPlayerUpdate.class);
        } else {
            try {
                update = HTTP.makeJSONHTTPRequest(this.playerUrls.get(this.lastWorldIndex), BlueMapPlayerUpdate.class);
                for (BlueMapPlayerUpdate.Player p : update.players) {
                    if (!Objects.equals(p.name, clientName)) continue;
                    correctWorld = !p.foreign;
                    break;
                }
            }
            catch (Exception ignored) {
                if (CommonModConfig.Instance.debugMode()) {
                    Utils.sendToClientChat("removed broken link: " + String.valueOf(this.playerUrls.get(this.lastWorldIndex)));
                }
                this.playerUrls.remove(this.lastWorldIndex);
                this.markerUrls.remove(this.lastWorldIndex);
                this.worlds.remove(this.lastWorldIndex);
            }
            if (!correctWorld) {
                for (int i = 0; i < this.playerUrls.size(); ++i) {
                    try {
                        update = HTTP.makeJSONHTTPRequest(this.playerUrls.get(i), BlueMapPlayerUpdate.class);
                        for (BlueMapPlayerUpdate.Player p : update.players) {
                            if (!Objects.equals(p.name, clientName)) continue;
                            correctWorld = !p.foreign;
                            break;
                        }
                    }
                    catch (Exception ignored) {
                        if (CommonModConfig.Instance.debugMode()) {
                            Utils.sendToClientChat("removed broken link: " + String.valueOf(this.playerUrls.get(i)));
                        }
                        this.playerUrls.remove(i);
                        this.markerUrls.remove(i);
                        this.worlds.remove(i);
                    }
                    if (!correctWorld) continue;
                    this.lastWorldIndex = i;
                    break;
                }
            }
        }
        if (update == null || this.playerUrls.isEmpty()) {
            throw new IllegalStateException("Can't get player positions. All Bluemap links are broken!");
        }
        PlayerPosition[] positions = new PlayerPosition[update.players.length];
        if (correctWorld) {
            for (i = 0; i < update.players.length; ++i) {
                BlueMapPlayerUpdate.Player player = update.players[i];
                positions[i] = new PlayerPosition(player.name, Math.round(player.position.x), Math.round(player.position.y), Math.round(player.position.z), player.foreign ? "foreign" : "thisWorld");
            }
        } else {
            for (i = 0; i < update.players.length; ++i) {
                BlueMapPlayerUpdate.Player player = update.players[i];
                positions[i] = new PlayerPosition(player.name, Math.round(player.position.x), Math.round(player.position.y), Math.round(player.position.z), "unknown");
            }
        }
        return this.HandlePlayerPositions(positions);
    }
}

