/*
 * Decompiled with CFR 0.152.
 */
package de.the_build_craft.remote_player_waypoints_for_xaero.common.connections;

import de.the_build_craft.remote_player_waypoints_for_xaero.common.AbstractModInitializer;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.CommonModConfig;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.PlayerPosition;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.WaypointPosition;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.wrappers.Text;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.wrappers.Utils;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;

public abstract class MapConnection {
    public URL queryURL;
    public final Minecraft mc = Minecraft.getInstance();
    public String currentDimension;
    public String onlineMapConfigLink;
    long lastUpdateTimeMs = System.currentTimeMillis();
    public boolean foundPlayer;

    @NotNull
    protected String getBaseURL(CommonModConfig.ServerEntry serverEntry, boolean useHttps) {
        int i;
        Object baseURL = serverEntry.link;
        if (!((String)baseURL).startsWith(useHttps ? "https://" : "http://")) {
            baseURL = (useHttps ? "https://" : "http://") + (String)baseURL;
        }
        if ((i = ((String)baseURL).indexOf("?")) != -1) {
            baseURL = ((String)baseURL).substring(0, i - 1);
        }
        if ((i = ((String)baseURL).indexOf("#")) != -1) {
            baseURL = ((String)baseURL).substring(0, i - 1);
        }
        if (((String)baseURL).endsWith("index.html")) {
            baseURL = ((String)baseURL).substring(0, ((String)baseURL).length() - 10);
        }
        if (((String)baseURL).endsWith("/")) {
            baseURL = ((String)baseURL).substring(0, ((String)baseURL).length() - 1);
        }
        return ((String)baseURL).replace(" ", "%20");
    }

    public abstract HashMap<String, PlayerPosition> getPlayerPositions() throws IOException;

    public HashMap<String, PlayerPosition> HandlePlayerPositions(PlayerPosition[] playerPositions) {
        HashMap<String, PlayerPosition> newPlayerPositions = new HashMap<String, PlayerPosition>();
        if (this.mc.player == null) {
            return newPlayerPositions;
        }
        String clientName = this.mc.player.getName().getString();
        this.foundPlayer = false;
        if (!AbstractModInitializer.overwriteCurrentDimension) {
            this.currentDimension = "";
            for (PlayerPosition p : playerPositions) {
                if (!Objects.equals(p.player, clientName)) continue;
                this.currentDimension = p.world;
                this.foundPlayer = true;
            }
        }
        if (CommonModConfig.Instance.debugMode() && CommonModConfig.Instance.chatLogInDebugMode()) {
            Utils.sendToClientChat("---");
        }
        for (PlayerPosition p : playerPositions) {
            this.UpdateAfkInfo(p);
            if (!CommonModConfig.Instance.debugMode() && (!Objects.equals(p.world, this.currentDimension) || Objects.equals(p.player, clientName))) continue;
            newPlayerPositions.put(p.player, p);
        }
        this.lastUpdateTimeMs = System.currentTimeMillis();
        return newPlayerPositions;
    }

    public void UpdateAfkInfo(PlayerPosition playerPosition) {
        if (AbstractModInitializer.lastPlayerDataDic.containsKey(playerPosition.player)) {
            if (AbstractModInitializer.lastPlayerDataDic.get(playerPosition.player).CompareCords(playerPosition)) {
                if (AbstractModInitializer.AfkTimeDic.containsKey(playerPosition.player)) {
                    AbstractModInitializer.AfkTimeDic.put(playerPosition.player, AbstractModInitializer.AfkTimeDic.get(playerPosition.player) + (System.currentTimeMillis() - this.lastUpdateTimeMs));
                } else {
                    AbstractModInitializer.AfkTimeDic.put(playerPosition.player, System.currentTimeMillis() - this.lastUpdateTimeMs);
                }
                if (CommonModConfig.Instance.debugMode() && CommonModConfig.Instance.chatLogInDebugMode()) {
                    Utils.sendToClientChat(playerPosition.player + "  afk_time: " + AbstractModInitializer.AfkTimeDic.get(playerPosition.player) / 1000L);
                }
                if (AbstractModInitializer.AfkTimeDic.get(playerPosition.player) / 1000L >= (long)CommonModConfig.Instance.timeUntilAfk()) {
                    AbstractModInitializer.AfkDic.put(playerPosition.player, true);
                }
            } else {
                AbstractModInitializer.AfkTimeDic.put(playerPosition.player, 0L);
                AbstractModInitializer.AfkDic.put(playerPosition.player, false);
            }
        }
        AbstractModInitializer.lastPlayerDataDic.put(playerPosition.player, playerPosition);
    }

    public abstract HashMap<String, WaypointPosition> getWaypointPositions() throws IOException;

    public void OpenOnlineMapConfig() {
        Utils.sendToClientChat((Component)Text.literal(this.onlineMapConfigLink).withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, this.onlineMapConfigLink))));
    }

    public abstract HashSet<String> getMarkerLayers();
}

