/*
 * Decompiled with CFR 0.152.
 */
package de.the_build_craft.remote_player_waypoints_for_xaero.mixins.common.client;

import de.the_build_craft.remote_player_waypoints_for_xaero.common.AbstractModInitializer;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.wrappers.Text;
import net.minecraft.client.gui.components.PlayerTabOverlay;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerTabOverlay.class})
public class PlayerListHudMixin {
    @Unique
    private static String formatDuration(long durationInMs) {
        int durationInMin = (int)(durationInMs / 60000L);
        int hours = (int)Math.floor((double)durationInMin / 60.0);
        int minutes = durationInMin % 60;
        if (hours == 0) {
            return minutes + " min";
        }
        if (AbstractModInitializer.hideAfkMinutes) {
            return hours + " h";
        }
        return hours + " h  " + minutes + " min";
    }

    @Inject(method={"getNameForDisplay(Lnet/minecraft/client/multiplayer/PlayerInfo;)Lnet/minecraft/network/chat/Component;"}, at={@At(value="RETURN")}, cancellable=true)
    private void injected(PlayerInfo entry, CallbackInfoReturnable<Component> cir) {
        String playerNameString = entry.getProfile().getName();
        Component newText = entry.getTabListDisplayName() == null ? ((PlayerTabOverlay)this).decorateName(entry, PlayerTeam.formatNameForTeam((Team)entry.getTeam(), (Component)Text.literal(playerNameString))) : ((PlayerTabOverlay)this).decorateName(entry, entry.getTabListDisplayName().copy());
        if (!(AbstractModInitializer.enabled && AbstractModInitializer.connected && AbstractModInitializer.showAfkInTabList)) {
            cir.setReturnValue((Object)newText);
            return;
        }
        if (AbstractModInitializer.AfkDic.containsKey(playerNameString)) {
            if (AbstractModInitializer.AfkDic.get(playerNameString).booleanValue()) {
                if (AbstractModInitializer.showAfkTimeInTabList) {
                    cir.setReturnValue((Object)newText.copy().append((Component)Text.literal("  [AFK: " + PlayerListHudMixin.formatDuration(AbstractModInitializer.AfkTimeDic.get(playerNameString)) + "]").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)AbstractModInitializer.AfkColor)))));
                } else {
                    cir.setReturnValue((Object)newText.copy().append((Component)Text.literal("  [AFK]").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)AbstractModInitializer.AfkColor)))));
                }
                return;
            }
        } else {
            cir.setReturnValue((Object)newText.copy().append((Component)Text.literal("  [???]").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)AbstractModInitializer.unknownAfkStateColor)))));
            return;
        }
        cir.setReturnValue((Object)newText);
    }
}

