/*
 * Decompiled with CFR 0.152.
 */
package de.the_build_craft.remote_player_waypoints_for_xaero.mixins.neoforge.mods.xaerominimap;

import de.the_build_craft.remote_player_waypoints_for_xaero.common.AbstractModInitializer;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.CommonModConfig;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.PlayerPosition;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.UpdateTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import xaero.hud.minimap.radar.state.RadarStateUpdater;

@Pseudo
@Mixin(value={RadarStateUpdater.class})
public class MinimapRadarMixin {
    @ModifyVariable(method={"update(Lnet/minecraft/client/multiplayer/ClientLevel;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/entity/player/Player;)V"}, at=@At(value="STORE"), ordinal=0)
    private Iterable<Entity> updateRadarEntities(Iterable<Entity> worldEntities) {
        if (!CommonModConfig.Instance.enableEntityRadar()) {
            return worldEntities;
        }
        if (UpdateTask.playerPositions == null || UpdateTask.playerPositions.isEmpty()) {
            return worldEntities;
        }
        if (Minecraft.getInstance().level == null) {
            return worldEntities;
        }
        if (Minecraft.getInstance().cameraEntity == null) {
            return worldEntities;
        }
        List playerClientEntityList = Minecraft.getInstance().level.players();
        ArrayList<String> renderedPlayerNames = new ArrayList<String>();
        for (AbstractClientPlayer playerClientEntity : playerClientEntityList) {
            renderedPlayerNames.add(playerClientEntity.getName().plainCopy().getString());
        }
        Vec3 camPosition = Minecraft.getInstance().cameraEntity.position();
        if (!AbstractModInitializer.fakePlayerEntities.containsKey(Minecraft.getInstance().level)) {
            HashMap temp = new HashMap();
            AbstractModInitializer.fakePlayerEntities.put(Minecraft.getInstance().level, temp);
        }
        ArrayList<RemotePlayer> playerEntities = new ArrayList<RemotePlayer>(UpdateTask.playerPositions.size());
        for (PlayerPosition playerPosition : UpdateTask.playerPositions.values()) {
            RemotePlayer playerEntity;
            if (playerPosition == null || playerPosition.gameProfile == null || renderedPlayerNames.contains(playerPosition.player)) continue;
            boolean isFriend = CommonModConfig.Instance.friendList().contains(playerPosition.player);
            if (CommonModConfig.Instance.onlyShowFriendsIcons() && !isFriend) continue;
            int maxIconDistance = CommonModConfig.Instance.overwriteFriendDistances() && isFriend ? CommonModConfig.Instance.maxFriendIconDistance() : CommonModConfig.Instance.maxIconDistance();
            double d = camPosition.distanceTo(new Vec3((double)playerPosition.x, (double)playerPosition.y, (double)playerPosition.z));
            if (d > (double)maxIconDistance) continue;
            if (AbstractModInitializer.fakePlayerEntities.get(Minecraft.getInstance().level).containsKey(playerPosition.player)) {
                playerEntity = AbstractModInitializer.fakePlayerEntities.get(Minecraft.getInstance().level).get(playerPosition.player);
            } else {
                playerEntity = new RemotePlayer(Minecraft.getInstance().level, playerPosition.gameProfile);
                AbstractModInitializer.fakePlayerEntities.get(Minecraft.getInstance().level).put(playerPosition.player, playerEntity);
            }
            playerEntity.moveTo((double)playerPosition.x, (double)playerPosition.y, (double)playerPosition.z, 0.0f, 0.0f);
            playerEntities.add(playerEntity);
        }
        ArrayList<Entity> worldEntitiesList = new ArrayList<Entity>();
        worldEntities.forEach(worldEntitiesList::add);
        worldEntitiesList.addAll(playerEntities);
        return worldEntitiesList;
    }
}

