/*
 * Decompiled with CFR 0.152.
 */
package de.the_build_craft.maplink.common;

import de.the_build_craft.maplink.common.AbstractModInitializer;
import de.the_build_craft.maplink.common.CommonModConfig;
import de.the_build_craft.maplink.common.FastUpdateTask;
import de.the_build_craft.maplink.common.LoaderType;
import de.the_build_craft.maplink.common.MainThreadTaskQueue;
import de.the_build_craft.maplink.common.ModConfig;
import de.the_build_craft.maplink.common.clientMapHandlers.ClientMapHandler;
import de.the_build_craft.maplink.common.connections.BlueMapConnection;
import de.the_build_craft.maplink.common.connections.DynmapConnection;
import de.the_build_craft.maplink.common.connections.LiveAtlasConnection;
import de.the_build_craft.maplink.common.connections.Pl3xMapConnection;
import de.the_build_craft.maplink.common.connections.SquareMapConnection;
import de.the_build_craft.maplink.common.wrappers.Text;
import de.the_build_craft.maplink.common.wrappers.Utils;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;

public class UpdateTask {
    private final class_310 mc = class_310.method_1551();
    private boolean connectionErrorWasShown = false;
    private boolean cantFindServerErrorWasShown = false;
    private boolean cantGetPlayerPositionsErrorWasShown = false;
    private boolean cantGetMarkerPositionsErrorWasShown = false;
    public boolean linkBrokenErrorWasShown = false;
    private String currentServerIP = "";
    public static int nextUpdateDelay = 1000;
    private static final Object resetLock = new Object();

    public void run() {
        try {
            this.runUpdate();
        }
        catch (Exception e) {
            AbstractModInitializer.LOGGER.error("Error in slow Update Task", (Throwable)e);
        }
        try {
            AbstractModInitializer.setUpdateDelay(nextUpdateDelay);
        }
        catch (Exception e) {
            AbstractModInitializer.LOGGER.error("Error updating update-delay!", (Throwable)e);
        }
    }

    private void runUpdate() {
        block25: {
            if (this.mc.field_1687 == null || this.mc.field_1724 == null || this.mc.field_1719 == null || this.mc.method_1576() != null && !this.mc.method_1576().method_3860() || this.mc.method_1558() == null || this.mc.method_1562() == null || !this.mc.method_1562().method_48296().method_10758()) {
                this.Reset();
                return;
            }
            if (!CommonModConfig.config.general.enabled) {
                this.Reset();
                return;
            }
            String serverIP = this.mc.method_1558().field_3761.toLowerCase(Locale.ROOT);
            if (!Objects.equals(this.currentServerIP, serverIP)) {
                this.currentServerIP = serverIP;
                this.Reset();
                AbstractModInitializer.LOGGER.info("Server ip has changed!");
            }
            if (AbstractModInitializer.getConnection() == null) {
                nextUpdateDelay = 1000;
                try {
                    ModConfig.ServerEntry serverEntry = CommonModConfig.getCurrentServerEntry();
                    if (Objects.equals(serverEntry, null)) {
                        if (!CommonModConfig.config.general.ignoredServers.contains(serverIP) && !this.cantFindServerErrorWasShown) {
                            String message = "[Map Link]: Could not find a web map link for this server. Make sure to add it to the config. (this server ip was detected: " + serverIP + ") ";
                            if (AbstractModInitializer.INSTANCE.loaderType == LoaderType.Fabric || AbstractModInitializer.INSTANCE.loaderType == LoaderType.Quilt) {
                                Utils.sendToClientChat((class_2561)Text.literal(message).method_10862(class_2583.field_24360.method_10977(class_124.field_1065)).method_10852((class_2561)Text.literal("[ignore this server]").method_10862(class_2583.field_24360.method_10977(class_124.field_1060).method_10982(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11750, "/maplink ignore_server")))));
                            } else {
                                Utils.sendToClientChat((class_2561)Text.literal(message).method_10862(class_2583.field_24360.method_10977(class_124.field_1065)).method_10852((class_2561)Text.literal("[ignore this server]").method_10862(class_2583.field_24360.method_10977(class_124.field_1060).method_10982(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11745, "/maplink ignore_server")))));
                            }
                            this.cantFindServerErrorWasShown = true;
                        }
                        AbstractModInitializer.connected = false;
                        return;
                    }
                    if (Objects.requireNonNull(serverEntry.maptype) == ModConfig.ServerEntry.MapType.Dynmap) {
                        AbstractModInitializer.setConnection(new DynmapConnection(serverEntry, this));
                        break block25;
                    }
                    if (serverEntry.maptype == ModConfig.ServerEntry.MapType.Squaremap) {
                        AbstractModInitializer.setConnection(new SquareMapConnection(serverEntry, this));
                        break block25;
                    }
                    if (serverEntry.maptype == ModConfig.ServerEntry.MapType.Bluemap) {
                        AbstractModInitializer.setConnection(new BlueMapConnection(serverEntry, this));
                        break block25;
                    }
                    if (serverEntry.maptype == ModConfig.ServerEntry.MapType.Pl3xMap) {
                        AbstractModInitializer.setConnection(new Pl3xMapConnection(serverEntry, this));
                        break block25;
                    }
                    if (serverEntry.maptype == ModConfig.ServerEntry.MapType.LiveAtlas) {
                        AbstractModInitializer.setConnection(new LiveAtlasConnection(serverEntry, this));
                        break block25;
                    }
                    throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)serverEntry.maptype));
                }
                catch (Exception e) {
                    if (!this.connectionErrorWasShown) {
                        this.connectionErrorWasShown = true;
                        Utils.sendErrorToClientChat("[Map Link]: Error while connecting to the web map. Please check you config or report a bug.");
                        AbstractModInitializer.LOGGER.error("Error while connecting to the web map.", (Throwable)e);
                    }
                    AbstractModInitializer.connected = false;
                    nextUpdateDelay = 1000;
                    return;
                }
            }
        }
        try {
            FastUpdateTask.getInstance().updateFromOnlineMap(AbstractModInitializer.getConnection().getPlayerPositions());
        }
        catch (Exception e) {
            if (!this.cantGetPlayerPositionsErrorWasShown) {
                this.cantGetPlayerPositionsErrorWasShown = true;
                Utils.sendErrorToClientChat("[Map Link]: Failed to make web map request (for player waypoints). Please check your config (maybe your link...) or report a bug.");
            }
            AbstractModInitializer.LOGGER.error("Failed to get player positions from the web map.", (Throwable)e);
            AbstractModInitializer.setConnection(null);
            return;
        }
        if (CommonModConfig.config.general.enableMarkerWaypoints || CommonModConfig.config.general.enableAreaMarkerOverlay) {
            try {
                AbstractModInitializer.getConnection().getWaypointPositions(false);
            }
            catch (Exception e) {
                if (!this.cantGetMarkerPositionsErrorWasShown) {
                    this.cantGetMarkerPositionsErrorWasShown = true;
                    Utils.sendErrorToClientChat("[Map Link]: Failed to make web map request (for marker waypoints). Please check your config (maybe your link...) or report a bug.");
                }
                AbstractModInitializer.LOGGER.error("Failed to get marker positions from the web map.", (Throwable)e);
            }
        } else if (ClientMapHandler.getInstance() != null) {
            ClientMapHandler.getInstance().removeAllMarkerWaypoints();
            ClientMapHandler.getInstance().removeAllAreaMarkers(true);
        }
        AbstractModInitializer.connected = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Reset() {
        Object object = resetLock;
        synchronized (object) {
            MainThreadTaskQueue.clearQueue();
            AbstractModInitializer.setConnection(null);
            ClientMapHandler.clearRegisteredPositions();
            FastUpdateTask.getInstance().clearAllPlayerPositions();
            if (ClientMapHandler.getInstance() != null) {
                ClientMapHandler.getInstance().reset();
            }
            this.connectionErrorWasShown = false;
            this.cantFindServerErrorWasShown = false;
            this.cantGetPlayerPositionsErrorWasShown = false;
            this.cantGetMarkerPositionsErrorWasShown = false;
            this.linkBrokenErrorWasShown = false;
            nextUpdateDelay = 1000;
        }
    }
}

