/*
 * Decompiled with CFR 0.152.
 */
package de.the_build_craft.maplink.common.connections;

import de.the_build_craft.maplink.common.AbstractModInitializer;
import de.the_build_craft.maplink.common.CommonModConfig;
import de.the_build_craft.maplink.common.HTTP;
import de.the_build_craft.maplink.common.ModConfig;
import de.the_build_craft.maplink.common.UpdateTask;
import de.the_build_craft.maplink.common.clientMapHandlers.ClientMapHandler;
import de.the_build_craft.maplink.common.configurations.DynmapConfiguration;
import de.the_build_craft.maplink.common.connections.MapConnection;
import de.the_build_craft.maplink.common.mapUpdates.DynmapMarkerUpdate;
import de.the_build_craft.maplink.common.mapUpdates.DynmapPlayerUpdate;
import de.the_build_craft.maplink.common.waypoints.AreaMarker;
import de.the_build_craft.maplink.common.waypoints.Color;
import de.the_build_craft.maplink.common.waypoints.Double3;
import de.the_build_craft.maplink.common.waypoints.MarkerLayer;
import de.the_build_craft.maplink.common.waypoints.PlayerPosition;
import de.the_build_craft.maplink.common.waypoints.Position;
import de.the_build_craft.maplink.common.wrappers.Utils;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DynmapConnection
extends MapConnection {
    private String markerStringTemplate = "";
    public String firstWorldName = "";
    public String[] worldNames = new String[0];
    String lastMarkerDimension = "";
    int lastMarkerHash;
    int lastAreaMarkerHash;
    List<Position> positions = new ArrayList<Position>();
    List<AreaMarker> areaMarkers = new ArrayList<AreaMarker>();

    public DynmapConnection(ModConfig.ServerEntry serverEntry, UpdateTask updateTask) throws IOException {
        try {
            this.generateLink(serverEntry, true);
        }
        catch (Exception ignored) {
            try {
                this.generateLink(serverEntry, false);
            }
            catch (Exception e) {
                if (!updateTask.linkBrokenErrorWasShown) {
                    updateTask.linkBrokenErrorWasShown = true;
                    Utils.sendErrorToClientChat("[Map Link]: Error: Your Dynmap link is broken!");
                }
                throw e;
            }
        }
    }

    public DynmapConnection(String baseURL, String config, boolean partOfLifeAtlas) throws IOException {
        this.generateLinkWithConfig(baseURL, config);
        this.partOfLiveAtlas = partOfLifeAtlas;
    }

    private void generateLink(ModConfig.ServerEntry serverEntry, boolean useHttps) throws IOException {
        block10: {
            String baseURL = this.getBaseURL(serverEntry, useHttps);
            try {
                this.queryURL = URI.create(serverEntry.link.replace(" ", "%20")).toURL();
                this.getPlayerPositions();
                if (CommonModConfig.config.general.debugMode) {
                    Utils.sendToClientChat("got link with method 1 | overwrite mode active!");
                }
            }
            catch (Exception a) {
                try {
                    String mapConfig = HTTP.makeTextHttpRequest(URI.create(baseURL + "/standalone/config.js").toURL());
                    this.generateLinkWithConfig(baseURL, mapConfig);
                    if (CommonModConfig.config.general.debugMode) {
                        Utils.sendToClientChat("got link with method 2 | that is good!");
                    }
                }
                catch (Exception b) {
                    try {
                        this.onlineMapConfigLink = baseURL + "/up/configuration";
                        this.setWorldNames();
                        this.queryURL = URI.create(baseURL + "/up/world/" + this.firstWorldName + "/").toURL();
                        this.markerStringTemplate = baseURL + "/tiles/_markers_/marker_{world}.json";
                        this.getPlayerPositions();
                        if (CommonModConfig.config.general.debugMode) {
                            Utils.sendErrorToClientChat("got link with method 3 instead of 2 | please report this on github!");
                        }
                    }
                    catch (Exception ignored) {
                        this.onlineMapConfigLink = baseURL + "/standalone/dynmap_config.json?";
                        this.setWorldNames();
                        this.queryURL = URI.create(baseURL + "/standalone/world/" + this.firstWorldName + ".json?").toURL();
                        this.markerStringTemplate = baseURL + "/tiles/_markers_/marker_{world}.json";
                        this.getPlayerPositions();
                        if (!CommonModConfig.config.general.debugMode) break block10;
                        Utils.sendErrorToClientChat("got link with method 4 instead of 2 | please report this on github!");
                    }
                }
            }
        }
        AbstractModInitializer.LOGGER.info("new link: " + String.valueOf(this.queryURL));
        if (CommonModConfig.config.general.debugMode) {
            Utils.sendToClientChat("new link: " + String.valueOf(this.queryURL));
        }
    }

    public void generateLinkWithConfig(String baseURL, String mapConfig) throws IOException {
        Matcher matcher = Pattern.compile(".*?//\\w*(\\.\\w+)+(:\\w+)?").matcher(baseURL);
        if (!matcher.find()) {
            throw new RuntimeException("wrong url pattern");
        }
        baseURL = matcher.group();
        int i = mapConfig.indexOf("configuration: ");
        int j = mapConfig.indexOf(",", i);
        AbstractModInitializer.LOGGER.info("mapConfig: " + mapConfig);
        Object substring = mapConfig.substring(i + 16, j - 1);
        if (((String)substring).contains("?")) {
            int k = ((String)substring).indexOf("?");
            substring = ((String)substring).substring(0, k);
        }
        if (((String)substring).contains("//")) {
            this.onlineMapConfigLink = ((String)substring).replace(" ", "%20");
        } else {
            if (!((String)substring).startsWith("/")) {
                substring = "/" + (String)substring;
            }
            this.onlineMapConfigLink = (baseURL + (String)substring).replace(" ", "%20");
        }
        AbstractModInitializer.LOGGER.info("configuration link: " + this.onlineMapConfigLink);
        this.setWorldNames();
        AbstractModInitializer.LOGGER.info("firstWorldName: " + this.firstWorldName);
        i = mapConfig.indexOf("update: ");
        j = mapConfig.indexOf(",", i);
        Object updateStringTemplate = mapConfig.substring(i + 9, j - 1).replace("{timestamp}", "1");
        AbstractModInitializer.LOGGER.info("updateStringTemplate: " + (String)updateStringTemplate);
        if (((String)updateStringTemplate).contains("//")) {
            this.queryURL = URI.create(((String)updateStringTemplate).replace("{world}", this.firstWorldName)).toURL();
        } else {
            if (!((String)updateStringTemplate).startsWith("/")) {
                updateStringTemplate = "/" + (String)updateStringTemplate;
            }
            this.queryURL = URI.create(baseURL + ((String)updateStringTemplate).replace("{world}", this.firstWorldName)).toURL();
        }
        AbstractModInitializer.LOGGER.info("url: " + String.valueOf(this.queryURL));
        i = mapConfig.indexOf("markers: ");
        int l = "markers: ".length() + 1;
        j = mapConfig.indexOf("'", i + l + 1);
        Object markerSubstring = mapConfig.substring(i + l, j);
        if (((String)markerSubstring).contains("//")) {
            this.markerStringTemplate = (String)markerSubstring + "_markers_/marker_{world}.json";
        } else {
            if (!((String)markerSubstring).startsWith("/")) {
                markerSubstring = "/" + (String)markerSubstring;
            }
            this.markerStringTemplate = baseURL + (String)markerSubstring + "_markers_/marker_{world}.json";
        }
        AbstractModInitializer.LOGGER.info("markerStringTemplate: " + this.markerStringTemplate);
        this.getPlayerPositions();
    }

    private void setWorldNames() throws IOException {
        DynmapConfiguration dynmapConfiguration = HTTP.makeJSONHTTPRequest(URI.create(this.onlineMapConfigLink).toURL(), DynmapConfiguration.class);
        DynmapConfiguration.World[] worlds = dynmapConfiguration.worlds;
        this.worldNames = new String[worlds.length];
        int worldsLength = worlds.length;
        for (int k = 0; k < worldsLength; ++k) {
            this.worldNames[k] = worlds[k].name.replace(" ", "%20");
        }
        this.firstWorldName = this.worldNames[0];
        UpdateTask.nextUpdateDelay = Math.max(UpdateTask.nextUpdateDelay, (int)Math.ceil(dynmapConfiguration.updaterate));
    }

    @Override
    public HashMap<String, PlayerPosition> getPlayerPositions() throws IOException {
        DynmapPlayerUpdate update = HTTP.makeJSONHTTPRequest(this.queryURL, DynmapPlayerUpdate.class);
        PlayerPosition[] positions = new PlayerPosition[update.players.length];
        for (int i = 0; i < update.players.length; ++i) {
            PlayerPosition playerPosition;
            DynmapPlayerUpdate.Player player = update.players[i];
            positions[i] = playerPosition = new PlayerPosition(player.account, (int)Math.round(player.x), (int)Math.round(player.y), (int)Math.round(player.z), player.world);
            ClientMapHandler.registerPlayerPosition(playerPosition, this.markerStringTemplate.replace("_markers_/marker_{world}.json", "faces/32x32/" + player.account + ".png"));
        }
        return this.HandlePlayerPositions(positions);
    }

    public HashSet<String> getMarkerLayers() {
        HashSet<String> layers = new HashSet<String>();
        for (String world : this.worldNames) {
            DynmapMarkerUpdate u;
            try {
                u = HTTP.makeJSONHTTPRequest(URI.create(this.markerStringTemplate.replace("{world}", world).replace(" ", "%20")).toURL(), DynmapMarkerUpdate.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            layers.addAll(u.sets.keySet());
        }
        return layers;
    }

    @Override
    public void getWaypointPositions(boolean forceRefresh) throws IOException {
        ModConfig.ServerEntry serverEntry = CommonModConfig.getCurrentServerEntry();
        if (serverEntry.needsMarkerLayerUpdate() && !this.partOfLiveAtlas) {
            serverEntry.setMarkerLayers(new ArrayList<String>(this.getMarkerLayers()));
        }
        if (ClientMapHandler.getInstance() == null) {
            return;
        }
        String dimension = CommonModConfig.config.general.debugMode ? this.firstWorldName : this.currentDimension;
        if (AbstractModInitializer.overwriteCurrentDimension && !Objects.equals(this.currentDimension, "")) {
            dimension = this.currentDimension;
        }
        if (this.markerStringTemplate.isEmpty() || dimension.isEmpty()) {
            ClientMapHandler.getInstance().removeAllMarkerWaypoints();
            ClientMapHandler.getInstance().removeAllAreaMarkers(true);
            return;
        }
        int newMarkerHash = serverEntry.getMarkerVisibilityHash();
        int newAreaMarkerHash = serverEntry.getAreaMarkerVisibilityHash();
        if (this.lastMarkerDimension.equals(dimension) && newMarkerHash == this.lastMarkerHash && newAreaMarkerHash == this.lastAreaMarkerHash && !forceRefresh) {
            ClientMapHandler.getInstance().handleMarkerWaypoints(this.positions);
            return;
        }
        this.lastMarkerDimension = dimension;
        this.lastMarkerHash = newMarkerHash;
        this.lastAreaMarkerHash = newAreaMarkerHash;
        DynmapMarkerUpdate update = HTTP.makeJSONHTTPRequest(URI.create(this.markerStringTemplate.replace("{world}", dimension).replace(" ", "%20")).toURL(), DynmapMarkerUpdate.class);
        this.positions.clear();
        this.areaMarkers.clear();
        for (Map.Entry<String, DynmapMarkerUpdate.Set> set : update.sets.entrySet()) {
            if (serverEntry.includeMarkerLayer(set.getKey())) {
                for (Map.Entry<String, DynmapMarkerUpdate.Set.Marker> entry : set.getValue().markers.entrySet()) {
                    DynmapMarkerUpdate.Set.Marker m = entry.getValue();
                    if (!serverEntry.includeMarker(m.label)) continue;
                    Position position = new Position(m.label, m.x, m.y, m.z, dimension + set.getKey() + entry.getKey(), new MarkerLayer(set.getKey(), set.getValue().label));
                    this.positions.add(position);
                    ClientMapHandler.registerPosition(position, !CommonModConfig.config.general.showDefaultMarkerIcons && m.icon.equals("default") ? null : this.markerStringTemplate.replace("marker_{world}.json", m.icon + ".png"));
                }
            }
            if (!serverEntry.includeAreaMarkerLayer(set.getKey())) continue;
            for (Map.Entry<String, Object> entry : set.getValue().areas.entrySet()) {
                Double3[] points;
                DynmapMarkerUpdate.Set.Area a = (DynmapMarkerUpdate.Set.Area)entry.getValue();
                if (!serverEntry.includeAreaMarker(a.label) || a.x.length < 2 || a.z.length < 2 || a.x.length != a.z.length) continue;
                if (a.x.length > 2) {
                    points = new Double3[a.x.length];
                    for (int i = 0; i < a.x.length; ++i) {
                        points[i] = new Double3(a.x[i], 0.0, a.z[i]);
                    }
                } else {
                    points = new Double3[]{new Double3(a.x[0], 0.0, a.z[0]), new Double3(a.x[0], 0.0, a.z[1]), new Double3(a.x[1], 0.0, a.z[1]), new Double3(a.x[1], 0.0, a.z[0])};
                }
                this.areaMarkers.add(new AreaMarker(a.label, 0.0, 0.0, 0.0, points, new Color(a.color, a.opacity), new Color(a.fillcolor, a.fillopacity), dimension + set.getKey() + entry.getKey(), new MarkerLayer(set.getKey(), set.getValue().label)));
            }
            for (Map.Entry<String, Object> entry : set.getValue().circles.entrySet()) {
                DynmapMarkerUpdate.Set.Circle c = (DynmapMarkerUpdate.Set.Circle)entry.getValue();
                if (!serverEntry.includeAreaMarker(c.label)) continue;
                this.areaMarkers.add(new AreaMarker(c.label, (double)c.x, (double)c.y, (double)c.z, this.convertEllipseToPolygon(c), new Color(c.color, c.opacity), new Color(c.fillcolor, c.fillopacity), dimension + set.getKey() + entry.getKey(), new MarkerLayer(set.getKey(), set.getValue().label)));
            }
        }
        ClientMapHandler.getInstance().handleMarkerWaypoints(this.positions);
        ClientMapHandler.getInstance().handleAreaMarkers(this.areaMarkers);
    }

    Double3[] convertEllipseToPolygon(DynmapMarkerUpdate.Set.Circle circle) {
        int N = 40;
        Double3[] points = new Double3[N];
        for (int i = 0; i < N; ++i) {
            double a = Math.PI * 2 / (double)N * (double)i;
            points[i] = new Double3((double)circle.x + (double)circle.xr * Math.sin(a), circle.y, (double)circle.z + (double)circle.zr * Math.cos(a));
        }
        return points;
    }
}

