/*
 * Decompiled with CFR 0.152.
 */
package de.the_build_craft.maplink.common;

import de.the_build_craft.maplink.common.AbstractModInitializer;
import de.the_build_craft.maplink.common.CommonModConfig;
import de.the_build_craft.maplink.common.clientMapHandlers.ClientMapHandler;
import de.the_build_craft.maplink.common.waypoints.Double3;
import de.the_build_craft.maplink.common.waypoints.PlayerPosition;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_310;
import net.minecraft.class_742;
import net.minecraft.class_745;

public class FastUpdateTask {
    private final class_310 mc;
    public static final Map<String, PlayerPosition> playerPositions = new ConcurrentHashMap<String, PlayerPosition>();
    private final Map<String, PlayerPosition> onlinePlayerPositions = new ConcurrentHashMap<String, PlayerPosition>();
    private Set<String> currentLocalPlayerNames = new HashSet<String>();
    private final Map<String, Integer> skipOnlineUpdates = new ConcurrentHashMap<String, Integer>();
    private final Map<String, Double3> lastLocalVector = new ConcurrentHashMap<String, Double3>();
    private final Map<String, PlayerPosition> lastLocalPosition = new HashMap<String, PlayerPosition>();
    private static FastUpdateTask instance;

    public FastUpdateTask() {
        this.mc = class_310.method_1551();
        instance = this;
    }

    public void run() {
        try {
            this.runUpdate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runUpdate() {
        if (!AbstractModInitializer.checkIfInGame() || !CommonModConfig.config.general.enabled || ClientMapHandler.getInstance() == null) {
            return;
        }
        playerPositions.clear();
        if (!AbstractModInitializer.connected) {
            ClientMapHandler.getInstance().handlePlayerWaypoints();
            return;
        }
        Set<String> prevLocalPlayerNames = this.currentLocalPlayerNames;
        this.currentLocalPlayerNames = new HashSet<String>(prevLocalPlayerNames.size());
        Map<String, PlayerPosition> map = this.onlinePlayerPositions;
        synchronized (map) {
            playerPositions.putAll(this.onlinePlayerPositions);
            for (class_742 player : this.mc.field_1687.method_18456()) {
                String name = player.method_7334().getName();
                if (!(player instanceof class_745) || !this.onlinePlayerPositions.containsKey(name)) continue;
                this.updateFromLocalPosition(new PlayerPosition(player));
            }
            for (String playerName : prevLocalPlayerNames) {
                if (this.currentLocalPlayerNames.contains(playerName)) continue;
                this.skipOnlineUpdates.put(playerName, 2);
            }
        }
        ClientMapHandler.getInstance().handlePlayerWaypoints();
    }

    private void updateFromLocalPosition(PlayerPosition playerPosition) {
        ClientMapHandler.registerTempPlayerPosition(playerPosition);
        Double3 lastPos = this.lastLocalPosition.getOrDefault((Object)playerPosition.name, (PlayerPosition)playerPosition).pos;
        if (!lastPos.roughlyEqual(playerPosition.pos)) {
            this.lastLocalVector.put(playerPosition.name, playerPosition.pos.sub(lastPos));
        }
        this.lastLocalPosition.put(playerPosition.name, playerPosition);
        playerPositions.put(playerPosition.name, playerPosition);
        this.currentLocalPlayerNames.add(playerPosition.name);
        this.skipOnlineUpdates.remove(playerPosition.name);
        this.onlinePlayerPositions.put(playerPosition.name, playerPosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFromOnlineMap(HashMap<String, PlayerPosition> onlinePlayerPositions) {
        Map<String, PlayerPosition> map = this.onlinePlayerPositions;
        synchronized (map) {
            for (PlayerPosition playerPosition : onlinePlayerPositions.values()) {
                if (this.skipOnlineUpdates.containsKey(playerPosition.name)) {
                    double dot = playerPosition.pos.sub(this.lastLocalPosition.get((Object)playerPosition.name).pos).dot(this.lastLocalVector.getOrDefault(playerPosition.name, Double3.ZERO));
                    if (dot >= 0.0) {
                        this.skipOnlineUpdates.remove(playerPosition.name);
                        this.onlinePlayerPositions.put(playerPosition.name, playerPosition);
                        continue;
                    }
                    int skipCount = this.skipOnlineUpdates.get(playerPosition.name);
                    if (skipCount <= 0) {
                        this.skipOnlineUpdates.remove(playerPosition.name);
                        this.onlinePlayerPositions.put(playerPosition.name, playerPosition);
                        continue;
                    }
                    this.skipOnlineUpdates.put(playerPosition.name, skipCount - 1);
                    continue;
                }
                this.onlinePlayerPositions.put(playerPosition.name, playerPosition);
            }
            this.onlinePlayerPositions.entrySet().removeIf(e -> !onlinePlayerPositions.containsKey(e.getKey()));
            this.skipOnlineUpdates.entrySet().removeIf(e -> !onlinePlayerPositions.containsKey(e.getKey()));
        }
    }

    public void clearAllPlayerPositions() {
        playerPositions.clear();
        this.onlinePlayerPositions.clear();
    }

    public static FastUpdateTask getInstance() {
        return instance;
    }
}

