/*
 * Decompiled with CFR 0.152.
 */
package de.the_build_craft.maplink.common.waypoints;

import java.util.List;
import java.util.Objects;
import net.minecraft.class_3532;

public class Color {
    public final int r;
    public final int g;
    public final int b;
    public final float a;

    public Color() {
        this(0, 0, 0, 0.0f);
    }

    public Color(int r, int g, int b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public Color(String hex, float a) {
        if (hex == null) {
            hex = "000000";
        }
        hex = hex.replace("#", "");
        this.r = Integer.parseInt(hex.substring(0, 2), 16);
        this.g = Integer.parseInt(hex.substring(2, 4), 16);
        this.b = Integer.parseInt(hex.substring(4, 6), 16);
        this.a = a;
    }

    public Color(int argb) {
        this.a = (float)(argb >>> 24 & 0xFF) / 255.0f;
        this.r = argb >>> 16 & 0xFF;
        this.g = argb >>> 8 & 0xFF;
        this.b = argb & 0xFF;
    }

    public int getAsRGBA() {
        return (this.r & 0xFF) << 24 | (this.g & 0xFF) << 16 | (this.b & 0xFF) << 8 | (int)(this.a * 255.0f) & 0xFF;
    }

    public int getAsARGB() {
        return (this.r & 0xFF) << 16 | (this.g & 0xFF) << 8 | this.b & 0xFF | ((int)(this.a * 255.0f) & 0xFF) << 24;
    }

    public int getAsBGRA() {
        return (this.r & 0xFF) << 8 | (this.g & 0xFF) << 16 | (this.b & 0xFF) << 24 | (int)(this.a * 255.0f) & 0xFF;
    }

    public static Color combineColors(List<Color> colors, float alphaMul, float alphaMin, float alphaMax) {
        float alphaSum = 0.0f;
        float currAlphaMax = 0.0f;
        for (Color c : colors) {
            alphaSum += c.a;
            currAlphaMax = Math.max(currAlphaMax, c.a);
        }
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        for (Color c : colors) {
            float factor = c.a / alphaSum;
            r += (float)c.r * factor;
            g += (float)c.g * factor;
            b += (float)c.b * factor;
        }
        float a = class_3532.method_15363((float)(currAlphaMax * alphaMul), (float)alphaMin, (float)alphaMax);
        return new Color(Math.round(r), Math.round(g), Math.round(b), a);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Color color = (Color)o;
        return this.r == color.r && this.g == color.g && this.b == color.b && Float.compare(this.a, color.a) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.r, this.g, this.b, Float.valueOf(this.a));
    }

    public Color clone() {
        return new Color(this.r, this.g, this.b, this.a);
    }

    public String toString() {
        return "Color{r=" + this.r + ", g=" + this.g + ", b=" + this.b + ", a=" + this.a + "}";
    }
}

