/*
 * Decompiled with CFR 0.152.
 */
package de.the_build_craft.maplink.common.connections;

import de.the_build_craft.maplink.common.AbstractModInitializer;
import de.the_build_craft.maplink.common.CommonModConfig;
import de.the_build_craft.maplink.common.HTTP;
import de.the_build_craft.maplink.common.ModConfig;
import de.the_build_craft.maplink.common.UpdateTask;
import de.the_build_craft.maplink.common.clientMapHandlers.ClientMapHandler;
import de.the_build_craft.maplink.common.connections.DynmapConnection;
import de.the_build_craft.maplink.common.connections.MapConnection;
import de.the_build_craft.maplink.common.connections.Pl3xMapConnection;
import de.the_build_craft.maplink.common.connections.SquareMapConnection;
import de.the_build_craft.maplink.common.waypoints.PlayerPosition;
import de.the_build_craft.maplink.common.wrappers.Utils;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LiveAtlasConnection
extends MapConnection {
    public static final Pattern dynmapRegexPattern = Pattern.compile("dynmap: *\\{\\R*((?!\\s+//\\s*).*\\R*)*?[^}\"']*}");
    public static final Pattern Pl3xMapRegexPattern = Pattern.compile("pl3xmap: *[\"'](.+)[\"']");
    public static final Pattern SquareMapRegexPattern = Pattern.compile("squaremap: *[\"'](.+)[\"']");
    List<MapConnection> mapConnections = new ArrayList<MapConnection>();
    int mapIndex;
    private int lastMapIndex;

    @Override
    public void setCurrentDimension(String currentDimension) {
        for (MapConnection connection : this.mapConnections) {
            connection.setCurrentDimension(currentDimension);
        }
    }

    public LiveAtlasConnection(ModConfig.ServerEntry serverEntry, UpdateTask updateTask) throws IOException {
        try {
            this.setupConnections(serverEntry, true);
        }
        catch (Exception ignored) {
            try {
                this.setupConnections(serverEntry, false);
            }
            catch (Exception e) {
                if (!updateTask.linkBrokenErrorWasShown) {
                    updateTask.linkBrokenErrorWasShown = true;
                    Utils.sendErrorToClientChat("[Map Link]: Error: Your LiveAtlas link is broken!");
                }
                throw e;
            }
        }
    }

    private void setupConnections(ModConfig.ServerEntry serverEntry, boolean useHttps) throws IOException {
        String g;
        String baseURL = this.getBaseURL(serverEntry, useHttps);
        String liveAtlasHTML = HTTP.makeTextHttpRequest(URI.create(baseURL).toURL(), true);
        Matcher matcher = dynmapRegexPattern.matcher(liveAtlasHTML);
        while (matcher.find()) {
            g = matcher.group();
            try {
                this.mapConnections.add(new DynmapConnection(baseURL, g, true));
            }
            catch (Exception e) {
                AbstractModInitializer.LOGGER.error("error creating Dynmap connection for LiveAtlas", (Throwable)e);
            }
        }
        matcher = Pl3xMapRegexPattern.matcher(liveAtlasHTML);
        while (matcher.find()) {
            g = matcher.group(1);
            try {
                this.mapConnections.add(new Pl3xMapConnection(baseURL, g, true));
            }
            catch (Exception e) {
                AbstractModInitializer.LOGGER.error("error creating Pl3xMap connection for LiveAtlas", (Throwable)e);
            }
        }
        matcher = SquareMapRegexPattern.matcher(liveAtlasHTML);
        while (matcher.find()) {
            g = matcher.group(1);
            try {
                this.mapConnections.add(new SquareMapConnection(baseURL, g, true));
            }
            catch (Exception e) {
                AbstractModInitializer.LOGGER.error("error creating Squaremap connection for LiveAtlas", (Throwable)e);
            }
        }
    }

    @Override
    public HashMap<String, PlayerPosition> getPlayerPositions() throws IOException {
        if (this.mapConnections.isEmpty()) {
            return new HashMap<String, PlayerPosition>();
        }
        if (CommonModConfig.config.general.debugMode) {
            HashMap<String, PlayerPosition> debug = new HashMap<String, PlayerPosition>();
            for (MapConnection mapConnection : this.mapConnections) {
                debug.putAll(mapConnection.getPlayerPositions());
            }
            return debug;
        }
        HashMap<String, PlayerPosition> map = this.mapConnections.get(this.mapIndex).getPlayerPositions();
        if (this.mapConnections.get((int)this.mapIndex).foundPlayer) {
            return map;
        }
        int i = 0;
        for (MapConnection mapConnection : this.mapConnections) {
            if (i == this.mapIndex) {
                ++i;
                continue;
            }
            HashMap<String, PlayerPosition> map2 = mapConnection.getPlayerPositions();
            if (mapConnection.foundPlayer) {
                this.mapIndex = i;
                return map2;
            }
            ++i;
        }
        return map;
    }

    @Override
    public void getWaypointPositions(boolean forceRefresh) throws IOException {
        if (this.mapConnections.isEmpty()) {
            if (ClientMapHandler.getInstance() != null) {
                ClientMapHandler.getInstance().removeAllMarkerWaypoints();
                ClientMapHandler.getInstance().removeAllAreaMarkers(true);
            }
            return;
        }
        ModConfig.ServerEntry serverEntry = CommonModConfig.getCurrentServerEntry();
        if (serverEntry.needsMarkerLayerUpdate()) {
            serverEntry.setMarkerLayers(new ArrayList<String>(this.getMarkerLayers()));
        }
        this.mapConnections.get(this.mapIndex).getWaypointPositions(this.mapIndex != this.lastMapIndex);
        this.lastMapIndex = this.mapIndex;
    }

    @Override
    public Set<String> getMarkerLayers() {
        HashSet<String> layers = new HashSet<String>();
        for (MapConnection connection : this.mapConnections) {
            layers.addAll(connection.getMarkerLayers());
        }
        return layers;
    }
}

