/*
 * Decompiled with CFR 0.152.
 */
package de.the_build_craft.maplink.common;

import com.google.gson.Gson;
import com.mojang.blaze3d.platform.NativeImage;
import de.the_build_craft.maplink.common.CommonModConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class HTTP {
    public static <T> T makeJSONHTTPRequest(URL endpoint, Class<T> clazz) throws IOException {
        Gson gson = new Gson();
        return (T)gson.fromJson(HTTP.makeTextHttpRequest(endpoint), clazz);
    }

    public static <T> T makeJSONHTTPRequest(URL endpoint, Type apiResponseType) throws IOException {
        Gson gson = new Gson();
        return (T)gson.fromJson(HTTP.makeTextHttpRequest(endpoint), apiResponseType);
    }

    public static String makeTextHttpRequest(URL url) throws IOException {
        return HTTP.makeTextHttpRequest(url, false);
    }

    public static HttpURLConnection openHTTPConnection(URL url, String contentType) throws IOException {
        HttpURLConnection request = (HttpURLConnection)url.openConnection();
        request.setRequestMethod("GET");
        request.setRequestProperty("Content-Type", contentType);
        request.setRequestProperty("User-Agent", "Map Link");
        request.setInstanceFollowRedirects(true);
        request.setConnectTimeout(10000);
        request.setReadTimeout(10000);
        if (CommonModConfig.config.general.ignoreCertificatesUseAtYourOwnRisk && request instanceof HttpsURLConnection) {
            try {
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, new TrustManager[]{new TrustAnyTrustManager()}, new SecureRandom());
                HostnameVerifier allHostsValid = (hostname, session) -> true;
                ((HttpsURLConnection)request).setSSLSocketFactory(sc.getSocketFactory());
                ((HttpsURLConnection)request).setHostnameVerifier(allHostsValid);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return request;
    }

    public static String makeTextHttpRequest(URL url, boolean includeNewLine) throws IOException {
        String output;
        HttpURLConnection request = HTTP.openHTTPConnection(url, "application/json");
        BufferedReader responseReader = new BufferedReader(new InputStreamReader(request.getInputStream()));
        StringBuilder response = new StringBuilder();
        while ((output = responseReader.readLine()) != null) {
            response.append(output);
            if (!includeNewLine) continue;
            response.append("\n");
        }
        return response.toString();
    }

    public static NativeImage makeImageHttpRequest(URL url) throws IOException {
        HttpURLConnection request = HTTP.openHTTPConnection(url, "image/png");
        return NativeImage.read((InputStream)request.getInputStream());
    }

    static class TrustAnyTrustManager
    implements X509TrustManager {
        TrustAnyTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

