/*
 * Decompiled with CFR 0.152.
 */
package de.the_build_craft.maplink.common;

import de.the_build_craft.maplink.common.ModConfig;
import java.util.Locale;
import java.util.Objects;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;

public abstract class CommonModConfig {
    public static ModConfig config;

    public CommonModConfig() {
        config = this.getConfig();
        if (CommonModConfig.config.general.serverEntries.isEmpty()) {
            CommonModConfig.config.general.serverEntries.add(new ModConfig.ServerEntry());
        }
    }

    protected abstract ModConfig getConfig();

    public static void saveConfig() {
        AutoConfig.getConfigHolder(ModConfig.class).save();
    }

    public static void setIgnoreMarkerMessage(boolean on) {
        CommonModConfig.config.general.ignoreMarkerMessage = on;
        CommonModConfig.saveConfig();
    }

    public static int getPlayerWaypointColor(String playerName) {
        if (CommonModConfig.config.friends.overwriteFriendWaypointColor && CommonModConfig.config.friends.friendList.contains(playerName)) {
            return CommonModConfig.config.friends.friendWaypointColor.ordinal();
        }
        return CommonModConfig.config.general.playerWaypointColor.ordinal();
    }

    public static ModConfig.ServerEntry getCurrentServerEntry() {
        ServerData serverData = Minecraft.m_91087_().m_91089_();
        if (serverData == null) {
            return null;
        }
        String serverIP = serverData.f_105363_.toLowerCase(Locale.ROOT);
        for (ModConfig.ServerEntry server : CommonModConfig.config.general.serverEntries) {
            if (!Objects.equals(serverIP, server.ip.toLowerCase(Locale.ROOT))) continue;
            return server;
        }
        return null;
    }

    public static int getWaypointLayerOrder() {
        return CommonModConfig.config.general.minimapWaypointsRenderBelow.isActive() ? -1 : 100;
    }
}

