/*
 * Decompiled with CFR 0.152.
 */
package de.the_build_craft.maplink.common;

import de.the_build_craft.maplink.common.AbstractModInitializer;
import de.the_build_craft.maplink.common.CommonModConfig;
import de.the_build_craft.maplink.common.FastUpdateTask;
import de.the_build_craft.maplink.common.LoaderType;
import de.the_build_craft.maplink.common.MainThreadTaskQueue;
import de.the_build_craft.maplink.common.ModConfig;
import de.the_build_craft.maplink.common.clientMapHandlers.ClientMapHandler;
import de.the_build_craft.maplink.common.connections.BlueMapConnection;
import de.the_build_craft.maplink.common.connections.DynmapConnection;
import de.the_build_craft.maplink.common.connections.LiveAtlasConnection;
import de.the_build_craft.maplink.common.connections.Pl3xMapConnection;
import de.the_build_craft.maplink.common.connections.SquareMapConnection;
import de.the_build_craft.maplink.common.wrappers.Text;
import de.the_build_craft.maplink.common.wrappers.Utils;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;

public class UpdateTask {
    private final Minecraft mc = Minecraft.m_91087_();
    private boolean connectionErrorWasShown = false;
    private boolean cantFindServerErrorWasShown = false;
    private boolean cantGetPlayerPositionsErrorWasShown = false;
    private boolean cantGetMarkerPositionsErrorWasShown = false;
    public boolean linkBrokenErrorWasShown = false;
    private String currentServerIP = "";
    public static int nextUpdateDelay = 1000;
    private static final Object resetLock = new Object();

    public void run() {
        try {
            this.runUpdate();
        }
        catch (Exception e) {
            AbstractModInitializer.LOGGER.error("Error in slow Update Task", (Throwable)e);
        }
        try {
            AbstractModInitializer.setUpdateDelay(nextUpdateDelay);
        }
        catch (Exception e) {
            AbstractModInitializer.LOGGER.error("Error updating update-delay!", (Throwable)e);
        }
    }

    private void runUpdate() {
        block25: {
            if (this.mc.f_91073_ == null || this.mc.f_91074_ == null || this.mc.f_91075_ == null || this.mc.m_91092_() != null && !this.mc.m_91092_().m_6992_() || this.mc.m_91089_() == null || this.mc.m_91403_() == null || !this.mc.m_91403_().m_6198_().m_129536_()) {
                this.Reset();
                return;
            }
            if (!CommonModConfig.config.general.enabled) {
                this.Reset();
                return;
            }
            String serverIP = this.mc.m_91089_().f_105363_.toLowerCase(Locale.ROOT);
            if (!Objects.equals(this.currentServerIP, serverIP)) {
                this.currentServerIP = serverIP;
                this.Reset();
                AbstractModInitializer.LOGGER.info("Server ip has changed!");
            }
            if (AbstractModInitializer.getConnection() == null) {
                nextUpdateDelay = 1000;
                try {
                    ModConfig.ServerEntry serverEntry = CommonModConfig.getCurrentServerEntry();
                    if (Objects.equals(serverEntry, null)) {
                        if (!CommonModConfig.config.general.ignoredServers.contains(serverIP) && !this.cantFindServerErrorWasShown) {
                            String message = "[Map Link]: Could not find a web map link for this server. Make sure to add it to the config. (this server ip was detected: " + serverIP + ") ";
                            if (AbstractModInitializer.INSTANCE.loaderType == LoaderType.Fabric || AbstractModInitializer.INSTANCE.loaderType == LoaderType.Quilt) {
                                Utils.sendToClientChat((Component)Text.literal(message).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)).m_7220_((Component)Text.literal("[ignore this server]").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN).m_131136_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/maplink ignore_server")))));
                            } else {
                                Utils.sendToClientChat((Component)Text.literal(message).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)).m_7220_((Component)Text.literal("[ignore this server]").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN).m_131136_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/maplink ignore_server")))));
                            }
                            this.cantFindServerErrorWasShown = true;
                        }
                        AbstractModInitializer.connected = false;
                        return;
                    }
                    if (Objects.requireNonNull(serverEntry.maptype) == ModConfig.ServerEntry.MapType.Dynmap) {
                        AbstractModInitializer.setConnection(new DynmapConnection(serverEntry, this));
                        break block25;
                    }
                    if (serverEntry.maptype == ModConfig.ServerEntry.MapType.Squaremap) {
                        AbstractModInitializer.setConnection(new SquareMapConnection(serverEntry, this));
                        break block25;
                    }
                    if (serverEntry.maptype == ModConfig.ServerEntry.MapType.Bluemap) {
                        AbstractModInitializer.setConnection(new BlueMapConnection(serverEntry, this));
                        break block25;
                    }
                    if (serverEntry.maptype == ModConfig.ServerEntry.MapType.Pl3xMap) {
                        AbstractModInitializer.setConnection(new Pl3xMapConnection(serverEntry, this));
                        break block25;
                    }
                    if (serverEntry.maptype == ModConfig.ServerEntry.MapType.LiveAtlas) {
                        AbstractModInitializer.setConnection(new LiveAtlasConnection(serverEntry, this));
                        break block25;
                    }
                    throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)serverEntry.maptype));
                }
                catch (Exception e) {
                    if (!this.connectionErrorWasShown) {
                        this.connectionErrorWasShown = true;
                        Utils.sendErrorToClientChat("[Map Link]: Error while connecting to the web map. Please check you config or report a bug.");
                        AbstractModInitializer.LOGGER.error("Error while connecting to the web map.", (Throwable)e);
                    }
                    AbstractModInitializer.connected = false;
                    nextUpdateDelay = 1000;
                    return;
                }
            }
        }
        try {
            FastUpdateTask.getInstance().updateFromOnlineMap(AbstractModInitializer.getConnection().getPlayerPositions());
        }
        catch (Exception e) {
            if (!this.cantGetPlayerPositionsErrorWasShown) {
                this.cantGetPlayerPositionsErrorWasShown = true;
                Utils.sendErrorToClientChat("[Map Link]: Failed to make web map request (for player waypoints). Please check your config (maybe your link...) or report a bug.");
            }
            AbstractModInitializer.LOGGER.error("Failed to get player positions from the web map.", (Throwable)e);
            AbstractModInitializer.setConnection(null);
            return;
        }
        if (CommonModConfig.config.general.enableMarkerWaypoints || CommonModConfig.config.general.enableAreaMarkerOverlay) {
            try {
                AbstractModInitializer.getConnection().getWaypointPositions(false);
            }
            catch (Exception e) {
                if (!this.cantGetMarkerPositionsErrorWasShown) {
                    this.cantGetMarkerPositionsErrorWasShown = true;
                    Utils.sendErrorToClientChat("[Map Link]: Failed to make web map request (for marker waypoints). Please check your config (maybe your link...) or report a bug.");
                }
                AbstractModInitializer.LOGGER.error("Failed to get marker positions from the web map.", (Throwable)e);
            }
        } else if (ClientMapHandler.getInstance() != null) {
            ClientMapHandler.getInstance().removeAllMarkerWaypoints();
            ClientMapHandler.getInstance().removeAllAreaMarkers(true);
        }
        AbstractModInitializer.connected = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Reset() {
        Object object = resetLock;
        synchronized (object) {
            MainThreadTaskQueue.clearQueue();
            AbstractModInitializer.setConnection(null);
            ClientMapHandler.clearRegisteredPositions();
            FastUpdateTask.getInstance().clearAllPlayerPositions();
            if (ClientMapHandler.getInstance() != null) {
                ClientMapHandler.getInstance().reset();
            }
            this.connectionErrorWasShown = false;
            this.cantFindServerErrorWasShown = false;
            this.cantGetPlayerPositionsErrorWasShown = false;
            this.cantGetMarkerPositionsErrorWasShown = false;
            this.linkBrokenErrorWasShown = false;
            nextUpdateDelay = 1000;
        }
    }
}

