/*
 * Decompiled with CFR 0.152.
 */
package de.the_build_craft.remote_player_waypoints_for_xaero.common;

import de.the_build_craft.remote_player_waypoints_for_xaero.common.AbstractModInitializer;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.CommonModConfig;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.FixedWaypoint;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.LoaderType;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.PlayerPosition;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.PlayerWaypoint;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.WaypointPosition;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.connections.BlueMapConnection;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.connections.DynmapConnection;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.connections.LiveAtlasConnection;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.connections.Pl3xMapConnection;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.connections.SquareMapConnection;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.wrappers.Text;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.wrappers.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.TimerTask;
import net.minecraft.class_124;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_3959;
import net.minecraft.class_640;
import net.minecraft.class_742;
import xaero.common.HudMod;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.waypoint.WaypointColor;
import xaero.hud.minimap.waypoint.set.WaypointSet;
import xaero.hud.minimap.world.MinimapWorld;

public class UpdateTask
extends TimerTask {
    private final class_310 mc = class_310.method_1551();
    private static final String PLAYER_SET_NAME = "Remote Player Waypoints For Xaero's Map_Player";
    private static final String MARKER_SET_NAME = "Remote Player Waypoints For Xaero's Map_Marker";
    private boolean connectionErrorWasShown = false;
    private boolean cantFindServerErrorWasShown = false;
    private boolean cantGetPlayerPositionsErrorWasShown = false;
    private boolean cantGetMarkerPositionsErrorWasShown = false;
    private boolean markerMessageWasShown = false;
    public boolean linkBrokenErrorWasShown = false;
    private String currentServerIP = "";
    private final int maxMarkerCountBeforeWarning = 25;
    public static HashMap<String, PlayerPosition> playerPositions;
    public static HashMap<String, WaypointPosition> markerPositions;
    private WaypointSet playerWaypointList = null;
    private WaypointSet markerWaypointList = null;
    private int previousPlayerWaypointColor = 0;
    private int previousMarkerWaypointColor = 0;
    private int previousFriendWaypointColor = 0;
    private boolean previousFriendColorOverride = false;
    private int previousFriendListHashCode = 0;

    @Override
    public void run() {
        try {
            this.runUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runUpdate() {
        block71: {
            if (this.mc.field_1687 == null || this.mc.field_1724 == null || this.mc.field_1719 == null || this.mc.method_1576() != null && !this.mc.method_1576().method_3860() || this.mc.method_1558() == null || this.mc.method_1562() == null || !this.mc.method_1562().method_48296().method_10758()) {
                this.Reset();
                return;
            }
            this.playerWaypointList = null;
            this.markerWaypointList = null;
            if (AbstractModInitializer.mapModInstalled) {
                try {
                    MinimapSession session = (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession();
                    MinimapWorld currentWorld = session.getWorldManager().getCurrentWorld();
                    if (currentWorld.getWaypointSet(PLAYER_SET_NAME) == null) {
                        currentWorld.addWaypointSet(PLAYER_SET_NAME);
                    }
                    if (currentWorld.getWaypointSet(MARKER_SET_NAME) == null) {
                        currentWorld.addWaypointSet(MARKER_SET_NAME);
                    }
                    this.playerWaypointList = currentWorld.getWaypointSet(PLAYER_SET_NAME);
                    this.markerWaypointList = currentWorld.getWaypointSet(MARKER_SET_NAME);
                }
                catch (Exception session) {
                    // empty catch block
                }
            }
            if (!(AbstractModInitializer.enabled = CommonModConfig.Instance.enabled())) {
                this.Reset();
                if (this.playerWaypointList != null) {
                    this.playerWaypointList.clear();
                }
                if (this.markerWaypointList != null) {
                    this.markerWaypointList.clear();
                }
                return;
            }
            String serverIP = this.mc.method_1558().field_3761.toLowerCase(Locale.ROOT);
            if (!Objects.equals(this.currentServerIP, serverIP)) {
                this.currentServerIP = serverIP;
                this.Reset();
                AbstractModInitializer.LOGGER.info("Server ip has changed!");
            }
            if (AbstractModInitializer.getConnection() == null) {
                try {
                    CommonModConfig.ServerEntry serverEntry = CommonModConfig.Instance.getCurrentServerEntry();
                    if (Objects.equals(serverEntry, null)) {
                        if (!CommonModConfig.Instance.ignoredServers().contains(serverIP) && !this.cantFindServerErrorWasShown) {
                            String message = "[Remote Player Waypoints For Xaero's Map]: Could not find an online map link for this server. Make sure to add it to the config. (this server ip was detected: " + serverIP + ") ";
                            if (AbstractModInitializer.INSTANCE.loaderType == LoaderType.Fabric || AbstractModInitializer.INSTANCE.loaderType == LoaderType.Quilt) {
                                Utils.sendToClientChat((class_2561)Text.literal(message).method_10862(class_2583.field_24360.method_10977(class_124.field_1065)).method_10852((class_2561)Text.literal("[ignore this server]").method_10862(class_2583.field_24360.method_10977(class_124.field_1060).method_10982(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11750, "/remote_player_waypoints_for_xaero ignore_server")))));
                            } else {
                                Utils.sendToClientChat((class_2561)Text.literal(message).method_10862(class_2583.field_24360.method_10977(class_124.field_1065)).method_10852((class_2561)Text.literal("[ignore this server]").method_10862(class_2583.field_24360.method_10977(class_124.field_1060).method_10982(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11745, "/remote_player_waypoints_for_xaero ignore_server")))));
                            }
                            this.cantFindServerErrorWasShown = true;
                        }
                        AbstractModInitializer.connected = false;
                        return;
                    }
                    if (Objects.requireNonNull(serverEntry.maptype) == CommonModConfig.ServerEntry.Maptype.Dynmap) {
                        AbstractModInitializer.setConnection(new DynmapConnection(serverEntry, this));
                        break block71;
                    }
                    if (serverEntry.maptype == CommonModConfig.ServerEntry.Maptype.Squaremap) {
                        AbstractModInitializer.setConnection(new SquareMapConnection(serverEntry, this));
                        break block71;
                    }
                    if (serverEntry.maptype == CommonModConfig.ServerEntry.Maptype.Bluemap) {
                        AbstractModInitializer.setConnection(new BlueMapConnection(serverEntry, this));
                        break block71;
                    }
                    if (serverEntry.maptype == CommonModConfig.ServerEntry.Maptype.Pl3xMap) {
                        AbstractModInitializer.setConnection(new Pl3xMapConnection(serverEntry, this));
                        break block71;
                    }
                    if (serverEntry.maptype == CommonModConfig.ServerEntry.Maptype.LiveAtlas) {
                        AbstractModInitializer.setConnection(new LiveAtlasConnection(serverEntry, this));
                        break block71;
                    }
                    throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)serverEntry.maptype));
                }
                catch (Exception e) {
                    if (!this.connectionErrorWasShown) {
                        this.connectionErrorWasShown = true;
                        Utils.sendErrorToClientChat("[Remote Player Waypoints For Xaero's Map]: Error while connecting to the online map. Please check you config or report a bug.");
                        e.printStackTrace();
                    }
                    AbstractModInitializer.connected = false;
                    return;
                }
            }
        }
        try {
            playerPositions = AbstractModInitializer.getConnection().getPlayerPositions();
        }
        catch (IOException e) {
            if (!this.cantGetPlayerPositionsErrorWasShown) {
                this.cantGetPlayerPositionsErrorWasShown = true;
                Utils.sendErrorToClientChat("[Remote Player Waypoints For Xaero's Map]: Failed to make online map request (for player waypoints). Please check your config (probably your link...) or report a bug.");
            }
            e.printStackTrace();
            AbstractModInitializer.setConnection(null);
            return;
        }
        if (CommonModConfig.Instance.enableMarkerWaypoints()) {
            try {
                markerPositions = AbstractModInitializer.getConnection().getWaypointPositions();
            }
            catch (IOException e) {
                markerPositions = new HashMap();
                if (!this.cantGetMarkerPositionsErrorWasShown) {
                    this.cantGetMarkerPositionsErrorWasShown = true;
                    Utils.sendErrorToClientChat("[Remote Player Waypoints For Xaero's Map]: Failed to make online map request (for marker waypoints). Please check your config (probably your link...) or report a bug.");
                }
                e.printStackTrace();
            }
        } else {
            markerPositions = new HashMap();
        }
        AbstractModInitializer.connected = true;
        AbstractModInitializer.AfkColor = CommonModConfig.Instance.AfkColor();
        AbstractModInitializer.unknownAfkStateColor = CommonModConfig.Instance.unknownAfkStateColor();
        AbstractModInitializer.showAfkInTabList = CommonModConfig.Instance.showAfkInTabList();
        AbstractModInitializer.showAfkTimeInTabList = CommonModConfig.Instance.showAfkTimeInTabList();
        AbstractModInitializer.hideAfkMinutes = CommonModConfig.Instance.hideAfkMinutes();
        if (!AbstractModInitializer.mapModInstalled || this.playerWaypointList == null || this.markerWaypointList == null) {
            if (CommonModConfig.Instance.updateDelay() != AbstractModInitializer.TimerDelay) {
                AbstractModInitializer.setUpdateDelay(CommonModConfig.Instance.updateDelay());
            }
            return;
        }
        HudMod.INSTANCE.getSettings().renderAllSets = true;
        if (CommonModConfig.Instance.enableEntityRadar()) {
            Collection playerList = this.mc.method_1562().method_2880();
            for (class_640 playerListEntity : playerList) {
                String playerName = playerListEntity.method_2966().getName();
                if (!playerPositions.containsKey(playerName)) continue;
                UpdateTask.playerPositions.get((Object)playerName).gameProfile = playerListEntity.method_2966();
            }
        }
        class_243 camPosition = this.mc.field_1719.method_19538();
        try {
            Object waypoint;
            HashMap<String, Integer> waypointNamesIndexes;
            WaypointSet message = this.playerWaypointList;
            synchronized (message) {
                if (CommonModConfig.Instance.enablePlayerWaypoints()) {
                    waypointNamesIndexes = new HashMap<String, Integer>(this.playerWaypointList.size());
                    for (int i = 0; i < this.playerWaypointList.size(); ++i) {
                        waypoint = this.playerWaypointList.get(i);
                        waypointNamesIndexes.put(waypoint.getName(), i);
                    }
                    List playerClientEntityList = this.mc.field_1687.method_18456();
                    HashMap<String, Integer> playerClientEntityIndexes = new HashMap<String, Integer>(this.playerWaypointList.size());
                    for (int i = 0; i < playerClientEntityList.size(); ++i) {
                        class_742 playerClientEntity = (class_742)playerClientEntityList.get(i);
                        playerClientEntityIndexes.put(playerClientEntity.method_7334().getName(), i);
                    }
                    ArrayList<String> currentPlayerWaypointNames = new ArrayList<String>();
                    for (PlayerPosition playerPosition : playerPositions.values()) {
                        double d;
                        int maximumWaypointDistanceToUse;
                        int minimumWaypointDistanceToUse;
                        if (playerPosition == null) continue;
                        String playerName = playerPosition.player;
                        boolean isFriend = CommonModConfig.Instance.friendList().contains(playerName);
                        if (CommonModConfig.Instance.onlyShowFriendsWaypoints() && !isFriend) continue;
                        if (CommonModConfig.Instance.overwriteFriendDistances() && isFriend) {
                            minimumWaypointDistanceToUse = CommonModConfig.Instance.minFriendDistance();
                            maximumWaypointDistanceToUse = CommonModConfig.Instance.maxFriendDistance();
                        } else {
                            minimumWaypointDistanceToUse = CommonModConfig.Instance.minDistance();
                            maximumWaypointDistanceToUse = CommonModConfig.Instance.maxDistance();
                        }
                        if (minimumWaypointDistanceToUse > maximumWaypointDistanceToUse) {
                            maximumWaypointDistanceToUse = minimumWaypointDistanceToUse;
                        }
                        if ((d = camPosition.method_1022(new class_243((double)playerPosition.x, (double)playerPosition.y, (double)playerPosition.z))) < (double)minimumWaypointDistanceToUse || d > (double)maximumWaypointDistanceToUse) continue;
                        if (playerClientEntityIndexes.containsKey(playerName)) {
                            class_742 playerClientEntity = (class_742)playerClientEntityList.get((Integer)playerClientEntityIndexes.get(playerName));
                            class_3959 clipContext = new class_3959(this.mc.field_1719.method_19538(), playerClientEntity.method_19538(), class_3959.class_3960.field_23142, class_3959.class_242.field_1347, this.mc.field_1719);
                            if (this.mc.field_1687.method_17742(clipContext).method_17783() != class_239.class_240.field_1332) continue;
                        }
                        if (waypointNamesIndexes.containsKey(playerName)) {
                            Waypoint waypoint2 = this.playerWaypointList.get(((Integer)waypointNamesIndexes.get(playerName)).intValue());
                            waypoint2.setX(playerPosition.x);
                            waypoint2.setY(playerPosition.y);
                            waypoint2.setZ(playerPosition.z);
                            currentPlayerWaypointNames.add(waypoint2.getName());
                            continue;
                        }
                        try {
                            PlayerWaypoint currentPlayerWaypoint = new PlayerWaypoint(playerPosition);
                            this.playerWaypointList.add((Waypoint)currentPlayerWaypoint);
                            currentPlayerWaypointNames.add(currentPlayerWaypoint.getName());
                        }
                        catch (NullPointerException nullPointerException) {}
                    }
                    Iterator iterator = this.playerWaypointList.getWaypoints().iterator();
                    while (iterator.hasNext()) {
                        Waypoint w = (Waypoint)iterator.next();
                        if (currentPlayerWaypointNames.contains(w.getName())) continue;
                        iterator.remove();
                    }
                    int newPlayerWaypointColor = CommonModConfig.Instance.playerWaypointColor();
                    int newFriendWaypointColor = CommonModConfig.Instance.friendWaypointColor();
                    boolean newFriendColorOverride = CommonModConfig.Instance.overwriteFriendWaypointColor();
                    int newFriendListHashCode = CommonModConfig.Instance.friendList().hashCode();
                    if (this.previousPlayerWaypointColor != newPlayerWaypointColor || this.previousFriendWaypointColor != newFriendWaypointColor || this.previousFriendColorOverride != newFriendColorOverride || this.previousFriendListHashCode != newFriendListHashCode) {
                        this.previousPlayerWaypointColor = newPlayerWaypointColor;
                        this.previousFriendWaypointColor = newFriendWaypointColor;
                        this.previousFriendColorOverride = newFriendColorOverride;
                        this.previousFriendListHashCode = newFriendListHashCode;
                        for (Waypoint waypoint3 : this.playerWaypointList.getWaypoints()) {
                            waypoint3.setWaypointColor(WaypointColor.fromIndex((int)CommonModConfig.Instance.getPlayerWaypointColor(waypoint3.getName())));
                        }
                    }
                } else {
                    this.playerWaypointList.clear();
                }
            }
            message = this.markerWaypointList;
            synchronized (message) {
                if (CommonModConfig.Instance.enableMarkerWaypoints()) {
                    waypointNamesIndexes = new HashMap(this.markerWaypointList.size());
                    for (int i = 0; i < this.markerWaypointList.size(); ++i) {
                        waypoint = this.markerWaypointList.get(i);
                        waypointNamesIndexes.put(waypoint.getName(), i);
                    }
                    ArrayList<String> currentMarkerWaypointNames = new ArrayList<String>();
                    for (WaypointPosition markerPosition : markerPositions.values()) {
                        double d;
                        int maximumWaypointDistanceToUse;
                        if (markerPosition == null) continue;
                        String markerName = markerPosition.name;
                        int minimumWaypointDistanceToUse = CommonModConfig.Instance.minDistanceMarker();
                        if (minimumWaypointDistanceToUse > (maximumWaypointDistanceToUse = CommonModConfig.Instance.maxDistanceMarker())) {
                            maximumWaypointDistanceToUse = minimumWaypointDistanceToUse;
                        }
                        if ((d = camPosition.method_1022(new class_243((double)markerPosition.x, (double)markerPosition.y, (double)markerPosition.z))) < (double)minimumWaypointDistanceToUse || d > (double)maximumWaypointDistanceToUse) continue;
                        if (waypointNamesIndexes.containsKey(markerName)) {
                            Waypoint waypoint4 = this.markerWaypointList.get(((Integer)waypointNamesIndexes.get(markerName)).intValue());
                            waypoint4.setX(markerPosition.x);
                            waypoint4.setY(markerPosition.y);
                            waypoint4.setZ(markerPosition.z);
                            currentMarkerWaypointNames.add(waypoint4.getName());
                            continue;
                        }
                        try {
                            FixedWaypoint currentMarkerWaypoint = new FixedWaypoint(markerPosition);
                            this.markerWaypointList.add((Waypoint)currentMarkerWaypoint);
                            currentMarkerWaypointNames.add(currentMarkerWaypoint.getName());
                        }
                        catch (NullPointerException nullPointerException) {}
                    }
                    Iterator iterator = this.markerWaypointList.getWaypoints().iterator();
                    while (iterator.hasNext()) {
                        Waypoint w = (Waypoint)iterator.next();
                        if (currentMarkerWaypointNames.contains(w.getName())) continue;
                        iterator.remove();
                    }
                    int newMarkerWaypointColor = CommonModConfig.Instance.markerWaypointColor();
                    if (this.previousMarkerWaypointColor != newMarkerWaypointColor) {
                        this.previousMarkerWaypointColor = newMarkerWaypointColor;
                        for (Waypoint waypoint5 : this.markerWaypointList.getWaypoints()) {
                            waypoint5.setWaypointColor(WaypointColor.fromIndex((int)newMarkerWaypointColor));
                        }
                    }
                    if (!this.markerMessageWasShown && currentMarkerWaypointNames.size() > 25 && !CommonModConfig.Instance.ignoreMarkerMessage()) {
                        this.markerMessageWasShown = true;
                        Utils.sendToClientChat((class_2561)Text.literal("[Remote Player Waypoints For Xaero's Map]: Looks like you have quite a lot of markers from the server visible! Did you know that you can chose the marker layers that are shown in the config, decrease their maximum distance or disable marker waypoints entirely? ").method_27696(class_2583.field_24360.method_10977(class_124.field_1065)).method_10852((class_2561)Text.literal("[Don't show this again]").method_27696(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11745, "/remote_player_waypoints_for_xaero ignore_marker_message")).method_10977(class_124.field_1060).method_10982(Boolean.valueOf(true)))));
                    }
                } else {
                    this.markerWaypointList.clear();
                }
            }
        }
        catch (ConcurrentModificationException e) {
            AbstractModInitializer.LOGGER.warn("waypoint error");
            e.printStackTrace();
        }
        if (CommonModConfig.Instance.updateDelay() != AbstractModInitializer.TimerDelay) {
            AbstractModInitializer.setUpdateDelay(CommonModConfig.Instance.updateDelay());
        }
    }

    private void Reset() {
        AbstractModInitializer.setConnection(null);
        this.connectionErrorWasShown = false;
        this.cantFindServerErrorWasShown = false;
        this.cantGetPlayerPositionsErrorWasShown = false;
        this.cantGetMarkerPositionsErrorWasShown = false;
        this.linkBrokenErrorWasShown = false;
        this.markerMessageWasShown = false;
    }
}

