/*
 * Decompiled with CFR 0.152.
 */
package de.the_build_craft.remote_player_waypoints_for_xaero.common.connections;

import de.the_build_craft.remote_player_waypoints_for_xaero.common.AbstractModInitializer;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.CommonModConfig;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.HTTP;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.PlayerPosition;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.UpdateTask;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.WaypointPosition;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.connections.DynmapConfiguration;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.connections.MapConnection;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.mapUpdates.DynmapMarkerUpdate;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.mapUpdates.DynmapPlayerUpdate;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.wrappers.Utils;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DynmapConnection
extends MapConnection {
    private String markerStringTemplate = "";
    public String firstWorldName = "";
    public String[] worldNames = new String[0];
    String lastMarkerDimension = "";
    HashMap<String, WaypointPosition> lastResult = new HashMap();

    public DynmapConnection(CommonModConfig.ServerEntry serverEntry, UpdateTask updateTask) throws IOException {
        try {
            this.generateLink(serverEntry, true);
        }
        catch (Exception ignored) {
            try {
                this.generateLink(serverEntry, false);
            }
            catch (Exception e) {
                if (!updateTask.linkBrokenErrorWasShown) {
                    updateTask.linkBrokenErrorWasShown = true;
                    Utils.sendErrorToClientChat("[Remote Player Waypoints For Xaero's Map]: Error: Your Dynmap link is broken!");
                }
                throw e;
            }
        }
    }

    public DynmapConnection(String baseURL, String config) throws IOException {
        this.generateLinkWithConfig(baseURL, config);
    }

    private void generateLink(CommonModConfig.ServerEntry serverEntry, boolean useHttps) throws IOException {
        block10: {
            String baseURL = this.getBaseURL(serverEntry, useHttps);
            try {
                this.queryURL = URI.create(serverEntry.link.replace(" ", "%20")).toURL();
                this.getPlayerPositions();
                if (CommonModConfig.Instance.debugMode()) {
                    Utils.sendToClientChat("got link with method 1 | overwrite mode active!");
                }
            }
            catch (Exception a) {
                try {
                    String mapConfig = HTTP.makeTextHttpRequest(URI.create(baseURL + "/standalone/config.js").toURL());
                    this.generateLinkWithConfig(baseURL, mapConfig);
                    if (CommonModConfig.Instance.debugMode()) {
                        Utils.sendToClientChat("got link with method 2 | that is good!");
                    }
                }
                catch (Exception b) {
                    try {
                        this.onlineMapConfigLink = baseURL + "/up/configuration";
                        this.setWorldNames();
                        this.queryURL = URI.create(baseURL + "/up/world/" + this.firstWorldName + "/").toURL();
                        this.markerStringTemplate = baseURL + "/tiles/_markers_/marker_{world}.json";
                        this.getPlayerPositions();
                        if (CommonModConfig.Instance.debugMode()) {
                            Utils.sendErrorToClientChat("got link with method 3 instead of 2 | please report this on github!");
                        }
                    }
                    catch (Exception ignored) {
                        this.onlineMapConfigLink = baseURL + "/standalone/dynmap_config.json?";
                        this.setWorldNames();
                        this.queryURL = URI.create(baseURL + "/standalone/world/" + this.firstWorldName + ".json?").toURL();
                        this.markerStringTemplate = baseURL + "/tiles/_markers_/marker_{world}.json";
                        this.getPlayerPositions();
                        if (!CommonModConfig.Instance.debugMode()) break block10;
                        Utils.sendErrorToClientChat("got link with method 4 instead of 2 | please report this on github!");
                    }
                }
            }
        }
        AbstractModInitializer.LOGGER.info("new link: " + String.valueOf(this.queryURL));
        if (CommonModConfig.Instance.debugMode()) {
            Utils.sendToClientChat("new link: " + String.valueOf(this.queryURL));
        }
    }

    public void generateLinkWithConfig(String baseURL, String mapConfig) throws IOException {
        Matcher matcher = Pattern.compile(".*?//\\w*(\\.\\w+)+(:\\w+)?").matcher(baseURL);
        if (!matcher.find()) {
            throw new RuntimeException("wrong url pattern");
        }
        baseURL = matcher.group();
        int i = mapConfig.indexOf("configuration: ");
        int j = mapConfig.indexOf(",", i);
        AbstractModInitializer.LOGGER.info("mapConfig: " + mapConfig);
        Object substring = mapConfig.substring(i + 16, j - 1);
        if (((String)substring).contains("?")) {
            int k = ((String)substring).indexOf("?");
            substring = ((String)substring).substring(0, k);
        }
        if (((String)substring).contains("//")) {
            this.onlineMapConfigLink = ((String)substring).replace(" ", "%20");
        } else {
            if (!((String)substring).startsWith("/")) {
                substring = "/" + (String)substring;
            }
            this.onlineMapConfigLink = (baseURL + (String)substring).replace(" ", "%20");
        }
        AbstractModInitializer.LOGGER.info("configuration link: " + this.onlineMapConfigLink);
        this.setWorldNames();
        AbstractModInitializer.LOGGER.info("firstWorldName: " + this.firstWorldName);
        i = mapConfig.indexOf("update: ");
        j = mapConfig.indexOf(",", i);
        Object updateStringTemplate = mapConfig.substring(i + 9, j - 1).replace("{timestamp}", "1");
        AbstractModInitializer.LOGGER.info("updateStringTemplate: " + (String)updateStringTemplate);
        if (((String)updateStringTemplate).contains("//")) {
            this.queryURL = URI.create(((String)updateStringTemplate).replace("{world}", this.firstWorldName)).toURL();
        } else {
            if (!((String)updateStringTemplate).startsWith("/")) {
                updateStringTemplate = "/" + (String)updateStringTemplate;
            }
            this.queryURL = URI.create(baseURL + ((String)updateStringTemplate).replace("{world}", this.firstWorldName)).toURL();
        }
        AbstractModInitializer.LOGGER.info("url: " + String.valueOf(this.queryURL));
        i = mapConfig.indexOf("markers: ");
        int l = "markers: ".length() + 1;
        j = mapConfig.indexOf("'", i + l + 1);
        Object markerSubstring = mapConfig.substring(i + l, j);
        if (((String)markerSubstring).contains("//")) {
            this.markerStringTemplate = (String)markerSubstring + "_markers_/marker_{world}.json";
        } else {
            if (!((String)markerSubstring).startsWith("/")) {
                markerSubstring = "/" + (String)markerSubstring;
            }
            this.markerStringTemplate = baseURL + (String)markerSubstring + "_markers_/marker_{world}.json";
        }
        AbstractModInitializer.LOGGER.info("markerStringTemplate: " + this.markerStringTemplate);
        this.getPlayerPositions();
    }

    private void setWorldNames() throws IOException {
        DynmapConfiguration.World[] worlds = HTTP.makeJSONHTTPRequest((URL)URI.create((String)this.onlineMapConfigLink).toURL(), DynmapConfiguration.class).worlds;
        this.worldNames = new String[worlds.length];
        int worldsLength = worlds.length;
        for (int k = 0; k < worldsLength; ++k) {
            this.worldNames[k] = worlds[k].name.replace(" ", "%20");
        }
        this.firstWorldName = this.worldNames[0];
    }

    @Override
    public HashMap<String, PlayerPosition> getPlayerPositions() throws IOException {
        DynmapPlayerUpdate update = HTTP.makeJSONHTTPRequest(this.queryURL, DynmapPlayerUpdate.class);
        PlayerPosition[] positions = new PlayerPosition[update.players.length];
        for (int i = 0; i < update.players.length; ++i) {
            DynmapPlayerUpdate.Player player = update.players[i];
            positions[i] = new PlayerPosition(player.account, Math.round(player.x), Math.round(player.y), Math.round(player.z), player.world);
        }
        return this.HandlePlayerPositions(positions);
    }

    @Override
    public HashSet<String> getMarkerLayers() {
        HashSet<String> layers = new HashSet<String>();
        for (String world : this.worldNames) {
            DynmapMarkerUpdate u;
            try {
                u = HTTP.makeJSONHTTPRequest(URI.create(this.markerStringTemplate.replace("{world}", world).replace(" ", "%20")).toURL(), DynmapMarkerUpdate.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            for (DynmapMarkerUpdate.Set set : u.sets.values()) {
                layers.add(set.label);
            }
        }
        return layers;
    }

    @Override
    public HashMap<String, WaypointPosition> getWaypointPositions() throws IOException {
        CommonModConfig.ServerEntry serverEntry = CommonModConfig.Instance.getCurrentServerEntry();
        if (serverEntry.markerVisibilityMode == CommonModConfig.ServerEntry.MarkerVisibilityMode.Auto) {
            CommonModConfig.Instance.setMarkerLayers(serverEntry.ip, new ArrayList<String>(this.getMarkerLayers()));
        }
        String dimension = CommonModConfig.Instance.debugMode() ? this.firstWorldName : this.currentDimension;
        if (AbstractModInitializer.overwriteCurrentDimension && !Objects.equals(this.currentDimension, "")) {
            dimension = this.currentDimension;
        }
        if (this.markerStringTemplate.isEmpty() || dimension.isEmpty()) {
            return new HashMap<String, WaypointPosition>();
        }
        if (this.lastMarkerDimension.equals(dimension)) {
            return this.lastResult;
        }
        this.lastMarkerDimension = dimension;
        DynmapMarkerUpdate update = HTTP.makeJSONHTTPRequest(URI.create(this.markerStringTemplate.replace("{world}", dimension).replace(" ", "%20")).toURL(), DynmapMarkerUpdate.class);
        HashMap<String, WaypointPosition> positions = new HashMap<String, WaypointPosition>();
        for (DynmapMarkerUpdate.Set set : update.sets.values()) {
            if (!serverEntry.includeMarkerLayer(set.label)) continue;
            for (DynmapMarkerUpdate.Set.Marker m : set.markers.values()) {
                WaypointPosition newWaypointPosition = new WaypointPosition(m.label, Math.round(m.x), Math.round(m.y), Math.round(m.z));
                positions.put(newWaypointPosition.name, newWaypointPosition);
            }
        }
        this.lastResult = positions;
        return positions;
    }
}

