/*
 * Decompiled with CFR 0.152.
 */
package de.the_build_craft.remote_player_waypoints_for_xaero.common.connections;

import de.the_build_craft.remote_player_waypoints_for_xaero.common.AbstractModInitializer;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.CommonModConfig;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.HTTP;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.PlayerPosition;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.UpdateTask;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.WaypointPosition;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.connections.DynmapConnection;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.connections.MapConnection;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.wrappers.Utils;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LiveAtlasConnection
extends MapConnection {
    public static final Pattern dynmapRegexPattern = Pattern.compile("\\n +dynmap: \\{\\n(.*\\n)*?.*}\\n");
    List<MapConnection> mapConnections = new ArrayList<MapConnection>();
    int mapIndex;

    public LiveAtlasConnection(CommonModConfig.ServerEntry serverEntry, UpdateTask updateTask) throws IOException {
        try {
            this.setupConnections(serverEntry, true);
        }
        catch (Exception ignored) {
            try {
                this.setupConnections(serverEntry, false);
            }
            catch (Exception e) {
                if (!updateTask.linkBrokenErrorWasShown) {
                    updateTask.linkBrokenErrorWasShown = true;
                    Utils.sendErrorToClientChat("[Remote Player Waypoints For Xaero's Map]: Error: Your LiveAtlas link is broken!");
                }
                throw e;
            }
        }
    }

    private void setupConnections(CommonModConfig.ServerEntry serverEntry, boolean useHttps) throws IOException {
        String baseURL = this.getBaseURL(serverEntry, useHttps);
        String liveAtlasHTML = HTTP.makeTextHttpRequest(URI.create(baseURL).toURL(), true);
        Matcher matcher = dynmapRegexPattern.matcher(liveAtlasHTML);
        while (matcher.find()) {
            String g = matcher.group();
            try {
                this.mapConnections.add(new DynmapConnection(baseURL, g));
            }
            catch (Exception e) {
                AbstractModInitializer.LOGGER.error("error creating connection");
            }
        }
    }

    @Override
    public HashMap<String, PlayerPosition> getPlayerPositions() throws IOException {
        if (CommonModConfig.Instance.debugMode()) {
            HashMap<String, PlayerPosition> debug = new HashMap<String, PlayerPosition>();
            for (MapConnection mapConnection : this.mapConnections) {
                debug.putAll(mapConnection.getPlayerPositions());
            }
            return debug;
        }
        HashMap<String, PlayerPosition> map = this.mapConnections.get(this.mapIndex).getPlayerPositions();
        if (this.mapConnections.get((int)this.mapIndex).foundPlayer) {
            return map;
        }
        int i = 0;
        for (MapConnection mapConnection : this.mapConnections) {
            if (i == this.mapIndex) {
                ++i;
                continue;
            }
            HashMap<String, PlayerPosition> map2 = mapConnection.getPlayerPositions();
            if (mapConnection.foundPlayer) {
                this.mapIndex = i;
                return map2;
            }
            ++i;
        }
        return map;
    }

    @Override
    public HashMap<String, WaypointPosition> getWaypointPositions() throws IOException {
        CommonModConfig.ServerEntry serverEntry = CommonModConfig.Instance.getCurrentServerEntry();
        if (serverEntry.markerVisibilityMode == CommonModConfig.ServerEntry.MarkerVisibilityMode.Auto) {
            CommonModConfig.Instance.setMarkerLayers(serverEntry.ip, new ArrayList<String>(this.getMarkerLayers()));
        }
        return this.mapConnections.get(this.mapIndex).getWaypointPositions();
    }

    @Override
    public HashSet<String> getMarkerLayers() {
        HashSet<String> layers = new HashSet<String>();
        for (MapConnection connection : this.mapConnections) {
            layers.addAll(connection.getMarkerLayers());
        }
        return layers;
    }
}

