/*
 * Decompiled with CFR 0.152.
 */
package de.the_build_craft.remote_player_waypoints_for_xaero.common.connections;

import com.google.common.reflect.TypeToken;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.AbstractModInitializer;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.CommonModConfig;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.HTTP;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.PlayerPosition;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.UpdateTask;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.WaypointPosition;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.connections.MapConnection;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.mapUpdates.Pl3xMapMarkerLayerConfig;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.mapUpdates.Pl3xMapMarkerUpdate;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.mapUpdates.Pl3xMapPlayerUpdate;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.wrappers.Utils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;

public class Pl3xMapConnection
extends MapConnection {
    private String markerLayerStringTemplate = "";
    private String markerStringTemplate = "";
    String lastMarkerDimension = "";
    HashMap<String, WaypointPosition> lastResult = new HashMap();

    public Pl3xMapConnection(CommonModConfig.ServerEntry serverEntry, UpdateTask updateTask) throws IOException {
        try {
            this.generateLink(serverEntry, true);
        }
        catch (Exception ignored) {
            try {
                this.generateLink(serverEntry, false);
            }
            catch (Exception e) {
                if (!updateTask.linkBrokenErrorWasShown) {
                    updateTask.linkBrokenErrorWasShown = true;
                    Utils.sendErrorToClientChat("[Remote Player Waypoints For Xaero's Map]: Error: Your Pl3xMap link is broken!");
                }
                throw e;
            }
        }
    }

    private void generateLink(CommonModConfig.ServerEntry serverEntry, boolean useHttps) throws IOException {
        String baseURL = this.getBaseURL(serverEntry, useHttps);
        this.queryURL = URI.create(baseURL + "/tiles/settings.json").toURL();
        this.markerLayerStringTemplate = baseURL + "/tiles/{world}/markers.json";
        this.markerStringTemplate = baseURL + "/tiles/{world}/markers/{layerName}.json";
        this.onlineMapConfigLink = baseURL + "/tiles/settings.json";
        this.getPlayerPositions();
        AbstractModInitializer.LOGGER.info("new link: " + String.valueOf(this.queryURL));
        if (CommonModConfig.Instance.debugMode()) {
            Utils.sendToClientChat("new link: " + String.valueOf(this.queryURL));
        }
    }

    @Override
    public HashMap<String, PlayerPosition> getPlayerPositions() throws IOException {
        Pl3xMapPlayerUpdate update = HTTP.makeJSONHTTPRequest(this.queryURL, Pl3xMapPlayerUpdate.class);
        PlayerPosition[] positions = new PlayerPosition[update.players.length];
        for (int i = 0; i < update.players.length; ++i) {
            Pl3xMapPlayerUpdate.Player player = update.players[i];
            positions[i] = new PlayerPosition(player.name, player.position.x, CommonModConfig.Instance.defaultY(), player.position.z, player.world);
        }
        return this.HandlePlayerPositions(positions);
    }

    @Override
    public HashMap<String, WaypointPosition> getWaypointPositions() throws IOException {
        if (this.markerStringTemplate.isEmpty() || this.markerLayerStringTemplate.isEmpty() || this.currentDimension.isEmpty()) {
            return new HashMap<String, WaypointPosition>();
        }
        if (this.lastMarkerDimension.equals(this.currentDimension)) {
            return this.lastResult;
        }
        this.lastMarkerDimension = this.currentDimension;
        HashMap<String, WaypointPosition> positions = new HashMap<String, WaypointPosition>();
        for (String layer : this.getMarkerLayers()) {
            Pl3xMapMarkerUpdate[] markers;
            Type apiResponseType = new TypeToken<Pl3xMapMarkerUpdate[]>(){}.getType();
            URL reqUrl = URI.create(this.markerStringTemplate.replace("{world}", this.currentDimension.replaceAll(":", "-")).replace("{layerName}", layer)).toURL();
            for (Pl3xMapMarkerUpdate marker : markers = (Pl3xMapMarkerUpdate[])HTTP.makeJSONHTTPRequest(reqUrl, apiResponseType)) {
                if (!Objects.equals(marker.type, "icon")) continue;
                WaypointPosition newWaypointPosition = new WaypointPosition(marker.options.tooltip.content, marker.data.point.x, CommonModConfig.Instance.defaultY(), marker.data.point.z);
                positions.put(newWaypointPosition.name, newWaypointPosition);
            }
        }
        this.lastResult = positions;
        return positions;
    }

    @Override
    public HashSet<String> getMarkerLayers() {
        try {
            Type apiResponseType = new TypeToken<Pl3xMapMarkerLayerConfig[]>(){}.getType();
            CommonModConfig.ServerEntry serverEntry = CommonModConfig.Instance.getCurrentServerEntry();
            if (serverEntry.markerVisibilityMode == CommonModConfig.ServerEntry.MarkerVisibilityMode.Auto) {
                Pl3xMapPlayerUpdate update = HTTP.makeJSONHTTPRequest(this.queryURL, Pl3xMapPlayerUpdate.class);
                HashSet<String> layerMap = new HashSet<String>();
                for (Pl3xMapPlayerUpdate.WorldSetting ws : update.worldSettings) {
                    Pl3xMapMarkerLayerConfig[] mls;
                    for (Pl3xMapMarkerLayerConfig ml : mls = (Pl3xMapMarkerLayerConfig[])HTTP.makeJSONHTTPRequest(URI.create(this.markerLayerStringTemplate.replace("{world}", ws.name.replaceAll(":", "-"))).toURL(), apiResponseType)) {
                        if (Objects.equals(ml.key, "pl3xmap_players")) continue;
                        layerMap.add(ml.key);
                    }
                }
                CommonModConfig.Instance.setMarkerLayers(serverEntry.ip, new ArrayList<String>(layerMap));
            }
            URL reqUrl = URI.create(this.markerLayerStringTemplate.replace("{world}", this.currentDimension.replaceAll(":", "-"))).toURL();
            Pl3xMapMarkerLayerConfig[] markerLayers = (Pl3xMapMarkerLayerConfig[])HTTP.makeJSONHTTPRequest(reqUrl, apiResponseType);
            HashSet<String> layers = new HashSet<String>();
            for (Pl3xMapMarkerLayerConfig layer : markerLayers) {
                if (Objects.equals(layer.key, "pl3xmap_players")) continue;
                layers.add(layer.key);
            }
            layers.removeIf(o -> !serverEntry.includeMarkerLayer((String)o));
            return layers;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

