/*
 * Decompiled with CFR 0.152.
 */
package de.the_build_craft.remote_player_waypoints_for_xaero.common.connections;

import com.google.common.reflect.TypeToken;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.AbstractModInitializer;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.CommonModConfig;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.HTTP;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.PlayerPosition;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.UpdateTask;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.WaypointPosition;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.connections.MapConnection;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.connections.SquareMapConfiguration;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.mapUpdates.SquareMapMarkerUpdate;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.mapUpdates.SquareMapPlayerUpdate;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.wrappers.Utils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;

public class SquareMapConnection
extends MapConnection {
    private String markerStringTemplate = "";
    String lastMarkerDimension = "";
    HashMap<String, WaypointPosition> lastResult = new HashMap();

    public SquareMapConnection(CommonModConfig.ServerEntry serverEntry, UpdateTask updateTask) throws IOException {
        try {
            this.generateLink(serverEntry, true);
        }
        catch (Exception ignored) {
            try {
                this.generateLink(serverEntry, false);
            }
            catch (Exception e) {
                if (!updateTask.linkBrokenErrorWasShown) {
                    updateTask.linkBrokenErrorWasShown = true;
                    Utils.sendErrorToClientChat("[Remote Player Waypoints For Xaero's Map]: Error: Your Squaremap link is broken!");
                }
                throw e;
            }
        }
    }

    private void generateLink(CommonModConfig.ServerEntry serverEntry, boolean useHttps) throws IOException {
        String baseURL = this.getBaseURL(serverEntry, useHttps);
        this.queryURL = URI.create(baseURL + "/tiles/players.json").toURL();
        this.markerStringTemplate = baseURL + "/tiles/{world}/markers.json";
        this.onlineMapConfigLink = baseURL + "/tiles/settings.json";
        this.getPlayerPositions();
        AbstractModInitializer.LOGGER.info("new link: " + String.valueOf(this.queryURL));
        if (CommonModConfig.Instance.debugMode()) {
            Utils.sendToClientChat("new link: " + String.valueOf(this.queryURL));
        }
    }

    @Override
    public HashMap<String, PlayerPosition> getPlayerPositions() throws IOException {
        SquareMapPlayerUpdate update = HTTP.makeJSONHTTPRequest(this.queryURL, SquareMapPlayerUpdate.class);
        PlayerPosition[] positions = new PlayerPosition[update.players.length];
        for (int i = 0; i < update.players.length; ++i) {
            SquareMapPlayerUpdate.Player player = update.players[i];
            positions[i] = new PlayerPosition(player.name, player.x, player.y == Integer.MIN_VALUE ? CommonModConfig.Instance.defaultY() : player.y, player.z, player.world);
        }
        return this.HandlePlayerPositions(positions);
    }

    @Override
    public HashSet<String> getMarkerLayers() {
        try {
            Type apiResponseType = new TypeToken<SquareMapMarkerUpdate[]>(){}.getType();
            HashSet<String> layers = new HashSet<String>();
            SquareMapConfiguration squareMapConfiguration = HTTP.makeJSONHTTPRequest(URI.create(this.onlineMapConfigLink).toURL(), SquareMapConfiguration.class);
            for (SquareMapConfiguration.World world : squareMapConfiguration.worlds) {
                SquareMapMarkerUpdate[] ml;
                for (SquareMapMarkerUpdate markerLayer : ml = (SquareMapMarkerUpdate[])HTTP.makeJSONHTTPRequest(URI.create(this.markerStringTemplate.replace("{world}", world.name)).toURL(), apiResponseType)) {
                    layers.add(markerLayer.name);
                }
            }
            return layers;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public HashMap<String, WaypointPosition> getWaypointPositions() throws IOException {
        if (this.markerStringTemplate.isEmpty() || this.currentDimension.isEmpty()) {
            return new HashMap<String, WaypointPosition>();
        }
        if (this.lastMarkerDimension.equals(this.currentDimension)) {
            return this.lastResult;
        }
        this.lastMarkerDimension = this.currentDimension;
        Type apiResponseType = new TypeToken<SquareMapMarkerUpdate[]>(){}.getType();
        CommonModConfig.ServerEntry serverEntry = CommonModConfig.Instance.getCurrentServerEntry();
        if (serverEntry.markerVisibilityMode == CommonModConfig.ServerEntry.MarkerVisibilityMode.Auto) {
            CommonModConfig.Instance.setMarkerLayers(serverEntry.ip, new ArrayList<String>(this.getMarkerLayers()));
        }
        URL reqUrl = URI.create(this.markerStringTemplate.replace("{world}", this.currentDimension)).toURL();
        SquareMapMarkerUpdate[] markersLayers = (SquareMapMarkerUpdate[])HTTP.makeJSONHTTPRequest(reqUrl, apiResponseType);
        HashMap<String, WaypointPosition> positions = new HashMap<String, WaypointPosition>();
        for (SquareMapMarkerUpdate markerLayer : markersLayers) {
            if (!serverEntry.includeMarkerLayer(markerLayer.name)) continue;
            for (SquareMapMarkerUpdate.Marker marker : markerLayer.markers) {
                if (!Objects.equals(marker.type, "icon")) continue;
                WaypointPosition newWaypointPosition = new WaypointPosition(marker.tooltip, marker.point.x, CommonModConfig.Instance.defaultY(), marker.point.z);
                positions.put(newWaypointPosition.name, newWaypointPosition);
            }
        }
        this.lastResult = positions;
        return positions;
    }
}

