/*
 * Decompiled with CFR 0.152.
 */
package de.the_build_craft.maplink.common;

import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Supplier;

public class MainThreadTaskQueue {
    private static final Queue<QueuedTask<?>> taskQueue = new ConcurrentLinkedQueue();
    private static final int tasksPerFrame = 100;

    public static <T> QueuedTask<T> queueTask(Supplier<T> task) {
        QueuedTask<T> queuedTask = new QueuedTask<T>(task);
        taskQueue.offer(queuedTask);
        return queuedTask;
    }

    public static QueuedTask<Void> queueTask(Runnable task) {
        return MainThreadTaskQueue.queueTask(() -> {
            task.run();
            return null;
        });
    }

    public static void executeQueuedTasks() {
        for (int i = 0; i < 100; ++i) {
            if (taskQueue.isEmpty()) {
                return;
            }
            QueuedTask<?> queuedTask = taskQueue.poll();
            if (queuedTask == null) continue;
            if (queuedTask.isCancelled()) {
                queuedTask.future.cancel(false);
                continue;
            }
            try {
                queuedTask.future.complete(((QueuedTask)queuedTask).task.get());
                continue;
            }
            catch (Exception e) {
                queuedTask.future.completeExceptionally(e);
            }
        }
    }

    public static void clearQueue() {
        while (!taskQueue.isEmpty()) {
            QueuedTask<?> queuedTask = taskQueue.poll();
            if (queuedTask == null) continue;
            queuedTask.cancel();
        }
    }

    public static <T> T waitForTask(Supplier<T> task) {
        QueuedTask<T> queuedTask = MainThreadTaskQueue.queueTask(task);
        try {
            return queuedTask.future.join();
        }
        catch (Exception e) {
            throw new RuntimeException("Error while executing Main-Thread-Task", e);
        }
    }

    public static void waitForTask(Runnable task) {
        MainThreadTaskQueue.waitForTask(() -> {
            task.run();
            return null;
        });
    }

    public static class QueuedTask<T> {
        public final CompletableFuture<T> future;
        private final Supplier<T> task;
        private volatile boolean cancelled;

        public QueuedTask(Supplier<T> task) {
            this.task = task;
            this.future = new CompletableFuture();
        }

        public boolean cancel() {
            if (this.future.isDone()) {
                return false;
            }
            this.cancelled = true;
            this.future.cancel(false);
            return true;
        }

        public boolean isCancelled() {
            return this.cancelled || this.future.isCancelled();
        }
    }
}

